/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor.shared;

import com.alkacon.acacia.shared.AttributeConfiguration;
import com.alkacon.acacia.shared.ContentDefinition;
import com.alkacon.acacia.shared.Entity;
import com.alkacon.acacia.shared.TabInfo;
import com.alkacon.vie.shared.I_Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opencms.ade.contenteditor.shared.CmsExternalWidgetConfiguration;
import org.opencms.gwt.shared.CmsModelResourceInfo;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsContentDefinition
extends ContentDefinition {
    private static final String ENTITY_ID_PREFIX = "http://opencms.org/resources/";
    private Map<String, String> m_availableLocales;
    private List<String> m_contentLocales;
    private boolean m_deleteOnCancel;
    private List<CmsExternalWidgetConfiguration> m_externalWidgetConfigurations;
    private List<CmsModelResourceInfo> m_modelInfos;
    private String m_newLink;
    private boolean m_performedAutocorrection;
    private CmsUUID m_referenceResourceId;
    private String m_resourceType;
    private String m_sitePath;
    private String m_title;

    public CmsContentDefinition(Entity entity, Map<String, AttributeConfiguration> configurations, Collection<CmsExternalWidgetConfiguration> externalWidgetConfigurations, Map<String, I_Type> types, List<TabInfo> tabInfos, String locale, List<String> contentLocales, Map<String, String> availableLocales, String title, String sitePath, String resourceType, boolean performedAutocorrection) {
        super(entity, configurations, types, tabInfos, locale);
        this.m_contentLocales = contentLocales;
        this.m_availableLocales = availableLocales;
        this.m_title = title;
        this.m_sitePath = sitePath;
        this.m_resourceType = resourceType;
        this.m_externalWidgetConfigurations = new ArrayList<CmsExternalWidgetConfiguration>(externalWidgetConfigurations);
        this.m_performedAutocorrection = performedAutocorrection;
    }

    public CmsContentDefinition(List<CmsModelResourceInfo> modelInfos, String newLink, CmsUUID referenceId, String locale) {
        super(null, null, null, null, locale);
        this.m_modelInfos = modelInfos;
        this.m_newLink = newLink;
        this.m_referenceResourceId = referenceId;
    }

    protected CmsContentDefinition() {
    }

    public static CmsUUID entityIdToUuid(String entityId) {
        if (entityId.startsWith(ENTITY_ID_PREFIX)) {
            entityId = entityId.substring(entityId.lastIndexOf("/") + 1);
        }
        return new CmsUUID(entityId);
    }

    public static String getLocaleFromId(String entityId) {
        if (entityId.startsWith(ENTITY_ID_PREFIX)) {
            return entityId.substring(ENTITY_ID_PREFIX.length(), entityId.lastIndexOf("/"));
        }
        return null;
    }

    public static String uuidToEntityId(CmsUUID uuid, String locale) {
        return ENTITY_ID_PREFIX + locale + "/" + uuid.toString();
    }

    public Map<String, String> getAvailableLocales() {
        return this.m_availableLocales;
    }

    public List<String> getContentLocales() {
        return this.m_contentLocales;
    }

    public List<CmsExternalWidgetConfiguration> getExternalWidgetConfigurations() {
        return this.m_externalWidgetConfigurations;
    }

    public List<CmsModelResourceInfo> getModelInfos() {
        return this.m_modelInfos;
    }

    public String getNewLink() {
        return this.m_newLink;
    }

    public CmsUUID getReferenceResourceId() {
        return this.m_referenceResourceId;
    }

    public String getResourceType() {
        return this.m_resourceType;
    }

    public String getSitePath() {
        return this.m_sitePath;
    }

    public String getTitle() {
        return this.m_title;
    }

    public boolean isDeleteOnCancel() {
        return this.m_deleteOnCancel;
    }

    public boolean isModelInfo() {
        return this.m_modelInfos != null;
    }

    public boolean isPerformedAutocorrection() {
        return this.m_performedAutocorrection;
    }

    public void setDeleteOnCancel(boolean deleteOnCancel) {
        this.m_deleteOnCancel = deleteOnCancel;
    }
}

