/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.ade.galleries.ClientMessages;
import org.opencms.ade.galleries.CmsGalleryService;
import org.opencms.ade.galleries.Messages;
import org.opencms.ade.galleries.shared.CmsGalleryDataBean;
import org.opencms.ade.galleries.shared.CmsGallerySearchBean;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;
import org.opencms.ade.galleries.shared.rpc.I_CmsGalleryService;
import org.opencms.ade.upload.CmsUploadActionElement;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.tools.CmsToolDialog;

public class CmsGalleryActionElement
extends CmsGwtActionElement {
    public static final String MODULE_NAME = "galleries";
    private I_CmsGalleryProviderConstants.GalleryMode m_galleryMode;

    public CmsGalleryActionElement(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
        try {
            this.m_galleryMode = I_CmsGalleryProviderConstants.GalleryMode.valueOf(this.getRequest().getParameter(I_CmsGalleryProviderConstants.ReqParam.dialogmode.name()).trim());
        }
        catch (Exception e) {
            this.m_galleryMode = I_CmsGalleryProviderConstants.GalleryMode.view;
        }
        if (req.getSession().getAttribute("__CmsWorkplace.WORKPLACE_SETTINGS") == null) {
            new CmsToolDialog(new CmsJspActionElement(context, req, res));
        }
    }

    public String export() throws Exception {
        return this.export(this.m_galleryMode);
    }

    public String exportAll() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(super.export());
        sb.append(this.export());
        sb.append(this.exportCloseLink());
        sb.append(new CmsUploadActionElement(this.getJspContext(), this.getRequest(), this.getResponse()).export());
        sb.append(this.createNoCacheScript(MODULE_NAME));
        return sb.toString();
    }

    public String exportForContainerpage() throws Exception {
        return this.export(I_CmsGalleryProviderConstants.GalleryMode.ade);
    }

    public String exportWidget() {
        StringBuffer sb = new StringBuffer();
        sb.append(ClientMessages.get().export(this.getRequest()));
        this.wrapScript(sb);
        return sb.toString();
    }

    public String getTitle() {
        return Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_GALLERIES_TITLE_0");
    }

    public boolean isEditorMode() {
        return this.m_galleryMode == I_CmsGalleryProviderConstants.GalleryMode.editor;
    }

    public boolean isWidgetMode() {
        return this.m_galleryMode == I_CmsGalleryProviderConstants.GalleryMode.widget;
    }

    private String export(I_CmsGalleryProviderConstants.GalleryMode galleryMode) throws Exception {
        CmsGalleryService galleryService = CmsGalleryService.newInstance(this.getRequest());
        CmsGalleryDataBean data = galleryService.getInitialSettings(galleryMode, this.getRequest().getParameter(I_CmsGalleryProviderConstants.ReqParam.resource.name()), this.getRequest().getParameter(I_CmsGalleryProviderConstants.ReqParam.gallerypath.name()), this.getRequest().getParameter(I_CmsGalleryProviderConstants.ReqParam.currentelement.name()), this.getRequest().getParameter(I_CmsGalleryProviderConstants.ReqParam.types.name()), this.getRequest().getParameter(I_CmsGalleryProviderConstants.ReqParam.gallerytypes.name()));
        CmsGallerySearchBean search = null;
        if (I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_results.equals((Object)data.getStartTab())) {
            search = galleryService.getSearch(data);
        }
        if (search != null && search.getScope() != null && search.getScope() != data.getScope()) {
            data.setScope(search.getScope());
        } else if (search != null && search.getScope() == null) {
            data.setScope(CmsGallerySearchScope.everything);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ClientMessages.get().export(this.getRequest()));
        sb.append("cms_gallery_data_bean").append("='");
        sb.append(CmsGalleryActionElement.serializeForJavascript(I_CmsGalleryService.class.getMethod("getInitialSettings", I_CmsGalleryProviderConstants.GalleryMode.class, String.class, String.class, String.class, String.class, String.class), data));
        sb.append("';");
        sb.append("cms_gallery_search_bean").append("='").append(CmsGalleryActionElement.serializeForJavascript(I_CmsGalleryService.class.getMethod("getSearch", CmsGalleryDataBean.class), search));
        sb.append("';");
        this.wrapScript(sb);
        return sb.toString();
    }

    private String exportCloseLink() {
        String closeLink = null;
        if (this.getRequest().getAttribute("closeLink") != null) {
            closeLink = (String)this.getRequest().getAttribute("closeLink");
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(closeLink)) {
            closeLink = "/system/workplace/views/explorer/explorer_files.jsp";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("var ").append("closeLink").append(" = '").append(closeLink).append("';");
        this.wrapScript(sb);
        return sb.toString();
    }
}

