/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.galleries.CmsSiteSelectorOptionBuilder;
import org.opencms.ade.galleries.Messages;
import org.opencms.ade.galleries.preview.I_CmsPreviewProvider;
import org.opencms.ade.galleries.shared.CmsGalleryDataBean;
import org.opencms.ade.galleries.shared.CmsGalleryFolderBean;
import org.opencms.ade.galleries.shared.CmsGallerySearchBean;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.ade.galleries.shared.CmsResourceTypeBean;
import org.opencms.ade.galleries.shared.CmsResultItemBean;
import org.opencms.ade.galleries.shared.CmsSitemapEntryBean;
import org.opencms.ade.galleries.shared.CmsVfsEntryBean;
import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;
import org.opencms.ade.galleries.shared.rpc.I_CmsGalleryService;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.CmsResourceManager;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchParameters;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.search.galleries.CmsGallerySearchResultList;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsGalleryService
extends CmsGwtService
implements I_CmsGalleryService {
    private static final long serialVersionUID = 1673026761080584889L;
    CmsResourceManager m_resourceManager;
    private CmsWorkplaceSettings m_workplaceSettings;
    private Locale m_wpLocale;

    public static CmsGalleryService newInstance(HttpServletRequest request) {
        CmsGalleryService srv = new CmsGalleryService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        return srv;
    }

    @Override
    public void deleteResource(String resourcePath) throws CmsRpcException {
        try {
            this.ensureLock(resourcePath);
            this.getCmsObject().deleteResource(resourcePath, CmsResource.DELETE_PRESERVE_SIBLINGS);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public List<CmsGalleryFolderBean> getGalleries(List<String> resourceTypes) {
        return this.buildGalleriesList(this.readGalleryInfosByTypeNames(resourceTypes));
    }

    @Override
    public CmsGalleryDataBean getInitialSettings(I_CmsGalleryProviderConstants.GalleryMode galleryMode, String referencePath, String galleryPath, String currentElement, String resourceTypes, String galleryTypes) throws CmsRpcException {
        CmsGalleryDataBean data = new CmsGalleryDataBean();
        data.setMode(galleryMode);
        data.setLocales(this.buildLocalesMap());
        data.setLocale(this.getCmsObject().getRequestContext().getLocale().toString());
        data.setVfsRootFolders(this.getRootEntries());
        data.setScope(this.getWorkplaceSettings().getLastSearchScope());
        List<CmsResourceTypeBean> types = null;
        switch (galleryMode) {
            case editor: 
            case view: 
            case widget: {
                data.setStartGallery(galleryPath);
                data.setCurrentElement(currentElement);
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(referencePath)) {
                    referencePath = data.getStartGallery();
                }
                data.setReferenceSitePath(referencePath);
                types = this.getResourceTypeBeans(galleryMode, data.getReferenceSitePath(), resourceTypes);
                data.setTypes(types);
                Map<String, CmsGalleryTypeInfo> galleryTypeInfos = this.readGalleryInfosByTypeBeans(types);
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(galleryTypes)) {
                    HashMap<String, CmsGalleryTypeInfo> infos = new HashMap<String, CmsGalleryTypeInfo>();
                    String[] galleries = galleryTypes.split(",");
                    for (int i = 0; i < galleries.length; ++i) {
                        CmsGalleryTypeInfo typeInfo = galleryTypeInfos.get(galleries[i]);
                        if (typeInfo == null) continue;
                        infos.put(galleries[i], typeInfo);
                    }
                    galleryTypeInfos = infos;
                }
                data.setGalleries(this.buildGalleriesList(galleryTypeInfos));
                data.setStartTab(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_results);
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(data.getStartGallery()) && !types.isEmpty()) {
                    String lastGallery = this.getWorkplaceSettings().getLastUsedGallery(types.get(0).getTypeId());
                    if (this.getCmsObject().existsResource(lastGallery)) {
                        data.setStartGallery(lastGallery);
                    }
                }
                if (!CmsStringUtil.isEmptyOrWhitespaceOnly(data.getStartGallery()) || !CmsStringUtil.isEmptyOrWhitespaceOnly(data.getCurrentElement())) break;
                data.setStartTab(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_galleries);
                break;
            }
            case ade: {
                data.setReferenceSitePath(this.getCmsObject().getRequestContext().getUri());
                types = this.getResourceTypeBeans(galleryMode, data.getReferenceSitePath(), resourceTypes);
                data.setTypes(types);
                data.setStartTab(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_types);
                break;
            }
        }
        CmsSiteSelectorOptionBuilder optionBuilder = new CmsSiteSelectorOptionBuilder(this.getCmsObject());
        optionBuilder.addNormalSites(true);
        optionBuilder.addSharedSite();
        data.setVfsSiteSelectorOptions(optionBuilder.getOptions());
        CmsSiteSelectorOptionBuilder sitemapOptionBuilder = new CmsSiteSelectorOptionBuilder(this.getCmsObject());
        sitemapOptionBuilder.addNormalSites(false);
        if (data.getReferenceSitePath() != null) {
            sitemapOptionBuilder.addCurrentSubsite(this.getCmsObject().addSiteRoot(data.getReferenceSitePath()));
        }
        data.setSitemapSiteSelectorOptions(sitemapOptionBuilder.getOptions());
        return data;
    }

    @Override
    public CmsGallerySearchBean getSearch(CmsGalleryDataBean data) {
        CmsGallerySearchBean result = null;
        ArrayList<String> types = new ArrayList<String>();
        for (CmsResourceTypeBean info : data.getTypes()) {
            types.add(info.getType());
        }
        switch (data.getMode()) {
            case editor: 
            case view: 
            case widget: {
                String currentelement = data.getCurrentElement();
                try {
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(currentelement)) {
                        this.log("looking up:" + currentelement);
                        if (currentelement.startsWith(OpenCms.getSystemInfo().getOpenCmsContext())) {
                            currentelement = currentelement.substring(OpenCms.getSystemInfo().getOpenCmsContext().length());
                            this.log("removed context - result: " + currentelement);
                        }
                        result = this.findResourceInGallery(currentelement, data);
                    }
                    if (result == null || result.getResults() == null || result.getResults().isEmpty()) {
                        result = new CmsGallerySearchBean();
                        result.setIgnoreSearchExclude(true);
                        String gallery = data.getStartGallery();
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(gallery)) {
                            ArrayList<String> galleries = new ArrayList<String>();
                            galleries.add(gallery);
                            result.setGalleries(galleries);
                        }
                        result.setTypes(types);
                        result.setLocale(data.getLocale());
                        result.setScope(CmsGallerySearchScope.everything);
                        result = this.search(result);
                    }
                    result.setTypes(null);
                }
                catch (CmsException e) {
                    this.logError(e);
                    result = null;
                }
                break;
            }
        }
        return result;
    }

    @Override
    public CmsGallerySearchBean getSearch(CmsGallerySearchBean searchObj) throws CmsRpcException {
        CmsGallerySearchBean gSearchObj = null;
        try {
            gSearchObj = this.search(searchObj);
            this.getWorkplaceSettings().setLastSearchScope(searchObj.getScope());
            this.setLastOpenedGallery(gSearchObj);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return gSearchObj;
    }

    @Override
    public List<CmsSitemapEntryBean> getSubEntries(String rootPath, boolean isRoot) throws CmsRpcException {
        try {
            CmsObject rootCms = OpenCms.initCmsObject(this.getCmsObject());
            rootCms.getRequestContext().setSiteRoot("");
            CmsJspNavBuilder navBuilder = new CmsJspNavBuilder(rootCms);
            ArrayList<CmsSitemapEntryBean> result = new ArrayList<CmsSitemapEntryBean>();
            for (CmsJspNavElement navElement : navBuilder.getNavigationForFolder(rootPath, CmsJspNavBuilder.Visibility.all, CmsResourceFilter.ONLY_VISIBLE)) {
                if (!navElement.isInNavigation()) continue;
                result.add(this.prepareSitemapEntry(rootCms, navElement, false));
            }
            if (isRoot) {
                CmsJspNavElement navElement = navBuilder.getNavigationForResource(rootPath, CmsResourceFilter.ONLY_VISIBLE);
                CmsSitemapEntryBean root = this.prepareSitemapEntry(rootCms, navElement, isRoot);
                root.setChildren(result);
                return Collections.singletonList(root);
            }
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public List<CmsVfsEntryBean> getSubFolders(String rootPath) throws CmsRpcException {
        try {
            CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
            cms.getRequestContext().setSiteRoot("");
            CmsResource resource = cms.readResource(rootPath);
            List<CmsResource> resources = cms.getSubFolders(resource.getRootPath());
            ArrayList<CmsVfsEntryBean> result = new ArrayList<CmsVfsEntryBean>();
            for (CmsResource res : resources) {
                String title = cms.readPropertyObject(res, "Title", false).getValue();
                result.add(new CmsVfsEntryBean(res.getRootPath(), res.getStructureId(), title, false, this.isEditable(cms, res)));
            }
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsVfsEntryBean loadVfsEntryBean(String path) throws CmsRpcException {
        try {
            CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
            cms.getRequestContext().setSiteRoot("");
            CmsResource optionRes = cms.readResource(path);
            CmsVfsEntryBean entryBean = new CmsVfsEntryBean(path, optionRes.getStructureId(), path, true, this.isEditable(cms, optionRes));
            return entryBean;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public void updateIndex() throws CmsRpcException {
        try {
            OpenCms.getSearchManager().updateOfflineIndexes(30000L);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    private void addGalleriesForType(Map<String, CmsGalleryTypeInfo> galleryTypeInfos, String typeName) throws CmsLoaderException {
        I_CmsResourceType contentType = this.getResourceManager().getResourceType(typeName);
        for (I_CmsResourceType galleryType : contentType.getGalleryTypes()) {
            try {
                CmsGalleryTypeInfo typeInfo;
                if (galleryTypeInfos.containsKey(galleryType.getTypeName())) {
                    typeInfo = galleryTypeInfos.get(galleryType.getTypeName());
                    typeInfo.addContentType(contentType);
                    continue;
                }
                typeInfo = new CmsGalleryTypeInfo(galleryType, contentType, this.getGalleriesByType(galleryType.getTypeId()));
                galleryTypeInfos.put(galleryType.getTypeName(), typeInfo);
            }
            catch (CmsException e) {
                this.logError(e);
            }
        }
    }

    private List<CmsGalleryFolderBean> buildGalleriesList(Map<String, CmsGalleryTypeInfo> galleryTypes) {
        ArrayList<CmsGalleryFolderBean> list = new ArrayList<CmsGalleryFolderBean>();
        if (galleryTypes == null) {
            return list;
        }
        for (Map.Entry<String, CmsGalleryTypeInfo> ent : galleryTypes.entrySet()) {
            CmsGalleryTypeInfo tInfo = ent.getValue();
            ArrayList<String> contentTypes = new ArrayList<String>();
            Iterator<I_CmsResourceType> it = tInfo.getContentTypes().iterator();
            while (it.hasNext()) {
                contentTypes.add(String.valueOf(it.next().getTypeName()));
            }
            for (CmsResource res : tInfo.getGalleries()) {
                CmsGalleryFolderBean bean = new CmsGalleryFolderBean();
                String sitePath = this.getCmsObject().getSitePath(res);
                String title = "";
                try {
                    title = this.getCmsObject().readPropertyObject(sitePath, "Title", false).getValue("");
                }
                catch (CmsException e) {
                    this.logError(e);
                }
                bean.setPath(sitePath);
                bean.setContentTypes(contentTypes);
                bean.setTitle(title);
                bean.setType(tInfo.getResourceType().getTypeName());
                bean.setEditable(this.isEditable(this.getCmsObject(), res));
                list.add(bean);
            }
        }
        return list;
    }

    private Map<String, String> buildLocalesMap() {
        TreeMap<String, String> localesMap = new TreeMap<String, String>();
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            localesMap.put(locale.toString(), locale.getDisplayName(this.getWorkplaceLocale()));
        }
        return localesMap;
    }

    private List<CmsResultItemBean> buildSearchResultList(List<CmsGallerySearchResult> searchResult, CmsGallerySearchResult presetResult) {
        ArrayList<CmsResultItemBean> list = new ArrayList<CmsResultItemBean>();
        if (searchResult == null || searchResult.size() == 0) {
            return list;
        }
        CmsObject cms = this.getCmsObject();
        for (CmsGallerySearchResult sResult : searchResult) {
            try {
                CmsResultItemBean bean = this.buildSingleSearchResultItem(cms, sResult, presetResult);
                list.add(bean);
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
        return list;
    }

    private CmsResultItemBean buildSingleSearchResultItem(CmsObject cms, CmsGallerySearchResult sResult, CmsGallerySearchResult presetResult) throws CmsLoaderException, CmsException, ParseException {
        CmsProperty imageDimensionProp;
        Locale wpLocale = this.getWorkplaceLocale();
        CmsResultItemBean bean = new CmsResultItemBean();
        if (sResult == presetResult) {
            bean.setPreset(true);
        }
        bean.setReleasedAndNotExpired(sResult.isReleaseAndNotExpired(cms));
        String path = sResult.getPath();
        path = cms.getRequestContext().removeSiteRoot(path);
        bean.setPath(path);
        bean.setTitle(CmsStringUtil.isEmptyOrWhitespaceOnly(sResult.getTitle()) ? CmsResource.getName(sResult.getPath()) : sResult.getTitle());
        bean.setType(sResult.getResourceType());
        bean.setClientId(sResult.getStructureId());
        CmsResource resultResource = cms.readResource(new CmsUUID(sResult.getStructureId()), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        String permalink = CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getOpenCmsContext(), "/permalink/", sResult.getStructureId().toString());
        bean.setViewLink(permalink);
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(sResult.getResourceType());
        String resourceTypeDisplayName = CmsWorkplaceMessages.getResourceTypeName(wpLocale, type.getTypeName());
        String description = sResult.getDescription();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(description)) {
            bean.setDescription(description);
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_DESCRIPTION_0"), description);
        } else {
            bean.setDescription(resourceTypeDisplayName);
        }
        bean.setUserLastModified(sResult.getUserLastModified());
        Date date = sResult.getDateLastModified();
        String formattedDate = CmsDateUtil.getDateTime(date, 2, wpLocale);
        bean.setDateLastModified(formattedDate);
        if (!type.getTypeName().equals(CmsResourceTypeImage.getStaticTypeName())) {
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_RESOURCE_TYPE_0"), resourceTypeDisplayName);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(sResult.getExcerpt())) {
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_EXCERPT_0"), sResult.getExcerpt(), "multiLineLabel");
        }
        if (type instanceof CmsResourceTypeImage && !(imageDimensionProp = cms.readPropertyObject(resultResource, "image.size", false)).isNullProperty()) {
            String temp = imageDimensionProp.getValue();
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_DIMENSION_0"), temp.substring(2).replace(",h:", " x "));
        }
        bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_SIZE_0"), sResult.getLength() / 1000 + " kb");
        bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_DATE_CHANGED_0"), CmsDateUtil.getDate(sResult.getDateLastModified(), 3, this.getWorkplaceLocale()));
        if (sResult.getDateExpired().getTime() != Long.MAX_VALUE && !sResult.getDateExpired().equals(CmsSearchFieldMapping.getDefaultDateExpired())) {
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_DATE_EXPIRED_0"), CmsDateUtil.getDate(sResult.getDateExpired(), 3, this.getWorkplaceLocale()));
        }
        bean.setNoEditReson(new CmsResourceUtil(cms, resultResource).getNoEditReason(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)));
        return bean;
    }

    private List<CmsResourceTypeBean> buildTypesList(List<I_CmsResourceType> types, List<String> creatableTypes) {
        ArrayList<CmsResourceTypeBean> list = new ArrayList<CmsResourceTypeBean>();
        if (types == null) {
            return list;
        }
        Map<I_CmsResourceType, I_CmsPreviewProvider> typeProviderMapping = this.getPreviewProviderForTypes(types);
        for (I_CmsResourceType type : types) {
            try {
                CmsResourceTypeBean bean = this.createTypeBean(type, typeProviderMapping.get(type), creatableTypes.contains(type.getTypeName()));
                list.add(bean);
            }
            catch (Exception e) {
                if (type == null) continue;
                this.log(Messages.get().getBundle(this.getWorkplaceLocale()).key("ERR_BUILD_TYPE_LIST_1", type.getTypeName()), e);
            }
        }
        return list;
    }

    private CmsResourceTypeBean createTypeBean(I_CmsResourceType type, I_CmsPreviewProvider preview, boolean creatable) {
        CmsResourceTypeBean result = new CmsResourceTypeBean();
        result.setType(type.getTypeName());
        result.setTypeId(type.getTypeId());
        Locale wpLocale = this.getWorkplaceLocale();
        result.setTitle(CmsWorkplaceMessages.getResourceTypeName(wpLocale, type.getTypeName()));
        result.setDescription(CmsWorkplaceMessages.getResourceTypeDescription(wpLocale, type.getTypeName()));
        ArrayList<String> galleryNames = new ArrayList<String>();
        for (I_CmsResourceType galleryType : type.getGalleryTypes()) {
            galleryNames.add(galleryType.getTypeName());
        }
        result.setGalleryTypeNames(galleryNames);
        if (preview != null) {
            result.setPreviewProviderName(preview.getPreviewName());
        }
        result.setCreatableType(creatable);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CmsGallerySearchBean findResourceInGallery(String resourceName, CmsGalleryDataBean data) throws CmsException {
        CmsResource resource = null;
        int pos = resourceName.indexOf("?");
        String resName = resourceName;
        if (pos > -1) {
            resName = resourceName.substring(0, pos);
        }
        CmsObject cms = this.getCmsObject();
        try {
            this.log("reading resource: " + resName);
            resource = cms.readResource(resName, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        }
        catch (CmsException e) {
            String originalSiteRoot = cms.getRequestContext().getSiteRoot();
            try {
                cms.getRequestContext().setSiteRoot("");
                resource = cms.readResource(resName, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            }
            catch (CmsException e2) {
                this.logError(e);
                CmsGallerySearchBean cmsGallerySearchBean = null;
                return cmsGallerySearchBean;
            }
            finally {
                cms.getRequestContext().setSiteRoot(originalSiteRoot);
            }
        }
        ArrayList<String> types = new ArrayList<String>();
        String resType = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
        types.add(resType);
        CmsGallerySearchBean initialSearchObj = new CmsGallerySearchBean();
        initialSearchObj.setIgnoreSearchExclude(true);
        initialSearchObj.setTypes(types);
        ArrayList<String> galleries = new ArrayList<String>();
        for (CmsGalleryFolderBean gallery : data.getGalleries()) {
            if (!gallery.getPath().equals(CmsResource.getFolderPath(resName))) continue;
            galleries.add(gallery.getPath());
            initialSearchObj.setGalleries(galleries);
            break;
        }
        if (galleries.isEmpty()) {
            ArrayList<String> vfsFolders = new ArrayList<String>();
            vfsFolders.add(CmsResource.getFolderPath(resName));
            initialSearchObj.setFolders(new HashSet<String>(vfsFolders));
        }
        initialSearchObj.setLocale(data.getLocale());
        CmsGallerySearchBean searchObj = new CmsGallerySearchBean(initialSearchObj);
        searchObj.setSortOrder(CmsGallerySearchParameters.CmsGallerySortParam.DEFAULT.toString());
        int currentPage = 1;
        boolean found = false;
        searchObj.setPage(currentPage);
        CmsGallerySearchParameters params = this.prepareSearchParams(searchObj);
        CmsGallerySearch searchBean = new CmsGallerySearch();
        searchBean.init(this.getCmsObject());
        searchBean.setIndex("Gallery Index");
        CmsGallerySearchResultList searchResults = null;
        CmsGallerySearchResultList totalResults = new CmsGallerySearchResultList();
        CmsGallerySearchResult foundItem = null;
        while (!found) {
            params.setResultPage(currentPage);
            searchResults = searchBean.getResult(params);
            ListIterator resultsIt = searchResults.listIterator();
            totalResults.append(searchResults);
            while (resultsIt.hasNext()) {
                CmsGallerySearchResult searchResult = (CmsGallerySearchResult)resultsIt.next();
                if (!searchResult.getPath().equals(resource.getRootPath())) continue;
                found = true;
                foundItem = searchResult;
                break;
            }
            if (found || searchResults.getHitCount() / (currentPage * params.getMatchesPerPage()) < 1) break;
            ++currentPage;
        }
        boolean hasResults = searchResults != null;
        searchResults = totalResults;
        if (found && hasResults) {
            initialSearchObj.setSortOrder(params.getSortOrder().name());
            initialSearchObj.setResultCount(searchResults.getHitCount());
            initialSearchObj.setPage(params.getResultPage());
            initialSearchObj.setResults(this.buildSearchResultList(searchResults, foundItem));
            initialSearchObj.setPage(1);
            initialSearchObj.setLastPage(currentPage);
            initialSearchObj.setTabId(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_results.name());
            initialSearchObj.setResourcePath(resourceName);
            initialSearchObj.setResourceType(resType);
        } else {
            this.log("could not find selected resource");
        }
        return initialSearchObj;
    }

    private List<CmsResource> getGalleriesByType(int galleryTypeId) throws CmsException {
        ArrayList<CmsResource> galleries = new ArrayList();
        galleries = this.getCmsObject().readResources("/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryTypeId));
        String siteRoot = this.getCmsObject().getRequestContext().getSiteRoot();
        if (!siteRoot.equals("")) {
            List<CmsResource> systemGalleries = null;
            systemGalleries = this.getCmsObject().readResources("/system/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryTypeId));
            if (systemGalleries != null) {
                galleries.addAll(systemGalleries);
            }
        }
        if (!OpenCms.getSiteManager().isSharedFolder(siteRoot)) {
            String shared = OpenCms.getSiteManager().getSharedFolder();
            List<CmsResource> sharedGalleries = this.getCmsObject().readResources(shared, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryTypeId));
            if (sharedGalleries != null) {
                galleries.addAll(sharedGalleries);
            }
        }
        return galleries;
    }

    private Map<I_CmsResourceType, I_CmsPreviewProvider> getPreviewProviderForTypes(List<I_CmsResourceType> types) {
        HashMap<String, I_CmsPreviewProvider> previewProviderMap = new HashMap<String, I_CmsPreviewProvider>();
        HashMap<I_CmsResourceType, I_CmsPreviewProvider> typeProviderMapping = new HashMap<I_CmsResourceType, I_CmsPreviewProvider>();
        for (I_CmsResourceType type : types) {
            String providerClass = type.getGalleryPreviewProvider();
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(providerClass)) continue;
            providerClass = providerClass.trim();
            try {
                if (previewProviderMap.containsKey(providerClass)) {
                    typeProviderMapping.put(type, (I_CmsPreviewProvider)previewProviderMap.get(providerClass));
                    continue;
                }
                I_CmsPreviewProvider previewProvider = (I_CmsPreviewProvider)Class.forName(providerClass).newInstance();
                previewProviderMap.put(providerClass, previewProvider);
                typeProviderMapping.put(type, previewProvider);
            }
            catch (Exception e) {
                this.logError(new CmsException(Messages.get().container("ERR_INSTANCING_PREVIEW_PROVIDER_2", providerClass, type.getTypeName()), (Throwable)e));
            }
        }
        return typeProviderMapping;
    }

    private CmsResourceManager getResourceManager() {
        if (this.m_resourceManager == null) {
            this.m_resourceManager = OpenCms.getResourceManager();
        }
        return this.m_resourceManager;
    }

    private List<CmsResourceTypeBean> getResourceTypeBeans(I_CmsGalleryProviderConstants.GalleryMode galleryMode, String referenceSitePath, String typesParam) throws CmsRpcException {
        List<I_CmsResourceType> resourceTypes = null;
        List<String> creatableTypes = null;
        switch (galleryMode) {
            case editor: 
            case view: 
            case widget: {
                resourceTypes = this.readResourceTypesFromRequest(typesParam);
                creatableTypes = Collections.emptyList();
                break;
            }
            case ade: {
                resourceTypes = new ArrayList();
                creatableTypes = new ArrayList();
                try {
                    String typeName;
                    CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(this.getCmsObject(), this.getCmsObject().getRequestContext().addSiteRoot(this.getCmsObject().getRequestContext().getUri()));
                    for (CmsResourceTypeConfig typeConfig : config.getResourceTypes()) {
                        if (!typeConfig.checkViewable(this.getCmsObject(), referenceSitePath)) continue;
                        typeName = typeConfig.getTypeName();
                        resourceTypes.add(this.getResourceManager().getResourceType(typeName));
                    }
                    for (CmsResourceTypeConfig typeConfig : config.getCreatableTypes(this.getCmsObject())) {
                        typeName = typeConfig.getTypeName();
                        creatableTypes.add(typeName);
                    }
                    break;
                }
                catch (CmsException e) {
                    this.error(e);
                    break;
                }
            }
            default: {
                resourceTypes = Collections.emptyList();
                creatableTypes = Collections.emptyList();
            }
        }
        return this.buildTypesList(resourceTypes, creatableTypes);
    }

    private List<CmsVfsEntryBean> getRootEntries() throws CmsRpcException {
        ArrayList<CmsVfsEntryBean> rootFolders = new ArrayList<CmsVfsEntryBean>();
        CmsObject cms = this.getCmsObject();
        try {
            CmsResource rootFolderResource = this.getCmsObject().readResource("/");
            String title = cms.readPropertyObject("/", "Title", false).getValue();
            rootFolders.add(new CmsVfsEntryBean(rootFolderResource.getRootPath(), rootFolderResource.getStructureId(), title, true, this.isEditable(this.getCmsObject(), rootFolderResource)));
        }
        catch (CmsException e) {
            this.error(e);
        }
        return rootFolders;
    }

    private Locale getWorkplaceLocale() {
        if (this.m_wpLocale == null) {
            this.m_wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject());
        }
        return this.m_wpLocale;
    }

    private CmsWorkplaceSettings getWorkplaceSettings() {
        if (this.m_workplaceSettings == null) {
            this.m_workplaceSettings = (CmsWorkplaceSettings)this.getRequest().getSession().getAttribute("__CmsWorkplace.WORKPLACE_SETTINGS");
        }
        return this.m_workplaceSettings;
    }

    private boolean isEditable(CmsObject cms, CmsResource resource) {
        try {
            return cms.hasPermissions(resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
        }
        catch (CmsException e) {
            return false;
        }
    }

    private CmsGallerySearchParameters prepareSearchParams(CmsGallerySearchBean searchData) {
        CmsGallerySearchParameters.CmsGallerySortParam sortOrder;
        CmsGallerySearchParameters params = new CmsGallerySearchParameters();
        CmsObject cms = this.getCmsObject();
        if (searchData.getTypes() != null) {
            params.setResourceTypes(searchData.getTypes());
        }
        if (searchData.getGalleries() != null) {
            ArrayList<String> paramGalleries = new ArrayList<String>();
            for (String gallerySitePath : searchData.getGalleries()) {
                paramGalleries.add(cms.getRequestContext().addSiteRoot(gallerySitePath));
            }
            params.setGalleries(paramGalleries);
        }
        String temp = searchData.getSortOrder();
        try {
            sortOrder = CmsGallerySearchParameters.CmsGallerySortParam.valueOf(temp);
        }
        catch (Exception e) {
            sortOrder = CmsGallerySearchParameters.CmsGallerySortParam.DEFAULT;
        }
        params.setSortOrder(sortOrder);
        if (searchData.getScope() == null) {
            params.setScope(CmsGallerySearchScope.everything);
        } else {
            params.setScope(searchData.getScope());
        }
        params.setReferencePath(searchData.getReferencePath());
        params.setFolders(new ArrayList<String>(searchData.getFolders()));
        if (searchData.getCategories() != null) {
            params.setCategories(searchData.getCategories());
        }
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(searchData.getQuery())) {
            params.setSearchWords(searchData.getQuery());
        }
        int page = searchData.getPage();
        params.setResultPage(page);
        String locale = searchData.getLocale();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(locale)) {
            locale = this.getCmsObject().getRequestContext().getLocale().toString();
        }
        params.setSearchLocale(locale);
        params.setMatchesPerPage(searchData.getMatchesPerPage());
        long dateCreatedStart = searchData.getDateCreatedStart();
        long dateCreatedEnd = searchData.getDateCreatedEnd();
        long dateModifiedStart = searchData.getDateModifiedStart();
        long dateModifiedEnd = searchData.getDateModifiedEnd();
        if (dateCreatedStart != -1L && dateCreatedEnd != -1L) {
            params.setDateCreatedTimeRange(dateCreatedStart, dateCreatedEnd);
        } else if (dateCreatedStart != -1L) {
            params.setDateCreatedTimeRange(dateCreatedStart, Long.MAX_VALUE);
        } else if (dateCreatedEnd != -1L) {
            params.setDateCreatedTimeRange(Long.MIN_VALUE, dateCreatedEnd);
        }
        if (dateModifiedStart != -1L && dateModifiedEnd != -1L) {
            params.setDateLastModifiedTimeRange(dateModifiedStart, dateModifiedEnd);
        } else if (dateModifiedStart != -1L) {
            params.setDateLastModifiedTimeRange(dateModifiedStart, Long.MAX_VALUE);
        } else if (dateModifiedEnd != -1L) {
            params.setDateLastModifiedTimeRange(Long.MIN_VALUE, dateModifiedEnd);
        }
        params.setIgnoreSearchExclude(searchData.isIgnoreSearchExclude());
        return params;
    }

    private CmsSitemapEntryBean prepareSitemapEntry(CmsObject cms, CmsJspNavElement navElement, boolean isRoot) throws CmsException {
        CmsResource ownResource = navElement.getResource();
        CmsResource defaultFileResource = null;
        if (ownResource.isFolder() && !navElement.isNavigationLevel()) {
            defaultFileResource = cms.readDefaultFile(ownResource, CmsResourceFilter.ONLY_VISIBLE);
        }
        String type = defaultFileResource != null ? OpenCms.getResourceManager().getResourceType(defaultFileResource.getTypeId()).getTypeName() : OpenCms.getResourceManager().getResourceType(ownResource.getTypeId()).getTypeName();
        return new CmsSitemapEntryBean(navElement.getResource().getRootPath(), navElement.getResourceName(), ownResource.getStructureId(), navElement.getNavText(), type, ownResource.isFolder(), isRoot);
    }

    private Map<String, CmsGalleryTypeInfo> readGalleryInfosByTypeBeans(List<CmsResourceTypeBean> resourceTypes) {
        HashMap<String, CmsGalleryTypeInfo> galleryTypeInfos = new HashMap<String, CmsGalleryTypeInfo>();
        for (CmsResourceTypeBean typeBean : resourceTypes) {
            try {
                this.addGalleriesForType(galleryTypeInfos, typeBean.getType());
            }
            catch (CmsLoaderException e1) {
                this.logError(e1);
            }
        }
        return galleryTypeInfos;
    }

    private Map<String, CmsGalleryTypeInfo> readGalleryInfosByTypeNames(List<String> resourceTypes) {
        HashMap<String, CmsGalleryTypeInfo> galleryTypeInfos = new HashMap<String, CmsGalleryTypeInfo>();
        for (String typeName : resourceTypes) {
            try {
                this.addGalleriesForType(galleryTypeInfos, typeName);
            }
            catch (CmsLoaderException e1) {
                this.logError(e1);
            }
        }
        return galleryTypeInfos;
    }

    private List<I_CmsResourceType> readResourceTypesFromRequest(String typesParam) {
        List<I_CmsResourceType> result = new ArrayList<I_CmsResourceType>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(typesParam)) {
            String[] temp = typesParam.split(",");
            for (int i = 0; i < temp.length; ++i) {
                try {
                    result.add(this.getResourceManager().getResourceType(temp[i].trim()));
                    continue;
                }
                catch (Exception e) {
                    this.logError(e);
                }
            }
        }
        if (result.size() == 0) {
            result = this.getResourceManager().getResourceTypes();
        }
        return result;
    }

    private CmsGallerySearchBean search(CmsGallerySearchBean searchObj) throws CmsException {
        CmsGallerySearchBean searchObjBean = new CmsGallerySearchBean(searchObj);
        if (searchObj == null) {
            return searchObjBean;
        }
        CmsGallerySearchParameters params = this.prepareSearchParams(searchObj);
        CmsGallerySearch searchBean = new CmsGallerySearch();
        if (searchObj.isIncludeExpired()) {
            CmsObject searchCms = OpenCms.initCmsObject(this.getCmsObject());
            searchCms.getRequestContext().setRequestTime(Long.MIN_VALUE);
            searchBean.init(searchCms);
        } else {
            searchBean.init(this.getCmsObject());
        }
        searchBean.setIndex("Gallery Index");
        CmsGallerySearchResultList searchResults = searchBean.getResult(params);
        searchObjBean.setSortOrder(params.getSortOrder().name());
        searchObjBean.setScope(params.getScope());
        searchObjBean.setResultCount(searchResults.getHitCount());
        searchObjBean.setPage(params.getResultPage());
        searchObjBean.setLastPage(params.getResultPage());
        searchObjBean.setResults(this.buildSearchResultList(searchResults, null));
        return searchObjBean;
    }

    private void setLastOpenedGallery(CmsGallerySearchBean searchObject) {
        if (searchObject.getGalleries() != null && searchObject.getGalleries().size() == 1) {
            String galleryPath = searchObject.getGalleries().get(0);
            CmsWorkplaceSettings settings = this.getWorkplaceSettings();
            for (String typeName : searchObject.getTypes()) {
                try {
                    settings.setLastUsedGallery(OpenCms.getResourceManager().getResourceType(typeName).getTypeId(), galleryPath);
                }
                catch (CmsLoaderException e) {
                    this.log(e.getLocalizedMessage(), e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CmsGalleryTypeInfo {
        private List<I_CmsResourceType> m_contentTypes;
        private List<CmsResource> m_galleries;
        private I_CmsResourceType m_resourceType;

        protected CmsGalleryTypeInfo(I_CmsResourceType resourceType, I_CmsResourceType contentType, List<CmsResource> galleries) {
            this.m_resourceType = resourceType;
            this.m_contentTypes = new ArrayList<I_CmsResourceType>();
            this.m_contentTypes.add(contentType);
            this.m_galleries = galleries;
        }

        protected void addContentType(I_CmsResourceType type) {
            this.m_contentTypes.add(type);
        }

        protected List<I_CmsResourceType> getContentTypes() {
            return this.m_contentTypes;
        }

        protected List<CmsResource> getGalleries() {
            return this.m_galleries;
        }

        protected I_CmsResourceType getResourceType() {
            return this.m_resourceType;
        }

        protected void setContentTypes(List<I_CmsResourceType> contentTypes) {
            this.m_contentTypes = contentTypes;
        }

        protected void setGalleries(List<CmsResource> galleries) {
            this.m_galleries = galleries;
        }

        protected void setResourceType(I_CmsResourceType resourceType) {
            this.m_resourceType = resourceType;
        }
    }
}

