/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.List;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSitemapEntryBean
implements IsSerializable {
    private List<CmsSitemapEntryBean> m_children;
    private boolean m_isFolder;
    private boolean m_isRoot;
    private String m_rootPath;
    private String m_sitePath;
    private CmsUUID m_structureId;
    private String m_title;
    private String m_type;

    public CmsSitemapEntryBean(String rootPath, String sitePath, CmsUUID structureId, String title, String type, boolean isFolder, boolean isRoot) {
        this.m_rootPath = rootPath;
        this.m_sitePath = sitePath;
        this.m_structureId = structureId;
        this.m_title = title;
        this.m_type = type;
        this.m_isFolder = isFolder;
        this.m_isRoot = isRoot;
    }

    protected CmsSitemapEntryBean() {
    }

    public List<CmsSitemapEntryBean> getChildren() {
        return this.m_children;
    }

    public String getDisplayName() {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_title)) {
            return this.m_title;
        }
        if (this.m_isRoot) {
            return this.m_sitePath;
        }
        String fixedPath = this.m_sitePath.replaceFirst("/$", "");
        int lastSlash = fixedPath.lastIndexOf(47);
        if (lastSlash == -1) {
            return fixedPath;
        }
        return fixedPath.substring(lastSlash + 1);
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public String getSitePath() {
        return this.m_sitePath;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean hasChildren() {
        return this.m_children != null;
    }

    public boolean isFolder() {
        return this.m_isFolder;
    }

    public boolean isRoot() {
        return this.m_isRoot;
    }

    public void setChildren(List<CmsSitemapEntryBean> children) {
        this.m_children = children;
    }
}

