/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap;

import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;

public class CmsAliasEditorLockTable {
    public static final long TIMEOUT_INTERVAL = 60000L;
    private Map<String, CmsUser> m_map;

    public CmsAliasEditorLockTable() {
        MapMaker mm = new MapMaker().expireAfterWrite(60000L, TimeUnit.MILLISECONDS);
        this.m_map = mm.makeMap();
    }

    public void clear(CmsObject cms, String siteRoot) {
        CmsUser originalUser = this.m_map.get(siteRoot);
        if (originalUser == null || !originalUser.equals(cms.getRequestContext().getCurrentUser())) {
            return;
        }
        this.m_map.remove(siteRoot);
    }

    public CmsUser update(CmsObject cms, String siteRoot) {
        CmsUser originalUser = this.m_map.get(siteRoot);
        if (originalUser == null || originalUser.equals(cms.getRequestContext().getCurrentUser())) {
            this.m_map.put(siteRoot, cms.getRequestContext().getCurrentUser());
            return null;
        }
        return originalUser;
    }
}

