/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.upload;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.ade.upload.ClientMessages;
import org.opencms.ade.upload.CmsUploadService;
import org.opencms.ade.upload.Messages;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.gwt.shared.CmsUploadData;
import org.opencms.gwt.shared.rpc.I_CmsUploadService;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;

public class CmsUploadActionElement
extends CmsGwtActionElement {
    public static final String MODULE_NAME = "upload";

    public CmsUploadActionElement(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    public String export() throws Exception {
        StringBuffer sb = new StringBuffer();
        String prefetchedData = CmsUploadActionElement.serializeForJavascript(I_CmsUploadService.class.getMethod("prefetch", new Class[0]), this.getUploadData());
        sb.append("org_opencms_ade_upload").append("='").append(prefetchedData).append("';");
        sb.append(ClientMessages.get().export(this.getRequest()));
        this.wrapScript(sb);
        return sb.toString();
    }

    public String exportAll() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(super.export());
        sb.append(this.export());
        sb.append(this.exportTargetFolder());
        sb.append(this.exportCloseLink());
        sb.append(this.createNoCacheScript(MODULE_NAME));
        return sb.toString();
    }

    public String exportButton() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(this.exportAll());
        sb.append(this.exportDialogMode());
        return sb.toString();
    }

    public String getTitle() {
        return Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_UPLOAD_TITLE_0");
    }

    public CmsUploadData getUploadData() {
        return CmsUploadService.newInstance(this.getRequest()).prefetch();
    }

    private String exportCloseLink() {
        String closeLink = null;
        if (this.getRequest().getAttribute("closeLink") != null) {
            closeLink = (String)this.getRequest().getAttribute("closeLink");
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(closeLink)) {
            closeLink = "/system/workplace/views/explorer/explorer_files.jsp";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("var ").append("closeLink").append(" = '").append(closeLink).append("';");
        this.wrapScript(sb);
        return sb.toString();
    }

    private String exportDialogMode() {
        StringBuffer sb = new StringBuffer("var dialogMode = 'button';");
        this.wrapScript(sb);
        return sb.toString();
    }

    private String exportTargetFolder() {
        String targetFolder = null;
        if (this.getRequest().getAttribute("currentFolder") != null) {
            targetFolder = (String)this.getRequest().getAttribute("currentFolder");
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(targetFolder)) {
            targetFolder = new Dialog(this).computeCurrentFolder();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("var ").append("targetFolder").append(" = '").append(targetFolder).append("';");
        this.wrapScript(sb);
        return sb.toString();
    }

    private class Dialog
    extends CmsDialog {
        public Dialog(CmsJspActionElement jsp) {
            super(jsp);
        }

        public String computeCurrentFolder() {
            return super.computeCurrentFolder();
        }
    }
}

