/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cmis;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.opencms.cmis.CmsCmisCallContext;
import org.opencms.cmis.CmsCmisTypeManager;
import org.opencms.cmis.I_CmsCmisRepository;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.main.CmsException;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class A_CmsCmisRepository
implements I_CmsCmisRepository {
    public static final String CMIS_ALL = "cmis:all";
    public static final String CMIS_READ = "cmis:read";
    public static final String CMIS_WRITE = "cmis:write";
    protected CmsCmisTypeManager m_typeManager;

    @Override
    public synchronized void addObjectToFolder(CmsCmisCallContext context, String objectId, String folderId, boolean allVersions) {
        throw this.notSupported();
    }

    @Override
    public synchronized Acl applyAcl(CmsCmisCallContext context, String objectId, Acl addAces, Acl removeAces, AclPropagation aclPropagation) {
        throw this.notSupported();
    }

    @Override
    public synchronized Acl applyAcl(CmsCmisCallContext context, String objectId, Acl aces, AclPropagation aclPropagation) {
        throw this.notSupported();
    }

    @Override
    public synchronized void applyPolicy(CmsCmisCallContext context, String policyId, String objectId) {
        throw this.notSupported();
    }

    @Override
    public synchronized void cancelCheckOut(CmsCmisCallContext context, String objectId) {
        throw this.notSupported();
    }

    @Override
    public synchronized void checkIn(CmsCmisCallContext context, Holder<String> objectId, boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces) {
        throw this.notSupported();
    }

    @Override
    public synchronized void checkOut(CmsCmisCallContext context, Holder<String> objectId, Holder<Boolean> contentCopied) {
        throw this.notSupported();
    }

    @Override
    public synchronized String createPolicy(CmsCmisCallContext context, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces) {
        throw this.notSupported();
    }

    @Override
    public synchronized List<ObjectData> getAllVersions(CmsCmisCallContext context, String objectId, String versionSeriesId, String filter, boolean includeAllowableActions) {
        throw this.notSupported();
    }

    @Override
    public synchronized List<ObjectData> getAppliedPolicies(CmsCmisCallContext context, String objectId, String filter) {
        throw this.notSupported();
    }

    @Override
    public synchronized ObjectList getContentChanges(CmsCmisCallContext context, Holder<String> changeLogToken, boolean includeProperties, String filter, boolean includePolicyIds, boolean includeAcl, BigInteger maxItems) {
        throw this.notSupported();
    }

    @Override
    public synchronized ObjectData getObjectOfLatestVersion(CmsCmisCallContext context, String objectId, String versionSeriesId, boolean major, String filter, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, boolean includePolicyIds, boolean includeAcl) {
        throw this.notSupported();
    }

    @Override
    public synchronized Properties getPropertiesOfLatestVersion(CmsCmisCallContext context, String objectId, String versionSeriesId, boolean major, String filter) {
        throw this.notSupported();
    }

    @Override
    public synchronized ObjectList query(CmsCmisCallContext context, String statement, boolean searchAllVersions, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        throw this.notSupported();
    }

    @Override
    public synchronized void removeObjectFromFolder(CmsCmisCallContext context, String objectId, String folderId) {
        throw this.notSupported();
    }

    @Override
    public synchronized void removePolicy(CmsCmisCallContext context, String policyId, String objectId) {
        throw this.notSupported();
    }

    protected byte[] extractRange(byte[] content, BigInteger offset, BigInteger length) {
        if (offset == null && length == null) {
            return content;
        }
        if (offset == null) {
            offset = BigInteger.ZERO;
        }
        long offsetLong = offset.longValue();
        if (length == null) {
            length = BigInteger.valueOf((long)content.length - offsetLong);
        }
        long lengthLong = length.longValue();
        return Arrays.copyOfRange(content, (int)offsetLong, (int)(offsetLong + lengthLong));
    }

    protected String getAcePrincipalName(CmsObject cms, CmsUUID principalId) {
        if (CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID.equals(principalId)) {
            return "ALL_OTHERS";
        }
        if (CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID.equals(principalId)) {
            return "OVERWRITE_ALL";
        }
        CmsRole role = CmsRole.valueOfId(principalId);
        if (role != null) {
            return role.getRoleName();
        }
        try {
            return CmsPrincipal.readPrincipalIncludingHistory(cms, principalId).getName();
        }
        catch (CmsException e) {
            return "" + principalId;
        }
    }

    protected List<CmsProperty> getOpenCmsProperties(Map<String, PropertyData<?>> properties) {
        ArrayList<CmsProperty> cmsProperties = new ArrayList<CmsProperty>();
        for (Map.Entry<String, PropertyData<?>> entry : properties.entrySet()) {
            String propId = entry.getKey();
            if (!propId.startsWith("opencms:")) continue;
            String propName = propId.substring("opencms:".length());
            String value = (String)entry.getValue().getFirstValue();
            if (value == null) {
                value = "";
            }
            cmsProperties.add(new CmsProperty(propName, value, null));
        }
        return cmsProperties;
    }

    protected RuntimeException notSupported() {
        return new CmisNotSupportedException("Not supported");
    }
}

