/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cmis;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.impl.server.RenditionInfoImpl;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.opencms.cmis.CmsCmisCallContext;
import org.opencms.cmis.CmsCmisRenditionFilter;
import org.opencms.cmis.CmsCmisRepository;
import org.opencms.cmis.CmsCmisTypeManager;
import org.opencms.cmis.CmsCmisUtil;
import org.opencms.cmis.I_CmsCmisObjectHelper;
import org.opencms.cmis.I_CmsCmisRenditionProvider;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsCmisResourceHelper
implements I_CmsCmisObjectHelper {
    private CmsCmisRepository m_repository;

    public CmsCmisResourceHelper(CmsCmisRepository repository) {
        this.m_repository = repository;
    }

    @Override
    public synchronized void deleteObject(CmsCmisCallContext context, String objectId, boolean allVersions) {
        try {
            CmsObject cms = this.m_repository.getCmsObject(context);
            CmsUUID structureId = new CmsUUID(objectId);
            CmsResource resource = cms.readResource(structureId);
            if (resource.isFolder()) {
                boolean isLeaf;
                boolean bl = isLeaf = !CmsCmisUtil.hasChildren(cms, resource);
                if (!isLeaf) {
                    throw new CmisConstraintException("Only leaf resources can be deleted.");
                }
            }
            CmsCmisUtil.ensureLock(cms, resource);
            cms.deleteResource(resource.getRootPath(), CmsResource.DELETE_PRESERVE_SIBLINGS);
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
        }
    }

    @Override
    public synchronized Acl getAcl(CmsCmisCallContext context, String objectId, boolean onlyBasicPermissions) {
        try {
            CmsObject cms = this.m_repository.getCmsObject(context);
            CmsUUID structureId = new CmsUUID(objectId);
            CmsResource resource = cms.readResource(structureId);
            return this.collectAcl(cms, resource, onlyBasicPermissions);
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    @Override
    public synchronized AllowableActions getAllowableActions(CmsCmisCallContext context, String objectId) {
        try {
            CmsObject cms = this.m_repository.getCmsObject(context);
            CmsUUID structureId = new CmsUUID(objectId);
            CmsResource file = cms.readResource(structureId);
            return this.collectAllowableActions(cms, file);
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    @Override
    public synchronized ObjectData getObject(CmsCmisCallContext context, String objectId, String filter, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, boolean includePolicyIds, boolean includeAcl) {
        try {
            if (objectId == null) {
                throw new CmisInvalidArgumentException("Object Id must be set.");
            }
            CmsObject cms = this.m_repository.getCmsObject(context);
            CmsResource file = cms.readResource(new CmsUUID(objectId));
            Set<String> filterCollection = CmsCmisUtil.splitFilter(filter);
            return this.collectObjectData(context, cms, file, filterCollection, renditionFilter, includeAllowableActions, includeAcl, includeRelationships);
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    protected Acl collectAcl(CmsObject cms, CmsResource resource, boolean onlyBasic) throws CmsException {
        AccessControlListImpl cmisAcl = new AccessControlListImpl();
        ArrayList<AccessControlEntryImpl> cmisAces = new ArrayList<AccessControlEntryImpl>();
        List<CmsAccessControlEntry> aces = cms.getAccessControlEntries(resource.getRootPath(), true);
        for (CmsAccessControlEntry ace : aces) {
            boolean isDirect = ace.getResource().equals(resource.getResourceId());
            CmsUUID principalId = ace.getPrincipal();
            String principalName = CmsCmisUtil.getAcePrincipalName(cms, principalId);
            AccessControlEntryImpl cmisAce = new AccessControlEntryImpl();
            AccessControlPrincipalDataImpl cmisPrincipal = new AccessControlPrincipalDataImpl();
            cmisPrincipal.setPrincipalId(principalName);
            cmisAce.setPrincipal((Principal)cmisPrincipal);
            cmisAce.setPermissions(onlyBasic ? CmsCmisUtil.getCmisPermissions(ace) : CmsCmisUtil.getNativePermissions(ace));
            cmisAce.setDirect(isDirect);
            cmisAces.add(cmisAce);
        }
        cmisAcl.setAces(cmisAces);
        cmisAcl.setExact(Boolean.FALSE);
        return cmisAcl;
    }

    protected AllowableActions collectAllowableActions(CmsObject cms, CmsResource file) {
        try {
            if (file == null) {
                throw new IllegalArgumentException("File must not be null!");
            }
            CmsLock lock = cms.getLock(file);
            CmsUser user = cms.getRequestContext().getCurrentUser();
            boolean canWrite = !cms.getRequestContext().getCurrentProject().isOnlineProject() && (lock.isOwnedBy(user) || lock.isLockableBy(user)) && cms.hasPermissions(file, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.DEFAULT);
            boolean isReadOnly = !canWrite;
            boolean isFolder = file.isFolder();
            boolean isRoot = file.getRootPath().length() <= 1;
            LinkedHashSet<Action> aas = new LinkedHashSet<Action>();
            CmsCmisUtil.addAction(aas, Action.CAN_GET_OBJECT_PARENTS, !isRoot);
            CmsCmisUtil.addAction(aas, Action.CAN_GET_PROPERTIES, true);
            CmsCmisUtil.addAction(aas, Action.CAN_UPDATE_PROPERTIES, !isReadOnly);
            CmsCmisUtil.addAction(aas, Action.CAN_MOVE_OBJECT, !isReadOnly);
            CmsCmisUtil.addAction(aas, Action.CAN_DELETE_OBJECT, !isReadOnly && !isRoot);
            if (isFolder) {
                CmsCmisUtil.addAction(aas, Action.CAN_GET_DESCENDANTS, true);
                CmsCmisUtil.addAction(aas, Action.CAN_GET_CHILDREN, true);
                CmsCmisUtil.addAction(aas, Action.CAN_GET_FOLDER_PARENT, !isRoot);
                CmsCmisUtil.addAction(aas, Action.CAN_GET_FOLDER_TREE, true);
                CmsCmisUtil.addAction(aas, Action.CAN_CREATE_DOCUMENT, !isReadOnly);
                CmsCmisUtil.addAction(aas, Action.CAN_CREATE_FOLDER, !isReadOnly);
                CmsCmisUtil.addAction(aas, Action.CAN_DELETE_TREE, !isReadOnly);
            } else {
                CmsCmisUtil.addAction(aas, Action.CAN_GET_CONTENT_STREAM, true);
                CmsCmisUtil.addAction(aas, Action.CAN_SET_CONTENT_STREAM, !isReadOnly);
                CmsCmisUtil.addAction(aas, Action.CAN_GET_ALL_VERSIONS, true);
            }
            AllowableActionsImpl result = new AllowableActionsImpl();
            result.setAllowableActions(aas);
            return result;
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    protected ObjectData collectObjectData(CmsCmisCallContext context, CmsObject cms, CmsResource resource, Set<String> filter, String renditionFilter, boolean includeAllowableActions, boolean includeAcl, IncludeRelationships includeRelationships) throws CmsException {
        ObjectDataImpl result = new ObjectDataImpl();
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        result.setProperties(this.collectProperties(cms, resource, filter, objectInfo));
        if (includeAllowableActions) {
            result.setAllowableActions(this.collectAllowableActions(cms, resource));
        }
        if (includeAcl) {
            result.setAcl(this.collectAcl(cms, resource, true));
            result.setIsExactAcl(Boolean.FALSE);
        }
        if (includeRelationships != null && includeRelationships != IncludeRelationships.NONE) {
            RelationshipDirection direction = includeRelationships == IncludeRelationships.SOURCE ? RelationshipDirection.SOURCE : (includeRelationships == IncludeRelationships.TARGET ? RelationshipDirection.TARGET : RelationshipDirection.EITHER);
            List<ObjectData> relationData = this.m_repository.getRelationshipObjectData(context, cms, resource, direction, CmsCmisUtil.splitFilter("*"), false);
            result.setRelationships(relationData);
        }
        result.setRenditions(this.collectRenditions(cms, resource, renditionFilter, objectInfo));
        if (context.isObjectInfoRequired()) {
            objectInfo.setObject((ObjectData)result);
            context.getObjectInfoHandler().addObjectInfo((ObjectInfo)objectInfo);
        }
        return result;
    }

    protected Properties collectProperties(CmsObject cms, CmsResource resource, Set<String> orgfilter, ObjectInfoImpl objectInfo) {
        CmsCmisTypeManager tm = this.m_repository.getTypeManager();
        if (resource == null) {
            throw new IllegalArgumentException("Resource may not be null.");
        }
        LinkedHashSet<String> filter = orgfilter == null ? null : new LinkedHashSet<String>(orgfilter);
        String typeId = null;
        ArrayList<String> relationSourceIds = new ArrayList<String>();
        ArrayList<String> relationTargetIds = new ArrayList<String>();
        try {
            List<CmsRelation> relations = cms.getRelationsForResource(resource, CmsRelationFilter.ALL);
            for (CmsRelation relation : relations) {
                if (resource.getStructureId().equals(relation.getSourceId())) {
                    relationTargetIds.add(relation.getTargetId().toString());
                }
                if (!resource.getStructureId().equals(relation.getTargetId())) continue;
                relationSourceIds.add(relation.getSourceId().toString());
            }
        }
        catch (CmsException e) {
            throw new CmisStorageException(e.getLocalizedMessage(), (Throwable)e);
        }
        if (resource.isFolder()) {
            typeId = CmsCmisTypeManager.FOLDER_TYPE_ID;
            objectInfo.setBaseType(BaseTypeId.CMIS_FOLDER);
            objectInfo.setTypeId(typeId);
            objectInfo.setContentType(null);
            objectInfo.setFileName(null);
            objectInfo.setHasAcl(true);
            objectInfo.setHasContent(false);
            objectInfo.setVersionSeriesId(null);
            objectInfo.setIsCurrentVersion(true);
            objectInfo.setRelationshipSourceIds(relationSourceIds);
            objectInfo.setRelationshipTargetIds(relationTargetIds);
            objectInfo.setSupportsDescendants(true);
            objectInfo.setSupportsFolderTree(true);
            objectInfo.setSupportsPolicies(false);
            objectInfo.setSupportsRelationships(true);
            objectInfo.setWorkingCopyId(null);
            objectInfo.setWorkingCopyOriginalId(null);
        } else {
            typeId = CmsCmisTypeManager.DOCUMENT_TYPE_ID;
            objectInfo.setBaseType(BaseTypeId.CMIS_DOCUMENT);
            objectInfo.setTypeId(typeId);
            objectInfo.setHasAcl(true);
            objectInfo.setHasContent(true);
            objectInfo.setHasParent(true);
            objectInfo.setVersionSeriesId(null);
            objectInfo.setIsCurrentVersion(true);
            objectInfo.setRelationshipSourceIds(relationSourceIds);
            objectInfo.setRelationshipTargetIds(relationTargetIds);
            objectInfo.setSupportsDescendants(false);
            objectInfo.setSupportsFolderTree(false);
            objectInfo.setSupportsPolicies(false);
            objectInfo.setSupportsRelationships(true);
            objectInfo.setWorkingCopyId(null);
            objectInfo.setWorkingCopyOriginalId(null);
        }
        try {
            CmsUser user;
            PropertiesImpl result = new PropertiesImpl();
            String id = resource.getStructureId().toString();
            CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:objectId", id);
            objectInfo.setId(id);
            String name = resource.getName();
            if ("".equals(name)) {
                name = "/";
            }
            CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:name", name);
            objectInfo.setName(name);
            CmsUUID creatorId = resource.getUserCreated();
            CmsUUID modifierId = resource.getUserLastModified();
            String creatorName = creatorId.toString();
            String modifierName = modifierId.toString();
            try {
                user = cms.readUser(creatorId);
                creatorName = user.getName();
            }
            catch (CmsException e) {
                // empty catch block
            }
            try {
                user = cms.readUser(modifierId);
                modifierName = user.getName();
            }
            catch (CmsException e) {
                // empty catch block
            }
            CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:createdBy", creatorName);
            CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:lastModifiedBy", modifierName);
            objectInfo.setCreatedBy(creatorName);
            GregorianCalendar lastModified = CmsCmisUtil.millisToCalendar(resource.getDateLastModified());
            GregorianCalendar created = CmsCmisUtil.millisToCalendar(resource.getDateCreated());
            CmsCmisUtil.addPropertyDateTime(tm, result, typeId, filter, "cmis:creationDate", created);
            CmsCmisUtil.addPropertyDateTime(tm, result, typeId, filter, "cmis:lastModificationDate", lastModified);
            objectInfo.setCreationDate(created);
            objectInfo.setLastModificationDate(lastModified);
            CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:changeToken", null);
            if (resource.isFolder()) {
                CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:baseTypeId", BaseTypeId.CMIS_FOLDER.value());
                CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:objectTypeId", CmsCmisTypeManager.FOLDER_TYPE_ID);
                String path = resource.getRootPath();
                CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:path", path.length() == 0 ? "/" : path);
                if (resource.getRootPath().length() > 1) {
                    CmsResource parent = cms.readParentFolder(resource.getStructureId());
                    CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:parentId", parent.getStructureId().toString());
                    objectInfo.setHasParent(true);
                } else {
                    CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:parentId", null);
                    objectInfo.setHasParent(false);
                }
                CmsCmisUtil.addPropertyIdList(tm, result, typeId, filter, "cmis:allowedChildObjectTypeIds", null);
            } else {
                CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:baseTypeId", BaseTypeId.CMIS_DOCUMENT.value());
                CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:objectTypeId", CmsCmisTypeManager.DOCUMENT_TYPE_ID);
                CmsCmisUtil.addPropertyBoolean(tm, result, typeId, filter, "cmis:isImmutable", false);
                CmsCmisUtil.addPropertyBoolean(tm, result, typeId, filter, "cmis:isLatestVersion", true);
                CmsCmisUtil.addPropertyBoolean(tm, result, typeId, filter, "cmis:isMajorVersion", true);
                CmsCmisUtil.addPropertyBoolean(tm, result, typeId, filter, "cmis:isLatestMajorVersion", true);
                CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:versionLabel", resource.getName());
                CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:versionSeriesId", resource.getStructureId().toString());
                CmsCmisUtil.addPropertyBoolean(tm, result, typeId, filter, "cmis:isVersionSeriesCheckedOut", false);
                CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:versionSeriesCheckedOutBy", null);
                CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:versionSeriesCheckedOutId", null);
                CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:checkinComment", "");
                CmsCmisUtil.addPropertyInteger(tm, result, typeId, filter, "cmis:contentStreamLength", resource.getLength());
                CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:contentStreamMimeType", OpenCms.getResourceManager().getMimeType(resource.getRootPath(), null, "text/plain"));
                CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "cmis:contentStreamFileName", resource.getName());
                objectInfo.setHasContent(true);
                objectInfo.setContentType(OpenCms.getResourceManager().getMimeType(resource.getRootPath(), null, "text/plain"));
                objectInfo.setFileName(resource.getName());
                CmsCmisUtil.addPropertyId(tm, result, typeId, filter, "cmis:contentStreamId", null);
            }
            List<CmsProperty> props = cms.readPropertyObjects(resource, false);
            LinkedHashSet<String> propertiesToAdd = new LinkedHashSet<String>(this.m_repository.getTypeManager().getCmsPropertyNames());
            for (CmsProperty prop : props) {
                CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "opencms:" + prop.getName(), prop.getValue());
                propertiesToAdd.remove(prop.getName());
            }
            for (String propName : propertiesToAdd) {
                CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "opencms:" + propName, null);
            }
            List<CmsProperty> inheritedProps = cms.readPropertyObjects(resource, true);
            LinkedHashSet<String> inheritedPropertiesToAdd = new LinkedHashSet<String>(this.m_repository.getTypeManager().getCmsPropertyNames());
            for (CmsProperty prop : inheritedProps) {
                CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "opencms-inherited:" + prop.getName(), prop.getValue());
                inheritedPropertiesToAdd.remove(prop.getName());
            }
            for (String propName : inheritedPropertiesToAdd) {
                CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "opencms-inherited:" + propName, null);
            }
            I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(resource);
            CmsCmisUtil.addPropertyString(tm, result, typeId, filter, "opencms-special:resource-type", resType.getTypeName());
            CmsCmisUtil.addDynamicProperties(cms, this.m_repository.getTypeManager(), result, typeId, resource, filter);
            return result;
        }
        catch (Exception e) {
            if (e instanceof CmisBaseException) {
                throw (CmisBaseException)e;
            }
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected List<RenditionData> collectRenditions(CmsObject cms, CmsResource resource, String renditionFilterString, ObjectInfoImpl objectInfo) {
        List<I_CmsCmisRenditionProvider> providers = this.m_repository.getRenditionProviders(new CmsCmisRenditionFilter(renditionFilterString));
        ArrayList<RenditionData> result = new ArrayList<RenditionData>();
        ArrayList<RenditionInfoImpl> renditionInfos = new ArrayList<RenditionInfoImpl>();
        for (I_CmsCmisRenditionProvider provider : providers) {
            RenditionData renditionData = provider.getRendition(cms, resource);
            if (renditionData == null) continue;
            RenditionInfoImpl renditionInfo = new RenditionInfoImpl();
            renditionInfo.setContentType(renditionData.getMimeType());
            renditionInfo.setKind(renditionData.getKind());
            renditionInfo.setId(renditionData.getStreamId());
            result.add(renditionData);
            renditionInfos.add(renditionInfo);
        }
        if (objectInfo != null) {
            objectInfo.setRenditionInfos(renditionInfos);
        }
        return result;
    }
}

