/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cmis;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractCmisService;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.opencms.cmis.CmsCmisCallContext;
import org.opencms.cmis.I_CmsCmisRepository;
import org.opencms.main.OpenCms;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsCmisService
extends AbstractCmisService {
    protected CallContext m_callContext;

    public CmsCmisService(CallContext context) {
        this.m_callContext = context;
    }

    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        this.getRepository(repositoryId).addObjectToFolder(this.makeContext(), objectId, folderId, allVersions);
    }

    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        this.getRepository(repositoryId).applyPolicy(this.makeContext(), policyId, objectId);
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.getRepository(repositoryId).createDocument(this.makeContext(), properties, folderId, contentStream, versioningState, policies, addAces, removeAces);
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.getRepository(repositoryId).createDocumentFromSource(this.makeContext(), sourceId, properties, folderId, versioningState, policies, addAces, removeAces);
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.getRepository(repositoryId).createFolder(this.makeContext(), properties, folderId, policies, addAces, removeAces);
    }

    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.getRepository(repositoryId).createPolicy(this.makeContext(), properties, folderId, policies, addAces, removeAces);
    }

    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.getRepository(repositoryId).createRelationship(this.makeContext(), properties, policies, addAces, removeAces);
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        this.getRepository(repositoryId).deleteContentStream(this.makeContext(), objectId, changeToken);
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.getRepository(repositoryId).deleteObject(this.makeContext(), objectId, allVersions);
    }

    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.getRepository(repositoryId).deleteObject(this.makeContext(), objectId, allVersions);
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        return this.getRepository(repositoryId).deleteTree(this.makeContext(), folderId, allVersions, unfileObjects, continueOnFailure);
    }

    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        return this.getRepository(repositoryId).getAcl(this.makeContext(), objectId, onlyBasicPermissions);
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        return this.getRepository(repositoryId).getAllowableActions(this.makeContext(), objectId);
    }

    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        return this.getRepository(repositoryId).getAppliedPolicies(this.makeContext(), objectId, filter);
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.getRepository(repositoryId).getCheckedOutDocs(this.makeContext(), folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount);
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.getRepository(repositoryId).getChildren(this.makeContext(), folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, maxItems, skipCount);
    }

    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension) {
        return this.getRepository(repositoryId).getContentChanges(this.makeContext(), changeLogToken, includeProperties, filter, includePolicyIds, includeAcl, maxItems);
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        return this.getRepository(repositoryId).getContentStream(this.makeContext(), objectId, streamId, offset, length);
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        return this.getRepository(repositoryId).getDescendants(this.makeContext(), folderId, depth, filter, includeAllowableActions, includePathSegment, false);
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        return this.getRepository(repositoryId).getFolderParent(this.makeContext(), folderId, filter);
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        return this.getRepository(repositoryId).getDescendants(this.makeContext(), folderId, depth, filter, includeAllowableActions, includePathSegment, true);
    }

    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.getRepository(repositoryId).getObject(this.makeContext(), objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.getRepository(repositoryId).getObjectByPath(this.makeContext(), path, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
    }

    public ObjectInfo getObjectInfo(String repositoryId, String objectId) {
        ObjectInfo result = super.getObjectInfo(repositoryId, objectId);
        return result;
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        return this.getRepository(repositoryId).getObjectParents(this.makeContext(), objectId, filter, includeAllowableActions, includeRelativePathSegment);
    }

    public ObjectList getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.getRepository(repositoryId).getObjectRelationships(this.makeContext(), objectId, includeSubRelationshipTypes, relationshipDirection, typeId, filter, includeAllowableActions, maxItems, skipCount);
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        return this.getRepository(repositoryId).getProperties(this.makeContext(), objectId, filter);
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.getRepository(repositoryId).getRenditions(this.makeContext(), objectId, renditionFilter, maxItems, skipCount);
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        return this.getRepository(repositoryId).getRepositoryInfo();
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        for (I_CmsCmisRepository repository : OpenCms.getRepositoryManager().getRepositories(I_CmsCmisRepository.class)) {
            result.add(repository.getRepositoryInfo());
        }
        return result;
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.getRepository(repositoryId).getTypeChildren(this.makeContext(), typeId, includePropertyDefinitions, maxItems, skipCount);
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        return this.getRepository(repositoryId).getTypeDefinition(this.makeContext(), typeId);
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        return this.getRepository(repositoryId).getTypeDescendants(this.makeContext(), typeId, depth, includePropertyDefinitions);
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        this.getRepository(repositoryId).moveObject(this.makeContext(), objectId, targetFolderId, sourceFolderId);
    }

    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.getRepository(repositoryId).query(this.makeContext(), statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount);
    }

    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        this.getRepository(repositoryId).removeObjectFromFolder(this.makeContext(), objectId, folderId);
    }

    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        this.getRepository(repositoryId).removePolicy(this.makeContext(), policyId, objectId);
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        this.getRepository(repositoryId).setContentStream(this.makeContext(), objectId, overwriteFlag, changeToken, contentStream);
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        this.getRepository(repositoryId).updateProperties(this.makeContext(), objectId, changeToken, properties);
    }

    protected I_CmsCmisRepository getRepository(String repositoryId) {
        I_CmsCmisRepository result = OpenCms.getRepositoryManager().getRepository(repositoryId, I_CmsCmisRepository.class);
        if (result == null) {
            throw new CmisConnectionException("missing repository: " + repositoryId);
        }
        return result;
    }

    private CmsCmisCallContext makeContext() {
        return new CmsCmisCallContext(this.m_callContext, (ObjectInfoHandler)this);
    }
}

