/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocumentType;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.I_CmsXmlConfiguration;
import org.opencms.configuration.Messages;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsFileUtil;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlErrorHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsConfigurationManager
implements I_CmsXmlConfiguration {
    public static final String DEFAULT_DTD_LOCATION = "org/opencms/configuration/";
    public static final String DEFAULT_DTD_PREFIX = "http://www.opencms.org/dtd/6.0/";
    public static final String DEFAULT_XML_FILE_NAME = "opencms.xml";
    public static final String DTD_FILE_NAME = "opencms-configuration.dtd";
    public static final String N_ROOT = "opencms";
    public static final String POSTFIX_ORI = ".ori";
    protected static final String N_CONFIG = "config";
    protected static final String N_CONFIGURATION = "configuration";
    private static final SimpleDateFormat BACKUP_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_");
    private static final Log LOG = CmsLog.getLog(CmsConfigurationManager.class);
    private static final long MAX_BACKUP_DAYS = 15L;
    private File m_backupFolder;
    private File m_baseFolder;
    private List<I_CmsXmlConfiguration> m_configurations;
    private Digester m_digester;
    private CmsParameterConfiguration m_propertyConfiguration;

    public CmsConfigurationManager(String baseFolder) {
        this.m_baseFolder = new File(baseFolder);
        if (!this.m_baseFolder.exists() && LOG.isErrorEnabled()) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_CONFIG_BASE_FOLDER_1", this.m_baseFolder.getAbsolutePath()));
        }
        this.m_backupFolder = new File(this.m_baseFolder.getAbsolutePath() + File.separatorChar + "backup");
        if (!this.m_backupFolder.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_CONFIG_BKP_FOLDER_1", this.m_backupFolder.getAbsolutePath()));
            }
            this.m_backupFolder.mkdirs();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CONFIG_BASE_FOLDER_1", this.m_baseFolder.getAbsolutePath()));
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CONFIG_BKP_FOLDER_1", this.m_backupFolder.getAbsolutePath()));
        }
        this.cacheDtdSystemId(this);
        this.m_configurations = new ArrayList<I_CmsXmlConfiguration>();
    }

    public void addConfiguration(I_CmsXmlConfiguration configuration) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_CONFIG_1", configuration));
        }
        this.m_configurations.add(configuration);
        this.cacheDtdSystemId(configuration);
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
    }

    @Override
    public void addXmlDigesterRules(Digester digester) {
        digester.addObjectCreate("*/configuration/config", "class", CmsConfigurationException.class);
        digester.addSetNext("*/configuration/config", "addConfiguration");
    }

    @Override
    public Element generateXml(Element parent) {
        Element configurationElement = parent.addElement(N_CONFIGURATION);
        for (int i = 0; i < this.m_configurations.size(); ++i) {
            I_CmsXmlConfiguration configuration = this.m_configurations.get(i);
            configurationElement.addElement(N_CONFIG).addAttribute("class", configuration.getClass().getName());
        }
        return parent;
    }

    public Document generateXml(I_CmsXmlConfiguration configuration) {
        Document result = DocumentHelper.createDocument();
        DOMDocumentType docType = new DOMDocumentType();
        docType.setElementName(N_ROOT);
        docType.setSystemID(configuration.getDtdUrlPrefix() + configuration.getDtdFilename());
        result.setDocType((DocumentType)docType);
        Element root = result.addElement(N_ROOT);
        configuration.generateXml(root);
        return result;
    }

    public File getBackupFolder() {
        return this.m_backupFolder;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_propertyConfiguration;
    }

    public I_CmsXmlConfiguration getConfiguration(Class<?> clazz) {
        for (int i = 0; i < this.m_configurations.size(); ++i) {
            I_CmsXmlConfiguration configuration = this.m_configurations.get(i);
            if (!clazz.equals(configuration.getClass())) continue;
            return configuration;
        }
        return null;
    }

    public List<I_CmsXmlConfiguration> getConfigurations() {
        return this.m_configurations;
    }

    @Override
    public String getDtdFilename() {
        return DTD_FILE_NAME;
    }

    @Override
    public String getDtdSystemLocation() {
        return DEFAULT_DTD_LOCATION;
    }

    @Override
    public String getDtdUrlPrefix() {
        return DEFAULT_DTD_PREFIX;
    }

    @Override
    public String getXmlFileName() {
        return DEFAULT_XML_FILE_NAME;
    }

    @Override
    public void initConfiguration() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_INIT_CONFIGURATION_1", this));
        }
    }

    public void loadXmlConfiguration() throws SAXException, IOException {
        URL baseUrl = this.m_baseFolder.toURI().toURL();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_BASE_URL_1", baseUrl));
        }
        this.loadXmlConfiguration(baseUrl, this);
        Iterator<I_CmsXmlConfiguration> i = this.m_configurations.iterator();
        while (i.hasNext()) {
            this.loadXmlConfiguration(baseUrl, i.next());
        }
        this.removeOldBackups(15L);
    }

    public void setConfiguration(CmsParameterConfiguration propertyConfiguration) {
        this.m_propertyConfiguration = propertyConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfiguration(Class<?> clazz) throws IOException, CmsConfigurationException {
        I_CmsXmlConfiguration configuration = this.getConfiguration(clazz);
        if (configuration == null) {
            throw new CmsConfigurationException(Messages.get().container("ERR_CONFIG_WITH_UNKNOWN_CLASS_1", clazz.getName()));
        }
        File file = new File(this.m_baseFolder, configuration.getXmlFileName());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_WRITE_CONFIG_XMLFILE_1", file.getAbsolutePath()));
        }
        Document config = this.generateXml(configuration);
        XMLWriter writer = null;
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setIndentSize(4);
        format.setTrimText(false);
        format.setEncoding("UTF-8");
        try {
            FileOutputStream out = new FileOutputStream(file);
            writer = new XMLWriter((OutputStream)out, format);
            writer.write(config);
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_WRITE_CONFIG_SUCCESS_2", file.getAbsolutePath(), configuration.getClass().getName()));
        }
    }

    private void backupXmlConfiguration(I_CmsXmlConfiguration configuration) {
        String fromName = this.m_baseFolder.getAbsolutePath() + File.separatorChar + configuration.getXmlFileName();
        String toDatePrefix = BACKUP_DATE_FORMAT.format(new Date());
        String toName = this.m_backupFolder.getAbsolutePath() + File.separatorChar + toDatePrefix + configuration.getXmlFileName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_CONFIG_BKP_2", fromName, toName));
        }
        try {
            CmsFileUtil.copy(fromName, toName);
        }
        catch (IOException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_CREATE_CONFIG_BKP_FAILURE_1", toName), (Throwable)e);
        }
    }

    private void cacheDtdSystemId(I_CmsXmlConfiguration configuration) {
        if (configuration.getDtdSystemLocation() != null) {
            try {
                String file = CmsFileUtil.readFile(configuration.getDtdSystemLocation() + configuration.getDtdFilename(), "UTF-8");
                CmsXmlEntityResolver.cacheSystemId(configuration.getDtdUrlPrefix() + configuration.getDtdFilename(), file.getBytes("UTF-8"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_CACHE_DTD_SYSTEM_ID_1", configuration.getDtdUrlPrefix() + configuration.getDtdFilename() + " --> " + configuration.getDtdSystemLocation() + configuration.getDtdFilename()));
                }
            }
            catch (IOException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_CACHE_DTD_SYSTEM_ID_FAILURE_1", configuration.getDtdSystemLocation() + configuration.getDtdFilename()), (Throwable)e);
            }
        }
    }

    private void loadXmlConfiguration(URL url, I_CmsXmlConfiguration configuration) throws SAXException, IOException {
        URL fileUrl = new URL(url, configuration.getXmlFileName());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_LOAD_CONFIG_XMLFILE_1", fileUrl));
        }
        this.backupXmlConfiguration(configuration);
        this.m_digester = new Digester();
        this.m_digester.setUseContextClassLoader(true);
        this.m_digester.setValidating(true);
        this.m_digester.setEntityResolver((EntityResolver)new CmsXmlEntityResolver(null));
        this.m_digester.setRuleNamespaceURI(null);
        this.m_digester.setErrorHandler((ErrorHandler)new CmsXmlErrorHandler(fileUrl.getFile()));
        this.m_digester.push((Object)configuration);
        configuration.addXmlDigesterRules(this.m_digester);
        this.m_digester.parse(fileUrl.openStream());
    }

    private void removeOldBackups(long daysToKeep) {
        long maxAge = System.currentTimeMillis() - daysToKeep * 24L * 60L * 60L * 1000L;
        File[] files = this.m_backupFolder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            long lastMod = file.lastModified();
            if (!(lastMod < maxAge & !file.getAbsolutePath().endsWith(POSTFIX_ORI))) continue;
            file.delete();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)Messages.get().getBundle().key("LOG_REMOVE_CONFIG_FILE_1", file.getAbsolutePath()));
        }
    }
}

