/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CmsPersistenceUnitConfiguration {
    public static final String ATTR_CONNECTION_PROPERTIES = "openjpa.ConnectionProperties";
    public static final String ATTR_GENERATE_SCHEMA = "openjpa.jdbc.SynchronizeMappings";
    public static final String ATTR_GENERATE_SCHEMA_VALUE = "buildSchema(ForeignKeys=true)";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String TAG_PERSISTENCE_UNIT = "persistence-unit";
    public static final String TAG_PROPERTIES = "properties";
    public static final String TAG_PROPERTY = "property";
    private Document m_document;
    private String m_fileName;
    private Element m_persistenceUnit;
    private String m_persistenceUnitName;
    private NodeList m_properties;
    private Element m_propertiesElement;

    public CmsPersistenceUnitConfiguration(String unitName, String fileName) {
        this.m_fileName = new String(fileName);
        this.m_persistenceUnitName = unitName;
        this.m_document = this.readDocument(this.m_fileName);
        this.m_persistenceUnit = this.getPersistenceUnit(this.m_document.getDocumentElement());
        this.m_propertiesElement = (Element)this.m_persistenceUnit.getElementsByTagName(TAG_PROPERTIES).item(0);
        this.refreshProperties();
    }

    public String getPropertyValue(String name, String defaultValue) {
        Element el = null;
        for (int i = 0; i < this.m_properties.getLength(); ++i) {
            el = (Element)this.m_properties.item(i);
            if (!name.equalsIgnoreCase(el.getAttribute(ATTR_NAME))) continue;
            return el.getAttribute(ATTR_VALUE);
        }
        return defaultValue;
    }

    public void removeProperty(String name) {
        Element el = null;
        for (int i = 0; i < this.m_properties.getLength(); ++i) {
            el = (Element)this.m_properties.item(i);
            if (!name.equalsIgnoreCase(el.getAttribute(ATTR_NAME))) continue;
            this.m_propertiesElement.removeChild(el);
            break;
        }
        this.refreshProperties();
    }

    public void save() {
        this.save(this.m_fileName);
    }

    public void setPropertyValue(String name, String value) {
        boolean exist = false;
        Element el = null;
        for (int i = 0; i < this.m_properties.getLength(); ++i) {
            el = (Element)this.m_properties.item(i);
            if (!name.equalsIgnoreCase(el.getAttribute(ATTR_NAME))) continue;
            el.setAttribute(ATTR_VALUE, value);
            exist = true;
            break;
        }
        if (!exist) {
            this.addProperty(name, value);
        }
    }

    private void addProperty(String name, String value) {
        Element el = this.m_document.createElement(TAG_PROPERTY);
        el.setAttribute(ATTR_NAME, name);
        el.setAttribute(ATTR_VALUE, value);
        this.m_propertiesElement.appendChild(el);
        this.refreshProperties();
    }

    private Element getPersistenceUnit(Element e) {
        NodeList list = e.getElementsByTagName(TAG_PERSISTENCE_UNIT);
        Element el = null;
        for (int i = 0; i < list.getLength() && !this.m_persistenceUnitName.equalsIgnoreCase((el = (Element)list.item(i)).getAttribute(ATTR_NAME)); ++i) {
        }
        return el;
    }

    private Document readDocument(String fileName) {
        Document doc = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            File f = new File(fileName);
            doc = builder.parse(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    private void refreshProperties() {
        this.m_properties = this.m_propertiesElement.getElementsByTagName(TAG_PROPERTY);
    }

    private void save(String fileName) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(this.m_document);
            File file = new File(fileName);
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

