/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.dom4j.Element;
import org.opencms.configuration.A_CmsXmlConfiguration;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.Messages;
import org.opencms.db.CmsCacheSettings;
import org.opencms.db.CmsDefaultUsers;
import org.opencms.db.CmsLoginManager;
import org.opencms.db.CmsLoginMessage;
import org.opencms.db.CmsSubscriptionManager;
import org.opencms.db.I_CmsDbContextFactory;
import org.opencms.flex.CmsFlexCacheConfiguration;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.mail.CmsMailHost;
import org.opencms.mail.CmsMailSettings;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsDefaultSessionStorageProvider;
import org.opencms.main.CmsEventManager;
import org.opencms.main.CmsHttpAuthenticationSettings;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsServletContainerSettings;
import org.opencms.main.I_CmsRequestHandler;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.I_CmsSessionStorageProvider;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitorConfiguration;
import org.opencms.publish.CmsPublishManager;
import org.opencms.scheduler.CmsScheduleManager;
import org.opencms.scheduler.CmsScheduledJobInfo;
import org.opencms.security.CmsDefaultAuthorizationHandler;
import org.opencms.security.CmsDefaultValidationHandler;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.I_CmsAuthorizationHandler;
import org.opencms.security.I_CmsPasswordHandler;
import org.opencms.security.I_CmsValidationHandler;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteManagerImpl;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.util.CmsStringUtil;
import org.opencms.workflow.CmsDefaultWorkflowManager;
import org.opencms.workflow.I_CmsWorkflowManager;
import org.opencms.xml.containerpage.CmsADECacheSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSystemConfiguration
extends A_CmsXmlConfiguration {
    public static final String A_DELETED = "deleted";
    public static final String A_ERROR = "error";
    public static final String A_EXCLUSIVE = "exclusive";
    public static final String A_MAXVISITED = "maxvisited";
    public static final String A_MODE = "mode";
    public static final String A_OFFLINE = "offline";
    public static final String A_OFFSET = "offset";
    public static final String A_ONLINE = "online";
    public static final String A_POOLNAME = "poolname";
    public static final String A_SERVER = "server";
    public static final String CONFIGURATION_DTD_NAME = "opencms-system.dtd";
    public static final String DEFAULT_XML_FILE_NAME = "opencms-system.xml";
    public static final String N_ACTIVE = "active";
    public static final String N_ADE = "ade";
    public static final String N_ADE_CACHE = "ade-cache";
    public static final String N_ALIAS = "alias";
    public static final String N_AUTHORIZATIONHANDLER = "authorizationhandler";
    public static final String N_AVGCACHEBYTES = "avgcachebytes";
    public static final String N_BROWSER_BASED = "browser-based";
    public static final String N_CACHE_ENABLED = "cache-enabled";
    public static final String N_CACHE_OFFLINE = "cache-offline";
    public static final String N_CLASS = "class";
    public static final String N_CONFIGURATION = "configuration";
    public static final String N_CONTAINERPAGES = "containerpages";
    public static final String N_CONTENT_NOTIFICATION = "content-notification";
    public static final String N_CONTEXT = "context";
    public static final String N_CRONEXPRESSION = "cronexpression";
    public static final String N_DEFAULT_CONTENT_ENCODING = "defaultcontentencoding";
    public static final String N_DEFAULT_URI = "default-uri";
    public static final String N_DEFAULTUSERS = "defaultusers";
    public static final String N_DEVICESELECTOR = "device-selector";
    public static final String N_DIGESTTYPE = "digest-type";
    public static final String N_DISABLEMINUTES = "disableMinutes";
    public static final String N_DOCUMENTS = "documents";
    public static final String N_EMAIL_INTERVAL = "email-interval";
    public static final String N_EMAIL_RECEIVER = "email-receiver";
    public static final String N_EMAIL_SENDER = "email-sender";
    public static final String N_ENABLED = "enabled";
    public static final String N_ENABLESCURITY = "enableSecurity";
    public static final String N_ENCODING = "encoding";
    public static final String N_EVENTMANAGER = "eventmanager";
    public static final String N_EVENTS = "events";
    public static final String N_FLEXCACHE = "flexcache";
    public static final String N_FORM_BASED = "form-based";
    public static final String N_GROUP_ADMINISTRATORS = "group-administrators";
    public static final String N_GROUP_GUESTS = "group-guests";
    public static final String N_GROUP_PROJECTMANAGERS = "group-projectmanagers";
    public static final String N_GROUP_USERS = "group-users";
    public static final String N_GROUPCONTAINERS = "groupcontainers";
    public static final String N_HISTORYSIZE = "history-size";
    public static final String N_HTTP_AUTHENTICATION = "http-authentication";
    public static final String N_I18N = "internationalization";
    public static final String N_JOB = "job";
    public static final String N_KEYGENERATOR = "keygenerator";
    public static final String N_LOCALE = "locale";
    public static final String N_LOCALEHANDLER = "localehandler";
    public static final String N_LOCALESCONFIGURED = "localesconfigured";
    public static final String N_LOCALESDEFAULT = "localesdefault";
    public static final String N_LOG_INTERVAL = "log-interval";
    public static final String N_LOGINFORBIDDEN = "loginForbidden";
    public static final String N_LOGINMANAGER = "loginmanager";
    public static final String N_LOGINMESSAGE = "loginmessage";
    public static final String N_MAIL = "mail";
    public static final String N_MAILFROM = "mailfrom";
    public static final String N_MAILHOST = "mailhost";
    public static final String N_MAXBADATTEMPTS = "maxBadAttempts";
    public static final String N_MAXCACHEBYTES = "maxcachebytes";
    public static final String N_MAXENTRYBYTES = "maxentrybytes";
    public static final String N_MAXKEYS = "maxkeys";
    public static final String N_MAXUSAGE_PERCENT = "maxusagepercent";
    public static final String N_MEMORYMONITOR = "memorymonitor";
    public static final String N_MESSAGE = "message";
    public static final String N_NOTIFICATION_PROJECT = "notification-project";
    public static final String N_NOTIFICATION_TIME = "notification-time";
    public static final String N_PARAMETERS = "parameters";
    public static final String N_PASSWORDENCODING = "encoding";
    public static final String N_PASSWORDHANDLER = "passwordhandler";
    public static final String N_PERMISSIONHANDLER = "permissionhandler";
    public static final String N_PREVENTRESPONSEFLUSH = "prevent-response-flush";
    public static final String N_PROJECT = "project";
    public static final String N_PUBLISHMANAGER = "publishmanager";
    public static final String N_QUEUEPERSISTANCE = "queue-persistance";
    public static final String N_QUEUESHUTDOWNTIME = "queue-shutdowntime";
    public static final String N_RECEIVER = "receiver";
    public static final String N_RELEASETAGSAFTEREND = "release-tags-after-end";
    public static final String N_REMOTEADDR = "remoteaddr";
    public static final String N_REQUESTEDURI = "requesteduri";
    public static final String N_REQUESTERRORPAGEATTRIBUTE = "request-error-page-attribute";
    public static final String N_REQUESTHANDLER = "requesthandler";
    public static final String N_REQUESTHANDLERS = "requesthandlers";
    public static final String N_RESOURCEINIT = "resourceinit";
    public static final String N_RESOURCEINITHANDLER = "resourceinithandler";
    public static final String N_RESULTCACHE = "resultcache";
    public static final String N_REUSEINSTANCE = "reuseinstance";
    public static final String N_RUNTIMECLASSES = "runtimeclasses";
    public static final String N_RUNTIMEINFO = "runtimeinfo";
    public static final String N_RUNTIMEPROPERTIES = "runtimeproperties";
    public static final String N_SCHEDULER = "scheduler";
    public static final String N_SECURE = "secure";
    public static final String N_SERVLETCONTAINERSETTINGS = "servletcontainer-settings";
    public static final String N_SESSION_STORAGEPROVIDER = "session-storageprovider";
    public static final String N_SHARED_FOLDER = "shared-folder";
    public static final String N_SITEMAP = "sitemap";
    public static final String N_SITEMAP_CACHE = "sitemap-cache";
    public static final String N_SITEROOT = "siteroot";
    public static final String N_SITES = "sites";
    public static final String N_SIZE_ACLS = "size-accesscontrollists";
    public static final String N_WORKFLOW = "workflow";
    public static final String N_SIZE_CONTAINERPAGE_OFFLINE = "size-containerpage-offline";
    public static final String N_SIZE_CONTAINERPAGE_ONLINE = "size-containerpage-online";
    public static final String N_SIZE_GROUPS = "size-groups";
    public static final String N_SIZE_ORGUNITS = "size-orgunits";
    public static final String N_SIZE_PERMISSIONS = "size-permissions";
    public static final String N_SIZE_PROJECTRESOURCES = "size-projectresources";
    public static final String N_SIZE_PROJECTS = "size-projects";
    public static final String N_SIZE_PROPERTIES = "size-properties";
    public static final String N_SIZE_PROPERTYLISTS = "size-propertylists";
    public static final String N_SIZE_RESOURCELISTS = "size-resourcelists";
    public static final String N_SIZE_RESOURCES = "size-resources";
    public static final String N_SIZE_ROLES = "size-roles";
    public static final String N_SIZE_USERGROUPS = "size-usergroups";
    public static final String N_SIZE_USERS = "size-users";
    public static final String N_SUBSCRIPTIONMANAGER = "subscriptionmanager";
    public static final String N_SYSTEM = "system";
    public static final String N_TIMEEND = "timeEnd";
    public static final String N_TIMESTART = "timeStart";
    public static final String N_TIMEZONE = "timezone";
    public static final String N_USER_ADMIN = "user-admin";
    public static final String N_USER_DELETEDRESOURCE = "user-deletedresource";
    public static final String N_USER_EXPORT = "user-export";
    public static final String N_USER_GUEST = "user-guest";
    public static final String N_USERNAME = "user";
    public static final String N_VALIDATIONHANDLER = "validationhandler";
    public static final String N_VERSIONHISTORY = "versionhistory";
    public static final String N_WARNING_INTERVAL = "warning-interval";
    public static final String N_WORKPLACE_SERVER = "workplace-server";
    private static final Log LOG = CmsLog.getLog(CmsSystemConfiguration.class);
    private CmsADECacheSettings m_adeCacheSettings;
    private String m_adeConfiguration;
    private String m_authorizationHandler;
    private CmsCacheSettings m_cacheSettings;
    private CmsDefaultUsers m_cmsDefaultUsers;
    private CmsFlexCacheConfiguration m_cmsFlexCacheConfiguration;
    private CmsMemoryMonitorConfiguration m_cmsMemoryMonitorConfiguration;
    private List<CmsScheduledJobInfo> m_configuredJobs;
    private String m_defaultContentEncoding;
    private CmsEventManager m_eventManager;
    private boolean m_historyEnabled;
    private int m_historyVersions;
    private int m_historyVersionsAfterDeletion;
    private CmsHttpAuthenticationSettings m_httpAuthenticationSettings;
    private CmsLocaleManager m_localeManager;
    private CmsLoginManager m_loginManager;
    private CmsLoginMessage m_loginMessage;
    private CmsMailSettings m_mailSettings;
    private String m_notificationProject;
    private Integer m_notificationTime;
    private I_CmsPasswordHandler m_passwordHandler;
    private String m_permissionHandler;
    private CmsPublishManager m_publishManager;
    private I_CmsWorkflowManager m_workflowManager;
    private List<I_CmsRequestHandler> m_requestHandlers;
    private List<I_CmsResourceInit> m_resourceInitHandlers;
    private I_CmsDbContextFactory m_runtimeInfoFactory;
    private Map<String, String> m_runtimeProperties;
    private CmsScheduleManager m_scheduleManager;
    private String m_sessionStorageProvider;
    private CmsSiteManagerImpl m_siteManager;
    private CmsSubscriptionManager m_subscriptionManager;
    private int m_tempFileProjectId;
    private String m_validationHandler;

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_runtimeProperties.put(paramName, paramValue);
    }

    public void addEventManager(String clazz) {
        try {
            this.m_eventManager = (CmsEventManager)Class.forName(clazz).newInstance();
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EVENTMANAGER_CLASS_SUCCESS_1", this.m_eventManager));
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("INIT_EVENTMANAGER_CLASS_INVALID_1", clazz), t);
            return;
        }
    }

    public void addJobFromConfiguration(CmsScheduledJobInfo jobInfo) {
        this.m_configuredJobs.add(jobInfo);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SCHEDULER_CONFIG_JOB_3", jobInfo.getJobName(), jobInfo.getClassName(), jobInfo.getContextInfo().getUserName()));
        }
    }

    public void addRequestHandler(String clazz) {
        Object initClass;
        try {
            initClass = Class.forName(clazz).newInstance();
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INIT_REQUEST_HANDLER_FAILURE_1", clazz), t);
            return;
        }
        if (initClass instanceof I_CmsRequestHandler) {
            this.m_requestHandlers.add((I_CmsRequestHandler)initClass);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_REQUEST_HANDLER_SUCCESS_1", clazz));
            }
        } else if (CmsLog.INIT.isErrorEnabled()) {
            CmsLog.INIT.error((Object)Messages.get().getBundle().key("INIT_REQUEST_HANDLER_INVALID_1", clazz));
        }
    }

    public void addResourceInitHandler(String clazz) {
        Object initClass;
        try {
            initClass = Class.forName(clazz).newInstance();
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_RESOURCE_INIT_CLASS_INVALID_1", clazz), t);
            return;
        }
        if (initClass instanceof I_CmsResourceInit) {
            this.m_resourceInitHandlers.add((I_CmsResourceInit)initClass);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_RESOURCE_INIT_SUCCESS_1", clazz));
            }
        } else if (CmsLog.INIT.isErrorEnabled()) {
            CmsLog.INIT.error((Object)Messages.get().getBundle().key("INIT_RESOURCE_INIT_INVALID_CLASS_1", clazz));
        }
    }

    public void addScheduleManager() {
        this.m_scheduleManager = new CmsScheduleManager(this.m_configuredJobs);
    }

    @Override
    public void addXmlDigesterRules(Digester digester) {
        digester.addCallMethod("*/system", "initializeFinished");
        digester.addObjectCreate("*/system/internationalization", CmsLocaleManager.class);
        digester.addSetNext("*/system/internationalization", "setLocaleManager");
        digester.addObjectCreate("*/system/internationalization/localehandler", N_CLASS, CmsConfigurationException.class);
        digester.addSetNext("*/system/internationalization/localehandler", "setLocaleHandler");
        digester.addCallMethod("*/system/internationalization/localesconfigured/locale", "addAvailableLocale", 0);
        digester.addCallMethod("*/system/internationalization/localesdefault/locale", "addDefaultLocale", 0);
        digester.addCallMethod("*/system/internationalization/timezone", "setTimeZone", 0);
        digester.addCallMethod("*/system/versionhistory", "setHistorySettings", 3);
        digester.addCallParam("*/system/versionhistory", 0, N_ENABLED);
        digester.addCallParam("*/system/versionhistory", 1, "count");
        digester.addCallParam("*/system/versionhistory", 2, A_DELETED);
        digester.addObjectCreate("*/system/mail", CmsMailSettings.class);
        digester.addCallMethod("*/system/mail/mailfrom", "setMailFromDefault", 0);
        digester.addSetNext("*/system/mail", "setMailSettings");
        digester.addCallMethod("*/system/mail/mailhost", "addMailHost", 6);
        digester.addCallParam("*/system/mail/mailhost", 0, "name");
        digester.addCallParam("*/system/mail/mailhost", 1, "port");
        digester.addCallParam("*/system/mail/mailhost", 2, "order");
        digester.addCallParam("*/system/mail/mailhost", 3, "protocol");
        digester.addCallParam("*/system/mail/mailhost", 4, N_USERNAME);
        digester.addCallParam("*/system/mail/mailhost", 5, "password");
        digester.addCallMethod("*/system/scheduler", "addScheduleManager");
        digester.addObjectCreate("*/system/scheduler/job", CmsScheduledJobInfo.class);
        digester.addBeanPropertySetter("*/system/scheduler/job/name", "jobName");
        digester.addBeanPropertySetter("*/system/scheduler/job/class", "className");
        digester.addBeanPropertySetter("*/system/scheduler/job/cronexpression", "cronExpression");
        digester.addBeanPropertySetter("*/system/scheduler/job/reuseinstance", "reuseInstance");
        digester.addBeanPropertySetter("*/system/scheduler/job/active", N_ACTIVE);
        digester.addSetNext("*/system/scheduler/job", "addJobFromConfiguration");
        digester.addObjectCreate("*/system/scheduler/job/context", CmsContextInfo.class);
        digester.addBeanPropertySetter("*/system/scheduler/job/context/user", "userName");
        digester.addBeanPropertySetter("*/system/scheduler/job/context/project", "projectName");
        digester.addBeanPropertySetter("*/system/scheduler/job/context/siteroot", "siteRoot");
        digester.addBeanPropertySetter("*/system/scheduler/job/context/requesteduri", "requestedUri");
        digester.addBeanPropertySetter("*/system/scheduler/job/context/locale", "localeName");
        digester.addBeanPropertySetter("*/system/scheduler/job/context/encoding");
        digester.addBeanPropertySetter("*/system/scheduler/job/context/remoteaddr", "remoteAddr");
        digester.addSetNext("*/system/scheduler/job/context", "setContextInfo");
        digester.addCallMethod("*/param", "addConfigurationParameter", 2);
        digester.addCallParam("*/param", 0, "name");
        digester.addCallParam("*/param", 1);
        digester.addCallMethod("*/system/events/eventmanager", "addEventManager", 1);
        digester.addCallParam("*/system/events/eventmanager", 0, N_CLASS);
        digester.addCallMethod("*/system/resourceinit/resourceinithandler", "addResourceInitHandler", 1);
        digester.addCallParam("*/system/resourceinit/resourceinithandler", 0, N_CLASS);
        digester.addCallMethod("*/system/requesthandlers/requesthandler", "addRequestHandler", 1);
        digester.addCallParam("*/system/requesthandlers/requesthandler", 0, N_CLASS);
        digester.addObjectCreate("*/system/passwordhandler", N_CLASS, CmsConfigurationException.class);
        digester.addCallMethod("*/system/passwordhandler", "initConfiguration");
        digester.addBeanPropertySetter("*/system/passwordhandler/encoding", "inputEncoding");
        digester.addBeanPropertySetter("*/system/passwordhandler/digest-type", "digestType");
        digester.addSetNext("*/system/passwordhandler", "setPasswordHandler");
        digester.addCallMethod("*/system/validationhandler", "setValidationHandler", 1);
        digester.addCallParam("*/system/validationhandler", 0, N_CLASS);
        digester.addCallMethod("*/loginmanager", "setLoginManager", 3);
        digester.addCallParam("*/loginmanager/disableMinutes", 0);
        digester.addCallParam("*/loginmanager/maxBadAttempts", 1);
        digester.addCallParam("*/loginmanager/enableSecurity", 2);
        digester.addObjectCreate("*/loginmessage", CmsLoginMessage.class);
        digester.addBeanPropertySetter("*/loginmessage/enabled");
        digester.addBeanPropertySetter("*/loginmessage/message");
        digester.addBeanPropertySetter("*/loginmessage/loginForbidden");
        digester.addBeanPropertySetter("*/loginmessage/timeStart");
        digester.addBeanPropertySetter("*/loginmessage/timeEnd");
        digester.addSetNext("*/loginmessage", "setLoginMessage");
        digester.addObjectCreate("*/system/sites", CmsSiteManagerImpl.class);
        digester.addCallMethod("*/system/sites/workplace-server", "setWorkplaceServer", 0);
        digester.addCallMethod("*/system/sites/default-uri", "setDefaultUri", 0);
        digester.addSetNext("*/system/sites", "setSiteManager");
        digester.addCallMethod("*/system/sites/site", "addSite", 5);
        digester.addCallParam("*/system/sites/site", 0, A_SERVER);
        digester.addCallParam("*/system/sites/site", 1, "uri");
        digester.addCallParam("*/system/sites/site/secure", 2, A_SERVER);
        digester.addCallParam("*/system/sites/site/secure", 3, A_EXCLUSIVE);
        digester.addCallParam("*/system/sites/site/secure", 4, A_ERROR);
        digester.addCallMethod("*/system/sites/site/alias", "addAliasToConfigSite", 2);
        digester.addCallParam("*/system/sites/site/alias", 0, A_SERVER);
        digester.addCallParam("*/system/sites/site/alias", 1, A_OFFSET);
        digester.addCallMethod("*/system/sites/shared-folder", "setSharedFolder", 0);
        digester.addCallMethod("*/system/runtimeproperties/param", "addConfigurationParameter", 2);
        digester.addCallParam("*/system/runtimeproperties/param", 0, "name");
        digester.addCallParam("*/system/runtimeproperties/param", 1);
        digester.addCallMethod("*/system/runtimeclasses/runtimeinfo", "setRuntimeInfoFactory", 1);
        digester.addCallParam("*/system/runtimeclasses/runtimeinfo", 0, N_CLASS);
        digester.addCallMethod("*/system/defaultusers", "setCmsDefaultUsers", 8);
        digester.addCallParam("*/system/defaultusers/user-admin", 0);
        digester.addCallParam("*/system/defaultusers/user-guest", 1);
        digester.addCallParam("*/system/defaultusers/user-export", 2);
        digester.addCallParam("*/system/defaultusers/user-deletedresource", 3);
        digester.addCallParam("*/system/defaultusers/group-administrators", 4);
        digester.addCallParam("*/system/defaultusers/group-projectmanagers", 5);
        digester.addCallParam("*/system/defaultusers/group-users", 6);
        digester.addCallParam("*/system/defaultusers/group-guests", 7);
        digester.addCallMethod("*/system/defaultcontentencoding", "setDefaultContentEncoding", 1);
        digester.addCallParam("*/system/defaultcontentencoding", 0);
        digester.addObjectCreate("*/system/memorymonitor", CmsMemoryMonitorConfiguration.class);
        digester.addCallMethod("*/system/memorymonitor", "initialize", 5);
        digester.addCallParam("*/system/memorymonitor", 0, N_CLASS);
        digester.addCallParam("*/system/memorymonitor/maxusagepercent", 1);
        digester.addCallParam("*/system/memorymonitor/log-interval", 2);
        digester.addCallParam("*/system/memorymonitor/email-interval", 3);
        digester.addCallParam("*/system/memorymonitor/warning-interval", 4);
        digester.addCallMethod("*/system/memorymonitor/email-sender", "setEmailSender", 0);
        digester.addCallMethod("*/system/memorymonitor/email-receiver/receiver", "addEmailReceiver", 0);
        digester.addSetNext("*/system/memorymonitor", "setCmsMemoryMonitorConfiguration");
        digester.addObjectCreate("*/system/flexcache", CmsFlexCacheConfiguration.class);
        digester.addCallMethod("*/system/flexcache", "initialize", 6);
        digester.addCallParam("*/system/flexcache/cache-enabled", 0);
        digester.addCallParam("*/system/flexcache/cache-offline", 1);
        digester.addCallParam("*/system/flexcache/maxcachebytes", 2);
        digester.addCallParam("*/system/flexcache/avgcachebytes", 3);
        digester.addCallParam("*/system/flexcache/maxentrybytes", 4);
        digester.addCallParam("*/system/flexcache/maxkeys", 5);
        digester.addCallMethod("*/system/flexcache/device-selector", "setDeviceSelectorConfiguration", 1);
        digester.addCallParam("*/system/flexcache/device-selector", 0, N_CLASS);
        digester.addSetNext("*/system/flexcache", "setCmsFlexCacheConfiguration");
        digester.addObjectCreate("*/system/http-authentication", CmsHttpAuthenticationSettings.class);
        digester.addCallMethod("*/system/http-authentication/browser-based", "setUseBrowserBasedHttpAuthentication", 0);
        digester.addCallMethod("*/system/http-authentication/form-based", "setFormBasedHttpAuthenticationUri", 0);
        digester.addSetNext("*/system/http-authentication", "setHttpAuthenticationSettings");
        digester.addObjectCreate("*/system/resultcache", CmsCacheSettings.class);
        digester.addCallMethod("*/system/resultcache/keygenerator", "setCacheKeyGenerator", 0);
        digester.addCallMethod("*/system/resultcache/size-users", "setUserCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-groups", "setGroupCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-orgunits", "setOrgUnitCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-usergroups", "setUserGroupsCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-projects", "setProjectCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-projectresources", "setProjectResourcesCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-resources", "setResourceCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-roles", "setRolesCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-resourcelists", "setResourcelistCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-properties", "setPropertyCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-propertylists", "setPropertyListsCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-accesscontrollists", "setAclCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-permissions", "setPermissionCacheSize", 0);
        digester.addCallMethod("*/system/resultcache/size-containerpage-offline", "setContainerPageOfflineSize", 0);
        digester.addCallMethod("*/system/resultcache/size-containerpage-online", "setContainerPageOnlineSize", 0);
        digester.addSetNext("*/system/resultcache", "setCacheSettings");
        digester.addCallMethod("*/system/content-notification/notification-time", "setNotificationTime", 1);
        digester.addCallParam("*/system/content-notification/notification-time", 0);
        digester.addCallMethod("*/system/content-notification/notification-project", "setNotificationProject", 1);
        digester.addCallParam("*/system/content-notification/notification-project", 0);
        digester.addCallMethod("*/system/authorizationhandler", "setAuthorizationHandler", 1);
        digester.addCallParam("*/system/authorizationhandler", 0, N_CLASS);
        digester.addObjectCreate("*/system/publishmanager", CmsPublishManager.class);
        digester.addCallMethod("*/system/publishmanager/history-size", "setPublishHistorySize", 0);
        digester.addCallMethod("*/system/publishmanager/queue-persistance", "setPublishQueuePersistance", 0);
        digester.addCallMethod("*/system/publishmanager/queue-shutdowntime", "setPublishQueueShutdowntime", 0);
        digester.addSetNext("*/system/publishmanager", "setPublishManager");
        digester.addCallMethod("*/system/session-storageprovider", "setSessionStorageProvider", 1);
        digester.addCallParam("*/system/session-storageprovider", 0, N_CLASS);
        digester.addCallMethod("*/system/permissionhandler", "setPermissionHandler", 1);
        digester.addCallParam("*/system/permissionhandler", 0, N_CLASS);
        digester.addCallMethod("*/system/servletcontainer-settings/prevent-response-flush", "setPreventResponseFlush", 0);
        digester.addCallMethod("*/system/servletcontainer-settings/release-tags-after-end", "setReleaseTagsAfterEnd", 0);
        digester.addCallMethod("*/system/servletcontainer-settings/request-error-page-attribute", "setRequestErrorPageAttribute", 0);
        digester.addCallMethod("*/system/servletcontainer-settings", "setServletContainerSettingsMode", 1);
        digester.addCallParam("*/system/servletcontainer-settings", 0, A_MODE);
        String adeCachePath = "*/system/ade/ade-cache";
        digester.addObjectCreate(adeCachePath, CmsADECacheSettings.class);
        digester.addCallMethod(adeCachePath + "/" + N_CONTAINERPAGES, "setContainerPageOfflineSize", 1);
        digester.addCallParam(adeCachePath + "/" + N_CONTAINERPAGES, 0, A_OFFLINE);
        digester.addCallMethod(adeCachePath + "/" + N_CONTAINERPAGES, "setContainerPageOnlineSize", 1);
        digester.addCallParam(adeCachePath + "/" + N_CONTAINERPAGES, 0, A_ONLINE);
        digester.addCallMethod(adeCachePath + "/" + N_GROUPCONTAINERS, "setGroupContainerOfflineSize", 1);
        digester.addCallParam(adeCachePath + "/" + N_GROUPCONTAINERS, 0, A_OFFLINE);
        digester.addCallMethod(adeCachePath + "/" + N_GROUPCONTAINERS, "setGroupContainerOnlineSize", 1);
        digester.addCallParam(adeCachePath + "/" + N_GROUPCONTAINERS, 0, A_ONLINE);
        digester.addSetNext(adeCachePath, "setAdeCacheSettings");
        digester.addObjectCreate("*/system/subscriptionmanager", CmsSubscriptionManager.class);
        digester.addCallMethod("*/system/subscriptionmanager", "setEnabled", 1);
        digester.addCallParam("*/system/subscriptionmanager", 0, N_ENABLED);
        digester.addCallMethod("*/system/subscriptionmanager", "setPoolName", 1);
        digester.addCallParam("*/system/subscriptionmanager", 0, A_POOLNAME);
        digester.addCallMethod("*/system/subscriptionmanager", "setMaxVisitedCount", 1);
        digester.addCallParam("*/system/subscriptionmanager", 0, A_MAXVISITED);
        digester.addSetNext("*/system/subscriptionmanager", "setSubscriptionManager");
        String workflowXpath = "*/system/workflow";
        digester.addObjectCreate(workflowXpath, CmsDefaultWorkflowManager.class.getName(), N_CLASS);
        digester.addObjectCreate(workflowXpath + "/" + N_PARAMETERS, LinkedHashMap.class);
        digester.addCallMethod(workflowXpath + "/" + N_PARAMETERS + "/" + "param", "put", 2);
        digester.addCallParam(workflowXpath + "/" + N_PARAMETERS + "/" + "param", 0, "name");
        digester.addCallParam(workflowXpath + "/" + N_PARAMETERS + "/" + "param", 1);
        digester.addSetNext(workflowXpath + "/" + N_PARAMETERS, "setParameters");
        digester.addSetNext(workflowXpath, "setWorkflowManager");
    }

    @Override
    public Element generateXml(Element parent) {
        I_CmsWorkflowManager workflowMan;
        CmsServletContainerSettings servletContainerSettings;
        Element systemElement = parent.addElement(N_SYSTEM);
        if (OpenCms.getRunLevel() >= 3) {
            this.m_localeManager = OpenCms.getLocaleManager();
            this.m_mailSettings = OpenCms.getSystemInfo().getMailSettings();
            this.m_configuredJobs = OpenCms.getScheduleManager().getJobs();
            this.m_historyEnabled = OpenCms.getSystemInfo().isHistoryEnabled();
            this.m_historyVersions = OpenCms.getSystemInfo().getHistoryVersions();
            this.m_historyVersionsAfterDeletion = OpenCms.getSystemInfo().getHistoryVersionsAfterDeletion();
            this.m_siteManager = OpenCms.getSiteManager();
            this.m_loginManager = OpenCms.getLoginManager();
            this.m_loginMessage = OpenCms.getLoginManager().getLoginMessage();
        }
        Element i18nElement = systemElement.addElement(N_I18N);
        i18nElement.addElement(N_LOCALEHANDLER).addAttribute(N_CLASS, this.m_localeManager.getLocaleHandler().getClass().getName());
        Element localesElement = i18nElement.addElement(N_LOCALESCONFIGURED);
        Iterator<Locale> loc = this.m_localeManager.getAvailableLocales().iterator();
        while (loc.hasNext()) {
            localesElement.addElement(N_LOCALE).addText(loc.next().toString());
        }
        localesElement = i18nElement.addElement(N_LOCALESDEFAULT);
        loc = this.m_localeManager.getDefaultLocales().iterator();
        while (loc.hasNext()) {
            localesElement.addElement(N_LOCALE).setText(loc.next().toString());
        }
        i18nElement.addElement(N_TIMEZONE).setText(this.m_localeManager.getTimeZone().getID());
        Element mailElement = systemElement.addElement(N_MAIL);
        mailElement.addElement(N_MAILFROM).setText(this.m_mailSettings.getMailFromDefault());
        for (CmsMailHost host : this.m_mailSettings.getMailHosts()) {
            Element hostElement = mailElement.addElement(N_MAILHOST).addAttribute("name", host.getHostname()).addAttribute("port", Integer.toString(host.getPort())).addAttribute("order", host.getOrder().toString()).addAttribute("protocol", host.getProtocol());
            if (!host.isAuthenticating()) continue;
            hostElement.addAttribute(N_USERNAME, host.getUsername()).addAttribute("password", host.getPassword());
        }
        Element schedulerElement = systemElement.addElement(N_SCHEDULER);
        for (CmsScheduledJobInfo jobInfo : this.m_configuredJobs) {
            Element jobElement = schedulerElement.addElement(N_JOB);
            jobElement.addElement("name").addText(jobInfo.getJobName());
            jobElement.addElement(N_CLASS).addText(jobInfo.getClassName());
            jobElement.addElement(N_REUSEINSTANCE).addText(String.valueOf(jobInfo.isReuseInstance()));
            jobElement.addElement(N_ACTIVE).addText(String.valueOf(jobInfo.isActive()));
            jobElement.addElement(N_CRONEXPRESSION).addCDATA(jobInfo.getCronExpression());
            Element contextElement = jobElement.addElement(N_CONTEXT);
            contextElement.addElement(N_USERNAME).setText(jobInfo.getContextInfo().getUserName());
            contextElement.addElement(N_PROJECT).setText(jobInfo.getContextInfo().getProjectName());
            contextElement.addElement(N_SITEROOT).setText(jobInfo.getContextInfo().getSiteRoot());
            contextElement.addElement(N_REQUESTEDURI).setText(jobInfo.getContextInfo().getRequestedUri());
            contextElement.addElement(N_LOCALE).setText(jobInfo.getContextInfo().getLocaleName());
            contextElement.addElement("encoding").setText(jobInfo.getContextInfo().getEncoding());
            contextElement.addElement(N_REMOTEADDR).setText(jobInfo.getContextInfo().getRemoteAddr());
            CmsParameterConfiguration jobParameters = jobInfo.getConfiguration();
            if (jobParameters == null || jobParameters.size() <= 0) continue;
            Element parameterElement = jobElement.addElement(N_PARAMETERS);
            jobParameters.appendToXml(parameterElement);
        }
        Element eventsElement = systemElement.addElement(N_EVENTS);
        Element eventManagerElement = eventsElement.addElement(N_EVENTMANAGER);
        eventManagerElement.addAttribute(N_CLASS, this.m_eventManager.getClass().getName());
        Element historyElement = systemElement.addElement(N_VERSIONHISTORY);
        historyElement.addAttribute(N_ENABLED, String.valueOf(this.m_historyEnabled));
        historyElement.addAttribute("count", new Integer(this.m_historyVersions).toString());
        historyElement.addAttribute(A_DELETED, new Integer(this.m_historyVersionsAfterDeletion).toString());
        Element resourceinitElement = systemElement.addElement(N_RESOURCEINIT);
        for (I_CmsResourceInit clazz : this.m_resourceInitHandlers) {
            Element handlerElement = resourceinitElement.addElement(N_RESOURCEINITHANDLER);
            handlerElement.addAttribute(N_CLASS, clazz.getClass().getName());
        }
        Element requesthandlersElement = systemElement.addElement(N_REQUESTHANDLERS);
        for (I_CmsRequestHandler clazz : this.m_requestHandlers) {
            Element handlerElement = requesthandlersElement.addElement(N_REQUESTHANDLER);
            handlerElement.addAttribute(N_CLASS, clazz.getClass().getName());
        }
        Element passwordhandlerElement = systemElement.addElement(N_PASSWORDHANDLER).addAttribute(N_CLASS, this.m_passwordHandler.getClass().getName());
        passwordhandlerElement.addElement("encoding").addText(this.m_passwordHandler.getInputEncoding());
        passwordhandlerElement.addElement(N_DIGESTTYPE).addText(this.m_passwordHandler.getDigestType());
        CmsParameterConfiguration handlerParameters = this.m_passwordHandler.getConfiguration();
        if (handlerParameters != null) {
            handlerParameters.appendToXml(passwordhandlerElement);
        }
        if (this.m_validationHandler != null) {
            Element valHandlerElem = systemElement.addElement(N_VALIDATIONHANDLER);
            valHandlerElem.addAttribute(N_CLASS, this.m_validationHandler);
        }
        if (this.m_loginManager != null) {
            Element managerElement = systemElement.addElement(N_LOGINMANAGER);
            managerElement.addElement(N_DISABLEMINUTES).addText(String.valueOf(this.m_loginManager.getDisableMinutes()));
            managerElement.addElement(N_MAXBADATTEMPTS).addText(String.valueOf(this.m_loginManager.getMaxBadAttempts()));
            managerElement.addElement(N_ENABLESCURITY).addText(String.valueOf(this.m_loginManager.isEnableSecurity()));
        }
        if (this.m_loginMessage != null) {
            Element messageElement = systemElement.addElement(N_LOGINMESSAGE);
            messageElement.addElement(N_ENABLED).addText(String.valueOf(this.m_loginMessage.isEnabled()));
            messageElement.addElement(N_MESSAGE).addCDATA(this.m_loginMessage.getMessage());
            messageElement.addElement(N_LOGINFORBIDDEN).addText(String.valueOf(this.m_loginMessage.isLoginForbidden()));
            if (this.m_loginMessage.getTimeStart() != CmsLoginMessage.DEFAULT_TIME_START) {
                messageElement.addElement(N_TIMESTART).addText(String.valueOf(this.m_loginMessage.getTimeStart()));
            }
            if (this.m_loginMessage.getTimeEnd() != CmsLoginMessage.DEFAULT_TIME_END) {
                messageElement.addElement(N_TIMEEND).addText(String.valueOf(this.m_loginMessage.getTimeEnd()));
            }
        }
        Element sitesElement = systemElement.addElement(N_SITES);
        sitesElement.addElement(N_WORKPLACE_SERVER).addText(this.m_siteManager.getWorkplaceServer());
        sitesElement.addElement(N_DEFAULT_URI).addText(this.m_siteManager.getDefaultUri());
        String sharedFolder = this.m_siteManager.getSharedFolder();
        if (sharedFolder != null) {
            sitesElement.addElement(N_SHARED_FOLDER).addText(sharedFolder);
        }
        for (CmsSite site : new HashSet<CmsSite>(this.m_siteManager.getSites().values())) {
            Element siteElement = sitesElement.addElement("site");
            siteElement.addAttribute(A_SERVER, site.getSiteMatcher().toString());
            siteElement.addAttribute("uri", site.getSiteRoot().concat("/"));
            if (site.hasSecureServer()) {
                Element secureElem = siteElement.addElement(N_SECURE);
                secureElem.addAttribute(A_SERVER, site.getSecureUrl());
                secureElem.addAttribute(A_EXCLUSIVE, "" + site.isExclusiveUrl());
                secureElem.addAttribute(A_ERROR, "" + site.isExclusiveError());
            }
            for (CmsSiteMatcher matcher : site.getAliases()) {
                Element aliasElement = siteElement.addElement(N_ALIAS);
                aliasElement.addAttribute(A_SERVER, matcher.getUrl());
                if (matcher.getTimeOffset() == 0L) continue;
                aliasElement.addAttribute(A_OFFSET, "" + matcher.getTimeOffset());
            }
        }
        Element runtimepropertiesElement = systemElement.addElement(N_RUNTIMEPROPERTIES);
        if (this.m_runtimeProperties != null) {
            ArrayList<String> sortedRuntimeProperties = new ArrayList<String>(this.m_runtimeProperties.keySet());
            Collections.sort(sortedRuntimeProperties);
            for (String key : sortedRuntimeProperties) {
                runtimepropertiesElement.addElement("param").addAttribute("name", key).addText(this.m_runtimeProperties.get(key));
            }
        }
        Element runtimeinfoElement = systemElement.addElement(N_RUNTIMECLASSES);
        Element runtimeinfofactoryElement = runtimeinfoElement.addElement(N_RUNTIMEINFO);
        runtimeinfofactoryElement.addAttribute(N_CLASS, this.getRuntimeInfoFactory().getClass().getName());
        Element defaultusersElement = systemElement.addElement(N_DEFAULTUSERS);
        defaultusersElement.addElement(N_USER_ADMIN).addText(this.m_cmsDefaultUsers.getUserAdmin());
        defaultusersElement.addElement(N_USER_GUEST).addText(this.m_cmsDefaultUsers.getUserGuest());
        defaultusersElement.addElement(N_USER_EXPORT).addText(this.m_cmsDefaultUsers.getUserExport());
        if (!this.m_cmsDefaultUsers.getUserDeletedResource().equals(this.m_cmsDefaultUsers.getUserAdmin())) {
            defaultusersElement.addElement(N_USER_DELETEDRESOURCE).addText(this.m_cmsDefaultUsers.getUserDeletedResource());
        }
        defaultusersElement.addElement(N_GROUP_ADMINISTRATORS).addText(this.m_cmsDefaultUsers.getGroupAdministrators());
        defaultusersElement.addElement(N_GROUP_PROJECTMANAGERS).addText(this.m_cmsDefaultUsers.getGroupProjectmanagers());
        defaultusersElement.addElement(N_GROUP_USERS).addText(this.m_cmsDefaultUsers.getGroupUsers());
        defaultusersElement.addElement(N_GROUP_GUESTS).addText(this.m_cmsDefaultUsers.getGroupGuests());
        systemElement.addElement(N_DEFAULT_CONTENT_ENCODING).addText(this.getDefaultContentEncoding());
        if (this.m_cmsMemoryMonitorConfiguration != null) {
            List<String> emailReceiver;
            Element memorymonitorElement = systemElement.addElement(N_MEMORYMONITOR);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_cmsMemoryMonitorConfiguration.getClassName())) {
                memorymonitorElement.addAttribute(N_CLASS, this.m_cmsMemoryMonitorConfiguration.getClassName());
            }
            memorymonitorElement.addElement(N_MAXUSAGE_PERCENT).addText(String.valueOf(this.m_cmsMemoryMonitorConfiguration.getMaxUsagePercent()));
            memorymonitorElement.addElement(N_LOG_INTERVAL).addText(String.valueOf(this.m_cmsMemoryMonitorConfiguration.getLogInterval()));
            if (this.m_cmsMemoryMonitorConfiguration.getEmailInterval() >= 0) {
                memorymonitorElement.addElement(N_EMAIL_INTERVAL).addText(String.valueOf(this.m_cmsMemoryMonitorConfiguration.getEmailInterval()));
            }
            memorymonitorElement.addElement(N_WARNING_INTERVAL).addText(String.valueOf(this.m_cmsMemoryMonitorConfiguration.getWarningInterval()));
            if (this.m_cmsMemoryMonitorConfiguration.getEmailSender() != null) {
                memorymonitorElement.addElement(N_EMAIL_SENDER).addText(this.m_cmsMemoryMonitorConfiguration.getEmailSender());
            }
            if (!(emailReceiver = this.m_cmsMemoryMonitorConfiguration.getEmailReceiver()).isEmpty()) {
                Element emailreceiverElement = memorymonitorElement.addElement(N_EMAIL_RECEIVER);
                Iterator<String> iter = emailReceiver.iterator();
                while (iter.hasNext()) {
                    emailreceiverElement.addElement(N_RECEIVER).addText(iter.next());
                }
            }
        }
        Element flexcacheElement = systemElement.addElement(N_FLEXCACHE);
        flexcacheElement.addElement(N_CACHE_ENABLED).addText(String.valueOf(this.m_cmsFlexCacheConfiguration.isCacheEnabled()));
        flexcacheElement.addElement(N_CACHE_OFFLINE).addText(String.valueOf(this.m_cmsFlexCacheConfiguration.isCacheOffline()));
        flexcacheElement.addElement(N_MAXCACHEBYTES).addText(String.valueOf(this.m_cmsFlexCacheConfiguration.getMaxCacheBytes()));
        flexcacheElement.addElement(N_AVGCACHEBYTES).addText(String.valueOf(this.m_cmsFlexCacheConfiguration.getAvgCacheBytes()));
        flexcacheElement.addElement(N_MAXENTRYBYTES).addText(String.valueOf(this.m_cmsFlexCacheConfiguration.getMaxEntryBytes()));
        flexcacheElement.addElement(N_MAXKEYS).addText(String.valueOf(this.m_cmsFlexCacheConfiguration.getMaxKeys()));
        if (this.m_cmsFlexCacheConfiguration.getDeviceSelectorConfiguration() != null) {
            Element flexcacheDeviceSelectorElement = flexcacheElement.addElement(N_DEVICESELECTOR);
            flexcacheDeviceSelectorElement.addAttribute(N_CLASS, this.m_cmsFlexCacheConfiguration.getDeviceSelectorConfiguration());
        }
        Element httpAuthenticationElement = systemElement.addElement(N_HTTP_AUTHENTICATION);
        httpAuthenticationElement.addElement(N_BROWSER_BASED).setText(this.m_httpAuthenticationSettings.getConfigBrowserBasedAuthentication());
        if (this.m_httpAuthenticationSettings.getFormBasedHttpAuthenticationUri() != null) {
            httpAuthenticationElement.addElement(N_FORM_BASED).setText(this.m_httpAuthenticationSettings.getFormBasedHttpAuthenticationUri());
        }
        Element cacheElement = systemElement.addElement(N_RESULTCACHE);
        cacheElement.addElement(N_KEYGENERATOR).setText(this.m_cacheSettings.getCacheKeyGenerator());
        cacheElement.addElement(N_SIZE_USERS).setText(Integer.toString(this.m_cacheSettings.getUserCacheSize()));
        cacheElement.addElement(N_SIZE_GROUPS).setText(Integer.toString(this.m_cacheSettings.getGroupCacheSize()));
        if (this.m_cacheSettings.getConfiguredOrgUnitCacheSize() > -1) {
            cacheElement.addElement(N_SIZE_ORGUNITS).setText(Integer.toString(this.m_cacheSettings.getConfiguredOrgUnitCacheSize()));
        }
        cacheElement.addElement(N_SIZE_USERGROUPS).setText(Integer.toString(this.m_cacheSettings.getUserGroupsCacheSize()));
        cacheElement.addElement(N_SIZE_PROJECTS).setText(Integer.toString(this.m_cacheSettings.getProjectCacheSize()));
        if (this.m_cacheSettings.getConfiguredProjectResourcesCacheSize() > -1) {
            cacheElement.addElement(N_SIZE_PROJECTRESOURCES).setText(Integer.toString(this.m_cacheSettings.getConfiguredProjectResourcesCacheSize()));
        }
        cacheElement.addElement(N_SIZE_RESOURCES).setText(Integer.toString(this.m_cacheSettings.getResourceCacheSize()));
        if (this.m_cacheSettings.getConfiguredRolesCacheSize() > -1) {
            cacheElement.addElement(N_SIZE_ROLES).setText(Integer.toString(this.m_cacheSettings.getConfiguredRolesCacheSize()));
        }
        cacheElement.addElement(N_SIZE_RESOURCELISTS).setText(Integer.toString(this.m_cacheSettings.getResourcelistCacheSize()));
        cacheElement.addElement(N_SIZE_PROPERTIES).setText(Integer.toString(this.m_cacheSettings.getPropertyCacheSize()));
        if (this.m_cacheSettings.getConfiguredPropertyListsCacheSize() > -1) {
            cacheElement.addElement(N_SIZE_PROPERTYLISTS).setText(Integer.toString(this.m_cacheSettings.getConfiguredPropertyListsCacheSize()));
        }
        cacheElement.addElement(N_SIZE_ACLS).setText(Integer.toString(this.m_cacheSettings.getAclCacheSize()));
        cacheElement.addElement(N_SIZE_PERMISSIONS).setText(Integer.toString(this.m_cacheSettings.getPermissionCacheSize()));
        if (this.m_notificationTime != null || this.m_notificationProject != null) {
            Element notificationElement = systemElement.addElement(N_CONTENT_NOTIFICATION);
            if (this.m_notificationTime != null) {
                notificationElement.addElement(N_NOTIFICATION_TIME).setText(this.m_notificationTime.toString());
            }
            if (this.m_notificationProject != null) {
                notificationElement.addElement(N_NOTIFICATION_PROJECT).setText(this.m_notificationProject);
            }
        }
        if (this.m_authorizationHandler != null) {
            Element authorizationHandlerElem = systemElement.addElement(N_AUTHORIZATIONHANDLER);
            authorizationHandlerElem.addAttribute(N_CLASS, this.m_authorizationHandler);
        }
        if (this.m_publishManager != null) {
            Element pubHistElement = systemElement.addElement(N_PUBLISHMANAGER);
            pubHistElement.addElement(N_HISTORYSIZE).setText(String.valueOf(this.m_publishManager.getPublishHistorySize()));
            pubHistElement.addElement(N_QUEUEPERSISTANCE).setText(String.valueOf(this.m_publishManager.isPublishQueuePersistanceEnabled()));
            pubHistElement.addElement(N_QUEUESHUTDOWNTIME).setText(String.valueOf(this.m_publishManager.getPublishQueueShutdowntime()));
        }
        if (this.m_sessionStorageProvider != null) {
            Element sessionStorageProviderElem = systemElement.addElement(N_SESSION_STORAGEPROVIDER);
            sessionStorageProviderElem.addAttribute(N_CLASS, this.m_sessionStorageProvider);
        }
        if (this.m_permissionHandler != null) {
            Element permissionHandlerElem = systemElement.addElement(N_PERMISSIONHANDLER);
            permissionHandlerElem.addAttribute(N_CLASS, this.m_permissionHandler);
        }
        if (!(servletContainerSettings = OpenCms.getSystemInfo().getServletContainerSettings()).getMode().isNone()) {
            Element servletContainerSettingsElem = systemElement.addElement(N_SERVLETCONTAINERSETTINGS);
            servletContainerSettingsElem.addAttribute(A_MODE, servletContainerSettings.getMode().getMode());
            if (!servletContainerSettings.getMode().isAuto()) {
                servletContainerSettingsElem.addElement(N_PREVENTRESPONSEFLUSH).addText("" + servletContainerSettings.isPreventResponseFlush());
                servletContainerSettingsElem.addElement(N_RELEASETAGSAFTEREND).addText("" + servletContainerSettings.isReleaseTagsAfterEnd());
            }
            if (servletContainerSettings.getRequestErrorPageAttribute() != null) {
                servletContainerSettingsElem.addElement(N_REQUESTERRORPAGEATTRIBUTE).addText(servletContainerSettings.getRequestErrorPageAttribute());
            }
        }
        if (this.getAdeConfiguration() != null || this.getAdeCacheSettings() != null) {
            Element adeElem = systemElement.addElement(N_ADE);
            if (this.getAdeConfiguration() != null) {
                adeElem.addElement(N_CONFIGURATION).addAttribute(N_CLASS, this.getAdeConfiguration());
            }
            if (this.getAdeCacheSettings() != null) {
                Element cacheElem = adeElem.addElement(N_ADE_CACHE);
                Element cntPageCacheElem = cacheElem.addElement(N_CONTAINERPAGES);
                cntPageCacheElem.addAttribute(A_OFFLINE, "" + this.getAdeCacheSettings().getContainerPageOfflineSize());
                cntPageCacheElem.addAttribute(A_ONLINE, "" + this.getAdeCacheSettings().getContainerPageOnlineSize());
                Element groupContainerCacheElem = cacheElem.addElement(N_GROUPCONTAINERS);
                groupContainerCacheElem.addAttribute(A_OFFLINE, "" + this.getAdeCacheSettings().getGroupContainerOfflineSize());
                groupContainerCacheElem.addAttribute(A_ONLINE, "" + this.getAdeCacheSettings().getGroupContainerOnlineSize());
            }
        }
        if (this.getSubscriptionManager() != null) {
            Element subscrManElem = systemElement.addElement(N_SUBSCRIPTIONMANAGER);
            subscrManElem.addAttribute(N_ENABLED, Boolean.toString(this.getSubscriptionManager().isEnabled()));
            subscrManElem.addAttribute(A_POOLNAME, this.getSubscriptionManager().getPoolName());
            subscrManElem.addAttribute(A_MAXVISITED, String.valueOf(this.getSubscriptionManager().getMaxVisitedCount()));
        }
        if ((workflowMan = this.getWorkflowManager()) != null) {
            Element workflowElem = systemElement.addElement(N_WORKFLOW);
            workflowElem.addAttribute(N_CLASS, workflowMan.getClass().getName());
            Map<String, String> parameters = workflowMan.getParameters();
            Element parametersElem = workflowElem.addElement(N_PARAMETERS);
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                Element paramElem = parametersElem.addElement("param");
                paramElem.addAttribute("name", entry.getKey());
                paramElem.addText(entry.getValue());
            }
        }
        return systemElement;
    }

    public CmsADECacheSettings getAdeCacheSettings() {
        return this.m_adeCacheSettings;
    }

    public String getAdeConfiguration() {
        return this.m_adeConfiguration;
    }

    public I_CmsAuthorizationHandler getAuthorizationHandler() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_authorizationHandler)) {
            return new CmsDefaultAuthorizationHandler();
        }
        try {
            I_CmsAuthorizationHandler authorizationHandler = (I_CmsAuthorizationHandler)Class.forName(this.m_authorizationHandler).newInstance();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("INIT_AUTHORIZATION_HANDLER_CLASS_SUCCESS_1", this.m_authorizationHandler));
            }
            authorizationHandler.setParameters(this.m_runtimeProperties);
            return authorizationHandler;
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("INIT_AUTHORIZATION_HANDLER_CLASS_INVALID_1", this.m_authorizationHandler), t);
            return new CmsDefaultAuthorizationHandler();
        }
    }

    public CmsCacheSettings getCacheSettings() {
        return this.m_cacheSettings;
    }

    public CmsDefaultUsers getCmsDefaultUsers() {
        return this.m_cmsDefaultUsers;
    }

    public CmsFlexCacheConfiguration getCmsFlexCacheConfiguration() {
        return this.m_cmsFlexCacheConfiguration;
    }

    public CmsMemoryMonitorConfiguration getCmsMemoryMonitorConfiguration() {
        return this.m_cmsMemoryMonitorConfiguration;
    }

    public String getDefaultContentEncoding() {
        return this.m_defaultContentEncoding;
    }

    @Override
    public String getDtdFilename() {
        return CONFIGURATION_DTD_NAME;
    }

    public CmsEventManager getEventManager() {
        return this.m_eventManager;
    }

    public int getHistoryVersions() {
        return this.m_historyVersions;
    }

    public int getHistoryVersionsAfterDeletion() {
        return this.m_historyVersionsAfterDeletion;
    }

    public CmsHttpAuthenticationSettings getHttpAuthenticationSettings() {
        return this.m_httpAuthenticationSettings;
    }

    public CmsLocaleManager getLocaleManager() {
        return this.m_localeManager;
    }

    public CmsLoginManager getLoginManager() {
        if (this.m_loginManager == null) {
            this.m_loginManager = new CmsLoginManager(15, 3, false);
        }
        if (this.m_loginMessage != null) {
            try {
                this.m_loginManager.setLoginMessage(null, this.m_loginMessage);
            }
            catch (CmsRoleViolationException cmsRoleViolationException) {
                // empty catch block
            }
        }
        return this.m_loginManager;
    }

    public CmsMailSettings getMailSettings() {
        return this.m_mailSettings;
    }

    public String getNotificationProject() {
        return this.m_notificationProject;
    }

    public int getNotificationTime() {
        if (this.m_notificationTime != null) {
            return this.m_notificationTime;
        }
        return -1;
    }

    public I_CmsPasswordHandler getPasswordHandler() {
        return this.m_passwordHandler;
    }

    public String getPermissionHandler() {
        return this.m_permissionHandler;
    }

    public CmsPublishManager getPublishManager() {
        if (this.m_publishManager == null) {
            this.m_publishManager = new CmsPublishManager(100, false, 1);
        }
        return this.m_publishManager;
    }

    public List<I_CmsRequestHandler> getRequestHandlers() {
        return this.m_requestHandlers;
    }

    public List<I_CmsResourceInit> getResourceInitHandlers() {
        return this.m_resourceInitHandlers;
    }

    public I_CmsDbContextFactory getRuntimeInfoFactory() {
        return this.m_runtimeInfoFactory;
    }

    public Map<String, String> getRuntimeProperties() {
        return this.m_runtimeProperties;
    }

    public CmsScheduleManager getScheduleManager() {
        return this.m_scheduleManager;
    }

    public I_CmsSessionStorageProvider getSessionStorageProvider() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_sessionStorageProvider)) {
            return new CmsDefaultSessionStorageProvider();
        }
        try {
            I_CmsSessionStorageProvider sessionCacheProvider = (I_CmsSessionStorageProvider)Class.forName(this.m_sessionStorageProvider).newInstance();
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SESSION_STORAGEPROVIDER_SUCCESS_1", this.m_sessionStorageProvider));
            }
            return sessionCacheProvider;
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INIT_SESSION_STORAGEPROVIDER_FAILURE_1", this.m_sessionStorageProvider), t);
            return new CmsDefaultSessionStorageProvider();
        }
    }

    public CmsSiteManagerImpl getSiteManager() {
        return this.m_siteManager;
    }

    public CmsSubscriptionManager getSubscriptionManager() {
        if (this.m_subscriptionManager == null) {
            this.m_subscriptionManager = new CmsSubscriptionManager();
        }
        return this.m_subscriptionManager;
    }

    public int getTempFileProjectId() {
        return this.m_tempFileProjectId;
    }

    public I_CmsValidationHandler getValidationHandler() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_validationHandler)) {
            return new CmsDefaultValidationHandler();
        }
        try {
            I_CmsValidationHandler validationHandler = (I_CmsValidationHandler)Class.forName(this.m_validationHandler).newInstance();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("INIT_VALIDATION_HANDLER_CLASS_SUCCESS_1", this.m_validationHandler));
            }
            return validationHandler;
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("INIT_VALIDATION_HANDLER_CLASS_INVALID_1", this.m_validationHandler), t);
            return new CmsDefaultValidationHandler();
        }
    }

    public I_CmsWorkflowManager getWorkflowManager() {
        return this.m_workflowManager;
    }

    public void initializeFinished() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SYSTEM_CONFIG_FINISHED_0"));
        }
    }

    public boolean isHistoryEnabled() {
        return this.m_historyEnabled;
    }

    public void setAdeCacheSettings(CmsADECacheSettings settings) {
        this.m_adeCacheSettings = settings;
    }

    public void setAdeConfiguration(String className) {
        this.m_adeConfiguration = className;
    }

    public void setAuthorizationHandler(String authorizationHandlerClass) {
        this.m_authorizationHandler = authorizationHandlerClass;
    }

    public void setCacheSettings(CmsCacheSettings settings) {
        this.m_cacheSettings = settings;
    }

    public void setCmsDefaultUsers(String userAdmin, String userGuest, String userExport, String userDeletedResource, String groupAdministrators, String groupProjectmanagers, String groupUsers, String groupGuests) {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_CHECKING_DEFAULT_USER_NAMES_0"));
        }
        this.m_cmsDefaultUsers = new CmsDefaultUsers(userAdmin, userGuest, userExport, userDeletedResource, groupAdministrators, groupProjectmanagers, groupUsers, groupGuests);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADMIN_USER_1", this.m_cmsDefaultUsers.getUserAdmin()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_GUEST_USER_1", this.m_cmsDefaultUsers.getUserGuest()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_USER_1", this.m_cmsDefaultUsers.getUserExport()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DELETED_RESOURCE_USER_1", this.m_cmsDefaultUsers.getUserDeletedResource()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADMIN_GROUP_1", this.m_cmsDefaultUsers.getGroupAdministrators()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_PROJECT_MANAGERS_GROUP_1", this.m_cmsDefaultUsers.getGroupProjectmanagers()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_USERS_GROUP_1", this.m_cmsDefaultUsers.getGroupUsers()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_GUESTS_GROUP_1", this.m_cmsDefaultUsers.getGroupGuests()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DEFAULT_USER_NAMES_INITIALIZED_0"));
        }
    }

    public void setCmsFlexCacheConfiguration(CmsFlexCacheConfiguration flexCacheConfiguration) {
        this.m_cmsFlexCacheConfiguration = flexCacheConfiguration;
    }

    public void setCmsMemoryMonitorConfiguration(CmsMemoryMonitorConfiguration cmsMemoryMonitorConfiguration) {
        this.m_cmsMemoryMonitorConfiguration = cmsMemoryMonitorConfiguration;
    }

    public void setDefaultContentEncoding(String defaultContentEncoding) {
        this.m_defaultContentEncoding = defaultContentEncoding;
    }

    public void setHistorySettings(String historyEnabled, String historyVersions, String historyVersionsAfterDeletion) {
        this.m_historyEnabled = Boolean.valueOf(historyEnabled);
        this.m_historyVersions = Integer.valueOf(historyVersions);
        this.m_historyVersionsAfterDeletion = Integer.valueOf(historyVersionsAfterDeletion);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_HISTORY_SETTINGS_3", this.m_historyEnabled, new Integer(this.m_historyVersions), new Integer(this.m_historyVersionsAfterDeletion)));
        }
    }

    public void setHttpAuthenticationSettings(CmsHttpAuthenticationSettings httpAuthenticationSettings) {
        this.m_httpAuthenticationSettings = httpAuthenticationSettings;
    }

    public void setLocaleManager(CmsLocaleManager localeManager) {
        this.m_localeManager = localeManager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_CONFIG_I18N_FINISHED_0"));
        }
    }

    public void setLoginManager(String disableMinutesStr, String maxBadAttemptsStr, String enableSecurityStr) {
        int maxBadAttempts;
        int disableMinutes;
        try {
            disableMinutes = Integer.valueOf(disableMinutesStr);
        }
        catch (NumberFormatException e) {
            disableMinutes = 15;
        }
        try {
            maxBadAttempts = Integer.valueOf(maxBadAttemptsStr);
        }
        catch (NumberFormatException e) {
            maxBadAttempts = 3;
        }
        boolean enableSecurity = Boolean.valueOf(enableSecurityStr);
        this.m_loginManager = new CmsLoginManager(disableMinutes, maxBadAttempts, enableSecurity);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOGINMANAGER_3", new Integer(disableMinutes), new Integer(maxBadAttempts), new Boolean(enableSecurity)));
        }
    }

    public void setLoginMessage(CmsLoginMessage message) {
        this.m_loginMessage = message;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOGINMESSAGE_3", message.isEnabled(), message.isLoginForbidden(), message.getMessage()));
        }
    }

    public void setMailSettings(CmsMailSettings mailSettings) {
        this.m_mailSettings = mailSettings;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_MAIL_SETTINGS_1", mailSettings));
        }
    }

    public void setNotificationProject(String notificationProject) {
        this.m_notificationProject = notificationProject;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NOTIFICATION_PROJECT_1", this.m_notificationProject));
        }
    }

    public void setNotificationTime(String notificationTime) {
        try {
            this.m_notificationTime = new Integer(notificationTime);
        }
        catch (Throwable t) {
            this.m_notificationTime = new Integer(-1);
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NOTIFICATION_TIME_1", this.m_notificationTime));
        }
    }

    public void setPasswordHandler(I_CmsPasswordHandler passwordHandler) {
        this.m_passwordHandler = passwordHandler;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_PWD_HANDLER_SUCCESS_1", passwordHandler.getClass().getName()));
        }
    }

    public void setPermissionHandler(String permissionHandler) {
        this.m_permissionHandler = permissionHandler;
    }

    public void setPreventResponseFlush(String configValue) {
        OpenCms.getSystemInfo().getServletContainerSettings().setPreventResponseFlush(Boolean.valueOf(configValue));
    }

    public void setPublishManager(CmsPublishManager publishManager) {
        this.m_publishManager = publishManager;
    }

    public void setReleaseTagsAfterEnd(String configValue) {
        OpenCms.getSystemInfo().getServletContainerSettings().setReleaseTagsAfterEnd(Boolean.valueOf(configValue));
    }

    public void setRequestErrorPageAttribute(String configValue) {
        OpenCms.getSystemInfo().getServletContainerSettings().setRequestErrorPageAttribute(configValue);
    }

    public void setRuntimeInfoFactory(String className) {
        Object objectInstance;
        try {
            objectInstance = Class.forName(className).newInstance();
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_CLASS_INIT_FAILURE_1", className), t);
            return;
        }
        if (objectInstance instanceof I_CmsDbContextFactory) {
            this.m_runtimeInfoFactory = (I_CmsDbContextFactory)objectInstance;
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_RUNTIME_INFO_FACTORY_SUCCESS_1", className));
            }
        } else if (CmsLog.INIT.isFatalEnabled()) {
            CmsLog.INIT.fatal((Object)Messages.get().getBundle().key("INIT_RUNTIME_INFO_FACTORY_FAILURE_1", className));
        }
    }

    public void setServletContainerSettingsMode(String configValue) {
        OpenCms.getSystemInfo().getServletContainerSettings().setMode(configValue);
    }

    public void setSessionStorageProvider(String sessionStorageProviderClass) {
        this.m_sessionStorageProvider = sessionStorageProviderClass;
    }

    public void setSiteManager(CmsSiteManagerImpl siteManager) {
        this.m_siteManager = siteManager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SITE_CONFIG_FINISHED_0"));
        }
    }

    public void setSubscriptionManager(CmsSubscriptionManager subscriptionManager) {
        this.m_subscriptionManager = subscriptionManager;
    }

    public void setTempFileProjectId(String tempFileProjectId) {
        try {
            this.m_tempFileProjectId = Integer.valueOf(tempFileProjectId);
        }
        catch (Throwable t) {
            this.m_tempFileProjectId = -1;
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_TEMPFILE_PROJECT_ID_1", new Integer(this.m_tempFileProjectId)));
        }
    }

    public void setValidationHandler(String validationHandlerClass) {
        this.m_validationHandler = validationHandlerClass;
    }

    public void setWorkflowManager(I_CmsWorkflowManager workflowManager) {
        this.m_workflowManager = workflowManager;
    }

    @Override
    protected void initMembers() {
        this.setXmlFileName(DEFAULT_XML_FILE_NAME);
        this.m_historyEnabled = true;
        this.m_historyVersions = 10;
        this.m_historyVersionsAfterDeletion = -1;
        this.m_resourceInitHandlers = new ArrayList<I_CmsResourceInit>();
        this.m_requestHandlers = new ArrayList<I_CmsRequestHandler>();
        this.m_configuredJobs = new ArrayList<CmsScheduledJobInfo>();
        this.m_runtimeProperties = new HashMap<String, String>();
        this.m_eventManager = new CmsEventManager();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SYSTEM_CONFIG_INIT_0"));
        }
    }
}

