/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.dom4j.Element;
import org.opencms.configuration.A_CmsXmlConfiguration;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.CmsSetNextRule;
import org.opencms.configuration.Messages;
import org.opencms.db.CmsExportPoint;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsRfsFileViewer;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceCustomFoot;
import org.opencms.workplace.CmsWorkplaceManager;
import org.opencms.workplace.CmsWorkplaceUserInfoBlock;
import org.opencms.workplace.CmsWorkplaceUserInfoEntry;
import org.opencms.workplace.CmsWorkplaceUserInfoManager;
import org.opencms.workplace.I_CmsDialogHandler;
import org.opencms.workplace.editors.I_CmsEditorCssHandler;
import org.opencms.workplace.editors.I_CmsPreEditorActionDefinition;
import org.opencms.workplace.editors.directedit.I_CmsDirectEditProvider;
import org.opencms.workplace.explorer.CmsExplorerContextMenu;
import org.opencms.workplace.explorer.CmsExplorerContextMenuItem;
import org.opencms.workplace.explorer.CmsExplorerTypeAccess;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsIconRule;
import org.opencms.workplace.explorer.menu.CmsMenuRule;
import org.opencms.workplace.explorer.menu.CmsMenuRuleTranslator;
import org.opencms.workplace.explorer.menu.I_CmsMenuItemRule;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.CmsToolRootHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsWorkplaceConfiguration
extends A_CmsXmlConfiguration {
    public static final String A_AUTOSETNAVIGATION = "autosetnavigation";
    public static final String A_AUTOSETTITLE = "autosettitle";
    public static final String A_BIGICON = "bigicon";
    public static final String A_EXTENSION = "extension";
    public static final String A_INFO = "info";
    public static final String A_MODE = "mode";
    public static final String A_OPTIONAL = "optional";
    public static final String A_PAGE = "page";
    public static final String A_PARAMS = "params";
    public static final String A_PARENT = "parent";
    public static final String A_PATH = "path";
    public static final String A_PERMISSIONS = "permissions";
    public static final String A_PRINCIPAL = "principal";
    public static final String A_REFERENCE = "reference";
    public static final String A_REPLACE = "replace";
    public static final String A_RULE = "rule";
    public static final String A_RULES = "rules";
    public static final String A_SHOWNAVIGATION = "shownavigation";
    public static final String A_TARGET = "target";
    public static final String A_WIDGET = "widget";
    public static final String CONFIGURATION_DTD_NAME = "opencms-workplace.dtd";
    public static final String DEFAULT_XML_FILE_NAME = "opencms-workplace.xml";
    public static final String N_ACCESSCONTROL = "accesscontrol";
    public static final String N_ACCESSENTRY = "accessentry";
    public static final String N_ALLOWBROKENRELATIONS = "allowbrokenrelations";
    public static final String N_AUTOLOCK = "autolock";
    public static final String N_BACKGROUNDCOLOR = "background-color";
    public static final String N_BUTTONSTYLE = "buttonstyle";
    public static final String N_COLOR = "color";
    public static final String N_CONTEXTMENU = "contextmenu";
    public static final String N_DATECREATED = "show-datecreated";
    public static final String N_DATEEXPIRED = "show-dateexpired";
    public static final String N_DATELASTMODIFIED = "show-datelastmodified";
    public static final String N_DATERELEASED = "show-datereleased";
    public static final String N_DEFAULTACCESSCONTROL = "defaultaccesscontrol";
    public static final String N_DEFAULTLOCALE = "defaultlocale";
    public static final String N_DEFAULTPREFERENCES = "default-preferences";
    public static final String N_DEFAULTPROPERTIES = "defaultproperties";
    public static final String N_DEFAULTPROPERTIESONSTRUCTURE = "defaultpropertiesonstructure";
    public static final String N_DEFAULTPROPERTY = "defaultproperty";
    public static final String N_DIALOGHANDLER = "dialoghandler";
    public static final String N_DIALOGHANDLERS = "dialoghandlers";
    public static final String N_DIALOGSDEFAULTSETTINGS = "dialogs-defaultsettings";
    public static final String N_DIALOGSPREFERENCES = "dialogs-preferences";
    public static final String N_DIRECTEDITPROVIDER = "directeditprovider";
    public static final String N_DIRECTEDITSTYLE = "directeditstyle";
    public static final String N_DIRECTPUBLISH = "directpublish";
    public static final String N_EDITOPTIONS = "editoptions";
    public static final String N_EDITOR = "editor";
    public static final String N_EDITORACTION = "editoraction";
    public static final String N_EDITORCSSHANDLER = "editorcsshandler";
    public static final String N_EDITORCSSHANDLERS = "editorcsshandlers";
    public static final String N_EDITORGENERALOPTIONS = "editors-generaloptions";
    public static final String N_EDITORHANDLER = "editorhandler";
    public static final String N_EDITORPRECONDITION = "editorprecondition";
    public static final String N_EDITORPRECONDITIONS = "editorpreconditions";
    public static final String N_EDITORPREFERENCES = "editors-preferences";
    public static final String N_EDITORPREFERREDEDITORS = "editors-preferrededitors";
    public static final String N_ENABLEADVANCEDPROPERTYTABS = "enableadvancedpropertytabs";
    public static final String N_ENABLED = "enabled";
    public static final String N_ENABLEUSERMGMT = "enableusermanagement";
    public static final String N_ENTRIES = "entries";
    public static final String N_ENTRY = "entry";
    public static final String N_ENTRYOPTIONS = "entryoptions";
    public static final String N_EXPANDPERMISSIONSINHERITED = "expand-permissionsinherited";
    public static final String N_EXPANDPERMISSIONSUSER = "expand-permissionsuser";
    public static final String N_EXPLORERDISPLAYOPTIONS = "explorer-displayoptions";
    public static final String N_EXPLORERGENERALOPTIONS = "explorer-generaloptions";
    public static final String N_EXPLORERPREFERENCES = "explorer-preferences";
    public static final String N_EXPLORERTYPE = "explorertype";
    public static final String N_EXPLORERTYPES = "explorertypes";
    public static final String N_FILECOPY = "filecopy";
    public static final String N_FILEDELETION = "filedeletion";
    public static final String N_FILEENCODING = "fileEncoding";
    public static final String N_FILEPATH = "filePath";
    public static final String N_FOLDER = "folder";
    public static final String N_FOLDERCOPY = "foldercopy";
    public static final String N_GALLERIESPREFERENCES = "galleries-preferences";
    public static final String N_GROUP_TRANSLATION = "group-translation";
    public static final String N_HELPTEXT = "helptext";
    public static final String N_ICONRULE = "iconrule";
    public static final String N_ICONRULES = "iconrules";
    public static final String N_INFOBLOCK = "info-block";
    public static final String N_ISLOGFILE = "isLogfile";
    public static final String N_KEY = "key";
    public static final String N_LABELEDFOLDERS = "labeledfolders";
    public static final String N_LISTALLPROJECTS = "listallprojects";
    public static final String N_LOCALE = "locale";
    public static final String N_LOCALIZEDFOLDERS = "localizedfolders";
    public static final String N_LOCKEDBY = "show-lockedby";
    public static final String N_MAXUPLOADSIZE = "maxfileuploadsize";
    public static final String N_MENUITEMRULE = "menuitemrule";
    public static final String N_MENURULE = "menurule";
    public static final String N_MENURULES = "menurules";
    public static final String N_MULTICONTEXTMENU = "multicontextmenu";
    public static final String N_NAVTEXT = "show-navtext";
    public static final String N_NEWFOLDERCREATEINDEXPAGE = "newfolder-createindexpage";
    public static final String N_NEWFOLDEREDITPROPERTIES = "newfolder-editproperties";
    public static final String N_NEWRESOURCE = "newresource";
    public static final String N_PERMISSIONS = "show-permissions";
    public static final String N_PERMISSIONSINHERITONFOLDER = "permissions-inheritonfolder";
    public static final String N_PROJECT = "project";
    public static final String N_PUBLISHBUTTONAPPEARANCE = "publishbuttonappearance";
    public static final String N_PUBLISHNOTIFICATION = "publishnotification";
    public static final String N_PUBLISHRELATEDRESOURCES = "publishrelatedresources";
    public static final String N_REPORTTYPE = "reporttype";
    public static final String N_RESTRICTEXPLORERVIEW = "restrictexplorerview";
    public static final String N_RFSFILEVIEWESETTINGS = "rfsfileviewsettings";
    public static final String N_ROOT = "root";
    public static final String N_ROOTPATH = "rootPath";
    public static final String N_ROOTS = "roots";
    public static final String N_SEARCHINDEXNAME = "searchindex-name";
    public static final String N_SEARCHVIEWSTYLE = "searchview-style";
    public static final String N_SEPARATOR = "separator";
    public static final String N_SHOWEXPORTSETTINGS = "showexportsettings";
    public static final String N_SHOWFILEUPLOADBUTTON = "show-fileuploadbutton";
    public static final String N_SHOWLOCK = "showlock";
    public static final String N_SHOWMESSAGES = "showmessages";
    public static final String N_SHOWUPLOADTYPEDIALOG = "show-uploadtypedialog";
    public static final String N_SIZE = "show-size";
    public static final String N_STARTGALLERIES = "startgalleries";
    public static final String N_STARTGALLERY = "startgallery";
    public static final String N_STATE = "show-state";
    public static final String N_SUBSITEMAP_CREATION_MODE = "subsitemap-creation-mode";
    public static final String N_TEXT = "text";
    public static final String N_TITLE = "show-title";
    public static final String N_TOOLMANAGER = "tool-manager";
    public static final String N_TYPE = "show-type";
    public static final String N_UPLOADAPPLET = "uploadapplet";
    public static final String N_URI = "uri";
    public static final String N_USER_LISTS = "user-lists";
    public static final String N_USERCREATED = "show-usercreated";
    public static final String N_USERINFO = "user-info";
    public static final String N_USERINFOS = "user-infos";
    public static final String N_USERLASTMODIFIED = "show-userlastmodified";
    public static final String N_WINDOWSIZE = "windowSize";
    public static final String N_WORKPLACE = "workplace";
    public static final String N_WORKPLACECUSTOMFOOT = "workplace-customfoot";
    public static final String N_WORKPLACEGENERALOPTIONS = "workplace-generaloptions";
    public static final String N_WORKPLACEPREFERENCES = "workplace-preferences";
    public static final String N_WORKPLACESEARCH = "workplace-search";
    public static final String N_WORKPLACESTARTUPSETTINGS = "workplace-startupsettings";
    public static final String N_WORKPLACEVIEW = "workplaceview";
    public static final String N_XMLCONTENTAUTOCORRECTION = "xmlcontentautocorrection";
    private CmsWorkplaceManager m_workplaceManager;

    public static void addExplorerTypeXmlRules(Digester digester) {
        digester.addObjectCreate("*/explorertype", CmsExplorerTypeSettings.class);
        digester.addSetNext("*/explorertype", "addExplorerTypeSetting");
        digester.addCallMethod("*/explorertype", "setTypeAttributes", 5);
        digester.addCallParam("*/explorertype", 0, "name");
        digester.addCallParam("*/explorertype", 1, N_KEY);
        digester.addCallParam("*/explorertype", 2, "icon");
        digester.addCallParam("*/explorertype", 3, A_BIGICON);
        digester.addCallParam("*/explorertype", 4, A_REFERENCE);
        digester.addCallMethod("*/explorertype/iconrules/iconrule", "addIconRule", 3);
        digester.addCallParam("*/explorertype/iconrules/iconrule", 0, A_EXTENSION);
        digester.addCallParam("*/explorertype/iconrules/iconrule", 1, "icon");
        digester.addCallParam("*/explorertype/iconrules/iconrule", 2, A_BIGICON);
        digester.addCallMethod("*/explorertype/newresource", "setNewResourceHandlerClassName", 1);
        digester.addCallParam("*/explorertype/newresource", 0, "handler");
        digester.addCallMethod("*/explorertype/newresource", "setNewResourceUri", 1);
        digester.addCallParam("*/explorertype/newresource", 0, N_URI);
        digester.addCallMethod("*/explorertype/newresource", "setNewResourceOrder", 1);
        digester.addCallParam("*/explorertype/newresource", 0, "order");
        digester.addCallMethod("*/explorertype/newresource", "setNewResourcePage", 1);
        digester.addCallParam("*/explorertype/newresource", 0, A_PAGE);
        digester.addCallMethod("*/explorertype/newresource", "setAutoSetNavigation", 1);
        digester.addCallParam("*/explorertype/newresource", 0, A_AUTOSETNAVIGATION);
        digester.addCallMethod("*/explorertype/newresource", "setAutoSetTitle", 1);
        digester.addCallParam("*/explorertype/newresource", 0, A_AUTOSETTITLE);
        digester.addCallMethod("*/explorertype/newresource", "setInfo", 1);
        digester.addCallParam("*/explorertype/newresource", 0, A_INFO);
        digester.addCallMethod("*/explorertype/newresource", "setDescriptionImage", 1);
        digester.addCallParam("*/explorertype/newresource", 0, "icon");
        digester.addCallMethod("*/explorertype/newresource", "setTitleKey", 1);
        digester.addCallParam("*/explorertype/newresource", 0, N_KEY);
        digester.addObjectCreate("*/explorertype/accesscontrol", CmsExplorerTypeAccess.class);
        digester.addSetNext("*/explorertype/accesscontrol", "setAccess");
        digester.addCallMethod("*/explorertype/accesscontrol/accessentry", "addAccessEntry", 2);
        digester.addCallParam("*/explorertype/accesscontrol/accessentry", 0, A_PRINCIPAL);
        digester.addCallParam("*/explorertype/accesscontrol/accessentry", 1, A_PERMISSIONS);
        digester.addCallMethod("*/explorertype/editoptions/defaultproperties", "setPropertyDefaults", 2);
        digester.addCallParam("*/explorertype/editoptions/defaultproperties", 0, N_ENABLED);
        digester.addCallParam("*/explorertype/editoptions/defaultproperties", 1, A_SHOWNAVIGATION);
        digester.addCallMethod("*/explorertype/editoptions/defaultproperties/property", "addProperty", 1);
        digester.addCallParam("*/explorertype/editoptions/defaultproperties/property", 0, "name");
        digester.addCallMethod("*/explorertype/editoptions/defaultproperties/defaultproperty", "addProperty", 1);
        digester.addCallParam("*/explorertype/editoptions/defaultproperties/defaultproperty", 0, "name");
        CmsWorkplaceConfiguration.addContextMenuItemRules(digester, "*");
        digester.addCallMethod("*/explorertype/editoptions/contextmenu", "createContextMenu");
        digester.addCallMethod("*/explorertype/editoptions", "setEditOptions");
    }

    public static void generateExplorerTypesXml(Element startNode, List<CmsExplorerTypeSettings> explorerTypes, boolean module) {
        CmsExplorerTypeAccess defaultAccess = null;
        if (OpenCms.getWorkplaceManager() != null) {
            defaultAccess = OpenCms.getWorkplaceManager().getDefaultAccess();
        }
        CmsMenuRuleTranslator menuRuleTranslator = new CmsMenuRuleTranslator();
        for (CmsExplorerTypeSettings settings : explorerTypes) {
            Map<String, CmsIconRule> iconRules;
            if (settings.isAddititionalModuleExplorerType() != module) continue;
            Element explorerTypeElement = startNode.addElement(N_EXPLORERTYPE);
            explorerTypeElement.addAttribute("name", settings.getName());
            explorerTypeElement.addAttribute(N_KEY, settings.getKey());
            String originalIcon = settings.getOriginalIcon();
            if (CmsStringUtil.isNotEmpty(originalIcon)) {
                explorerTypeElement.addAttribute("icon", settings.getOriginalIcon());
            }
            if (CmsStringUtil.isNotEmpty(settings.getBigIcon())) {
                explorerTypeElement.addAttribute(A_BIGICON, settings.getBigIcon());
            }
            if (settings.getReference() != null) {
                explorerTypeElement.addAttribute(A_REFERENCE, settings.getReference());
            }
            Element newResElement = explorerTypeElement.addElement(N_NEWRESOURCE);
            if (CmsStringUtil.isNotEmpty(settings.getNewResourcePage())) {
                newResElement.addAttribute(A_PAGE, settings.getNewResourcePage());
            }
            newResElement.addAttribute("handler", settings.getNewResourceHandlerClassName());
            newResElement.addAttribute(N_URI, CmsEncoder.escapeXml(settings.getNewResourceUri()));
            newResElement.addAttribute("order", settings.getNewResourceOrder());
            newResElement.addAttribute(A_AUTOSETNAVIGATION, String.valueOf(settings.isAutoSetNavigation()));
            newResElement.addAttribute(A_AUTOSETTITLE, String.valueOf(settings.isAutoSetTitle()));
            newResElement.addAttribute(A_INFO, settings.getInfo());
            newResElement.addAttribute("icon", settings.getDescriptionImage());
            newResElement.addAttribute(N_KEY, settings.getTitleKey());
            CmsExplorerTypeAccess access = settings.getAccess();
            if (access != defaultAccess) {
                ArrayList<String> accessEntries = new ArrayList<String>(access.getAccessEntries().keySet());
                Collections.sort(accessEntries);
                if (accessEntries.size() > 0) {
                    Element accessControlElement = explorerTypeElement.addElement(N_ACCESSCONTROL);
                    for (String key : accessEntries) {
                        String value = settings.getAccess().getAccessEntries().get(key);
                        Element accessEntryElement = accessControlElement.addElement(N_ACCESSENTRY);
                        accessEntryElement.addAttribute(A_PRINCIPAL, key);
                        accessEntryElement.addAttribute(A_PERMISSIONS, value);
                    }
                }
            }
            if (settings.hasEditOptions()) {
                Element editOptionsElement = explorerTypeElement.addElement(N_EDITOPTIONS);
                Element defaultPropertiesElement = editOptionsElement.addElement(N_DEFAULTPROPERTIES);
                defaultPropertiesElement.addAttribute(N_ENABLED, String.valueOf(settings.isPropertiesEnabled()));
                defaultPropertiesElement.addAttribute(A_SHOWNAVIGATION, String.valueOf(settings.isShowNavigation()));
                Iterator<String> m = settings.getProperties().iterator();
                while (m.hasNext()) {
                    defaultPropertiesElement.addElement(N_DEFAULTPROPERTY).addAttribute("name", m.next());
                }
                Element contextMenuElement = editOptionsElement.addElement(N_CONTEXTMENU);
                for (CmsExplorerContextMenuItem item : settings.getContextMenuEntries()) {
                    CmsWorkplaceConfiguration.generateContextMenuItemXml(contextMenuElement, menuRuleTranslator, item);
                }
            }
            if ((iconRules = settings.getIconRules()) == null || iconRules.isEmpty()) continue;
            Element iconRulesElem = explorerTypeElement.addElement(N_ICONRULES);
            for (Map.Entry<String, CmsIconRule> entry : iconRules.entrySet()) {
                CmsIconRule rule = entry.getValue();
                Element ruleElem = iconRulesElem.addElement(N_ICONRULE);
                String icon = rule.getIcon();
                String bigIcon = rule.getBigIcon();
                String extension = rule.getExtension();
                ruleElem.addAttribute(A_EXTENSION, extension);
                ruleElem.addAttribute("icon", icon);
                if (bigIcon == null) continue;
                ruleElem.addAttribute(A_BIGICON, bigIcon);
            }
        }
    }

    protected static void addContextMenuItemRules(Digester digester, String xPathPrefix) {
        String xPath = xPathPrefix + "/" + N_ENTRY;
        digester.addObjectCreate(xPath, CmsExplorerContextMenuItem.class);
        digester.addCallMethod(xPath, "setKey", 1);
        digester.addCallParam(xPath, 0, N_KEY);
        digester.addCallMethod(xPath, "setUri", 1);
        digester.addCallParam(xPath, 0, N_URI);
        digester.addCallMethod(xPath, "setRules", 1);
        digester.addCallParam(xPath, 0, A_RULES);
        digester.addCallMethod(xPath, "setRule", 1);
        digester.addCallParam(xPath, 0, A_RULE);
        digester.addCallMethod(xPath, "setTarget", 1);
        digester.addCallParam(xPath, 0, A_TARGET);
        digester.addCallMethod(xPath, "setName", 1);
        digester.addCallParam(xPath, 0, "name");
        digester.addCallMethod(xPath, "setParams", 1);
        digester.addCallParam(xPath, 0, A_PARAMS);
        digester.addCallMethod(xPath, "setIcon", 1);
        digester.addCallParam(xPath, 0, "icon");
        digester.addSetNext(xPath, "addContextMenuEntry");
        xPath = xPathPrefix + "/" + N_SEPARATOR;
        digester.addObjectCreate(xPath, CmsExplorerContextMenuItem.class);
        digester.addSetNext(xPath, "addContextMenuSeparator");
    }

    protected static void generateContextMenuItemXml(Element parentElement, CmsMenuRuleTranslator menuRuleTranslator, CmsExplorerContextMenuItem item) {
        if (N_ENTRY.equals(item.getType())) {
            String rule;
            Element itemElement = parentElement.addElement(N_ENTRY);
            itemElement.addAttribute(N_KEY, item.getKey());
            itemElement.addAttribute(N_URI, item.getUri());
            if (item.getName() != null) {
                itemElement.addAttribute("name", item.getName());
            }
            if (item.getIcon() != null) {
                itemElement.addAttribute("icon", item.getIcon());
            }
            if (item.getTarget() != null) {
                itemElement.addAttribute(A_TARGET, item.getTarget());
            }
            if (item.getParams() != null) {
                itemElement.addAttribute(A_PARAMS, item.getParams());
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(rule = item.getRule())) {
                itemElement.addAttribute(A_RULE, rule);
            } else {
                String legacyRules = item.getRules();
                if (CmsStringUtil.isNotEmpty(legacyRules) && menuRuleTranslator.hasMenuRule(legacyRules)) {
                    itemElement.addAttribute(A_RULE, menuRuleTranslator.getMenuRuleName(legacyRules));
                } else {
                    itemElement.addAttribute(A_RULES, legacyRules);
                }
            }
            if (item.isParentItem()) {
                for (CmsExplorerContextMenuItem subItem : item.getSubItems()) {
                    CmsWorkplaceConfiguration.generateContextMenuItemXml(itemElement, menuRuleTranslator, subItem);
                }
            }
        } else {
            parentElement.addElement(N_SEPARATOR);
        }
    }

    @Override
    public void addXmlDigesterRules(Digester digester) {
        digester.addCallMethod("*/workplace", "initializeFinished");
        digester.addCallMethod("*/param", "addConfigurationParameter", 2);
        digester.addCallParam("*/param", 0, "name");
        digester.addCallParam("*/param", 1);
        digester.addObjectCreate("*/workplace", CmsWorkplaceManager.class);
        digester.addSetNext("*/workplace", "setWorkplaceManager");
        digester.addCallMethod("*/workplace/user-lists", "setUserListMode", 1);
        digester.addCallParam("*/workplace/user-lists", 0, A_MODE);
        digester.addCallMethod("*/workplace/defaultlocale", "setDefaultLocale", 0);
        digester.addCallMethod("*/workplace/defaultpropertiesonstructure", "setDefaultPropertiesOnStructure", 0);
        digester.addCallMethod("*/workplace/enableadvancedpropertytabs", "setEnableAdvancedPropertyTabs", 0);
        digester.addCallMethod("*/workplace/group-translation", "setGroupTranslationClass", 1);
        digester.addCallParam("*/workplace/group-translation", 0, "class");
        digester.addObjectCreate("*/workplace/dialoghandlers/dialoghandler", "class", CmsConfigurationException.class);
        digester.addSetNext("*/workplace/dialoghandlers/dialoghandler", "addDialogHandler");
        digester.addCallMethod("*/workplace/dialoghandlers/dialoghandler", "initConfiguration");
        digester.addObjectCreate("*/workplace/editorhandler", "class", CmsConfigurationException.class);
        digester.addSetNext("*/workplace/editorhandler", "setEditorHandler");
        digester.addObjectCreate("*/workplace/editoraction", "class", CmsConfigurationException.class);
        digester.addSetNext("*/workplace/editoraction", "setEditorAction");
        digester.addCallMethod("*/workplace/editorcsshandlers/editorcsshandler", "addEditorCssHandler", 1);
        digester.addCallParam("*/workplace/editorcsshandlers/editorcsshandler", 0, "class");
        digester.addObjectCreate("*/workplace/editorpreconditions/editorprecondition", "class", CmsConfigurationException.class);
        digester.addSetNext("*/workplace/editorpreconditions/editorprecondition", "addPreEditorConditionDefinition");
        digester.addCallMethod("*/workplace/editorpreconditions/editorprecondition", "setResourceTypeName", 1);
        digester.addCallParam("*/workplace/editorpreconditions/editorprecondition", 0, "name");
        digester.addCallMethod("*/workplace/editorpreconditions/editorprecondition", "initConfiguration");
        digester.addObjectCreate("*/workplace/directeditprovider", "class", CmsConfigurationException.class);
        digester.addCallMethod("*/workplace/directeditprovider", "initConfiguration");
        digester.addSetNext("*/workplace/directeditprovider", "setDirectEditProvider");
        digester.addCallMethod("*/workplace/exportpoints/exportpoint", "addExportPoint", 2);
        digester.addCallParam("*/workplace/exportpoints/exportpoint", 0, N_URI);
        digester.addCallParam("*/workplace/exportpoints/exportpoint", 1, "destination");
        digester.addCallMethod("*/workplace/autolock", "setAutoLock", 0);
        digester.addCallMethod("*/workplace/xmlcontentautocorrection", "setXmlContentAutoCorrect", 0);
        digester.addCallMethod("*/workplace/enableusermanagement", "setUserManagementEnabled", 0);
        digester.addCallMethod("*/workplace/maxfileuploadsize", "setFileMaxUploadSize", 0);
        digester.addCallMethod("*/workplace/labeledfolders/resource", "addLabeledFolder", 1);
        digester.addCallParam("*/workplace/labeledfolders/resource", 0, N_URI);
        digester.addCallMethod("*/workplace/localizedfolders/resource", "addLocalizedFolder", 1);
        digester.addCallParam("*/workplace/localizedfolders/resource", 0, N_URI);
        String xPathPrefix = "*/rfsfileviewsettings";
        digester.addObjectCreate(xPathPrefix, CmsRfsFileViewer.class);
        digester.addBeanPropertySetter(xPathPrefix + "/" + N_ROOTPATH);
        digester.addBeanPropertySetter(xPathPrefix + "/" + N_FILEPATH);
        digester.addBeanPropertySetter(xPathPrefix + "/" + N_ENABLED);
        digester.addBeanPropertySetter(xPathPrefix + "/" + N_FILEENCODING);
        digester.addBeanPropertySetter(xPathPrefix + "/" + N_ISLOGFILE);
        digester.addBeanPropertySetter(xPathPrefix + "/" + N_WINDOWSIZE);
        digester.addRule(xPathPrefix, (Rule)new CmsSetNextRule("setFileViewSettings", CmsRfsFileViewer.class));
        CmsWorkplaceConfiguration.addExplorerTypeXmlRules(digester);
        this.addDefaultAccessControlRules(digester);
        this.addMultiContextMenuRules(digester);
        this.addContextMenuRules(digester);
        this.addUserInfoRules(digester);
        this.addDefaultPreferencesRules(digester);
        xPathPrefix = "*/workplace/workplace-customfoot";
        digester.addObjectCreate(xPathPrefix, CmsWorkplaceCustomFoot.class);
        digester.addCallMethod(xPathPrefix + "/" + N_BACKGROUNDCOLOR, "setBackgroundColor", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_COLOR, "setColor", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_TEXT, "setText", 2);
        digester.addCallParam(xPathPrefix + "/" + N_TEXT, 0);
        digester.addCallParam(xPathPrefix + "/" + N_TEXT, 1, A_REPLACE);
        digester.addSetNext(xPathPrefix, "setCustomFoot");
        this.addToolManagerRules(digester);
    }

    @Override
    public Element generateXml(Element parent) {
        Iterator<CmsExplorerContextMenuItem> menuEntries;
        String filePath;
        Element workplaceElement = parent.addElement(N_WORKPLACE);
        workplaceElement.addElement(N_DEFAULTLOCALE).setText(this.m_workplaceManager.getDefaultLocale().toString());
        Element localizedElement = workplaceElement.addElement(N_LOCALIZEDFOLDERS);
        Iterator<String> localizedIterator = this.m_workplaceManager.getLocalizedFolders().iterator();
        while (localizedIterator.hasNext()) {
            localizedElement.addElement("resource").addAttribute(N_URI, localizedIterator.next());
        }
        Element dialogElement = workplaceElement.addElement(N_DIALOGHANDLERS);
        Map<String, I_CmsDialogHandler> dialogs = this.m_workplaceManager.getDialogHandler();
        Object[] keys = dialogs.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (int j = 0; j < keys.length; ++j) {
            Object name = keys[j];
            Element element = dialogElement.addElement(N_DIALOGHANDLER).addAttribute("class", dialogs.get(name).getClass().getName());
            I_CmsDialogHandler daialogHandlerConfig = dialogs.get(name);
            CmsParameterConfiguration handlerConfig = daialogHandlerConfig.getConfiguration();
            if (handlerConfig == null) continue;
            handlerConfig.appendToXml(element);
        }
        workplaceElement.addElement(N_EDITORHANDLER).addAttribute("class", this.m_workplaceManager.getEditorHandler().getClass().getName());
        workplaceElement.addElement(N_EDITORACTION).addAttribute("class", this.m_workplaceManager.getEditorActionHandler().getClass().getName());
        if (this.m_workplaceManager.getEditorCssHandlers().size() > 0) {
            Element editorCssHandlers = workplaceElement.addElement(N_EDITORCSSHANDLERS);
            for (I_CmsEditorCssHandler i_CmsEditorCssHandler : this.m_workplaceManager.getEditorCssHandlers()) {
                Element handler = editorCssHandlers.addElement(N_EDITORCSSHANDLER);
                handler.addAttribute("class", i_CmsEditorCssHandler.getClass().getName());
            }
        }
        if (this.m_workplaceManager.getPreEditorConditionDefinitions().size() > 0) {
            Element editorPreActions = workplaceElement.addElement(N_EDITORPRECONDITIONS);
            for (I_CmsPreEditorActionDefinition i_CmsPreEditorActionDefinition : this.m_workplaceManager.getPreEditorConditionDefinitions()) {
                Element action = editorPreActions.addElement(N_EDITORPRECONDITION);
                action.addAttribute("name", i_CmsPreEditorActionDefinition.getResourceTypeName());
                action.addAttribute("class", i_CmsPreEditorActionDefinition.getClass().getName());
                CmsParameterConfiguration config = i_CmsPreEditorActionDefinition.getConfiguration();
                if (config == null || config.size() <= 0) continue;
                config.appendToXml(action);
            }
        }
        I_CmsDirectEditProvider deProvider = this.m_workplaceManager.getDirectEditProvider();
        Element deProviderNode = workplaceElement.addElement(N_DIRECTEDITPROVIDER).addAttribute("class", deProvider.getClass().getName());
        CmsParameterConfiguration cmsParameterConfiguration = deProvider.getConfiguration();
        if (cmsParameterConfiguration != null) {
            cmsParameterConfiguration.appendToXml(deProviderNode);
        }
        Element resourceloadersElement = workplaceElement.addElement("exportpoints");
        Set<CmsExportPoint> points = this.m_workplaceManager.getExportPoints();
        for (CmsExportPoint point : points) {
            resourceloadersElement.addElement("exportpoint").addAttribute(N_URI, point.getUri()).addAttribute("destination", point.getConfiguredDestination());
        }
        workplaceElement.addElement(N_AUTOLOCK).setText(String.valueOf(this.m_workplaceManager.autoLockResources()));
        workplaceElement.addElement(N_XMLCONTENTAUTOCORRECTION).setText(String.valueOf(this.m_workplaceManager.isXmlContentAutoCorrect()));
        workplaceElement.addElement(N_ENABLEUSERMGMT).setText(String.valueOf(this.m_workplaceManager.showUserGroupIcon()));
        workplaceElement.addElement(N_DEFAULTPROPERTIESONSTRUCTURE).setText(String.valueOf(this.m_workplaceManager.isDefaultPropertiesOnStructure()));
        workplaceElement.addElement(N_ENABLEADVANCEDPROPERTYTABS).setText(String.valueOf(this.m_workplaceManager.isEnableAdvancedPropertyTabs()));
        String groupTranslationClass = this.m_workplaceManager.getGroupTranslationClass();
        if (groupTranslationClass != null) {
            Element groupTranslationElement = workplaceElement.addElement(N_GROUP_TRANSLATION);
            groupTranslationElement.addAttribute("class", groupTranslationClass);
        }
        workplaceElement.addElement(N_MAXUPLOADSIZE).setText(String.valueOf(this.m_workplaceManager.getFileMaxUploadSize()));
        Element labeledElement = workplaceElement.addElement(N_LABELEDFOLDERS);
        Iterator<String> sitesFolders = this.m_workplaceManager.getLabelSiteFolders().iterator();
        while (sitesFolders.hasNext()) {
            labeledElement.addElement("resource").addAttribute(N_URI, sitesFolders.next());
        }
        CmsRfsFileViewer viewSettings = this.m_workplaceManager.getFileViewSettings();
        Element fileViewElement = workplaceElement.addElement(N_RFSFILEVIEWESETTINGS);
        String rootPath = viewSettings.getRootPath();
        if (rootPath != null) {
            fileViewElement.addElement(N_ROOTPATH).setText(rootPath);
        }
        if ((filePath = viewSettings.getFilePath()) != null) {
            fileViewElement.addElement(N_FILEPATH).setText(filePath);
        }
        fileViewElement.addElement(N_ENABLED).setText(String.valueOf(viewSettings.isEnabled()));
        fileViewElement.addElement(N_FILEENCODING).setText(viewSettings.getFileEncoding());
        fileViewElement.addElement(N_ISLOGFILE).setText(String.valueOf(viewSettings.getIsLogfile()));
        fileViewElement.addElement(N_WINDOWSIZE).setText(String.valueOf(viewSettings.getWindowSize()));
        Element explorerTypesElement = workplaceElement.addElement(N_EXPLORERTYPES);
        List<CmsExplorerTypeSettings> explorerTypes = this.m_workplaceManager.getExplorerTypeSettings();
        CmsWorkplaceConfiguration.generateExplorerTypesXml(explorerTypesElement, explorerTypes, false);
        Element defaultAccessControlElement = explorerTypesElement.addElement(N_DEFAULTACCESSCONTROL);
        ArrayList<String> accessEntries = new ArrayList<String>();
        CmsExplorerTypeAccess access = this.m_workplaceManager.getDefaultAccess();
        Iterator<String> iter = access.getAccessEntries().keySet().iterator();
        while (iter.hasNext()) {
            accessEntries.add(iter.next());
        }
        Collections.sort(accessEntries);
        if (accessEntries.size() > 0) {
            Element accessControlElement = defaultAccessControlElement.addElement(N_ACCESSCONTROL);
            for (String key : accessEntries) {
                String value = this.m_workplaceManager.getDefaultAccess().getAccessEntries().get(key);
                Element accessEntryElement = accessControlElement.addElement(N_ACCESSENTRY);
                accessEntryElement.addAttribute(A_PRINCIPAL, key);
                accessEntryElement.addAttribute(A_PERMISSIONS, value);
            }
        }
        if ((menuEntries = this.m_workplaceManager.getMultiContextMenu().getAllEntries().iterator()).hasNext()) {
            Element contextMenuElement = explorerTypesElement.addElement(N_MULTICONTEXTMENU);
            CmsMenuRuleTranslator menuRuleTranslator = new CmsMenuRuleTranslator();
            while (menuEntries.hasNext()) {
                CmsExplorerContextMenuItem item = menuEntries.next();
                CmsWorkplaceConfiguration.generateContextMenuItemXml(contextMenuElement, menuRuleTranslator, item);
            }
        }
        if (this.m_workplaceManager.getMenuRules().size() > 0) {
            Element rulesElement = explorerTypesElement.addElement(N_MENURULES);
            for (CmsMenuRule rule : this.m_workplaceManager.getMenuRules()) {
                Element ruleElement = rulesElement.addElement(N_MENURULE);
                ruleElement.addAttribute("name", rule.getName());
                for (I_CmsMenuItemRule itemRule : rule.getMenuItemRules()) {
                    Element itemRuleElement = ruleElement.addElement(N_MENUITEMRULE);
                    itemRuleElement.addAttribute("class", itemRule.getClass().getName());
                }
            }
        }
        if (this.m_workplaceManager.getUserInfoManager() != null) {
            Element userInfosElement = workplaceElement.addElement(N_USERINFOS);
            for (CmsWorkplaceUserInfoBlock block : this.m_workplaceManager.getUserInfoManager().getBlocks()) {
                Element infoBlockElement = userInfosElement.addElement(N_INFOBLOCK);
                infoBlockElement.addAttribute("name", block.getTitle());
                for (CmsWorkplaceUserInfoEntry entry : block.getEntries()) {
                    Element userInfoElement = infoBlockElement.addElement(N_USERINFO);
                    userInfoElement.addAttribute(N_KEY, entry.getKey());
                    if (entry.getType() != null) {
                        userInfoElement.addAttribute("type", entry.getType());
                    }
                    if (entry.getWidget() != null) {
                        userInfoElement.addAttribute(A_WIDGET, entry.getWidget());
                    }
                    if (entry.getParams() != null) {
                        userInfoElement.addAttribute(A_PARAMS, entry.getParams());
                    }
                    if (entry.getOptional() == null) continue;
                    userInfoElement.addAttribute(A_OPTIONAL, entry.getOptional());
                }
            }
        }
        Element defaultPreferences = workplaceElement.addElement(N_DEFAULTPREFERENCES);
        Element workplacePreferences = defaultPreferences.addElement(N_WORKPLACEPREFERENCES);
        Element workplaceGeneraloptions = workplacePreferences.addElement(N_WORKPLACEGENERALOPTIONS);
        workplaceGeneraloptions.addElement(N_BUTTONSTYLE).setText(this.m_workplaceManager.getDefaultUserSettings().getWorkplaceButtonStyleString());
        workplaceGeneraloptions.addElement(N_REPORTTYPE).setText(this.m_workplaceManager.getDefaultUserSettings().getWorkplaceReportType());
        workplaceGeneraloptions.addElement(N_UPLOADAPPLET).setText(this.m_workplaceManager.getDefaultUserSettings().getUploadVariant().toString());
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_workplaceManager.getDefaultUserSettings().getPublishButtonAppearance())) {
            workplaceGeneraloptions.addElement(N_PUBLISHBUTTONAPPEARANCE).setText(this.m_workplaceManager.getDefaultUserSettings().getPublishButtonAppearance());
        }
        workplaceGeneraloptions.addElement(N_LISTALLPROJECTS).setText(this.m_workplaceManager.getDefaultUserSettings().getListAllProjectsString());
        workplaceGeneraloptions.addElement(N_PUBLISHNOTIFICATION).setText(this.m_workplaceManager.getDefaultUserSettings().getShowPublishNotificationString());
        workplaceGeneraloptions.addElement(N_SHOWFILEUPLOADBUTTON).setText(this.m_workplaceManager.getDefaultUserSettings().getShowFileUploadButtonString());
        workplaceGeneraloptions.addElement(N_ALLOWBROKENRELATIONS).setText(String.valueOf(this.m_workplaceManager.getDefaultUserSettings().isAllowBrokenRelations()));
        if (this.m_workplaceManager.getDefaultUserSettings().getPublishRelatedResources() != null) {
            workplaceGeneraloptions.addElement(N_PUBLISHRELATEDRESOURCES).setText(this.m_workplaceManager.getDefaultUserSettings().getPublishRelatedResources().toString());
        }
        workplaceGeneraloptions.addElement(N_NEWFOLDEREDITPROPERTIES).setText(this.m_workplaceManager.getDefaultUserSettings().getNewFolderEditProperties().toString());
        workplaceGeneraloptions.addElement(N_NEWFOLDERCREATEINDEXPAGE).setText(this.m_workplaceManager.getDefaultUserSettings().getNewFolderCreateIndexPage().toString());
        workplaceGeneraloptions.addElement(N_SHOWUPLOADTYPEDIALOG).setText(this.m_workplaceManager.getDefaultUserSettings().getShowUploadTypeDialog().toString());
        CmsDefaultUserSettings.SubsitemapCreationMode subsitemapCreationMode = this.m_workplaceManager.getDefaultUserSettings().getSubsitemapCreationMode(null);
        if (subsitemapCreationMode != null) {
            workplaceGeneraloptions.addElement(N_SUBSITEMAP_CREATION_MODE).setText(subsitemapCreationMode.toString());
        }
        Element workplaceStartupsettings = workplacePreferences.addElement(N_WORKPLACESTARTUPSETTINGS);
        workplaceStartupsettings.addElement(N_LOCALE).setText(this.m_workplaceManager.getDefaultUserSettings().getLocale().toString());
        workplaceStartupsettings.addElement(N_PROJECT).setText(this.m_workplaceManager.getDefaultUserSettings().getStartProject());
        workplaceStartupsettings.addElement(N_WORKPLACEVIEW).setText(this.m_workplaceManager.getDefaultUserSettings().getStartView());
        workplaceStartupsettings.addElement(N_FOLDER).setText(this.m_workplaceManager.getDefaultUserSettings().getStartFolder());
        workplaceStartupsettings.addElement("site").setText(this.m_workplaceManager.getDefaultUserSettings().getStartSite());
        workplaceStartupsettings.addElement(N_RESTRICTEXPLORERVIEW).setText(this.m_workplaceManager.getDefaultUserSettings().getRestrictExplorerViewString());
        Element workplaceSearch = workplacePreferences.addElement(N_WORKPLACESEARCH);
        workplaceSearch.addElement(N_SEARCHINDEXNAME).setText(this.m_workplaceManager.getDefaultUserSettings().getWorkplaceSearchIndexName());
        workplaceSearch.addElement(N_SEARCHVIEWSTYLE).setText(this.m_workplaceManager.getDefaultUserSettings().getWorkplaceSearchViewStyle().toString());
        Element explorerPreferences = defaultPreferences.addElement(N_EXPLORERPREFERENCES);
        Element explorerGeneraloptions = explorerPreferences.addElement(N_EXPLORERGENERALOPTIONS);
        explorerGeneraloptions.addElement(N_BUTTONSTYLE).setText(this.m_workplaceManager.getDefaultUserSettings().getExplorerButtonStyleString());
        explorerGeneraloptions.addElement(N_ENTRIES).setText("" + this.m_workplaceManager.getDefaultUserSettings().getExplorerFileEntries());
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_workplaceManager.getDefaultUserSettings().getExporerFileEntryOptions())) {
            explorerGeneraloptions.addElement(N_ENTRYOPTIONS).setText(this.m_workplaceManager.getDefaultUserSettings().getExporerFileEntryOptions());
        }
        Element explorerDisplayoptions = explorerPreferences.addElement(N_EXPLORERDISPLAYOPTIONS);
        explorerDisplayoptions.addElement(N_TITLE).setText(this.m_workplaceManager.getDefaultUserSettings().getShowExplorerFileTitle());
        explorerDisplayoptions.addElement(N_NAVTEXT).setText(this.m_workplaceManager.getDefaultUserSettings().getShowExplorerFileNavText());
        explorerDisplayoptions.addElement(N_TYPE).setText(this.m_workplaceManager.getDefaultUserSettings().getShowExplorerFileType());
        explorerDisplayoptions.addElement(N_DATELASTMODIFIED).setText(this.m_workplaceManager.getDefaultUserSettings().getShowExplorerFileDateLastModified());
        explorerDisplayoptions.addElement(N_DATECREATED).setText(this.m_workplaceManager.getDefaultUserSettings().getShowExplorerFileDateCreated());
        explorerDisplayoptions.addElement(N_LOCKEDBY).setText(this.m_workplaceManager.getDefaultUserSettings().getShowExplorerFileLockedBy());
        explorerDisplayoptions.addElement(N_PERMISSIONS).setText(this.m_workplaceManager.getDefaultUserSettings().getShowExplorerFilePermissions());
        explorerDisplayoptions.addElement(N_SIZE).setText(this.m_workplaceManager.getDefaultUserSettings().getShowExplorerFileSize());
        explorerDisplayoptions.addElement(N_STATE).setText(this.m_workplaceManager.getDefaultUserSettings().getShowExplorerFileState());
        explorerDisplayoptions.addElement(N_USERLASTMODIFIED).setText(this.m_workplaceManager.getDefaultUserSettings().getShowExplorerFileUserLastModified());
        explorerDisplayoptions.addElement(N_USERCREATED).setText(this.m_workplaceManager.getDefaultUserSettings().getShowExplorerFileUserCreated());
        explorerDisplayoptions.addElement(N_DATERELEASED).setText(this.m_workplaceManager.getDefaultUserSettings().getShowExplorerFileDateReleased());
        explorerDisplayoptions.addElement(N_DATEEXPIRED).setText(this.m_workplaceManager.getDefaultUserSettings().getShowExplorerFileDateExpired());
        Element dialogPreferences = defaultPreferences.addElement(N_DIALOGSPREFERENCES);
        Element dialogDefaultSettings = dialogPreferences.addElement(N_DIALOGSDEFAULTSETTINGS);
        dialogDefaultSettings.addElement(N_FILECOPY).setText(this.m_workplaceManager.getDefaultUserSettings().getDialogCopyFileModeString());
        dialogDefaultSettings.addElement(N_FOLDERCOPY).setText(this.m_workplaceManager.getDefaultUserSettings().getDialogCopyFolderModeString());
        dialogDefaultSettings.addElement(N_FILEDELETION).setText(this.m_workplaceManager.getDefaultUserSettings().getDialogDeleteFileModeString());
        dialogDefaultSettings.addElement(N_DIRECTPUBLISH).setText(this.m_workplaceManager.getDefaultUserSettings().getDialogPublishSiblingsString());
        dialogDefaultSettings.addElement(N_SHOWLOCK).setText(this.m_workplaceManager.getDefaultUserSettings().getDialogShowLockString());
        dialogDefaultSettings.addElement(N_SHOWEXPORTSETTINGS).setText(this.m_workplaceManager.getDefaultUserSettings().getDialogShowExportSettingsString());
        dialogDefaultSettings.addElement(N_EXPANDPERMISSIONSUSER).setText(this.m_workplaceManager.getDefaultUserSettings().getDialogExpandUserPermissionsString());
        dialogDefaultSettings.addElement(N_EXPANDPERMISSIONSINHERITED).setText(this.m_workplaceManager.getDefaultUserSettings().getDialogExpandInheritedPermissionsString());
        dialogDefaultSettings.addElement(N_PERMISSIONSINHERITONFOLDER).setText(this.m_workplaceManager.getDefaultUserSettings().getDialogPermissionsInheritOnFolderString());
        Element editorsPreferences = defaultPreferences.addElement(N_EDITORPREFERENCES);
        Element editorGeneraloptions = editorsPreferences.addElement(N_EDITORGENERALOPTIONS);
        editorGeneraloptions.addElement(N_BUTTONSTYLE).setText(this.m_workplaceManager.getDefaultUserSettings().getEditorButtonStyleString());
        editorGeneraloptions.addElement(N_DIRECTEDITSTYLE).setText(this.m_workplaceManager.getDefaultUserSettings().getDirectEditButtonStyleString());
        Element editorPreferrededitors = editorsPreferences.addElement(N_EDITORPREFERREDEDITORS);
        for (Map.Entry<String, String> e : this.m_workplaceManager.getDefaultUserSettings().getEditorSettings().entrySet()) {
            String type = e.getKey();
            String value = e.getValue();
            Element editor = editorPreferrededitors.addElement(N_EDITOR);
            editor.addAttribute("type", type);
            editor.addAttribute("value", value);
        }
        if (!this.m_workplaceManager.getDefaultUserSettings().getStartGalleriesSettings().isEmpty()) {
            Element galleriesPreferences = defaultPreferences.addElement(N_GALLERIESPREFERENCES);
            Element galleryStartGalleries = galleriesPreferences.addElement(N_STARTGALLERIES);
            for (Map.Entry<String, String> e : this.m_workplaceManager.getDefaultUserSettings().getStartGalleriesSettings().entrySet()) {
                String type = e.getKey();
                String path = e.getValue();
                Element startGallery = galleryStartGalleries.addElement(N_STARTGALLERY);
                startGallery.addAttribute("type", type);
                startGallery.addAttribute(A_PATH, path);
            }
        }
        if (this.m_workplaceManager.getCustomFoot() != null) {
            Element workplaceFootCustom = workplaceElement.addElement(N_WORKPLACECUSTOMFOOT);
            workplaceFootCustom.addElement(N_COLOR).setText(this.m_workplaceManager.getCustomFoot().getColor());
            workplaceFootCustom.addElement(N_BACKGROUNDCOLOR).setText(this.m_workplaceManager.getCustomFoot().getBackgroundColor());
            Element textElement = workplaceFootCustom.addElement(N_TEXT);
            textElement.addAttribute(A_REPLACE, Boolean.toString(this.m_workplaceManager.getCustomFoot().isReplaceDefault()));
            textElement.setText(this.m_workplaceManager.getCustomFoot().getText());
        }
        Element toolManagerElement = workplaceElement.addElement(N_TOOLMANAGER);
        Element rootsElement = toolManagerElement.addElement(N_ROOTS);
        for (CmsToolRootHandler root : this.m_workplaceManager.getToolManager().getToolRoots()) {
            Element rootElement = rootsElement.addElement(N_ROOT);
            rootElement.addElement(N_KEY).addText(root.getKey());
            rootElement.addElement(N_URI).addText(root.getUri());
            rootElement.addElement("name").addText(root.getName());
            rootElement.addElement(N_HELPTEXT).addText(root.getHelpText());
        }
        String userListsMode = this.m_workplaceManager.getUserListModeString();
        if (userListsMode != null) {
            Element userListsElem = workplaceElement.addElement(N_USER_LISTS);
            userListsElem.addAttribute(A_MODE, userListsMode);
        }
        return workplaceElement;
    }

    @Override
    public String getDtdFilename() {
        return CONFIGURATION_DTD_NAME;
    }

    public CmsWorkplaceManager getWorkplaceManager() {
        return this.m_workplaceManager;
    }

    public void initializeFinished() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_FINISHED_0"));
        }
    }

    public void setWorkplaceManager(CmsWorkplaceManager manager) {
        this.m_workplaceManager = manager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_INIT_FINISHED_0"));
        }
    }

    protected void addContextMenuRules(Digester digester) {
        digester.addObjectCreate("*/workplace/explorertypes/menurules/menurule", CmsMenuRule.class);
        digester.addSetNext("*/workplace/explorertypes/menurules/menurule", "addMenuRule");
        digester.addCallMethod("*/workplace/explorertypes/menurules/menurule", "setName", 1);
        digester.addCallParam("*/workplace/explorertypes/menurules/menurule", 0, "name");
        digester.addCallMethod("*/workplace/explorertypes/menurules/menurule/menuitemrule", "addMenuItemRuleName", 1);
        digester.addCallParam("*/workplace/explorertypes/menurules/menurule/menuitemrule", 0, "class");
    }

    protected void addDefaultAccessControlRules(Digester digester) {
        digester.addObjectCreate("*/workplace/explorertypes/defaultaccesscontrol/accesscontrol", CmsExplorerTypeAccess.class);
        digester.addSetNext("*/workplace/explorertypes/defaultaccesscontrol/accesscontrol", "setDefaultAccess");
        digester.addCallMethod("*/workplace/explorertypes/defaultaccesscontrol/accesscontrol/accessentry", "addAccessEntry", 2);
        digester.addCallParam("*/workplace/explorertypes/defaultaccesscontrol/accesscontrol/accessentry", 0, A_PRINCIPAL);
        digester.addCallParam("*/workplace/explorertypes/defaultaccesscontrol/accesscontrol/accessentry", 1, A_PERMISSIONS);
    }

    protected void addDefaultPreferencesRules(Digester digester) {
        digester.addObjectCreate("*/workplace/default-preferences", CmsDefaultUserSettings.class);
        digester.addSetNext("*/workplace/default-preferences", "setDefaultUserSettings");
        String xPathPrefix = "*/workplace/default-preferences/workplace-preferences/workplace-generaloptions";
        digester.addCallMethod(xPathPrefix + "/" + N_BUTTONSTYLE, "setWorkplaceButtonStyle", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_REPORTTYPE, "setWorkplaceReportType", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_UPLOADAPPLET, "setUploadVariant", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_LISTALLPROJECTS, "setListAllProjects", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_PUBLISHNOTIFICATION, "setShowPublishNotification", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_PUBLISHBUTTONAPPEARANCE, "setPublishButtonAppearance", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_SHOWFILEUPLOADBUTTON, "setShowFileUploadButton", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_ALLOWBROKENRELATIONS, "setAllowBrokenRelations", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_PUBLISHRELATEDRESOURCES, "setPublishRelatedResourcesMode", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_NEWFOLDEREDITPROPERTIES, "setNewFolderEditProperties", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_NEWFOLDERCREATEINDEXPAGE, "setNewFolderCreateIndexPage", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_SHOWUPLOADTYPEDIALOG, "setShowUploadTypeDialog", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_SUBSITEMAP_CREATION_MODE, "setSubsitemapCreationMode", 0);
        xPathPrefix = "*/workplace/default-preferences/workplace-preferences/workplace-startupsettings";
        digester.addCallMethod(xPathPrefix + "/" + N_LOCALE, "setLocale", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_PROJECT, "setStartProject", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_WORKPLACEVIEW, "setStartView", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_FOLDER, "setStartFolder", 0);
        digester.addCallMethod(xPathPrefix + "/" + "site", "setStartSite", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_RESTRICTEXPLORERVIEW, "setRestrictExplorerView", 0);
        xPathPrefix = "*/workplace/default-preferences/workplace-preferences/workplace-search";
        digester.addCallMethod(xPathPrefix + "/" + N_SEARCHINDEXNAME, "setWorkplaceSearchIndexName", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_SEARCHVIEWSTYLE, "setWorkplaceSearchViewStyle", 0);
        xPathPrefix = "*/workplace/default-preferences/explorer-preferences/explorer-generaloptions";
        digester.addCallMethod(xPathPrefix + "/" + N_BUTTONSTYLE, "setExplorerButtonStyle", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_ENTRIES, "setExplorerFileEntries", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_ENTRYOPTIONS, "setExporerFileEntryOptions", 0);
        xPathPrefix = "*/workplace/default-preferences/explorer-preferences/explorer-displayoptions";
        digester.addCallMethod(xPathPrefix + "/" + N_TITLE, "setShowExplorerFileTitle", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_NAVTEXT, "setShowExplorerFileNavText", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_TYPE, "setShowExplorerFileType", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_DATELASTMODIFIED, "setShowExplorerFileDateLastModified", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_DATECREATED, "setShowExplorerFileDateCreated", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_LOCKEDBY, "setShowExplorerFileLockedBy", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_PERMISSIONS, "setShowExplorerFilePermissions", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_SIZE, "setShowExplorerFileSize", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_STATE, "setShowExplorerFileState", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_USERLASTMODIFIED, "setShowExplorerFileUserLastModified", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_USERCREATED, "setShowExplorerFileUserCreated", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_DATERELEASED, "setShowExplorerFileDateReleased", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_DATEEXPIRED, "setShowExplorerFileDateExpired", 0);
        xPathPrefix = "*/workplace/default-preferences/dialogs-preferences/dialogs-defaultsettings";
        digester.addCallMethod(xPathPrefix + "/" + N_FILECOPY, "setDialogCopyFileMode", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_FOLDERCOPY, "setDialogCopyFolderMode", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_FILEDELETION, "setDialogDeleteFileMode", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_DIRECTPUBLISH, "setDialogPublishSiblings", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_SHOWLOCK, "setShowLockDialog", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_SHOWEXPORTSETTINGS, "setShowExportSettingsDialog", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_PERMISSIONSINHERITONFOLDER, "setDialogPermissionsInheritOnFolder", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_EXPANDPERMISSIONSINHERITED, "setDialogExpandInheritedPermissions", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_EXPANDPERMISSIONSUSER, "setDialogExpandUserPermissions", 0);
        xPathPrefix = "*/workplace/default-preferences/editors-preferences/editors-generaloptions";
        digester.addCallMethod(xPathPrefix + "/" + N_BUTTONSTYLE, "setEditorButtonStyle", 0);
        digester.addCallMethod(xPathPrefix + "/" + N_DIRECTEDITSTYLE, "setDirectEditButtonStyle", 0);
        xPathPrefix = "*/workplace/default-preferences/editors-preferences/editors-preferrededitors";
        digester.addCallMethod(xPathPrefix + "/" + N_EDITOR, "setPreferredEditor", 2);
        digester.addCallParam(xPathPrefix + "/" + N_EDITOR, 0, "type");
        digester.addCallParam(xPathPrefix + "/" + N_EDITOR, 1, "value");
        xPathPrefix = "*/workplace/default-preferences/galleries-preferences/startgalleries";
        digester.addCallMethod(xPathPrefix + "/" + N_STARTGALLERY, "setStartGallery", 2);
        digester.addCallParam(xPathPrefix + "/" + N_STARTGALLERY, 0, "type");
        digester.addCallParam(xPathPrefix + "/" + N_STARTGALLERY, 1, A_PATH);
    }

    protected void addMultiContextMenuRules(Digester digester) {
        String xPath = "*/workplace/explorertypes/multicontextmenu";
        digester.addObjectCreate(xPath, CmsExplorerContextMenu.class);
        digester.addSetNext(xPath, "setMultiContextMenu");
    }

    protected void addToolManagerRules(Digester digester) {
        String rulePath = "*/tool-manager";
        digester.addObjectCreate(rulePath, CmsToolManager.class);
        digester.addSetNext(rulePath, "setToolManager");
        rulePath = rulePath + "/roots/root";
        digester.addObjectCreate(rulePath, CmsToolRootHandler.class);
        digester.addSetNext(rulePath, "addToolRoot");
        digester.addBeanPropertySetter(rulePath + "/" + N_KEY);
        digester.addBeanPropertySetter(rulePath + "/" + N_URI);
        digester.addBeanPropertySetter(rulePath + "/" + "name");
        digester.addBeanPropertySetter(rulePath + "/" + N_HELPTEXT, "helpText");
    }

    protected void addUserInfoRules(Digester digester) {
        String rulePath = "*/user-infos";
        digester.addObjectCreate(rulePath, CmsWorkplaceUserInfoManager.class);
        digester.addSetNext(rulePath, "setUserInfoManager");
        rulePath = rulePath + "/info-block";
        digester.addObjectCreate(rulePath, CmsWorkplaceUserInfoBlock.class);
        digester.addCallMethod(rulePath, "setTitle", 1);
        digester.addCallParam(rulePath, 0, "name");
        digester.addCallMethod(rulePath + "/" + N_USERINFO, "addEntry", 5);
        digester.addCallParam(rulePath + "/" + N_USERINFO, 0, N_KEY);
        digester.addCallParam(rulePath + "/" + N_USERINFO, 1, "type");
        digester.addCallParam(rulePath + "/" + N_USERINFO, 2, A_WIDGET);
        digester.addCallParam(rulePath + "/" + N_USERINFO, 3, A_PARAMS);
        digester.addCallParam(rulePath + "/" + N_USERINFO, 4, A_OPTIONAL);
        digester.addSetNext(rulePath, "addBlock");
    }

    @Override
    protected void initMembers() {
        this.setXmlFileName(DEFAULT_XML_FILE_NAME);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_INIT_0"));
        }
    }
}

