/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import au.com.bytecode.opencsv.CSVParser;
import com.google.common.collect.ArrayListMultimap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsAlias;
import org.opencms.db.CmsAliasFilter;
import org.opencms.db.CmsRewriteAlias;
import org.opencms.db.CmsRewriteAliasFilter;
import org.opencms.db.CmsRewriteAliasMatcher;
import org.opencms.db.CmsSecurityManager;
import org.opencms.db.Messages;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.gwt.shared.alias.CmsAliasImportResult;
import org.opencms.gwt.shared.alias.CmsAliasImportStatus;
import org.opencms.gwt.shared.alias.CmsAliasMode;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsAliasManager {
    private static final Log LOG = CmsLog.getLog(CmsAliasManager.class);
    protected CmsSecurityManager m_securityManager;

    public CmsAliasManager(CmsSecurityManager securityManager) {
        this.m_securityManager = securityManager;
    }

    public List<CmsAlias> getAliasesForPath(CmsObject cms, String siteRoot, String aliasPath) throws CmsException {
        CmsAlias alias = this.m_securityManager.readAliasByPath(cms.getRequestContext(), siteRoot, aliasPath);
        if (alias == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(alias);
    }

    public List<CmsAlias> getAliasesForSite(CmsObject cms, String siteRoot) throws CmsException {
        return this.m_securityManager.getAliasesForSite(cms.getRequestContext(), siteRoot);
    }

    public List<CmsAlias> getAliasesForStructureId(CmsObject cms, CmsUUID structureId) throws CmsException {
        List<CmsAlias> aliases = this.m_securityManager.readAliasesById(cms.getRequestContext(), structureId);
        Collections.sort(aliases, new Comparator<CmsAlias>(){

            @Override
            public int compare(CmsAlias first, CmsAlias second) {
                return first.getAliasPath().compareTo(second.getAliasPath());
            }
        });
        return aliases;
    }

    public List<CmsRewriteAlias> getRewriteAliases(CmsObject cms, String siteRoot) throws CmsException {
        CmsRewriteAliasFilter filter = new CmsRewriteAliasFilter().setSiteRoot(siteRoot);
        List<CmsRewriteAlias> result = this.m_securityManager.getRewriteAliases(cms.getRequestContext(), filter);
        return result;
    }

    public CmsRewriteAliasMatcher getRewriteAliasMatcher(CmsObject cms, String siteRoot) throws CmsException {
        List<CmsRewriteAlias> aliases = this.getRewriteAliases(cms, siteRoot);
        return new CmsRewriteAliasMatcher(aliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermissionsForMassEdit(CmsObject cms, String siteRoot) {
        String originalSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot(siteRoot);
            boolean bl = OpenCms.getRoleManager().hasRoleForResource(cms, CmsRole.ADMINISTRATOR, "/");
            return bl;
        }
        finally {
            cms.getRequestContext().setSiteRoot(originalSiteRoot);
        }
    }

    public synchronized List<CmsAliasImportResult> importAliases(CmsObject cms, byte[] aliasData, String siteRoot, String separator) throws Exception {
        this.checkPermissionsForMassEdit(cms);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(aliasData), "UTF-8"));
        String line = reader.readLine();
        ArrayList<CmsAliasImportResult> totalResult = new ArrayList<CmsAliasImportResult>();
        while (line != null) {
            CmsAliasImportResult result = this.processAliasLine(cms, siteRoot, line, separator);
            if (result != null) {
                totalResult.add(result);
            }
            line = reader.readLine();
        }
        return totalResult;
    }

    public synchronized void saveAliases(CmsObject cms, CmsUUID structureId, List<CmsAlias> aliases) throws CmsException {
        this.m_securityManager.saveAliases(cms.getRequestContext(), cms.readResource(structureId), aliases);
        this.touch(cms, cms.readResource(structureId));
    }

    public void saveRewriteAliases(CmsObject cms, String siteRoot, List<CmsRewriteAlias> newAliases) throws CmsException {
        this.checkPermissionsForMassEdit(cms, siteRoot);
        this.m_securityManager.saveRewriteAliases(cms.getRequestContext(), siteRoot, newAliases);
    }

    public synchronized void updateAliases(CmsObject cms, Collection<CmsAlias> toDelete, Collection<CmsAlias> toAdd) throws CmsException {
        HashSet<CmsAlias> aliasesToSave;
        this.checkPermissionsForMassEdit(cms);
        HashSet<CmsUUID> allKeys = new HashSet<CmsUUID>();
        ArrayListMultimap toDeleteMap = ArrayListMultimap.create();
        for (CmsAlias alias : toDelete) {
            toDeleteMap.put((Object)alias.getStructureId(), (Object)alias);
            allKeys.add(alias.getStructureId());
        }
        ArrayListMultimap toAddMap = ArrayListMultimap.create();
        for (CmsAlias alias : toAdd) {
            toAddMap.put((Object)alias.getStructureId(), (Object)alias);
            allKeys.add(alias.getStructureId());
        }
        for (CmsUUID structureId : allKeys) {
            aliasesToSave = new HashSet<CmsAlias>(this.getAliasesForStructureId(cms, structureId));
            Collection toDeleteForId = toDeleteMap.get((Object)structureId);
            if (toDeleteForId != null && !toDeleteForId.isEmpty()) {
                aliasesToSave.removeAll(toDeleteForId);
            }
            this.saveAliases(cms, structureId, new ArrayList<CmsAlias>(aliasesToSave));
        }
        for (CmsUUID structureId : allKeys) {
            aliasesToSave = new HashSet<CmsAlias>(this.getAliasesForStructureId(cms, structureId));
            Collection toAddForId = toAddMap.get((Object)structureId);
            if (toAddForId != null && !toAddForId.isEmpty()) {
                aliasesToSave.addAll(toAddForId);
            }
            this.saveAliases(cms, structureId, new ArrayList<CmsAlias>(aliasesToSave));
        }
    }

    protected void checkPermissionsForMassEdit(CmsObject cms) throws CmsException {
        OpenCms.getRoleManager().checkRoleForResource(cms, CmsRole.ADMINISTRATOR, "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized CmsAliasImportResult importAlias(CmsObject cms, String siteRoot, String aliasPath, String vfsPath, CmsAliasMode mode) throws CmsException {
        CmsResource resource;
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        String originalSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot(siteRoot);
            resource = cms.readResource(vfsPath);
        }
        catch (CmsException e) {
            CmsAliasImportResult cmsAliasImportResult = new CmsAliasImportResult(CmsAliasImportStatus.aliasImportError, this.messageImportCantReadResource(locale, vfsPath), aliasPath, vfsPath, mode);
            return cmsAliasImportResult;
        }
        finally {
            cms.getRequestContext().setSiteRoot(originalSiteRoot);
        }
        if (!CmsAlias.ALIAS_PATTERN.matcher(aliasPath).matches()) {
            return new CmsAliasImportResult(CmsAliasImportStatus.aliasImportError, this.messageImportInvalidAliasPath(locale, aliasPath), aliasPath, vfsPath, mode);
        }
        List<CmsAlias> maybeAlias = this.getAliasesForPath(cms, siteRoot, aliasPath);
        if (maybeAlias.isEmpty()) {
            CmsAlias newAlias = new CmsAlias(resource.getStructureId(), siteRoot, aliasPath, mode);
            this.m_securityManager.addAlias(cms.getRequestContext(), newAlias);
            this.touch(cms, resource);
            return new CmsAliasImportResult(CmsAliasImportStatus.aliasNew, this.messageImportOk(locale), aliasPath, vfsPath, mode);
        }
        CmsAlias existingAlias = maybeAlias.get(0);
        CmsAliasFilter deleteFilter = new CmsAliasFilter(siteRoot, existingAlias.getAliasPath(), existingAlias.getStructureId());
        this.m_securityManager.deleteAliases(cms.getRequestContext(), deleteFilter);
        CmsAlias newAlias = new CmsAlias(resource.getStructureId(), siteRoot, aliasPath, mode);
        this.m_securityManager.addAlias(cms.getRequestContext(), newAlias);
        this.touch(cms, resource);
        return new CmsAliasImportResult(CmsAliasImportStatus.aliasChanged, this.messageImportUpdate(locale), aliasPath, vfsPath, mode);
    }

    protected CmsAliasImportResult processAliasImport(CmsObject cms, String siteRoot, String aliasPath, String vfsPath, CmsAliasMode mode) {
        try {
            return this.importAlias(cms, siteRoot, aliasPath, vfsPath, mode);
        }
        catch (CmsException e) {
            return new CmsAliasImportResult(CmsAliasImportStatus.aliasImportError, e.getLocalizedMessage(), aliasPath, vfsPath, mode);
        }
    }

    protected CmsAliasImportResult processAliasLine(CmsObject cms, String siteRoot, String line, String separator) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(line = line.trim()) || line.startsWith("#")) {
            return null;
        }
        CSVParser parser = new CSVParser(separator.charAt(0));
        String[] tokens = null;
        try {
            tokens = parser.parseLine(line);
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = tokens[i].trim();
            }
        }
        catch (IOException e) {
            return new CmsAliasImportResult(line, CmsAliasImportStatus.aliasParseError, this.messageImportInvalidFormat(locale));
        }
        int numTokens = tokens.length;
        String alias = null;
        String vfsPath = null;
        if (numTokens >= 2) {
            alias = tokens[0];
            vfsPath = tokens[1];
        }
        CmsAliasMode mode = CmsAliasMode.permanentRedirect;
        if (numTokens >= 3) {
            try {
                mode = CmsAliasMode.valueOf(tokens[2].trim());
            }
            catch (Exception e) {
                return new CmsAliasImportResult(line, CmsAliasImportStatus.aliasParseError, this.messageImportInvalidFormat(locale));
            }
        }
        boolean isRewrite = false;
        if (numTokens == 4) {
            if (!tokens[3].equals("rewrite")) {
                return new CmsAliasImportResult(line, CmsAliasImportStatus.aliasParseError, this.messageImportInvalidFormat(locale));
            }
            isRewrite = true;
        }
        if (numTokens < 2 || numTokens > 4) {
            return new CmsAliasImportResult(line, CmsAliasImportStatus.aliasParseError, this.messageImportInvalidFormat(locale));
        }
        CmsAliasImportResult returnValue = null;
        returnValue = isRewrite ? this.processRewriteImport(cms, siteRoot, alias, vfsPath, mode) : this.processAliasImport(cms, siteRoot, alias, vfsPath, mode);
        returnValue.setLine(line);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPermissionsForMassEdit(CmsObject cms, String siteRoot) throws CmsException {
        String originalSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot(siteRoot);
            this.checkPermissionsForMassEdit(cms);
        }
        finally {
            cms.getRequestContext().setSiteRoot(originalSiteRoot);
        }
    }

    private String messageImportCantReadResource(Locale locale, String path) {
        return Messages.get().getBundle(locale).key("ERR_ALIAS_IMPORT_COULD_NOT_READ_RESOURCE_0");
    }

    private String messageImportInvalidAliasPath(Locale locale, String path) {
        return Messages.get().getBundle(locale).key("ERR_ALIAS_IMPORT_INVALID_ALIAS_PATH_0");
    }

    private String messageImportInvalidFormat(Locale locale) {
        return Messages.get().getBundle(locale).key("ERR_ALIAS_IMPORT_BAD_FORMAT_0");
    }

    private String messageImportOk(Locale locale) {
        return Messages.get().getBundle(locale).key("ERR_ALIAS_IMPORT_OK_0");
    }

    private String messageImportUpdate(Locale locale) {
        return Messages.get().getBundle(locale).key("ERR_ALIAS_IMPORT_UPDATED_0");
    }

    private CmsAliasImportResult processRewriteImport(CmsObject cms, String siteRoot, String source, String target, CmsAliasMode mode) {
        try {
            return this.m_securityManager.importRewriteAlias(cms.getRequestContext(), siteRoot, source, target, mode);
        }
        catch (CmsException e) {
            return new CmsAliasImportResult(CmsAliasImportStatus.aliasImportError, e.getLocalizedMessage(), source, target, mode);
        }
    }

    private void touch(CmsObject cms, CmsResource resource) {
        if (resource.getState().isUnchanged()) {
            try {
                CmsLock lock = cms.getLock(resource);
                if (lock.isUnlocked() || !lock.isOwnedBy(cms.getRequestContext().getCurrentUser())) {
                    cms.lockResourceTemporary(resource);
                    long now = System.currentTimeMillis();
                    resource.setDateLastModified(now);
                    cms.writeResource(resource);
                    if (lock.isUnlocked()) {
                        cms.unlockResource(resource);
                    }
                }
            }
            catch (CmsException e) {
                LOG.warn((Object)("Could not touch resource after alias modification: " + resource.getRootPath()), (Throwable)e);
            }
        }
    }
}

