/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import org.opencms.db.CmsDbContext;
import org.opencms.db.I_CmsCacheKey;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.security.CmsPermissionSet;

public class CmsCacheKey
implements I_CmsCacheKey {
    public static final String CACHE_KEY_SUBALL = "_all_";
    public static final String CACHE_KEY_SUBFILES = "_files_";
    public static final String CACHE_KEY_SUBFOLDERS = "_folders_";

    public String getCacheKeyForGroupUsers(String prefix, CmsDbContext context, CmsGroup group) {
        if (!context.getProjectId().isNullUUID()) {
            return "";
        }
        StringBuffer cacheBuffer = new StringBuffer(64);
        cacheBuffer.append(prefix);
        cacheBuffer.append('_');
        cacheBuffer.append(group.getName());
        return cacheBuffer.toString();
    }

    public String getCacheKeyForUserGroups(String prefix, CmsDbContext context, CmsUser user) {
        if (!context.getProjectId().isNullUUID()) {
            return "";
        }
        StringBuffer cacheBuffer = new StringBuffer(64);
        cacheBuffer.append(prefix);
        cacheBuffer.append('_');
        cacheBuffer.append(user.getName());
        return cacheBuffer.toString();
    }

    public String getCacheKeyForUserPermissions(String prefix, CmsDbContext context, CmsResource resource, CmsPermissionSet requiredPermissions) {
        if (!context.getProjectId().isNullUUID()) {
            return "";
        }
        StringBuffer cacheBuffer = new StringBuffer(64);
        cacheBuffer.append(prefix);
        cacheBuffer.append('_');
        cacheBuffer.append(context.currentUser().getName());
        cacheBuffer.append(context.currentProject().isOnlineProject() ? "_0_" : "_1_");
        cacheBuffer.append(requiredPermissions.getPermissionString());
        cacheBuffer.append('_');
        cacheBuffer.append(resource.getStructureId().toString());
        return cacheBuffer.toString();
    }
}

