/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.opencms.db.CmsDbException;
import org.opencms.db.CmsDbPool;
import org.opencms.db.CmsDriverManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSqlManager {
    private CmsDriverManager m_driverManager;

    protected CmsSqlManager() {
    }

    protected CmsSqlManager(CmsDriverManager driverManager) {
        this.m_driverManager = driverManager;
    }

    public int getActiveConnections(String dbPoolUrl) throws CmsDbException {
        return this.m_driverManager.getActiveConnections(dbPoolUrl);
    }

    public Connection getConnection(String dbPoolName) throws SQLException {
        return this.getConnectionByUrl("jdbc:apache:commons:dbcp:opencms:" + dbPoolName);
    }

    public Connection getConnectionByUrl(String dbPoolUrl) throws SQLException {
        return DriverManager.getConnection(dbPoolUrl);
    }

    public List<String> getDbPoolUrls() {
        return CmsDbPool.getDbPoolUrls(this.m_driverManager.getPropertyConfiguration());
    }

    public String getDefaultDbPoolName() {
        return CmsDbPool.getDefaultDbPoolName();
    }

    public int getIdleConnections(String dbPoolUrl) throws CmsDbException {
        return this.m_driverManager.getIdleConnections(dbPoolUrl);
    }
}

