/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.generic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsAlias;
import org.opencms.db.CmsAliasFilter;
import org.opencms.db.CmsDbConsistencyException;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsDbUtil;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsPreparedStatementIntParameter;
import org.opencms.db.CmsPreparedStatementStringParameter;
import org.opencms.db.CmsResourceState;
import org.opencms.db.CmsRewriteAlias;
import org.opencms.db.CmsRewriteAliasFilter;
import org.opencms.db.CmsVfsOnlineResourceAlreadyExistsException;
import org.opencms.db.I_CmsDriver;
import org.opencms.db.I_CmsPreparedStatementParameter;
import org.opencms.db.I_CmsProjectDriver;
import org.opencms.db.I_CmsVfsDriver;
import org.opencms.db.generic.CmsSqlManager;
import org.opencms.db.generic.Messages;
import org.opencms.db.urlname.CmsUrlNameMappingEntry;
import org.opencms.db.urlname.CmsUrlNameMappingFilter;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsException;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.I_CmsResource;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.gwt.shared.alias.CmsAliasMode;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsVfsDriver
implements I_CmsDriver,
I_CmsVfsDriver {
    protected static final String OFFLINE = "OFFLINE";
    protected static final String ONLINE = "ONLINE";
    private static final Log LOG = CmsLog.getLog(CmsVfsDriver.class);
    protected CmsDriverManager m_driverManager;
    protected List<CmsUUID> m_resOp = new ArrayList<CmsUUID>();
    protected CmsSqlManager m_sqlManager;

    public static CmsPair<String, List<I_CmsPreparedStatementParameter>> prepareUrlNameMappingConditions(CmsUrlNameMappingFilter filter) {
        ArrayList<String> sqlConditions = new ArrayList<String>();
        ArrayList<I_CmsPreparedStatementParameter> parameters = new ArrayList<I_CmsPreparedStatementParameter>();
        if (filter.getName() != null) {
            sqlConditions.add("NAME = ?");
            parameters.add(new CmsPreparedStatementStringParameter(filter.getName()));
        }
        if (filter.getStructureId() != null) {
            sqlConditions.add("STRUCTURE_ID = ?");
            parameters.add(new CmsPreparedStatementStringParameter(filter.getStructureId().toString()));
        }
        if (filter.getNamePattern() != null) {
            sqlConditions.add(" NAME LIKE ? ");
            parameters.add(new CmsPreparedStatementStringParameter(filter.getNamePattern()));
        }
        if (filter.getState() != null) {
            sqlConditions.add("STATE = ?");
            parameters.add(new CmsPreparedStatementIntParameter(filter.getState()));
        }
        if (filter.getRejectStructureId() != null) {
            sqlConditions.add(" STRUCTURE_ID <> ? ");
            parameters.add(new CmsPreparedStatementStringParameter(filter.getRejectStructureId().toString()));
        }
        if (filter.getLocale() != null) {
            sqlConditions.add(" LOCALE = ? ");
            parameters.add(new CmsPreparedStatementStringParameter(filter.getLocale()));
        }
        String conditionString = CmsStringUtil.listAsString(sqlConditions, " AND ");
        return CmsPair.create(conditionString, parameters);
    }

    protected static String escapeDbWildcard(String path) {
        return CmsStringUtil.substitute(path, "_", "|_");
    }

    @Override
    public void addUrlNameMappingEntry(CmsDbContext dbc, boolean online, CmsUrlNameMappingEntry entry) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        String query = this.m_sqlManager.readQuery("C_ADD_URLNAME_MAPPING");
        query = this.replaceProject(query, online);
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, query);
            stmt.setString(1, entry.getName());
            stmt.setString(2, entry.getStructureId().toString());
            stmt.setInt(3, entry.getState());
            stmt.setLong(4, entry.getDateChanged());
            stmt.setString(5, entry.getLocale());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw this.wrapException(stmt, e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public int countSiblings(CmsDbContext dbc, CmsUUID projectId, CmsUUID resourceId) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        int count = 0;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_COUNT_SIBLINGS");
            stmt.setString(1, resourceId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                count = res.getInt(1);
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return count;
    }

    @Override
    public void createContent(CmsDbContext dbc, CmsUUID projectId, CmsUUID resourceId, byte[] content) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_OFFLINE_CONTENTS_WRITE");
            stmt.setString(1, resourceId.toString());
            if (content.length < 2000) {
                stmt.setBytes(2, content);
            } else {
                stmt.setBinaryStream(2, (InputStream)new ByteArrayInputStream(content), content.length);
            }
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public CmsFile createFile(ResultSet res, CmsUUID projectId) throws SQLException {
        int newState;
        CmsUUID structureId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_ID")));
        CmsUUID resourceId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_ID")));
        int resourceType = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_TYPE"));
        String resourcePath = res.getString(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_PATH"));
        int resourceFlags = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_FLAGS"));
        int resourceState = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STATE"));
        int structureState = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_STATE"));
        long dateCreated = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_CREATED"));
        long dateLastModified = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_LASTMODIFIED"));
        long dateReleased = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_RELEASED"));
        long dateExpired = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_EXPIRED"));
        int resourceSize = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_SIZE"));
        CmsUUID userCreated = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_USER_CREATED")));
        CmsUUID userLastModified = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_USER_LASTMODIFIED")));
        byte[] content = this.m_sqlManager.getBytes(res, this.m_sqlManager.readQuery("C_RESOURCES_FILE_CONTENT"));
        int siblingCount = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_SIBLING_COUNT"));
        long dateContent = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_CONTENT"));
        int resourceVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_VERSION"));
        int structureVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_VERSION"));
        int n = newState = structureState > resourceState ? structureState : resourceState;
        if (CmsFolder.isFolderType(resourceType)) {
            resourcePath = CmsFileUtil.addTrailingSeparator(resourcePath);
        }
        return new CmsFile(structureId, resourceId, resourcePath, resourceType, resourceFlags, projectId, CmsResourceState.valueOf(newState), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, siblingCount, resourceSize, dateContent, resourceVersion + structureVersion, content);
    }

    @Override
    public CmsFile createFile(ResultSet res, CmsUUID projectId, boolean hasFileContentInResultSet) throws SQLException {
        byte[] content = null;
        CmsUUID resProjectId = null;
        CmsUUID structureId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_ID")));
        CmsUUID resourceId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_ID")));
        String resourcePath = res.getString(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_PATH"));
        int resourceType = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_TYPE"));
        int resourceFlags = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_FLAGS"));
        int resourceState = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STATE"));
        int structureState = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_STATE"));
        long dateCreated = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_CREATED"));
        long dateLastModified = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_LASTMODIFIED"));
        long dateReleased = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_RELEASED"));
        long dateExpired = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_EXPIRED"));
        int resourceSize = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_SIZE"));
        CmsUUID userCreated = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_USER_CREATED")));
        CmsUUID userLastModified = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_USER_LASTMODIFIED")));
        CmsUUID lockedInProject = new CmsUUID(res.getString("LOCKED_IN_PROJECT"));
        int siblingCount = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_SIBLING_COUNT"));
        long dateContent = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_CONTENT"));
        int resourceVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_VERSION"));
        int structureVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_VERSION"));
        if (CmsFolder.isFolderType(resourceType)) {
            resourcePath = CmsFileUtil.addTrailingSeparator(resourcePath);
        }
        if (hasFileContentInResultSet) {
            content = this.m_sqlManager.getBytes(res, this.m_sqlManager.readQuery("C_RESOURCES_FILE_CONTENT"));
        }
        resProjectId = lockedInProject;
        int newState = structureState > resourceState ? structureState : resourceState;
        return new CmsFile(structureId, resourceId, resourcePath, resourceType, resourceFlags, resProjectId, CmsResourceState.valueOf(newState), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, siblingCount, resourceSize, dateContent, resourceVersion + structureVersion, content);
    }

    @Override
    public CmsFolder createFolder(ResultSet res, CmsUUID projectId, boolean hasProjectIdInResultSet) throws SQLException {
        CmsUUID structureId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_ID")));
        CmsUUID resourceId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_ID")));
        String resourcePath = res.getString(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_PATH"));
        int resourceType = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_TYPE"));
        int resourceFlags = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_FLAGS"));
        int resourceState = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STATE"));
        int structureState = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_STATE"));
        long dateCreated = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_CREATED"));
        long dateLastModified = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_LASTMODIFIED"));
        long dateReleased = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_RELEASED"));
        long dateExpired = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_EXPIRED"));
        CmsUUID userCreated = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_USER_CREATED")));
        CmsUUID userLastModified = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_USER_LASTMODIFIED")));
        CmsUUID resProjectId = new CmsUUID(res.getString("LOCKED_IN_PROJECT"));
        int resourceVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_VERSION"));
        int structureVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_VERSION"));
        int resourceSize = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_SIZE"));
        if (CmsFolder.isFolderSize(resourceSize)) {
            resourcePath = CmsFileUtil.addTrailingSeparator(resourcePath);
        }
        int newState = structureState > resourceState ? structureState : resourceState;
        return new CmsFolder(structureId, resourceId, resourcePath, resourceType, resourceFlags, resProjectId, CmsResourceState.valueOf(newState), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, resourceVersion + structureVersion);
    }

    @Override
    public void createOnlineContent(CmsDbContext dbc, CmsUUID resourceId, byte[] contents, int publishTag, boolean keepOnline, boolean needToUpdateContent) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            boolean dbcHasProjectId;
            conn = this.m_sqlManager.getConnection(dbc);
            boolean bl = dbcHasProjectId = dbc.getProjectId() != null && !dbc.getProjectId().isNullUUID();
            if (needToUpdateContent || dbcHasProjectId) {
                if (dbcHasProjectId || !OpenCms.getSystemInfo().isHistoryEnabled()) {
                    stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ONLINE_CONTENTS_DELETE");
                    stmt.setString(1, resourceId.toString());
                    stmt.executeUpdate();
                    this.m_sqlManager.closeAll(dbc, null, stmt, null);
                } else {
                    stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ONLINE_CONTENTS_HISTORY");
                    stmt.setString(1, resourceId.toString());
                    stmt.executeUpdate();
                    this.m_sqlManager.closeAll(dbc, null, stmt, null);
                }
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ONLINE_CONTENTS_WRITE");
                stmt.setString(1, resourceId.toString());
                if (contents.length < 2000) {
                    stmt.setBytes(2, contents);
                } else {
                    stmt.setBinaryStream(2, (InputStream)new ByteArrayInputStream(contents), contents.length);
                }
                stmt.setInt(3, publishTag);
                stmt.setInt(4, publishTag);
                stmt.setInt(5, keepOnline ? 1 : 0);
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            } else {
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_HISTORY_CONTENTS_UPDATE");
                stmt.setInt(1, publishTag);
                stmt.setString(2, resourceId.toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
                if (!keepOnline) {
                    stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ONLINE_CONTENTS_HISTORY");
                    stmt.setString(1, resourceId.toString());
                    stmt.executeUpdate();
                    this.m_sqlManager.closeAll(dbc, null, stmt, null);
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public CmsPropertyDefinition createPropertyDefinition(CmsDbContext dbc, CmsUUID projectId, String name, CmsPropertyDefinition.CmsPropertyType type) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_PROPERTYDEF_CREATE");
            stmt.setString(1, new CmsUUID().toString());
            stmt.setString(2, name);
            stmt.setInt(3, type.getMode());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
        return this.readPropertyDefinition(dbc, name, projectId);
    }

    @Override
    public void createRelation(CmsDbContext dbc, CmsUUID projectId, CmsRelation relation) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_CREATE_RELATION");
            stmt.setString(1, relation.getSourceId().toString());
            stmt.setString(2, relation.getSourcePath());
            stmt.setString(3, relation.getTargetId().toString());
            stmt.setString(4, relation.getTargetPath());
            stmt.setInt(5, relation.getType().getId());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_RELATION_2", String.valueOf(projectId), relation));
            }
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CmsResource createResource(CmsDbContext dbc, CmsUUID projectId, CmsResource resource, byte[] content) throws CmsDataAccessException {
        long dateModified;
        long dateCreated;
        CmsResourceState newState;
        CmsUUID newStructureId = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        String resourcePath = CmsFileUtil.removeTrailingSeparator(resource.getRootPath());
        if (resourcePath.length() > 512) {
            throw new CmsDataAccessException(Messages.get().container("ERR_RESOURCENAME_TOO_LONG_2", resourcePath, new Integer(512)));
        }
        if (!resource.getRootPath().equals("/")) {
            String parentFolderName = CmsResource.getParentFolder(resource.getRootPath());
            CmsFolder parentFolder = this.m_driverManager.getVfsDriver(dbc).readFolder(dbc, projectId, parentFolderName);
            if (parentFolder.getState().isDeleted()) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_PARENT_FOLDER_DELETED_1", resource.getRootPath()));
            }
        }
        this.internalValidateResourceLength(resource);
        long dateContent = System.currentTimeMillis();
        if (projectId.equals(CmsProject.ONLINE_PROJECT_ID)) {
            newState = CmsResource.STATE_UNCHANGED;
            dateCreated = resource.getDateCreated();
            dateModified = resource.getDateLastModified();
        } else {
            newState = CmsResource.STATE_NEW;
            if (resource.isTouched()) {
                dateCreated = resource.getDateCreated();
                dateModified = resource.getDateLastModified();
            } else {
                dateModified = dateCreated = System.currentTimeMillis();
            }
        }
        newStructureId = resource.getStructureId();
        try {
            CmsResource existingResource = this.m_driverManager.getVfsDriver(dbc).readResource(dbc, dbc.getProjectId() == null || dbc.getProjectId().isNullUUID() ? projectId : dbc.getProjectId(), resourcePath, true);
            if (!existingResource.getState().isDeleted()) {
                throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_RESOURCE_WITH_NAME_ALREADY_EXISTS_1", dbc.removeSiteRoot(resource.getRootPath())));
            }
            newStructureId = existingResource.getStructureId();
            newState = CmsResource.STATE_CHANGED;
            List<CmsResource> modifiedResources = this.m_driverManager.getVfsDriver(dbc).readSiblings(dbc, projectId, existingResource, false);
            int propertyDeleteOption = existingResource.getSiblingCount() > 1 ? 2 : 1;
            this.deletePropertyObjects(dbc, projectId, existingResource, propertyDeleteOption);
            this.removeFile(dbc, projectId, existingResource);
            OpenCms.fireCmsEvent(new CmsEvent(12, Collections.singletonMap("resources", modifiedResources)));
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", existingResource)));
        }
        catch (CmsVfsResourceNotFoundException e) {
            // empty catch block
        }
        try {
            String parentId = this.internalReadParentId(dbc, projectId, resourcePath);
            int lastVersion = this.m_driverManager.getHistoryDriver(dbc).readLastVersion(dbc, newStructureId);
            int newStrVersion = 0;
            int newResVersion = 0;
            if (lastVersion > 0) {
                I_CmsHistoryResource histRes = this.m_driverManager.getHistoryDriver(dbc).readResource(dbc, newStructureId, lastVersion);
                newStrVersion = histRes.getStructureVersion();
                newResVersion = histRes.getResourceVersion();
            }
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_STRUCTURE_WRITE");
            stmt.setString(1, newStructureId.toString());
            stmt.setString(2, resource.getResourceId().toString());
            stmt.setString(3, resourcePath);
            stmt.setInt(4, newState.getState());
            stmt.setLong(5, resource.getDateReleased());
            stmt.setLong(6, resource.getDateExpired());
            stmt.setString(7, parentId);
            stmt.setInt(8, newStrVersion);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
            if (!this.validateResourceIdExists(dbc, projectId, resource.getResourceId())) {
                try {
                    conn = this.m_sqlManager.getConnection(dbc);
                    stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_WRITE");
                    stmt.setString(1, resource.getResourceId().toString());
                    stmt.setInt(2, resource.getTypeId());
                    stmt.setInt(3, resource.getFlags());
                    stmt.setLong(4, dateCreated);
                    stmt.setString(5, resource.getUserCreated().toString());
                    stmt.setLong(6, dateModified);
                    stmt.setString(7, resource.getUserLastModified().toString());
                    stmt.setInt(8, newState.getState());
                    stmt.setInt(9, resource.getLength());
                    stmt.setLong(10, dateContent);
                    stmt.setString(11, projectId.toString());
                    stmt.setInt(12, 1);
                    stmt.setInt(13, newResVersion);
                    stmt.executeUpdate();
                }
                finally {
                    this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                }
                if (resource.isFile() && content != null) {
                    this.createContent(dbc, projectId, resource.getResourceId(), content);
                }
            } else {
                if (content != null || !resource.getState().isKeep()) {
                    CmsUUID projLastMod = projectId;
                    CmsResourceState state = CmsResource.STATE_CHANGED;
                    if (projectId.equals(CmsProject.ONLINE_PROJECT_ID)) {
                        projLastMod = resource.getProjectLastModified();
                        state = CmsResource.STATE_UNCHANGED;
                    }
                    int sibCount = this.countSiblings(dbc, projectId, resource.getResourceId());
                    conn = this.m_sqlManager.getConnection(dbc);
                    stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_UPDATE_RESOURCES");
                    stmt.setInt(1, resource.getTypeId());
                    stmt.setInt(2, resource.getFlags());
                    stmt.setLong(3, dateModified);
                    stmt.setString(4, resource.getUserLastModified().toString());
                    stmt.setInt(5, state.getState());
                    stmt.setInt(6, resource.getLength());
                    stmt.setLong(7, resource.getDateContent());
                    stmt.setString(8, projLastMod.toString());
                    stmt.setInt(9, sibCount);
                    stmt.setString(10, resource.getResourceId().toString());
                    stmt.executeUpdate();
                    this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                }
                if (resource.isFile()) {
                    if (content != null) {
                        this.writeContent(dbc, resource.getResourceId(), content);
                    } else if (resource.getState().isKeep()) {
                        int sibCount = this.countSiblings(dbc, projectId, resource.getResourceId());
                        conn = this.m_sqlManager.getConnection(dbc);
                        stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_UPDATE_SIBLING_COUNT");
                        stmt.setInt(1, sibCount);
                        stmt.setString(2, resource.getResourceId().toString());
                        stmt.executeUpdate();
                        this.m_sqlManager.closeAll(dbc, null, stmt, null);
                        stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_UPDATE_FLAGS");
                        stmt.setInt(1, resource.getFlags());
                        stmt.setString(2, resource.getResourceId().toString());
                        stmt.executeUpdate();
                        this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                    }
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
        this.repairBrokenRelations(dbc, projectId, resource.getStructureId(), resource.getRootPath());
        return this.readResource(dbc, projectId, newStructureId, false);
    }

    @Override
    public CmsResource createResource(ResultSet res, CmsUUID projectId) throws SQLException {
        CmsUUID structureId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_ID")));
        CmsUUID resourceId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_ID")));
        String resourcePath = res.getString(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_PATH"));
        int resourceType = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_TYPE"));
        int resourceFlags = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_RESOURCE_FLAGS"));
        CmsUUID resourceProjectLastModified = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_PROJECT_LASTMODIFIED")));
        int resourceState = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STATE"));
        int structureState = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_STATE"));
        long dateCreated = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_CREATED"));
        long dateLastModified = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_LASTMODIFIED"));
        long dateReleased = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_RELEASED"));
        long dateExpired = res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_EXPIRED"));
        int resourceSize = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_SIZE"));
        boolean isFolder = CmsFolder.isFolderSize(resourceSize);
        if (isFolder) {
            resourcePath = CmsFileUtil.addTrailingSeparator(resourcePath);
        }
        long dateContent = isFolder ? -1L : res.getLong(this.m_sqlManager.readQuery("C_RESOURCES_DATE_CONTENT"));
        CmsUUID userCreated = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_USER_CREATED")));
        CmsUUID userLastModified = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RESOURCES_USER_LASTMODIFIED")));
        int siblingCount = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_SIBLING_COUNT"));
        int resourceVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_VERSION"));
        int structureVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_VERSION"));
        int newState = structureState > resourceState ? structureState : resourceState;
        int newVersion = resourceVersion + structureVersion + (newState > 0 ? 1 : 0);
        CmsResource newResource = new CmsResource(structureId, resourceId, resourcePath, resourceType, isFolder, resourceFlags, resourceProjectLastModified, CmsResourceState.valueOf(newState), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, siblingCount, resourceSize, dateContent, newVersion);
        return newResource;
    }

    @Override
    public void createSibling(CmsDbContext dbc, CmsProject project, CmsResource resource) throws CmsDataAccessException {
        if (!project.getUuid().equals(CmsProject.ONLINE_PROJECT_ID)) {
            return;
        }
        CmsResource existingSibling = null;
        CmsUUID newStructureId = resource.getStructureId();
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            existingSibling = this.readResource(dbc, project.getUuid(), resource.getRootPath(), true);
            if (!existingSibling.getState().isDeleted()) {
                throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_RESOURCE_WITH_NAME_ALREADY_EXISTS_1", dbc.removeSiteRoot(resource.getRootPath())));
            }
            newStructureId = existingSibling.getStructureId();
            List<CmsResource> modifiedResources = this.readSiblings(dbc, project.getUuid(), existingSibling, false);
            int propertyDeleteOption = existingSibling.getSiblingCount() > 1 ? 2 : 1;
            this.deletePropertyObjects(dbc, project.getUuid(), existingSibling, propertyDeleteOption);
            this.removeFile(dbc, project.getUuid(), existingSibling);
            OpenCms.fireCmsEvent(new CmsEvent(12, Collections.singletonMap("resources", modifiedResources)));
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", existingSibling)));
        }
        catch (CmsVfsResourceNotFoundException e) {
            // empty catch block
        }
        if (!this.validateResourceIdExists(dbc, project.getUuid(), resource.getResourceId())) {
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_CREATE_SIBLING_FILE_NOT_FOUND_1", dbc.removeSiteRoot(resource.getRootPath())));
        }
        try {
            int lastVersion = this.m_driverManager.getHistoryDriver(dbc).readLastVersion(dbc, newStructureId);
            int newStrVersion = 0;
            if (lastVersion > 0) {
                I_CmsHistoryResource histRes = this.m_driverManager.getHistoryDriver(dbc).readResource(dbc, newStructureId, lastVersion);
                newStrVersion = histRes.getStructureVersion();
            }
            String parentId = this.internalReadParentId(dbc, project.getUuid(), resource.getRootPath());
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, project, "C_STRUCTURE_WRITE");
            stmt.setString(1, newStructureId.toString());
            stmt.setString(2, resource.getResourceId().toString());
            stmt.setString(3, resource.getRootPath());
            stmt.setInt(4, CmsResource.STATE_UNCHANGED.getState());
            stmt.setLong(5, resource.getDateReleased());
            stmt.setLong(6, resource.getDateExpired());
            stmt.setString(7, parentId);
            stmt.setInt(8, newStrVersion);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
            int sibCount = this.countSiblings(dbc, project.getUuid(), resource.getResourceId());
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, project, "C_RESOURCES_UPDATE_SIBLING_COUNT");
            stmt.setInt(1, sibCount);
            stmt.setString(2, resource.getResourceId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, null, stmt, null);
            stmt = this.m_sqlManager.getPreparedStatement(conn, project, "C_RESOURCES_UPDATE_RESOURCE_PROJECT");
            stmt.setInt(1, resource.getFlags());
            stmt.setString(2, resource.getProjectLastModified().toString());
            stmt.setString(3, resource.getResourceId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
        this.repairBrokenRelations(dbc, project.getUuid(), resource.getStructureId(), resource.getRootPath());
    }

    @Override
    public void deleteAliases(CmsDbContext dbc, CmsProject project, CmsAliasFilter filter) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        if (filter.isNullFilter()) {
            throw new IllegalArgumentException("Trivial filter is not allowed for deleting aliases.");
        }
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            CmsPair<String, List<String>> filterData = this.buildAliasConditions(filter);
            String sql = "DELETE FROM CMS_ALIASES WHERE " + filterData.getFirst();
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, sql);
            List<String> conditionParams = filterData.getSecond();
            for (int i = 0; i < conditionParams.size(); ++i) {
                stmt.setString(1 + i, conditionParams.get(i));
            }
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
    }

    @Override
    public void deletePropertyDefinition(CmsDbContext dbc, CmsPropertyDefinition metadef) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            if (this.internalCountProperties(dbc, metadef, CmsProject.ONLINE_PROJECT_ID) != 0 || this.internalCountProperties(dbc, metadef, CmsUUID.getOpenCmsUUID()) != 0) {
                throw new CmsDataAccessException(Messages.get().container("ERR_DELETE_USED_PROPERTY_1", metadef.getName()));
            }
            conn = this.m_sqlManager.getConnection(dbc);
            for (int i = 0; i < 2; ++i) {
                stmt = i == 0 ? this.m_sqlManager.getPreparedStatement(conn, CmsUUID.getOpenCmsUUID(), "C_PROPERTYDEF_DELETE") : this.m_sqlManager.getPreparedStatement(conn, CmsProject.ONLINE_PROJECT_ID, "C_PROPERTYDEF_DELETE");
                stmt.setString(1, metadef.getId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void deletePropertyObjects(CmsDbContext dbc, CmsUUID projectId, CmsResource resource, int deleteOption) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            if (deleteOption == 1) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_PROPERTIES_DELETE_ALL_STRUCTURE_AND_RESOURCE_VALUES");
                stmt.setString(1, resource.getResourceId().toString());
                stmt.setInt(2, 2);
                stmt.setString(3, resource.getStructureId().toString());
                stmt.setInt(4, 1);
            } else if (deleteOption == 2) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_PROPERTIES_DELETE_ALL_VALUES_FOR_MAPPING_TYPE");
                stmt.setString(1, resource.getStructureId().toString());
                stmt.setInt(2, 1);
            } else if (deleteOption == 3) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_PROPERTIES_DELETE_ALL_VALUES_FOR_MAPPING_TYPE");
                stmt.setString(1, resource.getResourceId().toString());
                stmt.setInt(2, 2);
            } else {
                throw new CmsDataAccessException(Messages.get().container("ERR_INVALID_DELETE_OPTION_1"));
            }
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void deleteRelations(CmsDbContext dbc, CmsUUID projectId, CmsResource resource, CmsRelationFilter filter) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            int i;
            StringBuffer queryBuf;
            ArrayList<Object> params;
            conn = this.m_sqlManager.getConnection(dbc);
            if (filter.isSource()) {
                params = new ArrayList<Object>(7);
                queryBuf = new StringBuffer(256);
                queryBuf.append(this.m_sqlManager.readQuery(projectId, "C_DELETE_RELATIONS"));
                queryBuf.append(this.prepareRelationConditions(projectId, filter, resource, params, true));
                stmt = this.m_sqlManager.getPreparedStatementForSql(conn, queryBuf.toString());
                for (i = 0; i < params.size(); ++i) {
                    if (params.get(i) instanceof Integer) {
                        stmt.setInt(i + 1, (Integer)params.get(i));
                        continue;
                    }
                    stmt.setString(i + 1, (String)params.get(i));
                }
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            }
            if (filter.isTarget()) {
                params = new ArrayList(7);
                queryBuf = new StringBuffer(256);
                queryBuf.append(this.m_sqlManager.readQuery(projectId, "C_DELETE_RELATIONS"));
                queryBuf.append(this.prepareRelationConditions(projectId, filter, resource, params, false));
                stmt = this.m_sqlManager.getPreparedStatementForSql(conn, queryBuf.toString());
                for (i = 0; i < params.size(); ++i) {
                    if (params.get(i) instanceof Integer) {
                        stmt.setInt(i + 1, (Integer)params.get(i));
                        continue;
                    }
                    stmt.setString(i + 1, (String)params.get(i));
                }
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            }
        }
        catch (SQLException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
        }
        finally {
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        this.updateBrokenRelations(dbc, projectId, resource.getRootPath());
    }

    @Override
    public void deleteRewriteAliases(CmsDbContext dbc, CmsRewriteAliasFilter filter) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            CmsPair<String, List<Object>> conditionAndParams = this.prepareRewriteAliasConditions(filter);
            String condition = conditionAndParams.getFirst();
            List<Object> params = conditionAndParams.getSecond();
            String query = "DELETE FROM CMS_REWRITES WHERE " + condition;
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, query);
            CmsDbUtil.fillParameters(stmt, params);
            stmt.execute();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw this.wrapException(stmt, e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void deleteUrlNameMappingEntries(CmsDbContext dbc, boolean online, CmsUrlNameMappingFilter filter) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            String query = this.m_sqlManager.readQuery("C_DELETE_URLNAME_MAPPINGS");
            query = this.replaceProject(query, online);
            stmt = this.getPreparedStatementForFilter(conn, query, filter);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw this.wrapException(stmt, e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void destroy() throws Throwable {
        this.m_sqlManager = null;
        this.m_driverManager = null;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_DRIVER_1", this.getClass().getName()));
        }
    }

    @Override
    public List<CmsOrganizationalUnit> getResourceOus(CmsDbContext dbc, CmsUUID projectId, CmsResource resource) throws CmsDbSqlException {
        ArrayList<CmsOrganizationalUnit> ous = new ArrayList<CmsOrganizationalUnit>();
        String resName = resource.getRootPath();
        if (resource.isFolder() && !resName.endsWith("/")) {
            resName = resName + "/";
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        ArrayList<CmsRelation> rels = new ArrayList<CmsRelation>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, this.m_sqlManager.readQuery(projectId, "C_READ_RESOURCE_OUS"));
            stmt.setInt(1, CmsRelationType.OU_RESOURCE.getId());
            stmt.setString(2, resName);
            res = stmt.executeQuery();
            while (res.next()) {
                rels.add(this.internalReadRelation(res));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        for (CmsRelation rel : rels) {
            try {
                ous.add(this.m_driverManager.readOrganizationalUnit(dbc, rel.getSourcePath().substring("/system/orgunits/".length())));
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return ous;
    }

    @Override
    public CmsSqlManager getSqlManager() {
        return this.m_sqlManager;
    }

    @Override
    public int incrementCounter(CmsDbContext dbc, String name) throws CmsDataAccessException {
        int result;
        Integer counterObj = this.internalReadCounter(dbc, name);
        if (counterObj == null) {
            this.internalCreateCounter(dbc, name, 1);
            result = 0;
        } else {
            result = counterObj;
            this.internalIncrementCounter(dbc, name);
        }
        return result;
    }

    @Override
    public void init(CmsDbContext dbc, CmsConfigurationManager configurationManager, List<String> successiveDrivers, CmsDriverManager driverManager) {
        CmsParameterConfiguration configuration = configurationManager.getConfiguration();
        String poolUrl = configuration.get("db.vfs.pool");
        String classname = configuration.get("db.vfs.sqlmanager");
        this.m_sqlManager = this.initSqlManager(classname);
        this.m_sqlManager.init(3, poolUrl);
        this.m_driverManager = driverManager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ASSIGNED_POOL_1", poolUrl));
        }
        if (successiveDrivers != null && !successiveDrivers.isEmpty() && LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_SUCCESSIVE_DRIVERS_UNSUPPORTED_1", this.getClass().getName()));
        }
    }

    @Override
    public CmsSqlManager initSqlManager(String classname) {
        return CmsSqlManager.getInstance(classname);
    }

    @Override
    public void insertAlias(CmsDbContext dbc, CmsProject project, CmsAlias alias) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, project, "C_ALIAS_ADD_4");
            stmt.setString(1, alias.getSiteRoot());
            stmt.setString(2, alias.getAliasPath());
            stmt.setInt(3, alias.getMode().toInt());
            stmt.setString(4, alias.getStructureId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
    }

    @Override
    public void insertRewriteAliases(CmsDbContext dbc, Collection<CmsRewriteAlias> rewriteAliases) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, dbc.currentProject(), "C_REWRITE_ALIAS_INSERT_5");
            for (CmsRewriteAlias alias : rewriteAliases) {
                stmt.setString(1, alias.getId().toString());
                stmt.setString(2, alias.getSiteRoot());
                stmt.setString(3, alias.getPatternString());
                stmt.setString(4, alias.getReplacementString());
                stmt.setInt(5, alias.getMode().toInt());
                stmt.addBatch();
            }
            stmt.executeBatch();
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
    }

    @Override
    public void moveResource(CmsDbContext dbc, CmsUUID projectId, CmsResource source, String destinationPath) throws CmsDataAccessException {
        CmsFolder destinationFolder;
        block14: {
            if (dbc.getRequestContext() != null && dbc.getRequestContext().getAttribute("CHECK_PERMISSIONS") != null) {
                this.checkWritePermissionsInFolder(dbc, source);
                return;
            }
            String destinationFoldername = CmsResource.getParentFolder(destinationPath);
            destinationFolder = this.m_driverManager.readFolder(dbc, destinationFoldername, CmsResourceFilter.ALL);
            if (!projectId.equals(CmsProject.ONLINE_PROJECT_ID)) {
                try {
                    CmsResource offlineResource;
                    block15: {
                        CmsResource onlineResource = this.m_driverManager.getVfsDriver(dbc).readResource(dbc, CmsProject.ONLINE_PROJECT_ID, destinationPath, true);
                        if (onlineResource.getStructureId().equals(source.getStructureId())) break block14;
                        offlineResource = null;
                        try {
                            offlineResource = this.readResource(dbc, dbc.getRequestContext().getCurrentProject().getUuid(), onlineResource.getStructureId(), true);
                        }
                        catch (CmsException e) {
                            if (!LOG.isErrorEnabled()) break block15;
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    throw new CmsVfsOnlineResourceAlreadyExistsException(Messages.get().container("ERR_OVERWRITE_MOVED_RESOURCE_3", dbc.removeSiteRoot(source.getRootPath()), dbc.removeSiteRoot(destinationPath), dbc.removeSiteRoot(offlineResource == null ? "__ERROR__" : offlineResource.getRootPath())));
                }
                catch (CmsVfsResourceNotFoundException e) {
                    // empty catch block
                }
            }
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_MOVE");
            stmt.setString(1, CmsFileUtil.removeTrailingSeparator(destinationPath));
            stmt.setString(2, destinationFolder.getStructureId().toString());
            stmt.setString(3, source.getStructureId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        this.moveRelations(dbc, projectId, source.getStructureId(), destinationPath);
        this.repairBrokenRelations(dbc, projectId, source.getStructureId(), destinationPath);
        try {
            this.m_driverManager.repairCategories(dbc, projectId, this.readResource(dbc, projectId, destinationPath, true));
        }
        catch (CmsException e) {
            throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
        }
        if (!projectId.equals(CmsProject.ONLINE_PROJECT_ID) && dbc.getRequestContext() != null) {
            String deletedResourceRootPath = source.getRootPath();
            dbc.getRequestContext().setAttribute("DBC_ATTR_READ_PROJECT_FOR_RESOURCE", Boolean.TRUE);
            I_CmsProjectDriver projectDriver = this.m_driverManager.getProjectDriver(dbc);
            for (CmsProject project : projectDriver.readProjects(dbc, deletedResourceRootPath)) {
                projectDriver.deleteProjectResource(dbc, project.getUuid(), deletedResourceRootPath);
                projectDriver.createProjectResource(dbc, project.getUuid(), destinationPath);
            }
        }
    }

    @Override
    public void publishResource(CmsDbContext dbc, CmsProject onlineProject, CmsResource onlineResource, CmsResource offlineResource) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        this.internalValidateResourceLength(offlineResource);
        int resourceSize = offlineResource.getLength();
        String resourcePath = CmsFileUtil.removeTrailingSeparator(offlineResource.getRootPath());
        try {
            int sibCount = this.countSiblings(dbc, onlineProject.getUuid(), onlineResource.getResourceId());
            boolean resourceExists = this.validateResourceIdExists(dbc, onlineProject.getUuid(), offlineResource.getResourceId());
            conn = this.m_sqlManager.getConnection(dbc);
            if (resourceExists) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, onlineProject, "C_RESOURCES_UPDATE_RESOURCES");
                stmt.setInt(1, offlineResource.getTypeId());
                stmt.setInt(2, offlineResource.getFlags());
                stmt.setLong(3, offlineResource.getDateLastModified());
                stmt.setString(4, offlineResource.getUserLastModified().toString());
                stmt.setInt(5, CmsResource.STATE_UNCHANGED.getState());
                stmt.setInt(6, resourceSize);
                stmt.setLong(7, offlineResource.getDateContent());
                stmt.setString(8, offlineResource.getProjectLastModified().toString());
                stmt.setInt(9, sibCount);
                stmt.setString(10, offlineResource.getResourceId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
            } else {
                stmt = this.m_sqlManager.getPreparedStatement(conn, onlineProject, "C_RESOURCES_WRITE");
                stmt.setString(1, offlineResource.getResourceId().toString());
                stmt.setInt(2, offlineResource.getTypeId());
                stmt.setInt(3, offlineResource.getFlags());
                stmt.setLong(4, offlineResource.getDateCreated());
                stmt.setString(5, offlineResource.getUserCreated().toString());
                stmt.setLong(6, offlineResource.getDateLastModified());
                stmt.setString(7, offlineResource.getUserLastModified().toString());
                stmt.setInt(8, CmsResource.STATE_UNCHANGED.getState());
                stmt.setInt(9, resourceSize);
                stmt.setLong(10, offlineResource.getDateContent());
                stmt.setString(11, offlineResource.getProjectLastModified().toString());
                stmt.setInt(12, 1);
                stmt.setInt(13, 1);
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
            }
            String parentId = this.internalReadParentId(dbc, onlineProject.getUuid(), resourcePath);
            boolean structureExists = this.validateStructureIdExists(dbc, onlineProject.getUuid(), offlineResource.getStructureId());
            conn = this.m_sqlManager.getConnection(dbc);
            if (structureExists) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, onlineProject, "C_RESOURCES_UPDATE_STRUCTURE");
                stmt.setString(1, offlineResource.getResourceId().toString());
                stmt.setString(2, resourcePath);
                stmt.setInt(3, CmsResource.STATE_UNCHANGED.getState());
                stmt.setLong(4, offlineResource.getDateReleased());
                stmt.setLong(5, offlineResource.getDateExpired());
                stmt.setString(6, parentId);
                stmt.setString(7, offlineResource.getStructureId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            } else {
                stmt = this.m_sqlManager.getPreparedStatement(conn, onlineProject, "C_STRUCTURE_WRITE");
                stmt.setString(1, offlineResource.getStructureId().toString());
                stmt.setString(2, offlineResource.getResourceId().toString());
                stmt.setString(3, resourcePath);
                stmt.setInt(4, CmsResource.STATE_UNCHANGED.getState());
                stmt.setLong(5, offlineResource.getDateReleased());
                stmt.setLong(6, offlineResource.getDateExpired());
                stmt.setString(7, parentId);
                stmt.setInt(8, resourceExists ? 1 : 0);
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void publishVersions(CmsDbContext dbc, CmsResource resource, boolean firstSibling) throws CmsDataAccessException {
        if (resource == null) {
            this.m_resOp.clear();
            return;
        }
        if (!dbc.getProjectId().isNullUUID() || dbc.currentProject().isOnlineProject()) {
            return;
        }
        if (firstSibling) {
            this.m_resOp.remove(resource.getResourceId());
        }
        boolean resOp = false;
        CmsResourceState resState = this.internalReadResourceState(dbc, dbc.currentProject().getUuid(), resource);
        CmsResourceState strState = this.internalReadStructureState(dbc, dbc.currentProject().getUuid(), resource);
        if (!resState.isUnchanged()) {
            resOp = strState.isDeleted() ? resState.isDeleted() || resource.getSiblingCount() == 1 || this.countSiblings(dbc, dbc.currentProject().getUuid(), resource.getResourceId()) == 1 : true;
        }
        if (!firstSibling) {
            if (resOp) {
                return;
            }
            if (this.m_resOp.contains(resource.getResourceId())) {
                return;
            }
        }
        Map<String, Integer> versions = this.readVersions(dbc, dbc.currentProject().getUuid(), resource.getResourceId(), resource.getStructureId());
        int strVersion = versions.get("structure");
        int resVersion = versions.get("resource");
        if (resOp) {
            if (resource.getSiblingCount() > 1) {
                this.m_resOp.add(resource.getResourceId());
            }
            ++resVersion;
        }
        if (!resOp) {
            ++strVersion;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            if (resOp) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, CmsProject.ONLINE_PROJECT_ID, "C_RESOURCES_UPDATE_RESOURCE_VERSION");
                stmt.setInt(1, resVersion);
                stmt.setString(2, resource.getResourceId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            }
            if (!resOp || strState.isNew()) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, CmsProject.ONLINE_PROJECT_ID, "C_RESOURCES_UPDATE_STRUCTURE_VERSION");
                stmt.setInt(1, strVersion);
                stmt.setString(2, resource.getStructureId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
    }

    @Override
    public List<CmsAlias> readAliases(CmsDbContext dbc, CmsProject project, CmsAliasFilter filter) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            CmsPair<String, List<String>> conditionPair = this.buildAliasConditions(filter);
            String conditionString = conditionPair.getFirst();
            List<String> conditionParams = conditionPair.getSecond();
            String sql = "SELECT site_root, path, alias_mode, structure_id FROM CMS_ALIASES WHERE " + conditionString;
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, sql);
            for (int i = 0; i < conditionParams.size(); ++i) {
                stmt.setString(1 + i, conditionParams.get(i));
            }
            res = stmt.executeQuery();
            ArrayList<CmsAlias> result = new ArrayList<CmsAlias>();
            while (res.next()) {
                CmsAlias alias = this.internalReadAlias(res);
                result.add(alias);
            }
            ArrayList<CmsAlias> arrayList = result;
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
    }

    @Override
    public List<CmsResource> readChildResources(CmsDbContext dbc, CmsProject currentProject, CmsResource resource, boolean getFolders, boolean getFiles) throws CmsDataAccessException {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        CmsUUID projectId = currentProject.getUuid();
        String resourceTypeClause = getFolders && getFiles ? null : (getFolders ? this.m_sqlManager.readQuery(projectId, "C_RESOURCES_GET_SUBRESOURCES_GET_FOLDERS") : this.m_sqlManager.readQuery(projectId, "C_RESOURCES_GET_SUBRESOURCES_GET_FILES"));
        StringBuffer query = new StringBuffer();
        query.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_GET_SUBRESOURCES"));
        if (resourceTypeClause != null) {
            query.append(' ');
            query.append(resourceTypeClause);
        }
        String sizeColumn = this.m_sqlManager.readQuery("C_RESOURCES_SIZE");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, query.toString());
            stmt.setString(1, resource.getStructureId().toString());
            res = stmt.executeQuery();
            while (res.next()) {
                long size = res.getInt(sizeColumn);
                if (CmsFolder.isFolderSize(size)) {
                    result.add(this.createFolder(res, projectId, false));
                    continue;
                }
                result.add(this.createFile(res, projectId, false));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        Collections.sort(result, I_CmsResource.COMPARE_ROOT_PATH_IGNORE_CASE_FOLDERS_FIRST);
        return result;
    }

    @Override
    public byte[] readContent(CmsDbContext dbc, CmsUUID projectId, CmsUUID resourceId) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        ResultSet res = null;
        Connection conn = null;
        byte[] byteRes = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = projectId.equals(CmsProject.ONLINE_PROJECT_ID) ? this.m_sqlManager.getPreparedStatement(conn, projectId, "C_ONLINE_FILES_CONTENT") : this.m_sqlManager.getPreparedStatement(conn, projectId, "C_OFFLINE_FILES_CONTENT");
            stmt.setString(1, resourceId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                byteRes = this.m_sqlManager.getBytes(res, this.m_sqlManager.readQuery("C_RESOURCES_FILE_CONTENT"));
                while (res.next()) {
                }
            } else {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_CONTENT_WITH_RESOURCE_ID_2", resourceId, projectId.equals(CmsProject.ONLINE_PROJECT_ID)));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return byteRes;
    }

    @Override
    public CmsFolder readFolder(CmsDbContext dbc, CmsUUID projectId, CmsUUID folderId) throws CmsDataAccessException {
        CmsFolder folder = null;
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_READBYID");
            stmt.setString(1, folderId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                folder = this.createFolder(res, projectId, true);
                while (res.next()) {
                }
            } else {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_FOLDER_WITH_ID_1", folderId));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return folder;
    }

    @Override
    public CmsFolder readFolder(CmsDbContext dbc, CmsUUID projectId, String folderPath) throws CmsDataAccessException {
        CmsFolder folder = null;
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        folderPath = CmsFileUtil.removeTrailingSeparator(folderPath);
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_READ");
            stmt.setString(1, folderPath);
            res = stmt.executeQuery();
            if (res.next()) {
                folder = this.createFolder(res, projectId, true);
                while (res.next()) {
                }
            } else {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_FOLDER_1", dbc.removeSiteRoot(folderPath)));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return folder;
    }

    @Override
    public CmsFolder readParentFolder(CmsDbContext dbc, CmsUUID projectId, CmsUUID structureId) throws CmsDataAccessException {
        CmsFolder parent = null;
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_READ_PARENT_BY_ID");
            stmt.setString(1, structureId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                parent = new CmsFolder(this.createResource(res, projectId));
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return parent;
    }

    @Override
    public CmsPropertyDefinition readPropertyDefinition(CmsDbContext dbc, String name, CmsUUID projectId) throws CmsDataAccessException {
        CmsPropertyDefinition propDef = null;
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_PROPERTYDEF_READ");
            stmt.setString(1, name);
            res = stmt.executeQuery();
            if (res.next()) {
                propDef = new CmsPropertyDefinition(new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_PROPERTYDEF_ID"))), res.getString(this.m_sqlManager.readQuery("C_PROPERTYDEF_NAME")), CmsPropertyDefinition.CmsPropertyType.valueOf(res.getInt(this.m_sqlManager.readQuery("C_PROPERTYDEF_TYPE"))));
                while (res.next()) {
                }
            } else {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_PROPERTYDEF_WITH_NAME_1", name));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return propDef;
    }

    @Override
    public List<CmsPropertyDefinition> readPropertyDefinitions(CmsDbContext dbc, CmsUUID projectId) throws CmsDataAccessException {
        ArrayList<CmsPropertyDefinition> propertyDefinitions = new ArrayList<CmsPropertyDefinition>();
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_PROPERTYDEF_READALL");
            res = stmt.executeQuery();
            while (res.next()) {
                propertyDefinitions.add(new CmsPropertyDefinition(new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_PROPERTYDEF_ID"))), res.getString(this.m_sqlManager.readQuery("C_PROPERTYDEF_NAME")), CmsPropertyDefinition.CmsPropertyType.valueOf(res.getInt(this.m_sqlManager.readQuery("C_PROPERTYDEF_TYPE")))));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return propertyDefinitions;
    }

    @Override
    public CmsProperty readPropertyObject(CmsDbContext dbc, String key, CmsProject project, CmsResource resource) throws CmsDataAccessException {
        CmsUUID projectId = dbc.getProjectId() == null || dbc.getProjectId().isNullUUID() ? project.getUuid() : dbc.getProjectId();
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        String propertyValue = null;
        int mappingType = -1;
        CmsProperty property = null;
        int resultSize = 0;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_PROPERTIES_READ");
            stmt.setString(1, key);
            stmt.setString(2, resource.getStructureId().toString());
            stmt.setString(3, resource.getResourceId().toString());
            res = stmt.executeQuery();
            while (res.next()) {
                if (resultSize >= 2) {
                    throw new CmsDbConsistencyException(Messages.get().container("ERR_TOO_MANY_PROPERTIES_3", key, resource.getRootPath(), new Integer(resultSize)));
                }
                if (property == null) {
                    property = new CmsProperty();
                    property.setName(key);
                }
                propertyValue = res.getString(1);
                mappingType = res.getInt(2);
                if (mappingType == 1) {
                    property.setStructureValue(propertyValue);
                } else if (mappingType == 2) {
                    property.setResourceValue(propertyValue);
                } else {
                    throw new CmsDbConsistencyException(Messages.get().container("ERR_UNKNOWN_PROPERTY_VALUE_MAPPING_3", resource.getRootPath(), new Integer(mappingType), key));
                }
                ++resultSize;
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return property != null ? property : CmsProperty.getNullProperty();
    }

    @Override
    public List<CmsProperty> readPropertyObjects(CmsDbContext dbc, CmsProject project, CmsResource resource) throws CmsDataAccessException {
        CmsUUID projectId = dbc.getProjectId() == null || dbc.getProjectId().isNullUUID() ? project.getUuid() : dbc.getProjectId();
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        int mappingType = -1;
        HashMap<String, CmsProperty> propertyMap = new HashMap<String, CmsProperty>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_PROPERTIES_READALL");
            stmt.setString(1, resource.getStructureId().toString());
            stmt.setString(2, resource.getResourceId().toString());
            res = stmt.executeQuery();
            while (res.next()) {
                String propertyKey = null;
                String propertyValue = null;
                mappingType = -1;
                propertyKey = res.getString(1);
                propertyValue = res.getString(2);
                mappingType = res.getInt(3);
                CmsProperty property = (CmsProperty)propertyMap.get(propertyKey);
                if (property == null) {
                    property = new CmsProperty();
                    property.setName(propertyKey);
                    propertyMap.put(propertyKey, property);
                }
                if (mappingType == 1) {
                    property.setStructureValue(propertyValue);
                } else if (mappingType == 2) {
                    property.setResourceValue(propertyValue);
                } else {
                    throw new CmsDbConsistencyException(Messages.get().container("ERR_UNKNOWN_PROPERTY_VALUE_MAPPING_3", resource.getRootPath(), new Integer(mappingType), propertyKey));
                }
                property.setOrigin(resource.getRootPath());
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return new ArrayList<CmsProperty>(propertyMap.values());
    }

    @Override
    public List<CmsRelation> readRelations(CmsDbContext dbc, CmsUUID projectId, CmsResource resource, CmsRelationFilter filter) throws CmsDataAccessException {
        HashSet<CmsRelation> relations = new HashSet<CmsRelation>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            int i;
            StringBuffer queryBuf;
            ArrayList<Object> params;
            conn = this.m_sqlManager.getConnection(dbc);
            if (filter.isSource()) {
                params = new ArrayList<Object>(7);
                queryBuf = new StringBuffer(256);
                queryBuf.append(this.m_sqlManager.readQuery(projectId, "C_READ_RELATIONS"));
                queryBuf.append(this.prepareRelationConditions(projectId, filter, resource, params, true));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)queryBuf.toString());
                }
                stmt = this.m_sqlManager.getPreparedStatementForSql(conn, queryBuf.toString());
                for (i = 0; i < params.size(); ++i) {
                    if (params.get(i) instanceof Integer) {
                        stmt.setInt(i + 1, (Integer)params.get(i));
                        continue;
                    }
                    stmt.setString(i + 1, (String)params.get(i));
                }
                res = stmt.executeQuery();
                while (res.next()) {
                    relations.add(this.internalReadRelation(res));
                }
                this.m_sqlManager.closeAll(dbc, null, stmt, res);
            }
            if (filter.isTarget()) {
                params = new ArrayList(7);
                queryBuf = new StringBuffer(256);
                queryBuf.append(this.m_sqlManager.readQuery(projectId, "C_READ_RELATIONS"));
                queryBuf.append(this.prepareRelationConditions(projectId, filter, resource, params, false));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)queryBuf.toString());
                }
                stmt = this.m_sqlManager.getPreparedStatementForSql(conn, queryBuf.toString());
                for (i = 0; i < params.size(); ++i) {
                    if (params.get(i) instanceof Integer) {
                        stmt.setInt(i + 1, (Integer)params.get(i));
                        continue;
                    }
                    stmt.setString(i + 1, (String)params.get(i));
                }
                res = stmt.executeQuery();
                while (res.next()) {
                    relations.add(this.internalReadRelation(res));
                }
                this.m_sqlManager.closeAll(dbc, null, stmt, res);
            }
        }
        catch (SQLException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
        }
        finally {
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        ArrayList<CmsRelation> result = new ArrayList<CmsRelation>(relations);
        Collections.sort(result, CmsRelation.COMPARATOR);
        return result;
    }

    @Override
    public CmsResource readResource(CmsDbContext dbc, CmsUUID projectId, CmsUUID structureId, boolean includeDeleted) throws CmsDataAccessException {
        CmsResource resource = null;
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_READBYID");
            stmt.setString(1, structureId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                resource = this.createResource(res, projectId);
                while (res.next()) {
                }
            } else {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_RESOURCE_WITH_ID_1", structureId));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        if (resource != null && resource.getState().isDeleted() && !includeDeleted) {
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_DELETED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())));
        }
        return resource;
    }

    @Override
    public CmsResource readResource(CmsDbContext dbc, CmsUUID projectId, String path, boolean includeDeleted) throws CmsDataAccessException {
        CmsResource resource = null;
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        int len = path.length();
        boolean endsWithSlash = len != (path = CmsFileUtil.removeTrailingSeparator(path)).length();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_READ");
            stmt.setString(1, path);
            res = stmt.executeQuery();
            if (res.next()) {
                resource = this.createResource(res, projectId);
                if (endsWithSlash && resource.isFile()) {
                    throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_RESOURCE_1", dbc.removeSiteRoot(path + "/")));
                }
                while (res.next()) {
                }
            } else {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_RESOURCE_1", dbc.removeSiteRoot(path)));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        if (resource != null && resource.getState().isDeleted() && !includeDeleted) {
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_DELETED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())));
        }
        return resource;
    }

    @Override
    public List<CmsResource> readResources(CmsDbContext dbc, CmsUUID projectId, CmsResourceState state, int mode) throws CmsDataAccessException {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            if (mode == 1) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_GET_RESOURCE_IN_PROJECT_WITH_STATE");
                stmt.setString(1, projectId.toString());
                stmt.setInt(2, state.getState());
                stmt.setInt(3, state.getState());
                stmt.setInt(4, state.getState());
                stmt.setInt(5, state.getState());
            } else if (mode == 2) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_GET_RESOURCE_IN_PROJECT_WITHOUT_STATE");
                stmt.setString(1, projectId.toString());
                stmt.setInt(2, state.getState());
                stmt.setInt(3, state.getState());
            } else {
                stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_GET_RESOURCE_IN_PROJECT_IGNORE_STATE");
                stmt.setString(1, projectId.toString());
            }
            res = stmt.executeQuery();
            while (res.next()) {
                CmsResource resource = this.createResource(res, projectId);
                result.add(resource);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public List<CmsResource> readResourcesForPrincipalACE(CmsDbContext dbc, CmsProject project, CmsUUID principalId) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet res = null;
        CmsFile currentResource = null;
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, project, "C_SELECT_RESOURCES_FOR_PRINCIPAL_ACE");
            stmt.setString(1, principalId.toString());
            res = stmt.executeQuery();
            while (res.next()) {
                currentResource = this.createFile(res, project.getUuid(), false);
                resources.add(currentResource);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return resources;
    }

    @Override
    public List<CmsResource> readResourcesForPrincipalAttr(CmsDbContext dbc, CmsProject project, CmsUUID principalId) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet res = null;
        CmsFile currentResource = null;
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, project, "C_SELECT_RESOURCES_FOR_PRINCIPAL_ATTR");
            stmt.setString(1, principalId.toString());
            stmt.setString(2, principalId.toString());
            res = stmt.executeQuery();
            while (res.next()) {
                currentResource = this.createFile(res, project.getUuid(), false);
                resources.add(currentResource);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return resources;
    }

    @Override
    public List<CmsResource> readResourcesWithProperty(CmsDbContext dbc, CmsUUID projectId, CmsUUID propertyDef, String path, String value) throws CmsDataAccessException {
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            if (value == null) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_GET_RESOURCE_WITH_PROPERTYDEF");
                stmt.setString(1, propertyDef.toString());
                stmt.setString(2, path + "%");
                stmt.setString(3, propertyDef.toString());
                stmt.setString(4, path + "%");
            } else {
                stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_GET_RESOURCE_WITH_PROPERTYDEF_VALUE");
                stmt.setString(1, propertyDef.toString());
                stmt.setString(2, path + "%");
                stmt.setString(3, "%" + value + "%");
                stmt.setString(4, propertyDef.toString());
                stmt.setString(5, path + "%");
                stmt.setString(6, "%" + value + "%");
            }
            res = stmt.executeQuery();
            while (res.next()) {
                CmsResource resource = this.createResource(res, projectId);
                resources.add(resource);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return resources;
    }

    @Override
    public List<CmsResource> readResourceTree(CmsDbContext dbc, CmsUUID projectId, String parentPath, int type, CmsResourceState state, long lastModifiedAfter, long lastModifiedBefore, long releasedAfter, long releasedBefore, long expiredAfter, long expiredBefore, int mode) throws CmsDataAccessException {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        StringBuffer conditions = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>(5);
        this.prepareProjectCondition(projectId, mode, conditions, params);
        this.prepareResourceCondition(projectId, mode, conditions);
        this.prepareTypeCondition(projectId, type, mode, conditions, params);
        this.prepareTimeRangeCondition(projectId, lastModifiedAfter, lastModifiedBefore, conditions, params);
        this.prepareReleasedTimeRangeCondition(projectId, releasedAfter, releasedBefore, conditions, params);
        this.prepareExpiredTimeRangeCondition(projectId, expiredAfter, expiredBefore, conditions, params);
        this.preparePathCondition(projectId, parentPath, mode, conditions, params);
        this.prepareStateCondition(projectId, state, mode, conditions, params);
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            StringBuffer queryBuf = new StringBuffer(256);
            queryBuf.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_READ_TREE"));
            queryBuf.append(conditions);
            queryBuf.append(" ");
            queryBuf.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_ORDER_BY_PATH"));
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, queryBuf.toString());
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i) instanceof Integer) {
                    stmt.setInt(i + 1, (Integer)params.get(i));
                    continue;
                }
                if (params.get(i) instanceof Long) {
                    stmt.setLong(i + 1, (Long)params.get(i));
                    continue;
                }
                stmt.setString(i + 1, (String)params.get(i));
            }
            res = stmt.executeQuery();
            while (res.next()) {
                CmsResource resource = this.createResource(res, projectId);
                result.add(resource);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public List<CmsRewriteAlias> readRewriteAliases(CmsDbContext dbc, CmsRewriteAliasFilter filter) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        ArrayList<CmsRewriteAlias> result = new ArrayList<CmsRewriteAlias>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            CmsPair<String, List<Object>> conditionAndParams = this.prepareRewriteAliasConditions(filter);
            String condition = conditionAndParams.getFirst();
            List<Object> params = conditionAndParams.getSecond();
            String query = this.m_sqlManager.readQuery("C_REWRITE_ALIAS_READ") + condition;
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, query);
            CmsDbUtil.fillParameters(stmt, params);
            res = stmt.executeQuery();
            while (res.next()) {
                int col = 1;
                String id = res.getString(col++);
                String siteRoot = res.getString(col++);
                String patternString = res.getString(col++);
                String replacementString = res.getString(col++);
                int mode = res.getInt(col++);
                CmsRewriteAlias alias = new CmsRewriteAlias(new CmsUUID(id), siteRoot, patternString, replacementString, CmsAliasMode.fromInt(mode));
                result.add(alias);
            }
            ArrayList<CmsRewriteAlias> arrayList = result;
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw this.wrapException(stmt, e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
    }

    @Override
    public List<CmsResource> readSiblings(CmsDbContext dbc, CmsUUID projectId, CmsResource resource, boolean includeDeleted) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet res = null;
        CmsFile currentResource = null;
        ArrayList<CmsResource> vfsLinks = new ArrayList<CmsResource>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = includeDeleted ? this.m_sqlManager.getPreparedStatement(conn, projectId, "C_SELECT_VFS_SIBLINGS") : this.m_sqlManager.getPreparedStatement(conn, projectId, "C_SELECT_NONDELETED_VFS_SIBLINGS");
            stmt.setString(1, resource.getResourceId().toString());
            res = stmt.executeQuery();
            while (res.next()) {
                currentResource = this.createFile(res, projectId, false);
                vfsLinks.add(currentResource);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return vfsLinks;
    }

    @Override
    public List<CmsUrlNameMappingEntry> readUrlNameMappingEntries(CmsDbContext dbc, boolean online, CmsUrlNameMappingFilter filter) throws CmsDataAccessException {
        Connection conn = null;
        ResultSet resultSet = null;
        PreparedStatement stmt = null;
        ArrayList<CmsUrlNameMappingEntry> result = new ArrayList<CmsUrlNameMappingEntry>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            String query = this.m_sqlManager.readQuery("C_READ_URLNAME_MAPPINGS");
            query = this.replaceProject(query, online);
            stmt = this.getPreparedStatementForFilter(conn, query, filter);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                CmsUrlNameMappingEntry entry = this.internalCreateUrlNameMappingEntry(resultSet);
                result.add(entry);
            }
            ArrayList<CmsUrlNameMappingEntry> arrayList = result;
            this.m_sqlManager.closeAll(dbc, conn, stmt, resultSet);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw this.wrapException(stmt, e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, resultSet);
                throw throwable;
            }
        }
    }

    @Override
    public Map<String, Integer> readVersions(CmsDbContext dbc, CmsUUID projectId, CmsUUID resourceId, CmsUUID structureId) throws CmsDataAccessException {
        int structureVersion = -1;
        int resourceVersion = -1;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_READ_VERSION_RES");
            stmt.setString(1, resourceId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                resourceVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_VERSION"));
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, null, stmt, res);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_READ_VERSION_STR");
            stmt.setString(1, structureId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                structureVersion = res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_VERSION"));
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("structure", new Integer(structureVersion));
        result.put("resource", new Integer(resourceVersion));
        return result;
    }

    @Override
    public void removeFile(CmsDbContext dbc, CmsUUID projectId, CmsResource resource) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        int siblingCount = 0;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_STRUCTURE_DELETE_BY_STRUCTUREID");
            stmt.setString(1, resource.getStructureId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
            siblingCount = this.countSiblings(dbc, projectId, resource.getResourceId());
            conn = this.m_sqlManager.getConnection(dbc);
            if (siblingCount > 0) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_UPDATE_SIBLING_COUNT");
                stmt.setInt(1, siblingCount);
                stmt.setString(2, resource.getResourceId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
                stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_UPDATE_FLAGS");
                stmt.setInt(1, resource.getFlags());
                stmt.setString(2, resource.getResourceId().toString());
                stmt.executeUpdate();
            } else {
                boolean dbcHasProjectId;
                stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_DELETE_BY_RESOURCEID");
                stmt.setString(1, resource.getResourceId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
                boolean bl = dbcHasProjectId = dbc.getProjectId() != null && !dbc.getProjectId().isNullUUID();
                if (projectId.equals(CmsProject.ONLINE_PROJECT_ID)) {
                    stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ONLINE_CONTENTS_HISTORY");
                    stmt.setString(1, resource.getResourceId().toString());
                    stmt.executeUpdate();
                } else if (dbcHasProjectId) {
                    stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ONLINE_CONTENTS_DELETE");
                    stmt.setString(1, resource.getResourceId().toString());
                    stmt.executeUpdate();
                } else {
                    stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_OFFLINE_FILE_CONTENT_DELETE");
                    stmt.setString(1, resource.getResourceId().toString());
                    stmt.executeUpdate();
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void removeFolder(CmsDbContext dbc, CmsProject currentProject, CmsResource resource) throws CmsDataAccessException {
        if (dbc.getRequestContext() != null && dbc.getRequestContext().getAttribute("CHECK_PERMISSIONS") != null) {
            this.checkWritePermissionsInFolder(dbc, resource);
            return;
        }
        Iterator<CmsResource> childResources = this.readChildResources(dbc, currentProject, resource, true, true).iterator();
        CmsUUID projectId = CmsProject.ONLINE_PROJECT_ID;
        if (currentProject.isOnlineProject()) {
            projectId = CmsUUID.getOpenCmsUUID();
        }
        I_CmsVfsDriver vfsDriver = this.m_driverManager.getVfsDriver(dbc);
        StringBuffer errorResNames = new StringBuffer(128);
        while (childResources.hasNext()) {
            boolean error;
            CmsResource errorRes = childResources.next();
            boolean bl = error = !currentProject.isOnlineProject();
            if (!error) {
                try {
                    String originalPath = vfsDriver.readResource(dbc, projectId, errorRes.getRootPath(), true).getRootPath();
                    error = originalPath.equals(errorRes.getRootPath()) || originalPath.startsWith(resource.getRootPath());
                }
                catch (CmsVfsResourceNotFoundException e) {
                    // empty catch block
                }
            }
            if (!error) continue;
            if (errorResNames.length() != 0) {
                errorResNames.append(", ");
            }
            errorResNames.append("[" + dbc.removeSiteRoot(errorRes.getRootPath()) + "]");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(errorResNames.toString())) {
            throw new CmsVfsException(Messages.get().container("ERR_DELETE_NONEMTY_FOLDER_2", dbc.removeSiteRoot(resource.getRootPath()), errorResNames.toString()));
        }
        this.internalRemoveFolder(dbc, currentProject, resource);
        String deletedResourceRootPath = resource.getRootPath();
        if (dbc.getRequestContext() != null) {
            dbc.getRequestContext().setAttribute("DBC_ATTR_READ_PROJECT_FOR_RESOURCE", Boolean.TRUE);
            I_CmsProjectDriver projectDriver = this.m_driverManager.getProjectDriver(dbc);
            for (CmsProject project : projectDriver.readProjects(dbc, deletedResourceRootPath)) {
                projectDriver.deleteProjectResource(dbc, project.getUuid(), deletedResourceRootPath);
            }
        }
    }

    @Override
    public void replaceResource(CmsDbContext dbc, CmsResource newResource, byte[] resContent, int newResourceType) throws CmsDataAccessException {
        if (resContent == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            this.writeContent(dbc, newResource.getResourceId(), resContent);
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, dbc.currentProject(), "C_RESOURCE_REPLACE");
            stmt.setInt(1, newResourceType);
            stmt.setInt(2, resContent.length);
            stmt.setLong(3, System.currentTimeMillis());
            stmt.setString(4, newResource.getResourceId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void setDriverManager(CmsDriverManager driverManager) {
        this.m_driverManager = driverManager;
    }

    @Override
    public void setSqlManager(org.opencms.db.CmsSqlManager sqlManager) {
        this.m_sqlManager = (CmsSqlManager)sqlManager;
    }

    @Override
    public void transferResource(CmsDbContext dbc, CmsProject project, CmsResource resource, CmsUUID createdUser, CmsUUID lastModifiedUser) throws CmsDataAccessException {
        if (createdUser == null) {
            createdUser = resource.getUserCreated();
        }
        if (lastModifiedUser == null) {
            lastModifiedUser = resource.getUserLastModified();
        }
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, project, "C_RESOURCES_TRANSFER_RESOURCE");
            stmt.setString(1, createdUser.toString());
            stmt.setString(2, lastModifiedUser.toString());
            stmt.setString(3, resource.getResourceId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void updateRelations(CmsDbContext dbc, CmsProject onlineProject, CmsResource offlineResource) throws CmsDataAccessException {
        I_CmsVfsDriver vfsDriver = this.m_driverManager.getVfsDriver(dbc);
        vfsDriver.deleteRelations(dbc, onlineProject.getUuid(), offlineResource, CmsRelationFilter.TARGETS);
        CmsUUID projectId = !dbc.getProjectId().isNullUUID() ? CmsProject.ONLINE_PROJECT_ID : dbc.currentProject().getUuid();
        CmsUUID dbcProjectId = dbc.getProjectId();
        dbc.setProjectId(CmsUUID.getNullUUID());
        Iterator<CmsRelation> itRelations = this.m_driverManager.getVfsDriver(dbc).readRelations(dbc, projectId, offlineResource, CmsRelationFilter.TARGETS).iterator();
        dbc.setProjectId(dbcProjectId);
        while (itRelations.hasNext()) {
            vfsDriver.createRelation(dbc, onlineProject.getUuid(), itRelations.next());
        }
    }

    @Override
    public boolean validateResourceIdExists(CmsDbContext dbc, CmsUUID projectId, CmsUUID resourceId) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        boolean exists = false;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_READ_RESOURCE_STATE");
            stmt.setString(1, resourceId.toString());
            res = stmt.executeQuery();
            exists = res.next();
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return exists;
    }

    @Override
    public boolean validateStructureIdExists(CmsDbContext dbc, CmsUUID projectId, CmsUUID structureId) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        boolean found = false;
        int count = 0;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_SELECT_STRUCTURE_ID");
            stmt.setString(1, structureId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                count = res.getInt(1);
                boolean bl = found = count == 1;
                while (res.next()) {
                }
            } else {
                found = false;
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return found;
    }

    @Override
    public void writeContent(CmsDbContext dbc, CmsUUID resourceId, byte[] content) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, dbc.currentProject(), "C_OFFLINE_CONTENTS_UPDATE");
            if (content.length < 2000) {
                stmt.setBytes(1, content);
            } else {
                stmt.setBinaryStream(1, (InputStream)new ByteArrayInputStream(content), content.length);
            }
            stmt.setString(2, resourceId.toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void writeLastModifiedProjectId(CmsDbContext dbc, CmsProject project, CmsUUID projectId, CmsResource resource) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, project, "C_RESOURCES_UPDATE_PROJECT_LASTMODIFIED");
            stmt.setString(1, projectId.toString());
            stmt.setString(2, resource.getResourceId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePropertyObject(CmsDbContext dbc, CmsProject project, CmsResource resource, CmsProperty property) throws CmsDataAccessException {
        CmsProperty existingProperty;
        Connection conn;
        PreparedStatement stmt;
        CmsPropertyDefinition propertyDefinition;
        CmsUUID projectId;
        block26: {
            projectId = dbc.getProjectId() == null || dbc.getProjectId().isNullUUID() ? project.getUuid() : dbc.getProjectId();
            propertyDefinition = null;
            try {
                propertyDefinition = this.readPropertyDefinition(dbc, property.getName(), projectId);
            }
            catch (CmsDbEntryNotFoundException e) {
                if (property.autoCreatePropertyDefinition()) {
                    propertyDefinition = this.createPropertyDefinition(dbc, projectId, property.getName(), CmsPropertyDefinition.TYPE_NORMAL);
                    try {
                        this.readPropertyDefinition(dbc, property.getName(), CmsProject.ONLINE_PROJECT_ID);
                    }
                    catch (CmsDataAccessException e1) {
                        this.createPropertyDefinition(dbc, CmsProject.ONLINE_PROJECT_ID, property.getName(), CmsPropertyDefinition.TYPE_NORMAL);
                    }
                    try {
                        this.m_driverManager.getHistoryDriver(dbc).readPropertyDefinition(dbc, property.getName());
                    }
                    catch (CmsDataAccessException e1) {
                        this.m_driverManager.getHistoryDriver(dbc).createPropertyDefinition(dbc, property.getName(), CmsPropertyDefinition.TYPE_NORMAL);
                    }
                    OpenCms.fireCmsEvent(new CmsEvent(28, Collections.singletonMap("propertyDefinition", propertyDefinition)));
                }
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_PROPERTYDEF_WITH_NAME_1", property.getName()));
            }
            stmt = null;
            conn = null;
            existingProperty = this.readPropertyObject(dbc, propertyDefinition.getName(), project, resource);
            if (!existingProperty.isIdentical(property)) break block26;
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
            return;
        }
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            for (int i = 0; i < 2; ++i) {
                int mappingType = -1;
                String value = null;
                CmsUUID id = null;
                boolean existsPropertyValue = false;
                boolean deletePropertyValue = false;
                if (i == 0) {
                    if (existingProperty.getStructureValue() != null && property.isDeleteStructureValue()) {
                        deletePropertyValue = true;
                    } else {
                        value = property.getStructureValue();
                        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) continue;
                    }
                    mappingType = 1;
                    id = resource.getStructureId();
                    existsPropertyValue = existingProperty.getStructureValue() != null;
                } else {
                    if (existingProperty.getResourceValue() != null && property.isDeleteResourceValue()) {
                        deletePropertyValue = true;
                    } else {
                        value = property.getResourceValue();
                        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) break;
                    }
                    mappingType = 2;
                    id = resource.getResourceId();
                    existsPropertyValue = existingProperty.getResourceValue() != null;
                }
                try {
                    if (!deletePropertyValue) {
                        if (existsPropertyValue) {
                            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_PROPERTIES_UPDATE");
                            stmt.setString(1, this.m_sqlManager.validateEmpty(value));
                            stmt.setString(2, id.toString());
                            stmt.setInt(3, mappingType);
                            stmt.setString(4, propertyDefinition.getId().toString());
                        } else {
                            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_PROPERTIES_CREATE");
                            stmt.setString(1, new CmsUUID().toString());
                            stmt.setString(2, propertyDefinition.getId().toString());
                            stmt.setString(3, id.toString());
                            stmt.setInt(4, mappingType);
                            stmt.setString(5, this.m_sqlManager.validateEmpty(value));
                        }
                    } else {
                        stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_PROPERTIES_DELETE");
                        stmt.setString(1, propertyDefinition.getId().toString());
                        stmt.setString(2, id.toString());
                        stmt.setInt(3, mappingType);
                    }
                    stmt.executeUpdate();
                    continue;
                }
                finally {
                    this.m_sqlManager.closeAll(dbc, null, stmt, null);
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void writePropertyObjects(CmsDbContext dbc, CmsProject project, CmsResource resource, List<CmsProperty> properties) throws CmsDataAccessException {
        CmsProperty property = null;
        for (int i = 0; i < properties.size(); ++i) {
            property = properties.get(i);
            this.writePropertyObject(dbc, project, resource, property);
        }
    }

    @Override
    public void writeResource(CmsDbContext dbc, CmsUUID projectId, CmsResource resource, int changed) throws CmsDataAccessException {
        this.internalValidateResourceLength(resource);
        String resourcePath = CmsFileUtil.removeTrailingSeparator(resource.getRootPath());
        PreparedStatement stmt = null;
        Connection conn = null;
        long resourceDateModified = resource.isTouched() ? resource.getDateLastModified() : System.currentTimeMillis();
        CmsResourceState structureState = resource.getState();
        CmsResourceState resourceState = resource.getState();
        CmsResourceState structureStateOld = this.internalReadStructureState(dbc, projectId, resource);
        CmsResourceState resourceStateOld = this.internalReadResourceState(dbc, projectId, resource);
        CmsUUID projectLastModified = projectId;
        if (changed == 1) {
            resourceState = resourceStateOld;
            resourceState = resourceState.isNew() ? CmsResource.STATE_NEW : CmsResource.STATE_CHANGED;
            structureState = structureStateOld;
        } else if (changed == 2) {
            structureState = structureStateOld;
            structureState = structureState.isNew() ? CmsResource.STATE_NEW : CmsResource.STATE_CHANGED;
        } else if (changed == 0) {
            projectLastModified = resource.getProjectLastModified();
        } else {
            resourceState = resourceStateOld;
            resourceState = resourceState.isNew() ? CmsResource.STATE_NEW : CmsResource.STATE_CHANGED;
            structureState = structureStateOld;
            structureState = structureState.isNew() ? CmsResource.STATE_NEW : CmsResource.STATE_CHANGED;
        }
        try {
            String parentId = this.internalReadParentId(dbc, projectId, resourcePath);
            int sibCount = this.countSiblings(dbc, projectId, resource.getResourceId());
            conn = this.m_sqlManager.getConnection(dbc);
            if (changed != 2) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_UPDATE_RESOURCES");
                stmt.setInt(1, resource.getTypeId());
                stmt.setInt(2, resource.getFlags());
                stmt.setLong(3, resourceDateModified);
                stmt.setString(4, resource.getUserLastModified().toString());
                stmt.setInt(5, resourceState.getState());
                stmt.setInt(6, resource.getLength());
                stmt.setLong(7, resource.getDateContent());
                stmt.setString(8, projectLastModified.toString());
                stmt.setInt(9, sibCount);
                stmt.setString(10, resource.getResourceId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            } else {
                stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_UPDATE_RESOURCES_WITHOUT_STATE");
                stmt.setInt(1, resource.getTypeId());
                stmt.setInt(2, resource.getFlags());
                stmt.setLong(3, resourceDateModified);
                stmt.setString(4, resource.getUserLastModified().toString());
                stmt.setInt(5, resource.getLength());
                stmt.setLong(6, resource.getDateContent());
                stmt.setString(7, projectLastModified.toString());
                stmt.setInt(8, sibCount);
                stmt.setString(9, resource.getResourceId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            }
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_UPDATE_STRUCTURE");
            stmt.setString(1, resource.getResourceId().toString());
            stmt.setString(2, resourcePath);
            stmt.setInt(3, structureState.getState());
            stmt.setLong(4, resource.getDateReleased());
            stmt.setLong(5, resource.getDateExpired());
            stmt.setString(6, parentId);
            stmt.setString(7, resource.getStructureId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    @Override
    public void writeResourceState(CmsDbContext dbc, CmsProject project, CmsResource resource, int changed, boolean isPublishing) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        if (project.getUuid().equals(CmsProject.ONLINE_PROJECT_ID)) {
            return;
        }
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            if (changed == 6) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, project, "C_RESOURCES_UPDATE_RESOURCE_PROJECT");
                stmt.setInt(1, resource.getFlags());
                stmt.setString(2, project.getUuid().toString());
                stmt.setString(3, resource.getResourceId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            }
            if (changed == 4) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, project, "C_RESOURCES_UPDATE_RESOURCE_STATELASTMODIFIED");
                stmt.setInt(1, resource.getState().getState());
                stmt.setLong(2, resource.getDateLastModified());
                stmt.setString(3, resource.getUserLastModified().toString());
                stmt.setString(4, project.getUuid().toString());
                stmt.setString(5, resource.getResourceId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            }
            if (changed == 1 || changed == 3) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, project, "C_RESOURCES_UPDATE_RESOURCE_STATE");
                stmt.setInt(1, resource.getState().getState());
                stmt.setString(2, project.getUuid().toString());
                stmt.setString(3, resource.getResourceId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            }
            if (changed == 5 || changed == 3 || changed == 2) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, project, "C_RESOURCES_UPDATE_STRUCTURE_STATE");
                stmt.setInt(1, resource.getState().getState());
                stmt.setString(2, resource.getStructureId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            }
            if (changed == 5 || changed == 3) {
                stmt = this.m_sqlManager.getPreparedStatement(conn, project, "C_RESOURCES_UPDATE_RELEASE_EXPIRED");
                stmt.setLong(1, resource.getDateReleased());
                stmt.setLong(2, resource.getDateExpired());
                stmt.setString(3, resource.getStructureId().toString());
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, null, stmt, null);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
        if (isPublishing) {
            this.internalUpdateVersions(dbc, resource);
        }
    }

    protected void checkWritePermissionsInFolder(CmsDbContext dbc, CmsResource folder) throws CmsDataAccessException {
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        CmsUUID projectId = dbc.getRequestContext().getCurrentProject().getUuid();
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_READ_WITH_ACE_1");
            stmt.setString(1, folder.getRootPath() + "%");
            res = stmt.executeQuery();
            while (res.next()) {
                resources.add(this.createResource(res, projectId));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        for (CmsResource resource : resources) {
            try {
                this.m_driverManager.getSecurityManager().checkPermissions(dbc.getRequestContext(), resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
            }
            catch (CmsException e) {
                throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
            }
        }
        CmsResourceFilter filter = CmsResourceFilter.ALL;
        for (CmsResource resource : this.readTypesInResourceTree(dbc, projectId, folder.getRootPath(), CmsResourceTypeJsp.getJspResourceTypeIds(), filter.getState(), filter.getModifiedAfter(), filter.getModifiedBefore(), filter.getReleaseAfter(), filter.getReleaseBefore(), filter.getExpireAfter(), filter.getExpireBefore(), 0)) {
            try {
                this.m_driverManager.getSecurityManager().checkPermissions(dbc.getRequestContext(), resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
            }
            catch (CmsException e) {
                throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
            }
        }
    }

    protected int internalCountProperties(CmsDbContext dbc, CmsPropertyDefinition propertyDefinition, CmsUUID projectId) throws CmsDataAccessException {
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        int count = 0;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_PROPERTIES_READALL_COUNT");
            stmt.setString(1, propertyDefinition.getId().toString());
            res = stmt.executeQuery();
            if (res.next()) {
                count = res.getInt(1);
                while (res.next()) {
                }
            } else {
                throw new CmsDbConsistencyException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", propertyDefinition.getName()));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return count;
    }

    protected void internalCreateCounter(CmsDbContext dbc, String name, int value) throws CmsDbSqlException {
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, CmsProject.ONLINE_PROJECT_ID, "C_CREATE_COUNTER");
            stmt.setString(1, name);
            stmt.setInt(2, value);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw this.wrapException(stmt, e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    protected CmsUrlNameMappingEntry internalCreateUrlNameMappingEntry(ResultSet resultSet) throws SQLException {
        String name = resultSet.getString(1);
        CmsUUID structureId = new CmsUUID(resultSet.getString(2));
        int state = resultSet.getInt(3);
        long dateChanged = resultSet.getLong(4);
        String locale = resultSet.getString(5);
        return new CmsUrlNameMappingEntry(name, structureId, state, dateChanged, locale);
    }

    protected void internalIncrementCounter(CmsDbContext dbc, String name) throws CmsDbSqlException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet resultSet = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, CmsProject.ONLINE_PROJECT_ID, "C_INCREMENT_COUNTER");
            stmt.setString(1, name);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, resultSet);
        }
        catch (SQLException e) {
            try {
                throw this.wrapException(stmt, e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, resultSet);
                throw throwable;
            }
        }
    }

    protected CmsAlias internalReadAlias(ResultSet resultset) throws SQLException {
        String siteRoot = resultset.getString(1);
        String path = resultset.getString(2);
        int mode = resultset.getInt(3);
        String structId = resultset.getString(4);
        return new CmsAlias(new CmsUUID(structId), siteRoot, path, CmsAliasMode.fromInt(mode));
    }

    protected Integer internalReadCounter(CmsDbContext dbc, String name) throws CmsDbSqlException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet resultSet = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, CmsProject.ONLINE_PROJECT_ID, "C_READ_COUNTER");
            stmt.setString(1, name);
            resultSet = stmt.executeQuery();
            Integer result = null;
            if (resultSet.next()) {
                int counter = resultSet.getInt(1);
                result = new Integer(counter);
                while (resultSet.next()) {
                }
            }
            Integer n = result;
            this.m_sqlManager.closeAll(dbc, conn, stmt, resultSet);
            return n;
        }
        catch (SQLException e) {
            try {
                throw this.wrapException(stmt, e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, resultSet);
                throw throwable;
            }
        }
    }

    protected String internalReadParentId(CmsDbContext dbc, CmsUUID projectId, String resourcename) throws CmsDataAccessException {
        if ("/".equalsIgnoreCase(resourcename)) {
            return CmsUUID.getNullUUID().toString();
        }
        String parent = CmsResource.getParentFolder(resourcename);
        parent = CmsFileUtil.removeTrailingSeparator(parent);
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        String parentId = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RESOURCES_READ_PARENT_STRUCTURE_ID");
            stmt.setString(1, parent);
            res = stmt.executeQuery();
            if (res.next()) {
                parentId = res.getString(1);
                while (res.next()) {
                }
            } else {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_PARENT_ID_1", dbc.removeSiteRoot(resourcename)));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return parentId;
    }

    protected CmsRelation internalReadRelation(ResultSet res) throws SQLException {
        CmsUUID sourceId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RELATION_SOURCE_ID")));
        String sourcePath = res.getString(this.m_sqlManager.readQuery("C_RELATION_SOURCE_PATH"));
        CmsUUID targetId = new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_RELATION_TARGET_ID")));
        String targetPath = res.getString(this.m_sqlManager.readQuery("C_RELATION_TARGET_PATH"));
        int type = res.getInt(this.m_sqlManager.readQuery("C_RELATION_TYPE"));
        return new CmsRelation(sourceId, sourcePath, targetId, targetPath, CmsRelationType.valueOf(type));
    }

    protected CmsResourceState internalReadResourceState(CmsDbContext dbc, CmsUUID projectId, CmsResource resource) throws CmsDbSqlException {
        CmsResourceState state = CmsResource.STATE_KEEP;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_READ_RESOURCE_STATE");
            stmt.setString(1, resource.getResourceId().toString());
            res = stmt.executeQuery();
            if (res.next()) {
                state = CmsResourceState.valueOf(res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STATE")));
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return state;
    }

    protected CmsResourceState internalReadStructureState(CmsDbContext dbc, CmsUUID projectId, CmsResource resource) throws CmsDbSqlException {
        CmsResourceState state = CmsResource.STATE_KEEP;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_READ_STRUCTURE_STATE");
            stmt.setString(1, resource.getStructureId().toString());
            res = stmt.executeQuery();
            if (res.next()) {
                state = CmsResourceState.valueOf(res.getInt(this.m_sqlManager.readQuery("C_RESOURCES_STRUCTURE_STATE")));
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return state;
    }

    protected void internalRemoveFolder(CmsDbContext dbc, CmsProject currentProject, CmsResource resource) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, currentProject, "C_STRUCTURE_DELETE_BY_STRUCTUREID");
            stmt.setString(1, resource.getStructureId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, null, stmt, null);
            stmt = this.m_sqlManager.getPreparedStatement(conn, currentProject, "C_RESOURCES_DELETE_BY_RESOURCEID");
            stmt.setString(1, resource.getResourceId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    protected void internalUpdateVersions(CmsDbContext dbc, CmsResource resource) throws CmsDataAccessException {
        if (dbc.getRequestContext() == null) {
            return;
        }
        if (dbc.currentProject().isOnlineProject()) {
            return;
        }
        Map<String, Integer> onlineVersions = this.readVersions(dbc, CmsProject.ONLINE_PROJECT_ID, resource.getResourceId(), resource.getStructureId());
        int onlineStructureVersion = onlineVersions.get("structure");
        int onlineResourceVersion = onlineVersions.get("resource");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, dbc.currentProject(), "C_RESOURCES_UPDATE_RESOURCE_VERSION");
            stmt.setInt(1, onlineResourceVersion);
            stmt.setString(2, resource.getResourceId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, null, stmt, null);
            stmt = this.m_sqlManager.getPreparedStatement(conn, dbc.currentProject(), "C_RESOURCES_UPDATE_STRUCTURE_VERSION");
            stmt.setInt(1, onlineStructureVersion);
            stmt.setString(2, resource.getStructureId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, null, stmt, null);
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
    }

    protected void internalValidateResourceLength(CmsResource resource) throws CmsDataAccessException {
        if (resource.isFolder() && resource.getLength() == -1) {
            return;
        }
        if (resource.isFile() && resource.getLength() >= 0) {
            return;
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_INVALID_RESOURCE_LENGTH_2", new Integer(resource.getLength()), resource.getRootPath()));
    }

    protected void moveRelations(CmsDbContext dbc, CmsUUID projectId, CmsUUID structureId, String rootPath) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_MOVE_RELATIONS_SOURCE");
            stmt.setString(1, rootPath);
            stmt.setString(2, structureId.toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, null, stmt, null);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_MOVE_RELATIONS_TARGET");
            stmt.setString(1, rootPath);
            stmt.setString(2, structureId.toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    protected void prepareExpiredTimeRangeCondition(CmsUUID projectId, long startTime, long endTime, StringBuffer conditions, List<Object> params) {
        if (startTime > 0L) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, "C_STRUCTURE_SELECT_BY_DATE_EXPIRED_AFTER"));
            conditions.append(") ");
            params.add(new Long(startTime));
        }
        if (endTime > 0L) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, "C_STRUCTURE_SELECT_BY_DATE_EXPIRED_BEFORE"));
            conditions.append(") ");
            params.add(new Long(endTime));
        }
    }

    protected void preparePathCondition(CmsUUID projectId, String parent, int mode, StringBuffer conditions, List<Object> params) {
        if (parent == CmsDriverManager.READ_IGNORE_PARENT) {
            return;
        }
        if ((mode & 1) > 0) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_SELECT_BY_PARENT_UUID"));
            conditions.append(") ");
            params.add(parent);
            return;
        }
        if ("/".equalsIgnoreCase(parent)) {
            return;
        }
        conditions.append(" AND (");
        conditions.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_SELECT_BY_PATH_PREFIX"));
        conditions.append(") ");
        params.add(CmsFileUtil.addTrailingSeparator(CmsVfsDriver.escapeDbWildcard(parent)) + "%");
    }

    protected void prepareProjectCondition(CmsUUID projectId, int mode, StringBuffer conditions, List<Object> params) {
        if ((mode & 2) > 0) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_SELECT_BY_PROJECT_LASTMODIFIED"));
            conditions.append(") ");
            params.add(projectId.toString());
        }
    }

    protected String prepareRelationConditions(CmsUUID projectId, CmsRelationFilter filter, CmsResource resource, List<Object> params, boolean checkSource) {
        Set<CmsRelationType> types;
        StringBuffer conditions = new StringBuffer(128);
        params.clear();
        if (filter.isSource() || filter.isTarget()) {
            if (resource != null) {
                conditions.append(" (");
                if (filter.isSource() && checkSource) {
                    if (!filter.isIncludeSubresources()) {
                        conditions.append(this.m_sqlManager.readQuery(projectId, "C_RELATION_FILTER_TARGET_ID"));
                        params.add(resource.getStructureId().toString());
                    } else {
                        conditions.append(this.m_sqlManager.readQuery(projectId, "C_RELATION_FILTER_TARGET_PATH"));
                        params.add(resource.getRootPath() + '%');
                    }
                } else if (filter.isTarget() && !checkSource) {
                    if (!filter.isIncludeSubresources()) {
                        conditions.append(this.m_sqlManager.readQuery(projectId, "C_RELATION_FILTER_SOURCE_ID"));
                        params.add(resource.getStructureId().toString());
                    } else {
                        conditions.append(this.m_sqlManager.readQuery(projectId, "C_RELATION_FILTER_SOURCE_PATH"));
                        params.add(resource.getRootPath() + '%');
                    }
                }
                conditions.append(") ");
            }
            if (filter.getStructureId() != null) {
                if (conditions.length() == 0) {
                    conditions.append(" (");
                } else {
                    conditions.append(" AND (");
                }
                if (filter.isSource() && checkSource) {
                    conditions.append(this.m_sqlManager.readQuery(projectId, "C_RELATION_FILTER_SOURCE_ID"));
                    params.add(filter.getStructureId().toString());
                } else if (filter.isTarget() && !checkSource) {
                    conditions.append(this.m_sqlManager.readQuery(projectId, "C_RELATION_FILTER_TARGET_ID"));
                    params.add(filter.getStructureId().toString());
                }
                conditions.append(") ");
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(filter.getPath())) {
                if (conditions.length() == 0) {
                    conditions.append(" (");
                } else {
                    conditions.append(" AND (");
                }
                String queryPath = filter.getPath();
                if (filter.isIncludeSubresources()) {
                    queryPath = queryPath + '%';
                }
                if (filter.isSource() && checkSource) {
                    conditions.append(this.m_sqlManager.readQuery(projectId, "C_RELATION_FILTER_SOURCE_PATH"));
                    params.add(queryPath);
                } else if (filter.isTarget() && !checkSource) {
                    conditions.append(this.m_sqlManager.readQuery(projectId, "C_RELATION_FILTER_TARGET_PATH"));
                    params.add(queryPath);
                }
                conditions.append(") ");
            }
        }
        if (!(types = filter.getTypes()).isEmpty()) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(projectId, "C_RELATION_FILTER_TYPE"));
            conditions.append(" (");
            Iterator<CmsRelationType> it = types.iterator();
            while (it.hasNext()) {
                CmsRelationType type = it.next();
                conditions.append("?");
                params.add(new Integer(type.getId()));
                if (!it.hasNext()) continue;
                conditions.append(", ");
            }
            conditions.append(") ");
            conditions.append(") ");
        }
        return conditions.toString();
    }

    protected void prepareReleasedTimeRangeCondition(CmsUUID projectId, long startTime, long endTime, StringBuffer conditions, List<Object> params) {
        if (startTime > 0L) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, "C_STRUCTURE_SELECT_BY_DATE_RELEASED_AFTER"));
            conditions.append(") ");
            params.add(new Long(startTime));
        }
        if (endTime > 0L) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, "C_STRUCTURE_SELECT_BY_DATE_RELEASED_BEFORE"));
            conditions.append(") ");
            params.add(new Long(endTime));
        }
    }

    protected void prepareResourceCondition(CmsUUID projectId, int mode, StringBuffer conditions) {
        if ((mode & 0x40) > 0) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_SELECT_ONLY_FOLDERS"));
            conditions.append(") ");
        } else if ((mode & 0x80) > 0) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_SELECT_ONLY_FILES"));
            conditions.append(") ");
        }
    }

    protected void prepareStateCondition(CmsUUID projectId, CmsResourceState state, int mode, StringBuffer conditions, List<Object> params) {
        if (state != null) {
            if ((mode & 8) > 0) {
                conditions.append(" AND NOT (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_SELECT_BY_RESOURCE_STATE"));
            conditions.append(") ");
            params.add(new Integer(state.getState()));
            params.add(new Integer(state.getState()));
        }
    }

    protected void prepareTimeRangeCondition(CmsUUID projectId, long startTime, long endTime, StringBuffer conditions, List<Object> params) {
        if (startTime > 0L) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_SELECT_BY_DATE_LASTMODIFIED_AFTER"));
            conditions.append(") ");
            params.add(new Long(startTime));
        }
        if (endTime > 0L) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_SELECT_BY_DATE_LASTMODIFIED_BEFORE"));
            conditions.append(") ");
            params.add(new Long(endTime));
        }
    }

    protected void prepareTypeCondition(CmsUUID projectId, int type, int mode, StringBuffer conditions, List<Object> params) {
        if (type != -1) {
            if ((mode & 4) > 0) {
                conditions.append(" AND NOT (");
                conditions.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_SELECT_BY_RESOURCE_TYPE"));
                conditions.append(") ");
                params.add(new Integer(type));
            } else {
                conditions.append(" AND (");
                conditions.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_SELECT_BY_RESOURCE_TYPE"));
                conditions.append(") ");
                params.add(new Integer(type));
            }
        }
    }

    protected void prepareTypesCondition(CmsUUID projectId, List<Integer> types, int mode, StringBuffer conditions, List<Object> params) {
        if ((mode & 4) > 0) {
            conditions.append(" AND NOT (");
            conditions.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_SELECT_BY_RESOURCE_TYPE"));
            conditions.append(") ");
            params.add(new Integer(-1));
        } else if (types != null && !types.isEmpty()) {
            conditions.append(" AND (");
            Iterator<Integer> typeIt = types.iterator();
            while (typeIt.hasNext()) {
                conditions.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_SELECT_BY_RESOURCE_TYPE"));
                params.add(typeIt.next());
                if (!typeIt.hasNext()) continue;
                conditions.append(" OR ");
            }
            conditions.append(") ");
        }
    }

    protected List<CmsResource> readTypesInResourceTree(CmsDbContext dbc, CmsUUID projectId, String parentPath, List<Integer> types, CmsResourceState state, long lastModifiedAfter, long lastModifiedBefore, long releasedAfter, long releasedBefore, long expiredAfter, long expiredBefore, int mode) throws CmsDataAccessException {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        StringBuffer conditions = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>(5);
        this.prepareProjectCondition(projectId, mode, conditions, params);
        this.prepareResourceCondition(projectId, mode, conditions);
        this.prepareTypesCondition(projectId, types, mode, conditions, params);
        this.prepareTimeRangeCondition(projectId, lastModifiedAfter, lastModifiedBefore, conditions, params);
        this.prepareReleasedTimeRangeCondition(projectId, releasedAfter, releasedBefore, conditions, params);
        this.prepareExpiredTimeRangeCondition(projectId, expiredAfter, expiredBefore, conditions, params);
        this.preparePathCondition(projectId, parentPath, mode, conditions, params);
        this.prepareStateCondition(projectId, state, mode, conditions, params);
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            StringBuffer queryBuf = new StringBuffer(256);
            queryBuf.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_READ_TREE"));
            queryBuf.append(conditions);
            queryBuf.append(" ");
            queryBuf.append(this.m_sqlManager.readQuery(projectId, "C_RESOURCES_ORDER_BY_PATH"));
            stmt = this.m_sqlManager.getPreparedStatementForSql(conn, queryBuf.toString());
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i) instanceof Integer) {
                    stmt.setInt(i + 1, (Integer)params.get(i));
                    continue;
                }
                if (params.get(i) instanceof Long) {
                    stmt.setLong(i + 1, (Long)params.get(i));
                    continue;
                }
                stmt.setString(i + 1, (String)params.get(i));
            }
            res = stmt.executeQuery();
            while (res.next()) {
                CmsResource resource = this.createResource(res, projectId);
                result.add(resource);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return result;
    }

    protected void repairBrokenRelations(CmsDbContext dbc, CmsUUID projectId, CmsUUID structureId, String rootPath) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RELATIONS_REPAIR_BROKEN");
            stmt.setString(1, structureId.toString());
            stmt.setString(2, rootPath);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    protected void updateBrokenRelations(CmsDbContext dbc, CmsUUID projectId, String rootPath) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_RELATIONS_UPDATE_BROKEN");
            stmt.setString(1, rootPath);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    protected CmsDbSqlException wrapException(PreparedStatement stmt, SQLException e) {
        return new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
    }

    PreparedStatement getPreparedStatementForFilter(Connection conn, String baseQuery, CmsUrlNameMappingFilter filter) throws SQLException {
        CmsPair<String, List<I_CmsPreparedStatementParameter>> conditionData = CmsVfsDriver.prepareUrlNameMappingConditions(filter);
        String whereClause = "";
        if (!conditionData.getFirst().equals("")) {
            whereClause = " WHERE " + conditionData.getFirst();
        }
        String query = baseQuery + whereClause;
        PreparedStatement stmt = this.m_sqlManager.getPreparedStatementForSql(conn, query);
        int counter = 1;
        for (I_CmsPreparedStatementParameter param : conditionData.getSecond()) {
            param.insertIntoStatement(stmt, counter);
            ++counter;
        }
        return stmt;
    }

    private CmsPair<String, List<String>> buildAliasConditions(CmsAliasFilter filter) {
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add("1 = 1");
        ArrayList<String> conditionParams = new ArrayList<String>();
        if (filter.getSiteRoot() != null) {
            conditions.add("site_root = ?");
            conditionParams.add(filter.getSiteRoot());
        }
        if (filter.getStructureId() != null) {
            conditions.add("structure_id = ?");
            conditionParams.add(filter.getStructureId().toString());
        }
        if (filter.getPath() != null) {
            conditions.add("path = ?");
            conditionParams.add(filter.getPath());
        }
        String conditionString = CmsStringUtil.listAsString(conditions, " AND ");
        return CmsPair.create(conditionString, conditionParams);
    }

    private CmsPair<String, List<Object>> prepareRewriteAliasConditions(CmsRewriteAliasFilter filter) {
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add("1 = 1");
        ArrayList<String> parameters = new ArrayList<String>();
        if (filter.getSiteRoot() != null) {
            parameters.add(filter.getSiteRoot());
            conditions.add("SITE_ROOT = ?");
        }
        if (filter.getId() != null) {
            parameters.add(filter.getId().toString());
            conditions.add("ID = ?");
        }
        return CmsPair.create(CmsStringUtil.listAsString(conditions, " AND "), parameters);
    }

    private String replaceProject(String query, boolean online) {
        return query.replace("%(PROJECT)", online ? ONLINE : OFFLINE);
    }
}

