/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.jpa;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.opencms.db.CmsSelectQuery;
import org.opencms.db.CmsSimpleQueryFragment;
import org.opencms.db.CmsStatementBuilder;
import org.opencms.db.I_CmsQueryFragment;
import org.opencms.db.generic.CmsUserQueryBuilder;
import org.opencms.file.CmsUserSearchParameters;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.util.CmsPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsJpaUserQueryBuilder
extends CmsUserQueryBuilder {
    @Override
    public CmsPair<String, List<Object>> createUserQuery(CmsUserSearchParameters searchParams, boolean countOnly) {
        CmsSelectQuery select = new CmsSelectQuery();
        CmsSelectQuery.TableAlias users = select.addTable("CmsDAOUsers", "user");
        if (countOnly) {
            select.addColumn("COUNT(user.m_userId)");
        } else {
            select.addColumn(users.getName());
        }
        CmsOrganizationalUnit orgUnit = searchParams.getOrganizationalUnit();
        boolean recursive = searchParams.recursiveOrgUnits();
        if (orgUnit != null) {
            this.addOrgUnitCondition(select, users, orgUnit, recursive);
        }
        if (searchParams.isFilterCore()) {
            select.addCondition(this.createCoreCondition(users));
        }
        this.addAllowedOuCondition(select, users, searchParams.getAllowedOus());
        this.addFlagCondition(select, users, searchParams.getFlags(), searchParams.keepCoreUsers());
        if (orgUnit != null) {
            this.addWebuserCondition(select, orgUnit, users);
        }
        this.addSearchFilterCondition(select, users, searchParams);
        this.addGroupCondition(select, users, searchParams);
        if (!countOnly) {
            this.addSorting(select, users, searchParams);
        }
        CmsStatementBuilder builder = new CmsStatementBuilder();
        select.visit(builder);
        return CmsPair.create(builder.getQuery(), builder.getParameters());
    }

    @Override
    protected void addSorting(CmsSelectQuery select, CmsSelectQuery.TableAlias users, CmsUserSearchParameters searchParams) {
        boolean ascending = searchParams.isAscending();
        String ordering = this.getSortExpression(users, searchParams);
        String direction = ascending ? " ASC" : " DESC";
        select.addColumn(ordering + " as sortvalue");
        select.setOrdering("sortvalue " + direction);
    }

    @Override
    protected String colDateCreated() {
        return "m_userDateCreated";
    }

    @Override
    protected String colEmail() {
        return "m_userEmail";
    }

    @Override
    protected String colFirstName() {
        return "m_userFirstName";
    }

    @Override
    protected String colFlags() {
        return "m_userFlags";
    }

    @Override
    protected String colGroupUserGroupId() {
        return "m_groupId";
    }

    @Override
    protected String colGroupUserUserId() {
        return "m_userId";
    }

    @Override
    protected String colId() {
        return "m_userId";
    }

    @Override
    protected String colLastLogin() {
        return "m_userLastLogin";
    }

    @Override
    protected String colLastName() {
        return "m_userLastName";
    }

    @Override
    protected String colName() {
        return "m_userName";
    }

    @Override
    protected String colOu() {
        return "m_userOu";
    }

    @Override
    protected String colPassword() {
        return "m_userPassword";
    }

    @Override
    protected I_CmsQueryFragment createFlagCondition(CmsSelectQuery.TableAlias users, int flags) {
        String conditionStr = this.internalCreateFlagCondition(users.column(this.colFlags()), flags);
        return new CmsSimpleQueryFragment(conditionStr, new Object[0]);
    }

    protected String createSingleFlagCondition(String col, int flag) {
        return "MOD(" + col + ", " + 2 * flag + ") >= " + flag;
    }

    @Override
    protected String generateConcat(String ... expressions) {
        int i;
        if (expressions.length == 1) {
            return expressions[0];
        }
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < expressions.length - 1; ++i) {
            buffer.append("CONCAT(" + expressions[i] + ", ");
        }
        buffer.append(expressions[expressions.length - 1]);
        for (i = 0; i < expressions.length - 1; ++i) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Override
    protected String getGroupUserSubqueryColumns() {
        return "GU";
    }

    protected String internalCreateFlagCondition(String col, int flags) {
        ArrayList<String> singleFlagConditions = new ArrayList<String>();
        for (Integer singleFlag : this.uncompressFlags(flags)) {
            singleFlagConditions.add(this.createSingleFlagCondition(col, singleFlag));
        }
        return "(" + Joiner.on((String)" AND ").join(singleFlagConditions) + ")";
    }

    @Override
    protected String tabGroups() {
        return "CmsDAOGroups";
    }

    @Override
    protected String tabGroupUsers() {
        return "CmsDAOGroupUsers";
    }

    @Override
    protected String tabUsers() {
        return "CmsDAOUsers";
    }

    protected List<Integer> uncompressFlags(int flags) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < 31; ++i) {
            int v = 1 << i;
            if ((flags & v) == 0) continue;
            result.add(new Integer(v));
        }
        return result;
    }
}

