/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.jpa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsSubscriptionFilter;
import org.opencms.db.CmsSubscriptionReadMode;
import org.opencms.db.CmsVisitEntry;
import org.opencms.db.CmsVisitEntryFilter;
import org.opencms.db.CmsVisitedByFilter;
import org.opencms.db.I_CmsDriver;
import org.opencms.db.I_CmsSubscriptionDriver;
import org.opencms.db.generic.Messages;
import org.opencms.db.jpa.CmsSqlManager;
import org.opencms.db.jpa.CmsVfsDriver;
import org.opencms.db.jpa.persistence.CmsDAOSubscription;
import org.opencms.db.jpa.persistence.CmsDAOSubscriptionVisit;
import org.opencms.db.jpa.utils.CmsQueryLongParameter;
import org.opencms.db.jpa.utils.CmsQueryStringParameter;
import org.opencms.db.jpa.utils.I_CmsQueryParameter;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSubscriptionDriver
implements I_CmsDriver,
I_CmsSubscriptionDriver {
    private static final String C_RESOURCES_SELECT_BY_PARENT_UUID = "C_RESOURCES_SELECT_BY_PARENT_UUID";
    private static final String C_RESOURCES_SELECT_BY_PATH_PREFIX = "C_RESOURCES_SELECT_BY_PATH_PREFIX";
    private static final String C_SUBSCRIPTION_CHECK_2 = "C_SUBSCRIPTION_CHECK_2";
    private static final String C_SUBSCRIPTION_DELETE = "C_SUBSCRIPTION_DELETE";
    private static final String C_SUBSCRIPTION_DELETE_FILTER_DATE = "C_SUBSCRIPTION_DELETE_FILTER_DATE";
    private static final String C_SUBSCRIPTION_DELETE_FILTER_PRINCIPAL = "C_SUBSCRIPTION_DELETE_FILTER_PRINCIPAL";
    private static final String C_SUBSCRIPTION_DELETE_FILTER_STRUCTURE = "C_SUBSCRIPTION_DELETE_FILTER_STRUCTURE";
    private static final String C_SUBSCRIPTION_DELETED = "C_SUBSCRIPTION_DELETED";
    private static final String C_SUBSCRIPTION_DELETED_FILTER_PRINCIPAL_SINGLE = "C_SUBSCRIPTION_DELETED_FILTER_PRINCIPAL_SINGLE";
    private static final String C_SUBSCRIPTION_DELETED_FILTER_PRINCIPALS = "C_SUBSCRIPTION_DELETED_FILTER_PRINCIPALS";
    private static final String C_SUBSCRIPTION_FILTER_PRINCIPAL_SINGLE = "C_SUBSCRIPTION_FILTER_PRINCIPAL_SINGLE";
    private static final String C_SUBSCRIPTION_FILTER_PRINCIPALS = "C_SUBSCRIPTION_FILTER_PRINCIPALS";
    private static final String C_SUBSCRIPTION_FILTER_PRINCIPALS_END = "C_SUBSCRIPTION_FILTER_PRINCIPALS_END";
    private static final String C_SUBSCRIPTION_FILTER_READ = "C_SUBSCRIPTION_FILTER_READ";
    private static final String C_SUBSCRIPTION_FILTER_RESOURCES_DATE_MODIFIED = "C_SUBSCRIPTION_FILTER_RESOURCES_DATE_MODIFIED";
    private static final String C_SUBSCRIPTION_READ_ALL_1 = "C_SUBSCRIPTION_READ_ALL_1";
    private static final String C_SUBSCRIPTION_UPDATE_DATE_2 = "C_SUBSCRIPTION_UPDATE_DATE_2";
    private static final String C_VISIT_DELETE_ENTRIES = "C_VISIT_DELETE_ENTRIES";
    private static final String C_VISIT_FILTER_DATE_FROM = "C_VISIT_FILTER_DATE_FROM";
    private static final String C_VISIT_FILTER_DATE_TO = "C_VISIT_FILTER_DATE_TO";
    private static final String C_VISIT_FILTER_STRUCTURE_ID = "C_VISIT_FILTER_STRUCTURE_ID";
    private static final String C_VISIT_FILTER_USER_ID = "C_VISIT_FILTER_USER_ID";
    private static final String C_VISIT_READ_ENTRIES = "C_VISIT_READ_ENTRIES";
    private static final String C_VISITED_USER_COUNT_1 = "C_VISITED_USER_COUNT_1";
    private static final String C_VISITED_USER_DELETE_GETDATE_2 = "C_VISITED_USER_DELETE_GETDATE_2";
    private static final String C_VISITED_USER_READ_4 = "C_VISITED_USER_READ_4";
    private static final Log LOG = CmsLog.getLog(org.opencms.db.generic.CmsSubscriptionDriver.class);
    protected CmsDriverManager m_driverManager;
    protected CmsSqlManager m_sqlManager;

    @Override
    public void deleteVisits(CmsDbContext dbc, String poolName, CmsVisitEntryFilter filter) throws CmsDataAccessException {
        try {
            StringBuffer queryBuf = new StringBuffer(256);
            queryBuf.append(this.m_sqlManager.readQuery(C_VISIT_DELETE_ENTRIES));
            CmsPair<String, List<I_CmsQueryParameter>> conditionsAndParams = this.prepareVisitConditions(filter);
            queryBuf.append(conditionsAndParams.getFirst());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)queryBuf.toString());
            }
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, queryBuf.toString());
            List<I_CmsQueryParameter> params = conditionsAndParams.getSecond();
            for (int i = 0; i < params.size(); ++i) {
                I_CmsQueryParameter param = conditionsAndParams.getSecond().get(i);
                param.insertIntoQuery(q, i + 1);
            }
            q.executeUpdate();
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_VISIT_DELETE_ENTRIES), (Throwable)e);
        }
    }

    @Override
    public long getDateLastVisitedBy(CmsDbContext dbc, String poolName, CmsUser user, CmsResource resource) throws CmsException {
        CmsVisitEntryFilter filter = CmsVisitEntryFilter.ALL.filterResource(resource.getStructureId()).filterUser(user.getId());
        List<CmsVisitEntry> entries = this.readVisits(dbc, poolName, filter);
        if (!entries.isEmpty()) {
            return entries.get(0).getDate();
        }
        return 0L;
    }

    @Override
    public CmsSqlManager getSqlManager() {
        return this.m_sqlManager;
    }

    @Override
    public void init(CmsDbContext dbc, CmsConfigurationManager configurationManager, List<String> successiveDrivers, CmsDriverManager driverManager) {
        CmsParameterConfiguration config = configurationManager.getConfiguration();
        String poolUrl = config.get("db.subscription.pool");
        String classname = config.get("db.subscription.sqlmanager");
        this.m_sqlManager = this.initSqlManager(classname);
        this.m_driverManager = driverManager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ASSIGNED_POOL_1", poolUrl));
        }
        if (successiveDrivers != null && !successiveDrivers.isEmpty() && LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_SUCCESSIVE_DRIVERS_UNSUPPORTED_1", this.getClass().getName()));
        }
    }

    @Override
    public CmsSqlManager initSqlManager(String classname) {
        return CmsSqlManager.getInstance(classname);
    }

    @Override
    public void markResourceAsVisitedBy(CmsDbContext dbc, String poolName, CmsResource resource, CmsUser user) throws CmsDataAccessException {
        boolean entryExists = false;
        CmsVisitEntryFilter filter = CmsVisitEntryFilter.ALL.filterResource(resource.getStructureId()).filterUser(user.getId());
        if (this.readVisits(dbc, OpenCms.getSubscriptionManager().getPoolName(), filter).size() > 0) {
            entryExists = true;
            this.deleteVisits(dbc, OpenCms.getSubscriptionManager().getPoolName(), filter);
        }
        CmsVisitEntry entry = new CmsVisitEntry(user.getId(), System.currentTimeMillis(), resource.getStructureId());
        this.addVisit(dbc, poolName, entry);
        if (!entryExists) {
            int count = 0;
            try {
                Query q = this.m_sqlManager.createQuery(dbc, dbc.currentProject(), C_VISITED_USER_COUNT_1);
                q.setParameter(1, (Object)user.getId().toString());
                count = ((Number)q.getSingleResult()).intValue();
                int maxCount = OpenCms.getSubscriptionManager().getMaxVisitedCount();
                if (count > maxCount) {
                    q = this.m_sqlManager.createQuery(dbc, dbc.currentProject(), C_VISITED_USER_DELETE_GETDATE_2);
                    q.setParameter(1, (Object)user.getId().toString());
                    q.setMaxResults(count - maxCount);
                    List res = q.getResultList();
                    long deleteDate = 0L;
                    for (Number n : res) {
                        deleteDate = n.longValue();
                    }
                    if (deleteDate > 0L) {
                        filter = CmsVisitEntryFilter.ALL.filterUser(user.getId()).filterTo(deleteDate);
                        this.deleteVisits(dbc, OpenCms.getSubscriptionManager().getPoolName(), filter);
                    }
                }
            }
            catch (PersistenceException e) {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_VISITED_USER_DELETE_GETDATE_2), (Throwable)e);
            }
        }
    }

    @Override
    public List<CmsResource> readAllSubscribedResources(CmsDbContext dbc, String poolName, CmsPrincipal principal) throws CmsDataAccessException {
        CmsFile currentResource = null;
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, dbc.currentProject(), C_SUBSCRIPTION_READ_ALL_1);
            q.setParameter(1, (Object)principal.getId().toString());
            List res = q.getResultList();
            for (Object[] obj : res) {
                currentResource = ((CmsVfsDriver)this.m_driverManager.getVfsDriver(dbc)).createFile(obj, dbc.currentProject().getUuid(), false);
                resources.add(currentResource);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_SUBSCRIPTION_READ_ALL_1), (Throwable)e);
        }
        return resources;
    }

    @Override
    public List<CmsResource> readResourcesVisitedBy(CmsDbContext dbc, String poolName, CmsVisitedByFilter filter) throws CmsDataAccessException {
        CmsFile currentResource = null;
        StringBuffer conditions = new StringBuffer(256);
        ArrayList<String> params = new ArrayList<String>(1);
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        try {
            if (CmsStringUtil.isNotEmpty(filter.getParentPath())) {
                CmsResource parent = this.m_driverManager.getVfsDriver(dbc).readResource(dbc, dbc.currentProject().getUuid(), filter.getParentPath(), false);
                conditions.append(" AND (");
                if (filter.isIncludeSubFolders()) {
                    conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), C_RESOURCES_SELECT_BY_PATH_PREFIX));
                    params.add(CmsFileUtil.addTrailingSeparator(CmsVfsDriver.escapeDbWildcard(filter.getParentPath())) + "%");
                } else {
                    conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), C_RESOURCES_SELECT_BY_PARENT_UUID));
                    params.add(parent.getStructureId().toString());
                }
                conditions.append(") ");
            }
            String query = this.m_sqlManager.readQuery(dbc.currentProject(), C_VISITED_USER_READ_4);
            query = CmsStringUtil.substitute(query, "%(CONDITIONS)", conditions.toString());
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, query);
            q.setParameter(1, (Object)filter.getUser().getId().toString());
            q.setParameter(2, (Object)filter.getFromDate());
            q.setParameter(3, (Object)filter.getToDate());
            for (int i = 0; i < params.size(); ++i) {
                q.setParameter(i + 4, params.get(i));
            }
            List res = q.getResultList();
            for (Object[] obj : res) {
                currentResource = ((CmsVfsDriver)this.m_driverManager.getVfsDriver(dbc)).createFile(obj, dbc.currentProject().getUuid(), false);
                resources.add(currentResource);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_VISITED_USER_READ_4), (Throwable)e);
        }
        return resources;
    }

    @Override
    public List<I_CmsHistoryResource> readSubscribedDeletedResources(CmsDbContext dbc, String poolName, CmsUser user, List<CmsGroup> groups, CmsResource parent, boolean includeSubFolders, long deletedFrom) throws CmsDataAccessException {
        ArrayList<I_CmsHistoryResource> resources = new ArrayList<I_CmsHistoryResource>();
        HashSet<CmsUUID> historyIDs = new HashSet<CmsUUID>();
        ArrayList<String> principalIds = new ArrayList<String>();
        principalIds.add(user.getId().toString());
        if (groups != null && !groups.isEmpty()) {
            Iterator<CmsGroup> it = groups.iterator();
            while (it.hasNext()) {
                principalIds.add(it.next().getId().toString());
            }
        }
        StringBuffer conditions = new StringBuffer(256);
        ArrayList params = new ArrayList();
        conditions.append(this.m_sqlManager.readQuery(C_SUBSCRIPTION_DELETED));
        if (principalIds.size() == 1) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(C_SUBSCRIPTION_DELETED_FILTER_PRINCIPAL_SINGLE));
            params.add(principalIds.get(0));
            conditions.append(") ");
        } else {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(C_SUBSCRIPTION_DELETED_FILTER_PRINCIPALS));
            conditions.append(" (");
            Iterator it = principalIds.iterator();
            while (it.hasNext()) {
                params.add(it.next());
                conditions.append("?");
                if (!it.hasNext()) continue;
                conditions.append(", ");
            }
            conditions.append(") ");
            conditions.append(") ");
        }
        try {
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, conditions.toString());
            q.setParameter(1, (Object)deletedFrom);
            for (int i = 0; i < params.size(); ++i) {
                q.setParameter(i + 2, params.get(i));
            }
            List result = q.getResultList();
            for (String id : result) {
                historyIDs.add(new CmsUUID(id));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_SUBSCRIPTION_DELETED), (Throwable)e);
        }
        String parentFolderPath = "";
        if (parent != null) {
            parentFolderPath = CmsResource.getFolderPath(parent.getRootPath());
        }
        for (CmsUUID id : historyIDs) {
            int version = this.m_driverManager.getHistoryDriver(dbc).readLastVersion(dbc, id);
            if (version <= 0) continue;
            I_CmsHistoryResource histRes = this.m_driverManager.getHistoryDriver(dbc).readResource(dbc, id, version);
            if (parent != null && (!includeSubFolders && !parentFolderPath.equals(CmsResource.getFolderPath(histRes.getRootPath())) || includeSubFolders && !histRes.getRootPath().startsWith(parentFolderPath))) continue;
            resources.add(histRes);
        }
        return resources;
    }

    @Override
    public List<CmsResource> readSubscribedResources(CmsDbContext dbc, String poolName, CmsSubscriptionFilter filter) throws CmsDataAccessException {
        ArrayList<CmsResource> resources;
        block20: {
            Iterator<CmsGroup> it;
            boolean groupsDefined;
            CmsFile currentResource = null;
            resources = new ArrayList<CmsResource>();
            String queryBuf = this.m_sqlManager.readQuery(dbc.currentProject(), C_SUBSCRIPTION_FILTER_READ);
            StringBuffer conditions = new StringBuffer(256);
            ArrayList<I_CmsQueryParameter> params = new ArrayList<I_CmsQueryParameter>();
            boolean userDefined = filter.getUser() != null;
            boolean bl = groupsDefined = !filter.getGroups().isEmpty();
            if (!groupsDefined && !userDefined) {
                filter.setUser(dbc.currentUser());
                userDefined = true;
            }
            if (!filter.getMode().isAll() && filter.getUser() == null) {
                filter.setMode(CmsSubscriptionReadMode.ALL);
            }
            ArrayList<String> principalIds = new ArrayList<String>();
            if (userDefined) {
                principalIds.add(filter.getUser().getId().toString());
            }
            if (groupsDefined) {
                it = filter.getGroups().iterator();
                while (it.hasNext()) {
                    principalIds.add(it.next().getId().toString());
                }
            }
            if (principalIds.size() == 1) {
                conditions.append(" (");
                conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), C_SUBSCRIPTION_FILTER_PRINCIPAL_SINGLE));
                params.add(new CmsQueryStringParameter((String)principalIds.get(0)));
                conditions.append(") ");
            } else {
                conditions.append(" (");
                conditions.append(this.m_sqlManager.readQuery(C_SUBSCRIPTION_FILTER_PRINCIPALS));
                conditions.append(" (");
                it = principalIds.iterator();
                while (it.hasNext()) {
                    params.add(new CmsQueryStringParameter((String)((Object)it.next())));
                    conditions.append("?");
                    if (!it.hasNext()) continue;
                    conditions.append(", ");
                }
                conditions.append(") ");
                conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), C_SUBSCRIPTION_FILTER_PRINCIPALS_END));
                conditions.append(") ");
            }
            if (CmsStringUtil.isNotEmpty(filter.getParentPath())) {
                CmsResource parent = this.m_driverManager.getVfsDriver(dbc).readResource(dbc, dbc.currentProject().getUuid(), filter.getParentPath(), false);
                conditions.append(" AND (");
                if (filter.isIncludeSubFolders()) {
                    conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), C_RESOURCES_SELECT_BY_PATH_PREFIX));
                    params.add(new CmsQueryStringParameter(CmsFileUtil.addTrailingSeparator(CmsVfsDriver.escapeDbWildcard(filter.getParentPath())) + "%"));
                } else {
                    conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), C_RESOURCES_SELECT_BY_PARENT_UUID));
                    params.add(new CmsQueryStringParameter(parent.getStructureId().toString()));
                }
                conditions.append(") ");
            }
            if (filter.getFromDate() > 0L || filter.getToDate() < Long.MAX_VALUE) {
                conditions.append(" AND (");
                conditions.append(this.m_sqlManager.readQuery(dbc.currentProject(), C_SUBSCRIPTION_FILTER_RESOURCES_DATE_MODIFIED));
                params.add(new CmsQueryLongParameter(filter.getFromDate()));
                params.add(new CmsQueryLongParameter(filter.getToDate()));
                conditions.append(") ");
            }
            try {
                queryBuf = CmsStringUtil.substitute(queryBuf, "%(CONDITIONS)", conditions.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)queryBuf.toString());
                }
                Query q = this.m_sqlManager.createQueryFromJPQL(dbc, queryBuf);
                for (int i = 0; i < params.size(); ++i) {
                    I_CmsQueryParameter param = (I_CmsQueryParameter)params.get(i);
                    param.insertIntoQuery(q, i + 1);
                }
                List res = q.getResultList();
                for (Object[] obj : res) {
                    currentResource = ((CmsVfsDriver)this.m_driverManager.getVfsDriver(dbc)).createFile(obj, dbc.currentProject().getUuid(), false);
                    resources.add(currentResource);
                }
                if (filter.getMode().isAll()) break block20;
                ArrayList<CmsResource> result = new ArrayList<CmsResource>(resources.size());
                for (CmsResource resource : resources) {
                    long visitedDate = 0L;
                    try {
                        visitedDate = this.m_driverManager.getDateLastVisitedBy(dbc, poolName, filter.getUser(), resource);
                    }
                    catch (CmsException e) {
                        throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_0"), (Throwable)e);
                    }
                    if (filter.getMode().isUnVisited() && visitedDate >= resource.getDateLastModified() || filter.getMode().isVisited() && resource.getDateLastModified() > visitedDate) continue;
                    result.add(resource);
                }
                resources = result;
            }
            catch (PersistenceException e) {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_SUBSCRIPTION_FILTER_READ), (Throwable)e);
            }
        }
        return resources;
    }

    public List<CmsVisitEntry> readVisits(CmsDbContext dbc, String poolName, CmsVisitEntryFilter filter) throws CmsDataAccessException {
        ArrayList<CmsVisitEntry> entries = new ArrayList<CmsVisitEntry>();
        try {
            StringBuffer queryBuf = new StringBuffer(256);
            queryBuf.append(this.m_sqlManager.readQuery(C_VISIT_READ_ENTRIES));
            CmsPair<String, List<I_CmsQueryParameter>> conditionsAndParameters = this.prepareVisitConditions(filter);
            List<I_CmsQueryParameter> params = conditionsAndParameters.getSecond();
            queryBuf.append(conditionsAndParameters.getFirst());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)queryBuf.toString());
            }
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, queryBuf.toString());
            for (int i = 0; i < params.size(); ++i) {
                I_CmsQueryParameter param = params.get(i);
                param.insertIntoQuery(q, i + 1);
            }
            List res = q.getResultList();
            for (CmsDAOSubscriptionVisit sv : res) {
                entries.add(this.internalReadVisitEntry(sv));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_VISIT_READ_ENTRIES), (Throwable)e);
        }
        return entries;
    }

    @Override
    public void setSubscribedResourceAsDeleted(CmsDbContext dbc, String poolName, CmsResource resource) throws CmsDataAccessException {
        long deletedTime = System.currentTimeMillis();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_SUBSCRIPTION_UPDATE_DATE_2);
            q.setParameter(1, (Object)resource.getStructureId().toString());
            List res = q.getResultList();
            for (CmsDAOSubscription s : res) {
                s.setDateDeleted(deletedTime);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_SUBSCRIPTION_UPDATE_DATE_2), (Throwable)e);
        }
    }

    @Override
    public void subscribeResourceFor(CmsDbContext dbc, String poolName, CmsPrincipal principal, CmsResource resource) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_SUBSCRIPTION_CHECK_2);
            q.setParameter(1, (Object)principal.getId().toString());
            q.setParameter(2, (Object)resource.getStructureId().toString());
            List res = q.getResultList();
            if (res.size() <= 0) {
                CmsDAOSubscription sb = new CmsDAOSubscription();
                sb.setPrincipalId(principal.getId().toString());
                sb.setStructureId(resource.getStructureId().toString());
                sb.setDateDeleted(0L);
                this.m_sqlManager.persist(dbc, sb);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_SUBSCRIPTION_CHECK_2), (Throwable)e);
        }
    }

    @Override
    public void unsubscribeAllDeletedResources(CmsDbContext dbc, String poolName, long deletedTo) throws CmsDataAccessException {
        try {
            StringBuffer conditions = new StringBuffer(256);
            conditions.append(this.m_sqlManager.readQuery(C_SUBSCRIPTION_DELETE));
            conditions.append(" (");
            conditions.append(this.m_sqlManager.readQuery(C_SUBSCRIPTION_DELETE_FILTER_DATE));
            conditions.append(") ");
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, conditions.toString());
            q.setParameter(1, (Object)deletedTo);
            List res = q.getResultList();
            for (CmsDAOSubscription sb : res) {
                this.m_sqlManager.remove(dbc, sb);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_SUBSCRIPTION_DELETE), (Throwable)e);
        }
    }

    @Override
    public void unsubscribeAllResourcesFor(CmsDbContext dbc, String poolName, CmsPrincipal principal) throws CmsDataAccessException {
        try {
            if (principal != null) {
                StringBuffer conditions = new StringBuffer(256);
                conditions.append(this.m_sqlManager.readQuery(C_SUBSCRIPTION_DELETE));
                conditions.append(" (");
                conditions.append(this.m_sqlManager.readQuery(C_SUBSCRIPTION_DELETE_FILTER_PRINCIPAL));
                conditions.append(") ");
                Query q = this.m_sqlManager.createQueryFromJPQL(dbc, conditions.toString());
                q.setParameter(1, (Object)principal.getId().toString());
                List res = q.getResultList();
                for (CmsDAOSubscription sb : res) {
                    this.m_sqlManager.remove(dbc, sb);
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_SUBSCRIPTION_DELETE), (Throwable)e);
        }
    }

    @Override
    public void unsubscribeResourceFor(CmsDbContext dbc, String poolName, CmsPrincipal principal, CmsResource resource) throws CmsDataAccessException {
        try {
            StringBuffer conditions = new StringBuffer(256);
            conditions.append(this.m_sqlManager.readQuery(C_SUBSCRIPTION_DELETE));
            conditions.append(" (");
            conditions.append(this.m_sqlManager.readQuery(C_SUBSCRIPTION_DELETE_FILTER_PRINCIPAL));
            conditions.append(") ");
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(C_SUBSCRIPTION_DELETE_FILTER_STRUCTURE));
            conditions.append(") ");
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, conditions.toString());
            q.setParameter(1, (Object)principal.getId().toString());
            q.setParameter(2, (Object)resource.getStructureId().toString());
            List res = q.getResultList();
            for (CmsDAOSubscription sb : res) {
                this.m_sqlManager.remove(dbc, sb);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_SUBSCRIPTION_DELETE), (Throwable)e);
        }
    }

    @Override
    public void unsubscribeResourceForAll(CmsDbContext dbc, String poolName, CmsResource resource) throws CmsDataAccessException {
        try {
            StringBuffer conditions = new StringBuffer(256);
            conditions.append(this.m_sqlManager.readQuery(C_SUBSCRIPTION_DELETE));
            conditions.append(" (");
            conditions.append(this.m_sqlManager.readQuery(C_SUBSCRIPTION_DELETE_FILTER_STRUCTURE));
            conditions.append(") ");
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, conditions.toString());
            q.setParameter(1, (Object)resource.getStructureId().toString());
            List res = q.getResultList();
            for (CmsDAOSubscription sb : res) {
                this.m_sqlManager.remove(dbc, sb);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_SUBSCRIPTION_DELETE), (Throwable)e);
        }
    }

    protected void addVisit(CmsDbContext dbc, String poolName, CmsVisitEntry visit) throws CmsDbSqlException {
        try {
            CmsDAOSubscriptionVisit sv = new CmsDAOSubscriptionVisit();
            sv.setUserId(visit.getUserId().toString());
            sv.setVisitDate(visit.getDate());
            sv.setStructureId(visit.getStructureId() == null ? null : visit.getStructureId().toString());
            this.m_sqlManager.persist(dbc, sv);
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", ""), (Throwable)e);
        }
    }

    protected CmsVisitEntry internalReadVisitEntry(CmsDAOSubscriptionVisit sv) {
        CmsUUID userId = new CmsUUID(sv.getUserId());
        long date = sv.getVisitDate();
        CmsUUID structureId = new CmsUUID(sv.getStructureId());
        return new CmsVisitEntry(userId, date, structureId);
    }

    protected CmsPair<String, List<I_CmsQueryParameter>> prepareVisitConditions(CmsVisitEntryFilter filter) {
        ArrayList<I_CmsQueryParameter> params = new ArrayList<I_CmsQueryParameter>();
        StringBuffer conditions = new StringBuffer();
        if (filter.getUserId() != null) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(C_VISIT_FILTER_USER_ID));
            params.add(new CmsQueryStringParameter(filter.getUserId().toString()));
            conditions.append(") ");
        }
        if (filter.getStructureId() != null) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(C_VISIT_FILTER_STRUCTURE_ID));
            params.add(new CmsQueryStringParameter(filter.getStructureId().toString()));
            conditions.append(") ");
        }
        if (filter.getDateFrom() != 0L) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(C_VISIT_FILTER_DATE_FROM));
            params.add(new CmsQueryLongParameter(filter.getDateFrom()));
            conditions.append(") ");
        }
        if (filter.getDateTo() != 0L) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(C_VISIT_FILTER_DATE_TO));
            params.add(new CmsQueryLongParameter(filter.getDateTo()));
            conditions.append(") ");
        }
        return CmsPair.create(conditions.toString(), params);
    }
}

