/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.jpa;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsAlias;
import org.opencms.db.CmsAliasFilter;
import org.opencms.db.CmsDbConsistencyException;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsResourceState;
import org.opencms.db.CmsRewriteAlias;
import org.opencms.db.CmsRewriteAliasFilter;
import org.opencms.db.CmsVfsOnlineResourceAlreadyExistsException;
import org.opencms.db.I_CmsDriver;
import org.opencms.db.I_CmsProjectDriver;
import org.opencms.db.I_CmsVfsDriver;
import org.opencms.db.generic.Messages;
import org.opencms.db.jpa.CmsSqlManager;
import org.opencms.db.jpa.persistence.CmsDAOAlias;
import org.opencms.db.jpa.persistence.CmsDAOContents;
import org.opencms.db.jpa.persistence.CmsDAOCounters;
import org.opencms.db.jpa.persistence.CmsDAOOfflineContents;
import org.opencms.db.jpa.persistence.CmsDAOOfflineProperties;
import org.opencms.db.jpa.persistence.CmsDAOOfflinePropertyDef;
import org.opencms.db.jpa.persistence.CmsDAOOfflineResourceRelations;
import org.opencms.db.jpa.persistence.CmsDAOOfflineResources;
import org.opencms.db.jpa.persistence.CmsDAOOfflineStructure;
import org.opencms.db.jpa.persistence.CmsDAOOfflineUrlNameMappings;
import org.opencms.db.jpa.persistence.CmsDAOOnlineProperties;
import org.opencms.db.jpa.persistence.CmsDAOOnlinePropertyDef;
import org.opencms.db.jpa.persistence.CmsDAOOnlineResourceRelations;
import org.opencms.db.jpa.persistence.CmsDAOOnlineResources;
import org.opencms.db.jpa.persistence.CmsDAOOnlineStructure;
import org.opencms.db.jpa.persistence.CmsDAOOnlineUrlNameMappings;
import org.opencms.db.jpa.persistence.CmsDAORewriteAlias;
import org.opencms.db.jpa.persistence.I_CmsDAOProperties;
import org.opencms.db.jpa.persistence.I_CmsDAOPropertyDef;
import org.opencms.db.jpa.persistence.I_CmsDAOResourceRelations;
import org.opencms.db.jpa.persistence.I_CmsDAOResources;
import org.opencms.db.jpa.persistence.I_CmsDAOStructure;
import org.opencms.db.jpa.persistence.I_CmsDAOUrlNameMappings;
import org.opencms.db.jpa.utils.CmsQueryIntParameter;
import org.opencms.db.jpa.utils.CmsQueryStringParameter;
import org.opencms.db.jpa.utils.I_CmsQueryParameter;
import org.opencms.db.urlname.CmsUrlNameMappingEntry;
import org.opencms.db.urlname.CmsUrlNameMappingFilter;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsException;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.I_CmsResource;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.gwt.shared.alias.CmsAliasMode;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsVfsDriver
implements I_CmsDriver,
I_CmsVfsDriver {
    public static final byte[] EMPTY_BLOB = new byte[0];
    private static final String C_DELETE_RELATIONS = "C_DELETE_RELATIONS";
    private static final String C_DELETE_URLNAME_MAPPINGS = "C_DELETE_URLNAME_MAPPINGS";
    private static final String C_HISTORY_CONTENTS_UPDATE = "C_HISTORY_CONTENTS_UPDATE";
    private static final String C_MOVE_RELATIONS_SOURCE = "C_MOVE_RELATIONS_SOURCE";
    private static final String C_MOVE_RELATIONS_TARGET = "C_MOVE_RELATIONS_TARGET";
    private static final String C_OFFLINE_CONTENTS_UPDATE = "C_OFFLINE_CONTENTS_UPDATE";
    private static final String C_OFFLINE_FILE_CONTENT_DELETE = "C_OFFLINE_FILE_CONTENT_DELETE";
    private static final String C_ONLINE_CONTENTS_DELETE = "C_ONLINE_CONTENTS_DELETE";
    private static final String C_ONLINE_CONTENTS_HISTORY = "C_ONLINE_CONTENTS_HISTORY";
    private static final String C_ONLINE_FILES_CONTENT = "C_ONLINE_FILES_CONTENT";
    private static final String C_PROPERTIES_DELETE = "C_PROPERTIES_DELETE";
    private static final String C_PROPERTIES_DELETE_ALL_STRUCTURE_AND_RESOURCE_VALUES = "C_PROPERTIES_DELETE_ALL_STRUCTURE_AND_RESOURCE_VALUES";
    private static final String C_PROPERTIES_DELETE_ALL_VALUES_FOR_MAPPING_TYPE = "C_PROPERTIES_DELETE_ALL_VALUES_FOR_MAPPING_TYPE";
    private static final String C_PROPERTIES_READ = "C_PROPERTIES_READ";
    private static final String C_PROPERTIES_READALL = "C_PROPERTIES_READALL";
    private static final String C_PROPERTIES_READALL_COUNT = "C_PROPERTIES_READALL_COUNT";
    private static final String C_PROPERTIES_UPDATE = "C_PROPERTIES_UPDATE";
    private static final String C_PROPERTYDEF_DELETE = "C_PROPERTYDEF_DELETE";
    private static final String C_PROPERTYDEF_READ = "C_PROPERTYDEF_READ";
    private static final String C_PROPERTYDEF_READALL = "C_PROPERTYDEF_READALL";
    private static final String C_READ_RELATIONS = "C_READ_RELATIONS";
    private static final String C_READ_RESOURCE_OUS = "C_READ_RESOURCE_OUS";
    private static final String C_READ_RESOURCE_STATE = "C_READ_RESOURCE_STATE";
    private static final String C_READ_STRUCTURE_STATE = "C_READ_STRUCTURE_STATE";
    private static final String C_READ_URLNAME_MAPPINGS = "C_READ_URLNAME_MAPPINGS";
    private static final String C_RELATION_FILTER_SOURCE_ID = "C_RELATION_FILTER_SOURCE_ID";
    private static final String C_RELATION_FILTER_SOURCE_PATH = "C_RELATION_FILTER_SOURCE_PATH";
    private static final String C_RELATION_FILTER_TARGET_ID = "C_RELATION_FILTER_TARGET_ID";
    private static final String C_RELATION_FILTER_TARGET_PATH = "C_RELATION_FILTER_TARGET_PATH";
    private static final String C_RELATION_FILTER_TYPE = "C_RELATION_FILTER_TYPE";
    private static final String C_RELATIONS_REPAIR_BROKEN = "C_RELATIONS_REPAIR_BROKEN";
    private static final String C_RELATIONS_UPDATE_BROKEN = "C_RELATIONS_UPDATE_BROKEN";
    private static final String C_RESOURCE_REPLACE = "C_RESOURCE_REPLACE";
    private static final String C_RESOURCES_COUNT_SIBLINGS = "C_RESOURCES_COUNT_SIBLINGS";
    private static final String C_RESOURCES_DELETE_BY_RESOURCEID = "C_RESOURCES_DELETE_BY_RESOURCEID";
    private static final String C_RESOURCES_GET_RESOURCE_IN_PROJECT_IGNORE_STATE = "C_RESOURCES_GET_RESOURCE_IN_PROJECT_IGNORE_STATE";
    private static final String C_RESOURCES_GET_RESOURCE_IN_PROJECT_WITH_STATE = "C_RESOURCES_GET_RESOURCE_IN_PROJECT_WITH_STATE";
    private static final String C_RESOURCES_GET_RESOURCE_IN_PROJECT_WITHOUT_STATE = "C_RESOURCES_GET_RESOURCE_IN_PROJECT_WITHOUT_STATE";
    private static final String C_RESOURCES_GET_RESOURCE_WITH_PROPERTYDEF = "C_RESOURCES_GET_RESOURCE_WITH_PROPERTYDEF";
    private static final String C_RESOURCES_GET_RESOURCE_WITH_PROPERTYDEF_VALUE = "C_RESOURCES_GET_RESOURCE_WITH_PROPERTYDEF_VALUE";
    private static final String C_RESOURCES_GET_SUBRESOURCES = "C_RESOURCES_GET_SUBRESOURCES";
    private static final String C_RESOURCES_GET_SUBRESOURCES_GET_FILES = "C_RESOURCES_GET_SUBRESOURCES_GET_FILES";
    private static final String C_RESOURCES_GET_SUBRESOURCES_GET_FOLDERS = "C_RESOURCES_GET_SUBRESOURCES_GET_FOLDERS";
    private static final String C_RESOURCES_MOVE = "C_RESOURCES_MOVE";
    private static final String C_RESOURCES_ORDER_BY_PATH = "C_RESOURCES_ORDER_BY_PATH";
    private static final String C_RESOURCES_READ = "C_RESOURCES_READ";
    private static final String C_RESOURCES_READ_PARENT_BY_ID = "C_RESOURCES_READ_PARENT_BY_ID";
    private static final String C_RESOURCES_READ_PARENT_STRUCTURE_ID = "C_RESOURCES_READ_PARENT_STRUCTURE_ID";
    private static final String C_RESOURCES_READ_RESOURCE_STATE = "C_RESOURCES_READ_RESOURCE_STATE";
    private static final String C_RESOURCES_READ_TREE = "C_RESOURCES_READ_TREE";
    private static final String C_RESOURCES_READ_VERSION_RES = "C_RESOURCES_READ_VERSION_RES";
    private static final String C_RESOURCES_READ_VERSION_STR = "C_RESOURCES_READ_VERSION_STR";
    private static final String C_RESOURCES_READ_WITH_ACE_1 = "C_RESOURCES_READ_WITH_ACE_1";
    private static final String C_RESOURCES_READBYID = "C_RESOURCES_READBYID";
    private static final String C_RESOURCES_SELECT_BY_DATE_LASTMODIFIED_AFTER = "C_RESOURCES_SELECT_BY_DATE_LASTMODIFIED_AFTER";
    private static final String C_RESOURCES_SELECT_BY_DATE_LASTMODIFIED_BEFORE = "C_RESOURCES_SELECT_BY_DATE_LASTMODIFIED_BEFORE";
    private static final String C_RESOURCES_SELECT_BY_PARENT_UUID = "C_RESOURCES_SELECT_BY_PARENT_UUID";
    private static final String C_RESOURCES_SELECT_BY_PATH_PREFIX = "C_RESOURCES_SELECT_BY_PATH_PREFIX";
    private static final String C_RESOURCES_SELECT_BY_PROJECT_LASTMODIFIED = "C_RESOURCES_SELECT_BY_PROJECT_LASTMODIFIED";
    private static final String C_RESOURCES_SELECT_BY_RESOURCE_STATE = "C_RESOURCES_SELECT_BY_RESOURCE_STATE";
    private static final String C_RESOURCES_SELECT_BY_RESOURCE_TYPE = "C_RESOURCES_SELECT_BY_RESOURCE_TYPE";
    private static final String C_RESOURCES_SELECT_ONLY_FILES = "C_RESOURCES_SELECT_ONLY_FILES";
    private static final String C_RESOURCES_SELECT_ONLY_FOLDERS = "C_RESOURCES_SELECT_ONLY_FOLDERS";
    private static final String C_RESOURCES_SELECT_STRUCTURE_ID = "C_RESOURCES_SELECT_STRUCTURE_ID";
    private static final String C_RESOURCES_TRANSFER_RESOURCE = "C_RESOURCES_TRANSFER_RESOURCE";
    private static final String C_RESOURCES_UPDATE_FLAGS = "C_RESOURCES_UPDATE_FLAGS";
    private static final String C_RESOURCES_UPDATE_PROJECT_LASTMODIFIED = "C_RESOURCES_UPDATE_PROJECT_LASTMODIFIED";
    private static final String C_RESOURCES_UPDATE_RELEASE_EXPIRED = "C_RESOURCES_UPDATE_RELEASE_EXPIRED";
    private static final String C_RESOURCES_UPDATE_RESOURCE_PROJECT = "C_RESOURCES_UPDATE_RESOURCE_PROJECT";
    private static final String C_RESOURCES_UPDATE_RESOURCE_STATE = "C_RESOURCES_UPDATE_RESOURCE_STATE";
    private static final String C_RESOURCES_UPDATE_RESOURCE_STATELASTMODIFIED = "C_RESOURCES_UPDATE_RESOURCE_STATELASTMODIFIED";
    private static final String C_RESOURCES_UPDATE_RESOURCE_VERSION = "C_RESOURCES_UPDATE_RESOURCE_VERSION";
    private static final String C_RESOURCES_UPDATE_RESOURCES = "C_RESOURCES_UPDATE_RESOURCES";
    private static final String C_RESOURCES_UPDATE_RESOURCES_WITHOUT_STATE = "C_RESOURCES_UPDATE_RESOURCES_WITHOUT_STATE";
    private static final String C_RESOURCES_UPDATE_SIBLING_COUNT = "C_RESOURCES_UPDATE_SIBLING_COUNT";
    private static final String C_RESOURCES_UPDATE_STRUCTURE = "C_RESOURCES_UPDATE_STRUCTURE";
    private static final String C_RESOURCES_UPDATE_STRUCTURE_STATE = "C_RESOURCES_UPDATE_STRUCTURE_STATE";
    private static final String C_RESOURCES_UPDATE_STRUCTURE_VERSION = "C_RESOURCES_UPDATE_STRUCTURE_VERSION";
    private static final String C_SELECT_NONDELETED_VFS_SIBLINGS = "C_SELECT_NONDELETED_VFS_SIBLINGS";
    private static final String C_SELECT_RESOURCES_FOR_PRINCIPAL_ACE = "C_SELECT_RESOURCES_FOR_PRINCIPAL_ACE";
    private static final String C_SELECT_RESOURCES_FOR_PRINCIPAL_ATTR1 = "C_SELECT_RESOURCES_FOR_PRINCIPAL_ATTR1";
    private static final String C_SELECT_RESOURCES_FOR_PRINCIPAL_ATTR2 = "C_SELECT_RESOURCES_FOR_PRINCIPAL_ATTR2";
    private static final String C_SELECT_VFS_SIBLINGS = "C_SELECT_VFS_SIBLINGS";
    private static final String C_STRUCTURE_DELETE_BY_STRUCTUREID = "C_STRUCTURE_DELETE_BY_STRUCTUREID";
    private static final String C_STRUCTURE_SELECT_BY_DATE_EXPIRED_AFTER = "C_STRUCTURE_SELECT_BY_DATE_EXPIRED_AFTER";
    private static final String C_STRUCTURE_SELECT_BY_DATE_EXPIRED_BEFORE = "C_STRUCTURE_SELECT_BY_DATE_EXPIRED_BEFORE";
    private static final String C_STRUCTURE_SELECT_BY_DATE_RELEASED_AFTER = "C_STRUCTURE_SELECT_BY_DATE_RELEASED_AFTER";
    private static final String C_STRUCTURE_SELECT_BY_DATE_RELEASED_BEFORE = "C_STRUCTURE_SELECT_BY_DATE_RELEASED_BEFORE";
    private static final Log LOG = CmsLog.getLog(CmsVfsDriver.class);
    protected CmsDriverManager m_driverManager;
    protected List<CmsUUID> m_resOp = new ArrayList<CmsUUID>();
    protected CmsSqlManager m_sqlManager;

    public static String escapeDbWildcard(String path) {
        return CmsStringUtil.substitute(path, "_", "|_");
    }

    public static CmsPair<String, List<I_CmsQueryParameter>> prepareUrlNameMappingConditions(CmsUrlNameMappingFilter filter) {
        ArrayList<String> sqlConditions = new ArrayList<String>();
        ArrayList<I_CmsQueryParameter> parameters = new ArrayList<I_CmsQueryParameter>();
        if (filter.getName() != null) {
            sqlConditions.add("T_CmsDAO%(PROJECT)UrlNameMappings.m_name = ?");
            parameters.add(new CmsQueryStringParameter(filter.getName()));
        }
        if (filter.getStructureId() != null) {
            sqlConditions.add("T_CmsDAO%(PROJECT)UrlNameMappings.m_structureId = ?");
            parameters.add(new CmsQueryStringParameter(filter.getStructureId().toString()));
        }
        if (filter.getNamePattern() != null) {
            sqlConditions.add("T_CmsDAO%(PROJECT)UrlNameMappings.m_name LIKE ? ");
            parameters.add(new CmsQueryStringParameter(filter.getNamePattern()));
        }
        if (filter.getState() != null) {
            sqlConditions.add("T_CmsDAO%(PROJECT)UrlNameMappings.m_state = ?");
            parameters.add(new CmsQueryIntParameter(filter.getState()));
        }
        if (filter.getRejectStructureId() != null) {
            sqlConditions.add("T_CmsDAO%(PROJECT)UrlNameMappings.m_structureId <> ? ");
            parameters.add(new CmsQueryStringParameter(filter.getRejectStructureId().toString()));
        }
        if (filter.getLocale() != null) {
            sqlConditions.add("T_CmsDAO%(PROJECT)UrlNameMappings.m_locale = ? ");
            parameters.add(new CmsQueryStringParameter(filter.getLocale()));
        }
        String conditionString = CmsStringUtil.listAsString(sqlConditions, " AND ");
        return CmsPair.create(conditionString, parameters);
    }

    @Override
    public void addUrlNameMappingEntry(CmsDbContext dbc, boolean online, CmsUrlNameMappingEntry entry) {
        PersistenceCapable m = online ? new CmsDAOOnlineUrlNameMappings() : new CmsDAOOfflineUrlNameMappings();
        m.setName(entry.getName());
        m.setStructureId(entry.getStructureId().toString());
        m.setState(entry.getState());
        m.setDateChanged(entry.getDateChanged());
        m.setLocale(entry.getLocale());
        this.m_sqlManager.persist(dbc, m);
    }

    @Override
    public int countSiblings(CmsDbContext dbc, CmsUUID projectId, CmsUUID resourceId) throws CmsDataAccessException {
        int count = 0;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_COUNT_SIBLINGS);
            q.setParameter(1, (Object)resourceId.toString());
            try {
                count = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return count;
    }

    @Override
    public void createContent(CmsDbContext dbc, CmsUUID projectId, CmsUUID resourceId, byte[] content) throws CmsDataAccessException {
        try {
            CmsDAOOfflineContents oc = new CmsDAOOfflineContents();
            oc.setResourceId(resourceId.toString());
            oc.setFileContent(content);
            this.m_sqlManager.persist(dbc, oc);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    public CmsFile createFile(Object[] o, CmsUUID projectId, boolean hasFileContentInResultSet) {
        I_CmsDAOResources r = (I_CmsDAOResources)o[0];
        I_CmsDAOStructure s = (I_CmsDAOStructure)o[1];
        String lockedInProjectParameter = (String)o[2];
        byte[] content = null;
        CmsUUID resProjectId = null;
        CmsUUID structureId = new CmsUUID(s.getStructureId());
        CmsUUID resourceId = new CmsUUID(r.getResourceId());
        String resourcePath = s.getResourcePath();
        int resourceType = r.getResourceType();
        int resourceFlags = r.getResourceFlags();
        int resourceState = r.getResourceState();
        int structureState = s.getStructureState();
        long dateCreated = r.getDateCreated();
        long dateLastModified = r.getDateLastModified();
        long dateReleased = s.getDateReleased();
        long dateExpired = s.getDateExpired();
        int resourceSize = r.getResourceSize();
        CmsUUID userCreated = new CmsUUID(r.getUserCreated());
        CmsUUID userLastModified = new CmsUUID(r.getUserLastModified());
        CmsUUID lockedInProject = new CmsUUID(lockedInProjectParameter);
        int siblingCount = r.getSiblingCount();
        long dateContent = r.getDateContent();
        int resourceVersion = r.getResourceVersion();
        int structureVersion = s.getStructureVersion();
        if (CmsFolder.isFolderType(resourceType)) {
            resourcePath = CmsFileUtil.addTrailingSeparator(resourcePath);
        }
        if (hasFileContentInResultSet) {
            throw new RuntimeException("CCmsVfsDriver: public CmsFile createFile(Object[] o, CmsUUID projectId, boolean hasFileContentInResultSet) throws SQLException ");
        }
        resProjectId = lockedInProject;
        int newState = structureState > resourceState ? structureState : resourceState;
        return new CmsFile(structureId, resourceId, resourcePath, resourceType, resourceFlags, resProjectId, CmsResourceState.valueOf(newState), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, siblingCount, resourceSize, dateContent, resourceVersion + structureVersion, content);
    }

    @Override
    public CmsFile createFile(ResultSet res, CmsUUID projectId) {
        LOG.error((Object)"This method is not implemented!");
        return null;
    }

    @Override
    public CmsFile createFile(ResultSet res, CmsUUID projectId, boolean hasFileContentInResultSet) {
        LOG.error((Object)"This method is not implemented!");
        return null;
    }

    public CmsFolder createFolder(Object[] o, CmsUUID projectId, boolean hasProjectIdInResultSet) {
        I_CmsDAOResources r = (I_CmsDAOResources)o[0];
        I_CmsDAOStructure s = (I_CmsDAOStructure)o[1];
        String lockedInProjectParameter = (String)o[2];
        CmsUUID structureId = new CmsUUID(s.getStructureId());
        CmsUUID resourceId = new CmsUUID(r.getResourceId());
        String resourcePath = s.getResourcePath();
        int resourceType = r.getResourceType();
        int resourceFlags = r.getResourceFlags();
        int resourceState = r.getResourceState();
        int structureState = s.getStructureState();
        long dateCreated = r.getDateCreated();
        long dateLastModified = r.getDateLastModified();
        long dateReleased = s.getDateReleased();
        long dateExpired = s.getDateExpired();
        CmsUUID userCreated = new CmsUUID(r.getUserCreated());
        CmsUUID userLastModified = new CmsUUID(r.getUserLastModified());
        CmsUUID resProjectId = new CmsUUID(lockedInProjectParameter);
        int resourceVersion = r.getResourceVersion();
        int structureVersion = s.getStructureVersion();
        int resourceSize = r.getResourceSize();
        if (CmsFolder.isFolderSize(resourceSize)) {
            resourcePath = CmsFileUtil.addTrailingSeparator(resourcePath);
        }
        int newState = structureState > resourceState ? structureState : resourceState;
        return new CmsFolder(structureId, resourceId, resourcePath, resourceType, resourceFlags, resProjectId, CmsResourceState.valueOf(newState), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, resourceVersion + structureVersion);
    }

    @Override
    public CmsFolder createFolder(ResultSet res, CmsUUID projectId, boolean hasProjectIdInResultSet) {
        LOG.error((Object)"This method is not implemented!");
        return null;
    }

    @Override
    public void createOnlineContent(CmsDbContext dbc, CmsUUID resourceId, byte[] contents, int publishTag, boolean keepOnline, boolean needToUpdateContent) throws CmsDataAccessException {
        try {
            boolean dbcHasProjectId;
            boolean bl = dbcHasProjectId = dbc.getProjectId() != null && !dbc.getProjectId().isNullUUID();
            if (needToUpdateContent || dbcHasProjectId) {
                Query q;
                if (dbcHasProjectId || !OpenCms.getSystemInfo().isHistoryEnabled()) {
                    q = this.m_sqlManager.createQuery(dbc, C_ONLINE_CONTENTS_DELETE);
                    q.setParameter(1, (Object)resourceId.toString());
                    q.executeUpdate();
                } else {
                    q = this.m_sqlManager.createQuery(dbc, C_ONLINE_CONTENTS_HISTORY);
                    q.setParameter(1, (Object)resourceId.toString());
                    List res = q.getResultList();
                    for (CmsDAOContents c : res) {
                        c.setOnlineFlag(0);
                    }
                }
                CmsDAOContents c = new CmsDAOContents();
                c.setResourceId(resourceId.toString());
                c.setFileContent(contents);
                c.setPublishTagFrom(publishTag);
                c.setPublishTagTo(publishTag);
                c.setOnlineFlag(keepOnline ? 1 : 0);
                this.m_sqlManager.persist(dbc, c);
            } else {
                Query q = this.m_sqlManager.createQuery(dbc, C_HISTORY_CONTENTS_UPDATE);
                q.setParameter(1, (Object)resourceId.toString());
                List res = q.getResultList();
                for (CmsDAOContents c : res) {
                    c.setPublishTagTo(publishTag);
                }
                if (!keepOnline) {
                    q = this.m_sqlManager.createQuery(dbc, C_ONLINE_CONTENTS_HISTORY);
                    q.setParameter(1, (Object)resourceId.toString());
                    List res1 = q.getResultList();
                    for (CmsDAOContents c : res1) {
                        c.setOnlineFlag(0);
                    }
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public CmsPropertyDefinition createPropertyDefinition(CmsDbContext dbc, CmsUUID projectId, String name, CmsPropertyDefinition.CmsPropertyType type) throws CmsDataAccessException {
        try {
            PersistenceCapable pd = CmsProject.isOnlineProject(projectId) ? new CmsDAOOnlinePropertyDef() : new CmsDAOOfflinePropertyDef();
            pd.setPropertyDefId(new CmsUUID().toString());
            pd.setPropertyDefName(name);
            pd.setPropertyDefType(type.getMode());
            this.m_sqlManager.persist(dbc, pd);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return this.readPropertyDefinition(dbc, name, projectId);
    }

    @Override
    public void createRelation(CmsDbContext dbc, CmsUUID projectId, CmsRelation relation) throws CmsDataAccessException {
        try {
            I_CmsDAOResourceRelations rr = CmsProject.isOnlineProject(projectId) ? new CmsDAOOnlineResourceRelations() : new CmsDAOOfflineResourceRelations();
            rr.setRelationSourceId(relation.getSourceId().toString());
            rr.setRelationSourcePath(relation.getSourcePath());
            rr.setRelationTargetId(relation.getTargetId().toString());
            rr.setRelationTargetPath(relation.getTargetPath());
            rr.setRelationType(relation.getType().getId());
            this.m_sqlManager.persist(dbc, rr);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_RELATION_2", String.valueOf(projectId), relation));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public CmsResource createResource(CmsDbContext dbc, CmsUUID projectId, CmsResource resource, byte[] content) throws CmsDataAccessException {
        long dateModified;
        long dateCreated;
        CmsResourceState newState;
        CmsUUID newStructureId = null;
        String resourcePath = CmsFileUtil.removeTrailingSeparator(resource.getRootPath());
        if (resourcePath.length() > 512) {
            throw new CmsDataAccessException(Messages.get().container("ERR_RESOURCENAME_TOO_LONG_2", resourcePath, new Integer(512)));
        }
        if (!resource.getRootPath().equals("/")) {
            String parentFolderName = CmsResource.getParentFolder(resource.getRootPath());
            CmsFolder parentFolder = this.m_driverManager.getVfsDriver(dbc).readFolder(dbc, projectId, parentFolderName);
            if (parentFolder.getState().isDeleted()) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_PARENT_FOLDER_DELETED_1", resource.getRootPath()));
            }
        }
        this.internalValidateResourceLength(resource);
        long dateContent = System.currentTimeMillis();
        if (projectId.equals(CmsProject.ONLINE_PROJECT_ID)) {
            newState = CmsResource.STATE_UNCHANGED;
            dateCreated = resource.getDateCreated();
            dateModified = resource.getDateLastModified();
        } else {
            newState = CmsResource.STATE_NEW;
            if (resource.isTouched()) {
                dateCreated = resource.getDateCreated();
                dateModified = resource.getDateLastModified();
            } else {
                dateModified = dateCreated = System.currentTimeMillis();
            }
        }
        newStructureId = resource.getStructureId();
        try {
            CmsResource existingResource = this.m_driverManager.getVfsDriver().readResource(dbc, dbc.getProjectId().isNullUUID() ? projectId : dbc.getProjectId(), resourcePath, true);
            if (!existingResource.getState().isDeleted()) {
                throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_RESOURCE_WITH_NAME_ALREADY_EXISTS_1", dbc.removeSiteRoot(resource.getRootPath())));
            }
            newStructureId = existingResource.getStructureId();
            newState = CmsResource.STATE_CHANGED;
            List<CmsResource> modifiedResources = this.m_driverManager.getVfsDriver(dbc).readSiblings(dbc, projectId, existingResource, false);
            int propertyDeleteOption = existingResource.getSiblingCount() > 1 ? 2 : 1;
            this.deletePropertyObjects(dbc, projectId, existingResource, propertyDeleteOption);
            this.removeFile(dbc, projectId, existingResource);
            OpenCms.fireCmsEvent(new CmsEvent(12, Collections.singletonMap("resources", modifiedResources)));
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", existingResource)));
        }
        catch (CmsVfsResourceNotFoundException e) {
            // empty catch block
        }
        try {
            String parentId = this.internalReadParentId(dbc, projectId, resourcePath);
            int lastVersion = this.m_driverManager.getHistoryDriver(dbc).readLastVersion(dbc, newStructureId);
            int newStrVersion = 0;
            int newResVersion = 0;
            if (lastVersion > 0) {
                I_CmsHistoryResource histRes = this.m_driverManager.getHistoryDriver(dbc).readResource(dbc, newStructureId, lastVersion);
                newStrVersion = histRes.getStructureVersion();
                newResVersion = histRes.getResourceVersion();
            }
            PersistenceCapable s = CmsProject.isOnlineProject(projectId) ? new CmsDAOOnlineStructure() : new CmsDAOOfflineStructure();
            s.setStructureId(newStructureId.toString());
            s.setResourceId(resource.getResourceId().toString());
            s.setResourcePath(resourcePath);
            s.setStructureState(newState.getState());
            s.setDateReleased(resource.getDateReleased());
            s.setDateExpired(resource.getDateExpired());
            s.setParentId(parentId);
            s.setStructureVersion(newStrVersion);
            this.m_sqlManager.persist(dbc, s);
            if (!this.validateResourceIdExists(dbc, projectId, resource.getResourceId())) {
                I_CmsDAOResources r = CmsProject.isOnlineProject(projectId) ? new CmsDAOOnlineResources() : new CmsDAOOfflineResources();
                r.setResourceId(resource.getResourceId().toString());
                r.setResourceType(resource.getTypeId());
                r.setResourceFlags(resource.getFlags());
                r.setDateCreated(dateCreated);
                r.setUserCreated(resource.getUserCreated().toString());
                r.setDateLastModified(dateModified);
                r.setUserLastModified(resource.getUserLastModified().toString());
                r.setResourceState(newState.getState());
                r.setResourceSize(resource.getLength());
                r.setDateContent(dateContent);
                r.setProjectLastModified(projectId.toString());
                r.setSiblingCount(1);
                r.setResourceVersion(newResVersion);
                this.m_sqlManager.persist(dbc, r);
                if (resource.isFile() && content != null) {
                    this.createContent(dbc, projectId, resource.getResourceId(), content);
                }
            } else {
                if (content != null || !resource.getState().isKeep()) {
                    CmsUUID projLastMod = projectId;
                    CmsResourceState state = CmsResource.STATE_CHANGED;
                    if (projectId.equals(CmsProject.ONLINE_PROJECT_ID)) {
                        projLastMod = resource.getProjectLastModified();
                        state = CmsResource.STATE_UNCHANGED;
                    }
                    Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_UPDATE_RESOURCES);
                    q.setParameter(1, (Object)resource.getResourceId().toString());
                    List res = q.getResultList();
                    for (I_CmsDAOResources r : res) {
                        r.setResourceType(resource.getTypeId());
                        r.setResourceFlags(resource.getFlags());
                        r.setDateLastModified(dateModified);
                        r.setUserLastModified(resource.getUserLastModified().toString());
                        r.setResourceState(state.getState());
                        r.setResourceSize(resource.getLength());
                        r.setDateContent(resource.getDateContent());
                        r.setProjectLastModified(projLastMod.toString());
                        r.setSiblingCount(this.countSiblings(dbc, projectId, resource.getResourceId()));
                    }
                }
                if (resource.isFile()) {
                    if (content != null) {
                        this.writeContent(dbc, resource.getResourceId(), content);
                    } else if (resource.getState().isKeep()) {
                        Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_UPDATE_SIBLING_COUNT);
                        q.setParameter(1, (Object)resource.getResourceId().toString());
                        List res = q.getResultList();
                        for (I_CmsDAOResources r : res) {
                            r.setSiblingCount(this.countSiblings(dbc, projectId, resource.getResourceId()));
                        }
                        q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_UPDATE_FLAGS);
                        q.setParameter(1, (Object)resource.getResourceId().toString());
                        List resf = q.getResultList();
                        for (I_CmsDAOResources r : resf) {
                            r.setResourceFlags(resource.getFlags());
                        }
                    }
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        this.repairBrokenRelations(dbc, projectId, resource.getStructureId(), resource.getRootPath());
        return this.readResource(dbc, projectId, newStructureId, false);
    }

    public CmsResource createResource(Object[] o, CmsUUID projectId) {
        I_CmsDAOResources r = (I_CmsDAOResources)o[0];
        I_CmsDAOStructure s = (I_CmsDAOStructure)o[1];
        CmsUUID structureId = new CmsUUID(s.getStructureId());
        CmsUUID resourceId = new CmsUUID(r.getResourceId());
        String resourcePath = s.getResourcePath();
        int resourceType = r.getResourceType();
        int resourceFlags = r.getResourceFlags();
        CmsUUID resourceProjectLastModified = new CmsUUID(r.getProjectLastModified());
        int resourceState = r.getResourceState();
        int structureState = s.getStructureState();
        long dateCreated = r.getDateCreated();
        long dateLastModified = r.getDateLastModified();
        long dateReleased = s.getDateReleased();
        long dateExpired = s.getDateExpired();
        int resourceSize = r.getResourceSize();
        boolean isFolder = CmsFolder.isFolderSize(resourceSize);
        if (isFolder) {
            resourcePath = CmsFileUtil.addTrailingSeparator(resourcePath);
        }
        long dateContent = isFolder ? -1L : r.getDateContent();
        CmsUUID userCreated = new CmsUUID(r.getUserCreated());
        CmsUUID userLastModified = new CmsUUID(r.getUserLastModified());
        int siblingCount = r.getSiblingCount();
        int resourceVersion = r.getResourceVersion();
        int structureVersion = s.getStructureVersion();
        int newState = structureState > resourceState ? structureState : resourceState;
        int newVersion = resourceVersion + structureVersion + (newState > 0 ? 1 : 0);
        CmsResource newResource = new CmsResource(structureId, resourceId, resourcePath, resourceType, isFolder, resourceFlags, resourceProjectLastModified, CmsResourceState.valueOf(newState), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, siblingCount, resourceSize, dateContent, newVersion);
        return newResource;
    }

    @Override
    public CmsResource createResource(ResultSet res, CmsUUID projectId) {
        LOG.error((Object)"This method is not implemented!");
        return null;
    }

    @Override
    public void createSibling(CmsDbContext dbc, CmsProject project, CmsResource resource) throws CmsDataAccessException {
        if (!project.getUuid().equals(CmsProject.ONLINE_PROJECT_ID)) {
            return;
        }
        CmsResource existingSibling = null;
        CmsUUID newStructureId = resource.getStructureId();
        try {
            existingSibling = this.readResource(dbc, project.getUuid(), resource.getRootPath(), true);
            if (!existingSibling.getState().isDeleted()) {
                throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_RESOURCE_WITH_NAME_ALREADY_EXISTS_1", dbc.removeSiteRoot(resource.getRootPath())));
            }
            newStructureId = existingSibling.getStructureId();
            List<CmsResource> modifiedResources = this.readSiblings(dbc, project.getUuid(), existingSibling, false);
            int propertyDeleteOption = existingSibling.getSiblingCount() > 1 ? 2 : 1;
            this.deletePropertyObjects(dbc, project.getUuid(), existingSibling, propertyDeleteOption);
            this.removeFile(dbc, project.getUuid(), existingSibling);
            OpenCms.fireCmsEvent(new CmsEvent(12, Collections.singletonMap("resources", modifiedResources)));
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", existingSibling)));
        }
        catch (CmsVfsResourceNotFoundException e) {
            // empty catch block
        }
        if (!this.validateResourceIdExists(dbc, project.getUuid(), resource.getResourceId())) {
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_CREATE_SIBLING_FILE_NOT_FOUND_1", dbc.removeSiteRoot(resource.getRootPath())));
        }
        try {
            int lastVersion = this.m_driverManager.getHistoryDriver(dbc).readLastVersion(dbc, newStructureId);
            int newStrVersion = 0;
            if (lastVersion > 0) {
                I_CmsHistoryResource histRes = this.m_driverManager.getHistoryDriver(dbc).readResource(dbc, newStructureId, lastVersion);
                newStrVersion = histRes.getStructureVersion();
            }
            String parentId = this.internalReadParentId(dbc, project.getUuid(), resource.getRootPath());
            PersistenceCapable s = CmsProject.isOnlineProject(project.getUuid()) ? new CmsDAOOnlineStructure() : new CmsDAOOfflineStructure();
            s.setStructureId(newStructureId.toString());
            s.setResourceId(resource.getResourceId().toString());
            s.setResourcePath(resource.getRootPath());
            s.setStructureState(CmsResource.STATE_UNCHANGED.getState());
            s.setDateReleased(resource.getDateReleased());
            s.setDateExpired(resource.getDateExpired());
            s.setParentId(parentId);
            s.setStructureVersion(newStrVersion);
            this.m_sqlManager.persist(dbc, s);
            Query q = this.m_sqlManager.createQuery(dbc, project, C_RESOURCES_UPDATE_SIBLING_COUNT);
            q.setParameter(1, (Object)resource.getResourceId().toString());
            List res = q.getResultList();
            for (I_CmsDAOResources r : res) {
                r.setSiblingCount(this.countSiblings(dbc, project.getUuid(), resource.getResourceId()));
            }
            q = this.m_sqlManager.createQuery(dbc, project, C_RESOURCES_UPDATE_RESOURCE_PROJECT);
            q.setParameter(1, (Object)resource.getResourceId().toString());
            List resr = q.getResultList();
            for (I_CmsDAOResources r : resr) {
                r.setResourceFlags(resource.getFlags());
                r.setProjectLastModified(resource.getProjectLastModified().toString());
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        this.repairBrokenRelations(dbc, project.getUuid(), resource.getStructureId(), resource.getRootPath());
    }

    @Override
    public void deleteAliases(CmsDbContext dbc, CmsProject project, CmsAliasFilter filter) throws CmsDataAccessException {
        String baseQuery = "DELETE FROM CmsDAOAlias alias ";
        try {
            Query query = this.getAliasQueryForFilter(dbc, baseQuery, filter);
            query.executeUpdate();
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deletePropertyDefinition(CmsDbContext dbc, CmsPropertyDefinition metadef) throws CmsDataAccessException {
        try {
            if (this.internalCountProperties(dbc, metadef, CmsProject.ONLINE_PROJECT_ID) != 0 || this.internalCountProperties(dbc, metadef, CmsUUID.getOpenCmsUUID()) != 0) {
                throw new CmsDataAccessException(Messages.get().container("ERR_DELETE_USED_PROPERTY_1", metadef.getName()));
            }
            for (int i = 0; i < 2; ++i) {
                Query q = i == 0 ? this.m_sqlManager.createQuery(dbc, CmsUUID.getOpenCmsUUID(), C_PROPERTYDEF_DELETE) : this.m_sqlManager.createQuery(dbc, CmsProject.ONLINE_PROJECT_ID, C_PROPERTYDEF_DELETE);
                q.setParameter(1, (Object)metadef.getId().toString());
                List res = q.getResultList();
                for (I_CmsDAOPropertyDef pd : res) {
                    this.m_sqlManager.remove(dbc, pd);
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deletePropertyObjects(CmsDbContext dbc, CmsUUID projectId, CmsResource resource, int deleteOption) throws CmsDataAccessException {
        try {
            Query q;
            if (deleteOption == 1) {
                q = this.m_sqlManager.createQuery(dbc, projectId, C_PROPERTIES_DELETE_ALL_STRUCTURE_AND_RESOURCE_VALUES);
                q.setParameter(1, (Object)resource.getResourceId().toString());
                q.setParameter(2, (Object)2);
                q.setParameter(3, (Object)String.valueOf(resource.getStructureId()));
                q.setParameter(4, (Object)1);
            } else if (deleteOption == 2) {
                q = this.m_sqlManager.createQuery(dbc, projectId, C_PROPERTIES_DELETE_ALL_VALUES_FOR_MAPPING_TYPE);
                q.setParameter(1, (Object)resource.getStructureId().toString());
                q.setParameter(2, (Object)1);
            } else if (deleteOption == 3) {
                q = this.m_sqlManager.createQuery(dbc, projectId, C_PROPERTIES_DELETE_ALL_VALUES_FOR_MAPPING_TYPE);
                q.setParameter(1, (Object)resource.getResourceId().toString());
                q.setParameter(2, (Object)2);
            } else {
                throw new CmsDataAccessException(Messages.get().container("ERR_INVALID_DELETE_OPTION_1"));
            }
            List res = q.getResultList();
            for (I_CmsDAOProperties p : res) {
                this.m_sqlManager.remove(dbc, p);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deleteRelations(CmsDbContext dbc, CmsUUID projectId, CmsResource resource, CmsRelationFilter filter) throws CmsDataAccessException {
        try {
            Query q;
            StringBuffer queryBuf;
            ArrayList<Object> params;
            if (filter.isSource()) {
                params = new ArrayList<Object>(7);
                queryBuf = new StringBuffer(256);
                queryBuf.append(this.m_sqlManager.readQuery(projectId, C_DELETE_RELATIONS));
                queryBuf.append(this.prepareRelationConditions(projectId, filter, resource, params, true));
                q = this.m_sqlManager.createQueryFromJPQL(dbc, queryBuf.toString());
                for (int i = 0; i < params.size(); ++i) {
                    q.setParameter(i + 1, params.get(i));
                }
                List res = q.getResultList();
                for (I_CmsDAOResourceRelations rr : res) {
                    this.m_sqlManager.remove(dbc, rr);
                }
            }
            if (filter.isTarget()) {
                params = new ArrayList(7);
                queryBuf = new StringBuffer(256);
                queryBuf.append(this.m_sqlManager.readQuery(projectId, C_DELETE_RELATIONS));
                queryBuf.append(this.prepareRelationConditions(projectId, filter, resource, params, false));
                q = this.m_sqlManager.createQueryFromJPQL(dbc, queryBuf.toString());
                for (int i = 0; i < params.size(); ++i) {
                    q.setParameter(i + 1, params.get(i));
                }
                List res = q.getResultList();
                for (I_CmsDAOResourceRelations rr : res) {
                    this.m_sqlManager.remove(dbc, rr);
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        this.updateBrokenRelations(dbc, projectId, resource.getRootPath());
    }

    @Override
    public void deleteRewriteAliases(CmsDbContext dbc, CmsRewriteAliasFilter filter) throws CmsDataAccessException {
        try {
            String baseQuery = this.m_sqlManager.readQuery("C_DELETE_REWRITES");
            CmsPair<String, List<Object>> queryAndParams = this.prepareRewriteAliasConditions("rewriteAlias", filter);
            String condition = queryAndParams.getFirst();
            List<Object> params = queryAndParams.getSecond();
            String fullQuery = baseQuery + condition;
            Query q = this.m_sqlManager.createQueryWithParametersFromJPQL(dbc, fullQuery, params);
            q.executeUpdate();
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void deleteUrlNameMappingEntries(CmsDbContext dbc, boolean online, CmsUrlNameMappingFilter filter) throws CmsDataAccessException {
        try {
            String query = this.m_sqlManager.readQuery(C_DELETE_URLNAME_MAPPINGS);
            query = this.replaceProject(query, online);
            Query q = this.getQueryForFilter(dbc, query, filter, online);
            List res = q.getResultList();
            for (I_CmsDAOUrlNameMappings m : res) {
                this.m_sqlManager.remove(dbc, m);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void destroy() throws Throwable {
        this.m_sqlManager = null;
        this.m_driverManager = null;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_DRIVER_1", this.getClass().getName()));
        }
    }

    @Override
    public List<CmsOrganizationalUnit> getResourceOus(CmsDbContext dbc, CmsUUID projectId, CmsResource resource) throws CmsDataAccessException {
        ArrayList<CmsOrganizationalUnit> ous = new ArrayList<CmsOrganizationalUnit>();
        String resName = resource.getRootPath();
        if (resource.isFolder() && !resName.endsWith("/")) {
            resName = resName + "/";
        }
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_READ_RESOURCE_OUS);
            q.setParameter(1, (Object)CmsRelationType.OU_RESOURCE.getId());
            List<I_CmsDAOResourceRelations> res = this.internalResourceOus(q.getResultList(), resName);
            for (I_CmsDAOResourceRelations rr : res) {
                CmsRelation rel = this.internalReadRelation(rr);
                try {
                    ous.add(this.m_driverManager.readOrganizationalUnit(dbc, rel.getSourcePath().substring("/system/orgunits/".length())));
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return ous;
    }

    @Override
    public CmsSqlManager getSqlManager() {
        return this.m_sqlManager;
    }

    @Override
    public int incrementCounter(CmsDbContext dbc, String name) {
        CmsDAOCounters c = this.m_sqlManager.find(dbc, CmsDAOCounters.class, name);
        int result = 0;
        if (c != null) {
            result = c.getCounter();
            c.setCounter(c.getCounter() + 1);
        } else {
            c = new CmsDAOCounters();
            c.setName(name);
            c.setCounter(1);
            this.m_sqlManager.persist(dbc, c);
        }
        return result;
    }

    @Override
    public void init(CmsDbContext dbc, CmsConfigurationManager configurationManager, List<String> successiveDrivers, CmsDriverManager driverManager) {
        CmsParameterConfiguration config = configurationManager.getConfiguration();
        String poolUrl = config.get("db.vfs.pool");
        String classname = config.get("db.vfs.sqlmanager");
        this.m_sqlManager = this.initSqlManager(classname);
        this.m_driverManager = driverManager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ASSIGNED_POOL_1", poolUrl));
        }
        if (successiveDrivers != null && !successiveDrivers.isEmpty() && LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_SUCCESSIVE_DRIVERS_UNSUPPORTED_1", this.getClass().getName()));
        }
    }

    @Override
    public CmsSqlManager initSqlManager(String classname) {
        return CmsSqlManager.getInstance(classname);
    }

    @Override
    public void insertAlias(CmsDbContext dbc, CmsProject project, CmsAlias alias) throws CmsDataAccessException {
        try {
            CmsDAOAlias bean = new CmsDAOAlias();
            bean.setMode(alias.getMode().toInt());
            bean.setSiteRoot(alias.getSiteRoot());
            bean.setStructureId(alias.getStructureId().toString());
            bean.setAliasPath(alias.getAliasPath());
            this.m_sqlManager.persist(dbc, bean);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void insertRewriteAliases(CmsDbContext dbc, Collection<CmsRewriteAlias> rewriteAliases) throws CmsDataAccessException {
        try {
            for (CmsRewriteAlias alias : rewriteAliases) {
                CmsDAORewriteAlias beanToWrite = new CmsDAORewriteAlias();
                beanToWrite.setId(alias.getId().toString());
                beanToWrite.setPattern(alias.getPatternString());
                beanToWrite.setReplacement(alias.getReplacementString());
                beanToWrite.setSiteRoot(alias.getSiteRoot());
                beanToWrite.setMode(alias.getMode().toInt());
                this.m_sqlManager.persist(dbc, beanToWrite);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void moveResource(CmsDbContext dbc, CmsUUID projectId, CmsResource source, String destinationPath) throws CmsDataAccessException {
        CmsFolder destinationFolder;
        block13: {
            if (dbc.getRequestContext() != null && dbc.getRequestContext().getAttribute("CHECK_PERMISSIONS") != null) {
                this.checkWritePermissionsInFolder(dbc, source);
                return;
            }
            String destinationFoldername = CmsResource.getParentFolder(destinationPath);
            destinationFolder = this.m_driverManager.readFolder(dbc, destinationFoldername, CmsResourceFilter.ALL);
            if (!projectId.equals(CmsProject.ONLINE_PROJECT_ID)) {
                try {
                    CmsResource offlineResource;
                    block14: {
                        CmsResource onlineResource = this.m_driverManager.getVfsDriver(dbc).readResource(dbc, CmsProject.ONLINE_PROJECT_ID, destinationPath, true);
                        if (onlineResource.getStructureId().equals(source.getStructureId())) break block13;
                        offlineResource = null;
                        try {
                            offlineResource = this.readResource(dbc, dbc.getRequestContext().getCurrentProject().getUuid(), onlineResource.getStructureId(), true);
                        }
                        catch (CmsException e) {
                            if (!LOG.isErrorEnabled()) break block14;
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    throw new CmsVfsOnlineResourceAlreadyExistsException(Messages.get().container("ERR_OVERWRITE_MOVED_RESOURCE_3", dbc.removeSiteRoot(source.getRootPath()), dbc.removeSiteRoot(destinationPath), dbc.removeSiteRoot(offlineResource == null ? "__ERROR__" : offlineResource.getRootPath())));
                }
                catch (CmsVfsResourceNotFoundException e) {
                    // empty catch block
                }
            }
        }
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_MOVE);
            q.setParameter(1, (Object)source.getStructureId().toString());
            List res = q.getResultList();
            for (I_CmsDAOStructure s : res) {
                s.setResourcePath(CmsFileUtil.removeTrailingSeparator(destinationPath));
                s.setParentId(destinationFolder.getStructureId().toString());
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        this.moveRelations(dbc, projectId, source.getStructureId(), destinationPath);
        this.repairBrokenRelations(dbc, projectId, source.getStructureId(), destinationPath);
        try {
            this.m_driverManager.repairCategories(dbc, projectId, this.readResource(dbc, projectId, destinationPath, true));
        }
        catch (CmsException e) {
            throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
        }
        if (!projectId.equals(CmsProject.ONLINE_PROJECT_ID) && dbc.getRequestContext() != null) {
            String deletedResourceRootPath = source.getRootPath();
            dbc.getRequestContext().setAttribute("DBC_ATTR_READ_PROJECT_FOR_RESOURCE", Boolean.TRUE);
            I_CmsProjectDriver projectDriver = this.m_driverManager.getProjectDriver(dbc);
            for (CmsProject project : projectDriver.readProjects(dbc, deletedResourceRootPath)) {
                projectDriver.deleteProjectResource(dbc, project.getUuid(), deletedResourceRootPath);
                projectDriver.createProjectResource(dbc, project.getUuid(), destinationPath);
            }
        }
    }

    @Override
    public void publishResource(CmsDbContext dbc, CmsProject onlineProject, CmsResource onlineResource, CmsResource offlineResource) throws CmsDataAccessException {
        this.internalValidateResourceLength(offlineResource);
        int resourceSize = offlineResource.getLength();
        String resourcePath = CmsFileUtil.removeTrailingSeparator(offlineResource.getRootPath());
        try {
            Query q;
            boolean resourceExists = this.validateResourceIdExists(dbc, onlineProject.getUuid(), offlineResource.getResourceId());
            if (resourceExists) {
                q = this.m_sqlManager.createQuery(dbc, onlineProject, C_RESOURCES_UPDATE_RESOURCES);
                q.setParameter(1, (Object)offlineResource.getResourceId().toString());
                List res = q.getResultList();
                for (I_CmsDAOResources r : res) {
                    r.setResourceType(offlineResource.getTypeId());
                    r.setResourceFlags(offlineResource.getFlags());
                    r.setDateLastModified(offlineResource.getDateLastModified());
                    r.setUserLastModified(offlineResource.getUserLastModified().toString());
                    r.setResourceState(CmsResource.STATE_UNCHANGED.getState());
                    r.setResourceSize(resourceSize);
                    r.setDateContent(offlineResource.getDateContent());
                    r.setProjectLastModified(offlineResource.getProjectLastModified().toString());
                    r.setSiblingCount(this.countSiblings(dbc, onlineProject.getUuid(), onlineResource.getResourceId()));
                }
            } else {
                I_CmsDAOResources r = CmsProject.isOnlineProject(onlineProject.getUuid()) ? new CmsDAOOnlineResources() : new CmsDAOOfflineResources();
                r.setResourceId(offlineResource.getResourceId().toString());
                r.setResourceType(offlineResource.getTypeId());
                r.setResourceFlags(offlineResource.getFlags());
                r.setDateCreated(offlineResource.getDateCreated());
                r.setUserCreated(offlineResource.getUserCreated().toString());
                r.setDateLastModified(offlineResource.getDateLastModified());
                r.setUserLastModified(offlineResource.getUserLastModified().toString());
                r.setResourceState(CmsResource.STATE_UNCHANGED.getState());
                r.setResourceSize(resourceSize);
                r.setDateContent(offlineResource.getDateContent());
                r.setProjectLastModified(offlineResource.getProjectLastModified().toString());
                r.setSiblingCount(1);
                r.setResourceVersion(1);
                this.m_sqlManager.persist(dbc, r);
            }
            String parentId = this.internalReadParentId(dbc, onlineProject.getUuid(), resourcePath);
            if (this.validateStructureIdExists(dbc, onlineProject.getUuid(), offlineResource.getStructureId())) {
                q = this.m_sqlManager.createQuery(dbc, onlineProject, C_RESOURCES_UPDATE_STRUCTURE);
                q.setParameter(1, (Object)offlineResource.getStructureId().toString());
                List res = q.getResultList();
                for (I_CmsDAOStructure s : res) {
                    s.setResourceId(offlineResource.getResourceId().toString());
                    s.setResourcePath(resourcePath);
                    s.setStructureState(CmsResource.STATE_UNCHANGED.getState());
                    s.setDateReleased(offlineResource.getDateReleased());
                    s.setDateExpired(offlineResource.getDateExpired());
                    s.setParentId(parentId);
                }
            } else {
                PersistenceCapable s = CmsProject.isOnlineProject(onlineProject.getUuid()) ? new CmsDAOOnlineStructure() : new CmsDAOOfflineStructure();
                s.setStructureId(offlineResource.getStructureId().toString());
                s.setResourceId(offlineResource.getResourceId().toString());
                s.setResourcePath(resourcePath);
                s.setStructureState(CmsResource.STATE_UNCHANGED.getState());
                s.setDateReleased(offlineResource.getDateReleased());
                s.setDateExpired(offlineResource.getDateExpired());
                s.setParentId(parentId);
                s.setStructureVersion(resourceExists ? 1 : 0);
                this.m_sqlManager.persist(dbc, s);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void publishVersions(CmsDbContext dbc, CmsResource resource, boolean firstSibling) throws CmsDataAccessException {
        if (resource == null) {
            this.m_resOp.clear();
            return;
        }
        if (!dbc.getProjectId().isNullUUID() || dbc.currentProject().isOnlineProject()) {
            return;
        }
        if (firstSibling) {
            this.m_resOp.remove(resource.getResourceId());
        }
        boolean resOp = false;
        CmsResourceState resState = this.internalReadResourceState(dbc, dbc.currentProject().getUuid(), resource);
        CmsResourceState strState = this.internalReadStructureState(dbc, dbc.currentProject().getUuid(), resource);
        if (!resState.isUnchanged()) {
            resOp = strState.isDeleted() ? resState.isDeleted() || resource.getSiblingCount() == 1 || this.countSiblings(dbc, dbc.currentProject().getUuid(), resource.getResourceId()) == 1 : true;
        }
        if (!firstSibling) {
            if (resOp) {
                return;
            }
            if (this.m_resOp.contains(resource.getResourceId())) {
                return;
            }
        }
        Map<String, Integer> versions = this.readVersions(dbc, dbc.currentProject().getUuid(), resource.getResourceId(), resource.getStructureId());
        int strVersion = versions.get("structure");
        int resVersion = versions.get("resource");
        if (resOp) {
            if (resource.getSiblingCount() > 1) {
                this.m_resOp.add(resource.getResourceId());
            }
            ++resVersion;
        }
        if (!resOp) {
            ++strVersion;
        }
        try {
            List res;
            Query q;
            if (resOp) {
                q = this.m_sqlManager.createQuery(dbc, CmsProject.ONLINE_PROJECT_ID, C_RESOURCES_UPDATE_RESOURCE_VERSION);
                q.setParameter(1, (Object)resource.getResourceId().toString());
                res = q.getResultList();
                for (I_CmsDAOResources r : res) {
                    r.setResourceVersion(resVersion);
                }
            }
            if (!resOp || strState.isNew()) {
                q = this.m_sqlManager.createQuery(dbc, CmsProject.ONLINE_PROJECT_ID, C_RESOURCES_UPDATE_STRUCTURE_VERSION);
                q.setParameter(1, (Object)resource.getStructureId().toString());
                res = q.getResultList();
                for (I_CmsDAOStructure s : res) {
                    s.setStructureVersion(strVersion);
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public List<CmsAlias> readAliases(CmsDbContext dbc, CmsProject project, CmsAliasFilter filter) throws CmsDataAccessException {
        try {
            Query query = this.getAliasQueryForFilter(dbc, "SELECT alias FROM CmsDAOAlias alias ", filter);
            List resultList = query.getResultList();
            ArrayList<CmsAlias> result = new ArrayList<CmsAlias>();
            for (CmsDAOAlias bean : resultList) {
                result.add(new CmsAlias(new CmsUUID(bean.getStructureId()), bean.getSiteRoot(), bean.getAliasPath(), CmsAliasMode.fromInt(bean.getMode())));
            }
            return result;
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public List<CmsResource> readChildResources(CmsDbContext dbc, CmsProject currentProject, CmsResource resource, boolean getFolders, boolean getFiles) throws CmsDataAccessException {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        CmsUUID projectId = currentProject.getUuid();
        String resourceTypeClause = getFolders && getFiles ? null : (getFolders ? this.m_sqlManager.readQuery(projectId, C_RESOURCES_GET_SUBRESOURCES_GET_FOLDERS) : this.m_sqlManager.readQuery(projectId, C_RESOURCES_GET_SUBRESOURCES_GET_FILES));
        StringBuffer query = new StringBuffer();
        query.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_GET_SUBRESOURCES));
        if (resourceTypeClause != null) {
            query.append(' ');
            query.append(resourceTypeClause);
        }
        try {
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, query.toString());
            q.setParameter(1, (Object)resource.getStructureId().toString());
            List res = q.getResultList();
            for (Object[] o : res) {
                I_CmsDAOResources r = (I_CmsDAOResources)o[0];
                long size = r.getResourceSize();
                if (CmsFolder.isFolderSize(size)) {
                    result.add(this.createFolder(o, projectId, false));
                    continue;
                }
                result.add(this.createFile(o, projectId, false));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        Collections.sort(result, I_CmsResource.COMPARE_ROOT_PATH_IGNORE_CASE_FOLDERS_FIRST);
        return result;
    }

    @Override
    public byte[] readContent(CmsDbContext dbc, CmsUUID projectId, CmsUUID resourceId) throws CmsDataAccessException {
        byte[] byteRes = null;
        boolean resourceExists = false;
        try {
            if (projectId.equals(CmsProject.ONLINE_PROJECT_ID)) {
                Query q = this.m_sqlManager.createQuery(dbc, projectId, C_ONLINE_FILES_CONTENT);
                q.setParameter(1, (Object)resourceId.toString());
                try {
                    byteRes = ((CmsDAOContents)q.getSingleResult()).getFileContent();
                    resourceExists = true;
                }
                catch (NoResultException e) {}
            } else {
                CmsDAOOfflineContents c = this.m_sqlManager.find(dbc, CmsDAOOfflineContents.class, resourceId.toString());
                if (c != null) {
                    byteRes = c.getFileContent();
                    resourceExists = true;
                }
            }
            if (!resourceExists) {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_CONTENT_WITH_RESOURCE_ID_2", resourceId, projectId.equals(CmsProject.ONLINE_PROJECT_ID)));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return byteRes == null ? EMPTY_BLOB : byteRes;
    }

    @Override
    public CmsFolder readFolder(CmsDbContext dbc, CmsUUID projectId, CmsUUID folderId) throws CmsDataAccessException {
        CmsFolder folder = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_READBYID);
            q.setParameter(1, (Object)folderId.toString());
            try {
                Object[] o = (Object[])q.getSingleResult();
                folder = this.createFolder(o, projectId, true);
            }
            catch (NoResultException e) {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_FOLDER_WITH_ID_1", folderId));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return folder;
    }

    @Override
    public CmsFolder readFolder(CmsDbContext dbc, CmsUUID projectId, String folderPath) throws CmsDataAccessException {
        CmsFolder folder = null;
        folderPath = CmsFileUtil.removeTrailingSeparator(folderPath);
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_READ);
            q.setParameter(1, (Object)folderPath);
            try {
                Object[] o = (Object[])q.getSingleResult();
                folder = this.createFolder(o, projectId, true);
            }
            catch (NoResultException e) {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_FOLDER_1", dbc.removeSiteRoot(folderPath)));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return folder;
    }

    @Override
    public CmsFolder readParentFolder(CmsDbContext dbc, CmsUUID projectId, CmsUUID structureId) throws CmsDataAccessException {
        CmsFolder parent = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_READ_PARENT_BY_ID);
            q.setParameter(1, (Object)structureId.toString());
            try {
                Object[] o = (Object[])q.getSingleResult();
                parent = new CmsFolder(this.createResource(o, projectId));
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return parent;
    }

    @Override
    public CmsPropertyDefinition readPropertyDefinition(CmsDbContext dbc, String name, CmsUUID projectId) throws CmsDataAccessException {
        CmsPropertyDefinition propDef = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_PROPERTYDEF_READ);
            q.setParameter(1, (Object)name);
            try {
                I_CmsDAOPropertyDef pd = (I_CmsDAOPropertyDef)q.getSingleResult();
                propDef = new CmsPropertyDefinition(new CmsUUID(pd.getPropertyDefId()), pd.getPropertyDefName(), CmsPropertyDefinition.CmsPropertyType.valueOf(pd.getPropertyDefType()));
            }
            catch (NoResultException e) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_PROPERTYDEF_WITH_NAME_1", name));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return propDef;
    }

    @Override
    public List<CmsPropertyDefinition> readPropertyDefinitions(CmsDbContext dbc, CmsUUID projectId) throws CmsDataAccessException {
        ArrayList<CmsPropertyDefinition> propertyDefinitions = new ArrayList<CmsPropertyDefinition>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_PROPERTYDEF_READALL);
            List res = q.getResultList();
            for (I_CmsDAOPropertyDef pd : res) {
                propertyDefinitions.add(new CmsPropertyDefinition(new CmsUUID(pd.getPropertyDefId()), pd.getPropertyDefName(), CmsPropertyDefinition.CmsPropertyType.valueOf(pd.getPropertyDefType())));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return propertyDefinitions;
    }

    @Override
    public CmsProperty readPropertyObject(CmsDbContext dbc, String key, CmsProject project, CmsResource resource) throws CmsDataAccessException {
        CmsUUID projectId = dbc.getProjectId() == null || dbc.getProjectId().isNullUUID() ? project.getUuid() : dbc.getProjectId();
        String propertyValue = null;
        int mappingType = -1;
        CmsProperty property = null;
        int resultSize = 0;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_PROPERTIES_READ);
            q.setParameter(1, (Object)key);
            q.setParameter(2, (Object)resource.getStructureId().toString());
            q.setParameter(3, (Object)resource.getResourceId().toString());
            List res = q.getResultList();
            for (I_CmsDAOProperties o : res) {
                if (resultSize >= 2) {
                    throw new CmsDbConsistencyException(Messages.get().container("ERR_TOO_MANY_PROPERTIES_3", key, resource.getRootPath(), new Integer(resultSize)));
                }
                if (property == null) {
                    property = new CmsProperty();
                    property.setName(key);
                }
                propertyValue = o.getPropertyValue();
                mappingType = o.getPropertyMappingType();
                if (mappingType == 1) {
                    property.setStructureValue(propertyValue);
                } else if (mappingType == 2) {
                    property.setResourceValue(propertyValue);
                } else {
                    throw new CmsDbConsistencyException(Messages.get().container("ERR_UNKNOWN_PROPERTY_VALUE_MAPPING_3", resource.getRootPath(), new Integer(mappingType), key));
                }
                ++resultSize;
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return property != null ? property : CmsProperty.getNullProperty();
    }

    @Override
    public List<CmsProperty> readPropertyObjects(CmsDbContext dbc, CmsProject project, CmsResource resource) throws CmsDataAccessException {
        CmsUUID projectId = dbc.getProjectId() == null || dbc.getProjectId().isNullUUID() ? project.getUuid() : dbc.getProjectId();
        int mappingType = -1;
        HashMap<String, CmsProperty> propertyMap = new HashMap<String, CmsProperty>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_PROPERTIES_READALL);
            q.setParameter(1, (Object)resource.getStructureId().toString());
            q.setParameter(2, (Object)resource.getResourceId().toString());
            List res = q.getResultList();
            for (Object[] o : res) {
                String propertyKey = null;
                String propertyValue = null;
                mappingType = -1;
                propertyKey = ((I_CmsDAOPropertyDef)o[0]).getPropertyDefName();
                propertyValue = ((I_CmsDAOProperties)o[1]).getPropertyValue();
                mappingType = ((I_CmsDAOProperties)o[1]).getPropertyMappingType();
                CmsProperty property = (CmsProperty)propertyMap.get(propertyKey);
                if (property == null) {
                    property = new CmsProperty();
                    property.setName(propertyKey);
                    propertyMap.put(propertyKey, property);
                }
                if (mappingType == 1) {
                    property.setStructureValue(propertyValue);
                } else if (mappingType == 2) {
                    property.setResourceValue(propertyValue);
                } else {
                    throw new CmsDbConsistencyException(Messages.get().container("ERR_UNKNOWN_PROPERTY_VALUE_MAPPING_3", resource.getRootPath(), new Integer(mappingType), propertyKey));
                }
                property.setOrigin(resource.getRootPath());
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return new ArrayList<CmsProperty>(propertyMap.values());
    }

    @Override
    public List<CmsRelation> readRelations(CmsDbContext dbc, CmsUUID projectId, CmsResource resource, CmsRelationFilter filter) throws CmsDataAccessException {
        HashSet<CmsRelation> relations = new HashSet<CmsRelation>();
        try {
            Query q;
            StringBuffer queryBuf;
            ArrayList<Object> params;
            if (filter.isSource()) {
                params = new ArrayList<Object>(7);
                queryBuf = new StringBuffer(256);
                queryBuf.append(this.m_sqlManager.readQuery(projectId, C_READ_RELATIONS));
                queryBuf.append(this.prepareRelationConditions(projectId, filter, resource, params, true));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)queryBuf.toString());
                }
                q = this.m_sqlManager.createQueryFromJPQL(dbc, queryBuf.toString());
                for (int i = 0; i < params.size(); ++i) {
                    q.setParameter(i + 1, params.get(i));
                }
                List res = q.getResultList();
                for (I_CmsDAOResourceRelations rr : res) {
                    relations.add(this.internalReadRelation(rr));
                }
            }
            if (filter.isTarget()) {
                params = new ArrayList(7);
                queryBuf = new StringBuffer(256);
                queryBuf.append(this.m_sqlManager.readQuery(projectId, C_READ_RELATIONS));
                queryBuf.append(this.prepareRelationConditions(projectId, filter, resource, params, false));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)queryBuf.toString());
                }
                q = this.m_sqlManager.createQueryFromJPQL(dbc, queryBuf.toString());
                for (int i = 0; i < params.size(); ++i) {
                    q.setParameter(i + 1, params.get(i));
                }
                List res = q.getResultList();
                for (I_CmsDAOResourceRelations rr : res) {
                    relations.add(this.internalReadRelation(rr));
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        ArrayList<CmsRelation> result = new ArrayList<CmsRelation>(relations);
        Collections.sort(result, CmsRelation.COMPARATOR);
        return result;
    }

    @Override
    public CmsResource readResource(CmsDbContext dbc, CmsUUID projectId, CmsUUID structureId, boolean includeDeleted) throws CmsDataAccessException {
        CmsResource resource = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_READBYID);
            q.setParameter(1, (Object)structureId.toString());
            try {
                Object[] o = (Object[])q.getSingleResult();
                resource = this.createResource(o, projectId);
            }
            catch (NoResultException e) {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_RESOURCE_WITH_ID_1", structureId));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        if (resource != null && resource.getState().isDeleted() && !includeDeleted) {
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_DELETED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())));
        }
        return resource;
    }

    @Override
    public CmsResource readResource(CmsDbContext dbc, CmsUUID projectId, String path, boolean includeDeleted) throws CmsDataAccessException {
        CmsResource resource = null;
        path = CmsFileUtil.removeTrailingSeparator(path);
        boolean endsWithSlash = path.endsWith("/");
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_READ);
            q.setParameter(1, (Object)path);
            try {
                Object[] o = (Object[])q.getSingleResult();
                resource = this.createResource(o, projectId);
                if (endsWithSlash && resource.isFile()) {
                    throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_RESOURCE_1", dbc.removeSiteRoot(path + "/")));
                }
            }
            catch (NoResultException e) {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_RESOURCE_1", dbc.removeSiteRoot(path)));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        if (resource != null && resource.getState().isDeleted() && !includeDeleted) {
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_DELETED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())));
        }
        return resource;
    }

    @Override
    public List<CmsResource> readResources(CmsDbContext dbc, CmsUUID projectId, CmsResourceState state, int mode) throws CmsDataAccessException {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        try {
            Query q;
            if (mode == 1) {
                q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_GET_RESOURCE_IN_PROJECT_WITH_STATE);
                q.setParameter(1, (Object)projectId.toString());
                q.setParameter(2, (Object)state.getState());
                q.setParameter(3, (Object)state.getState());
                q.setParameter(4, (Object)state.getState());
                q.setParameter(5, (Object)state.getState());
            } else if (mode == 2) {
                q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_GET_RESOURCE_IN_PROJECT_WITHOUT_STATE);
                q.setParameter(1, (Object)projectId.toString());
                q.setParameter(2, (Object)state.getState());
                q.setParameter(3, (Object)state.getState());
            } else {
                q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_GET_RESOURCE_IN_PROJECT_IGNORE_STATE);
                q.setParameter(1, (Object)projectId.toString());
            }
            List res = q.getResultList();
            for (Object[] o : res) {
                CmsResource resource = this.createResource(o, projectId);
                result.add(resource);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return result;
    }

    @Override
    public List<CmsResource> readResourcesForPrincipalACE(CmsDbContext dbc, CmsProject project, CmsUUID principalId) throws CmsDataAccessException {
        CmsFile currentResource = null;
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, project, C_SELECT_RESOURCES_FOR_PRINCIPAL_ACE);
            q.setParameter(1, (Object)principalId.toString());
            List res = q.getResultList();
            for (Object[] o : res) {
                currentResource = this.createFile(o, project.getUuid(), false);
                resources.add(currentResource);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return resources;
    }

    @Override
    public List<CmsResource> readResourcesForPrincipalAttr(CmsDbContext dbc, CmsProject project, CmsUUID principalId) throws CmsDataAccessException {
        CmsFile currentResource = null;
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        try {
            String[] queries = new String[]{C_SELECT_RESOURCES_FOR_PRINCIPAL_ATTR1, C_SELECT_RESOURCES_FOR_PRINCIPAL_ATTR2};
            String[] parameters = new String[]{principalId.toString(), principalId.toString()};
            for (int i = 0; i < queries.length; ++i) {
                Query q = this.m_sqlManager.createQuery(dbc, project, queries[i]);
                q.setParameter(1, (Object)parameters[i]);
                List res = q.getResultList();
                for (Object[] o : res) {
                    currentResource = this.createFile(o, project.getUuid(), false);
                    resources.add(currentResource);
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return resources;
    }

    @Override
    public List<CmsResource> readResourcesWithProperty(CmsDbContext dbc, CmsUUID projectId, CmsUUID propertyDef, String path, String value) throws CmsDataAccessException {
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        ArrayList res = new ArrayList();
        try {
            Query q;
            if (value == null) {
                q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_GET_RESOURCE_WITH_PROPERTYDEF);
                q.setParameter(1, (Object)propertyDef.toString());
                q.setParameter(2, (Object)CmsVfsDriver.escapeDbWildcard(path + "%"));
                res.addAll(q.getResultList());
            } else {
                q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_GET_RESOURCE_WITH_PROPERTYDEF_VALUE);
                q.setParameter(1, (Object)propertyDef.toString());
                q.setParameter(2, (Object)CmsVfsDriver.escapeDbWildcard(path + "%"));
                q.setParameter(3, (Object)("%" + value + "%"));
                q.setParameter(4, (Object)CmsVfsDriver.escapeDbWildcard(path + "%"));
                q.setParameter(5, (Object)("%" + value + "%"));
                res.addAll(q.getResultList());
            }
            for (Object[] o : res) {
                CmsResource resource = this.createResource(o, projectId);
                resources.add(resource);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return resources;
    }

    @Override
    public List<CmsResource> readResourceTree(CmsDbContext dbc, CmsUUID projectId, String parentPath, int type, CmsResourceState state, long lastModifiedAfter, long lastModifiedBefore, long releasedAfter, long releasedBefore, long expiredAfter, long expiredBefore, int mode) throws CmsDataAccessException {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        StringBuffer conditions = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>(5);
        this.prepareProjectCondition(projectId, mode, conditions, params);
        this.prepareResourceCondition(projectId, mode, conditions);
        this.prepareTypeCondition(projectId, type, mode, conditions, params);
        this.prepareTimeRangeCondition(projectId, lastModifiedAfter, lastModifiedBefore, conditions, params);
        this.prepareReleasedTimeRangeCondition(projectId, releasedAfter, releasedBefore, conditions, params);
        this.prepareExpiredTimeRangeCondition(projectId, expiredAfter, expiredBefore, conditions, params);
        this.preparePathCondition(projectId, parentPath, mode, conditions, params);
        this.prepareStateCondition(projectId, state, mode, conditions, params);
        try {
            StringBuffer queryBuf = new StringBuffer(256);
            queryBuf.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_READ_TREE));
            queryBuf.append(conditions);
            queryBuf.append(" ");
            queryBuf.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_ORDER_BY_PATH));
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, queryBuf.toString());
            for (int i = 0; i < params.size(); ++i) {
                q.setParameter(i + 1, params.get(i));
            }
            List res = q.getResultList();
            for (Object[] o : res) {
                CmsResource resource = this.createResource(o, projectId);
                result.add(resource);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return result;
    }

    @Override
    public List<CmsRewriteAlias> readRewriteAliases(CmsDbContext dbc, CmsRewriteAliasFilter filter) throws CmsDataAccessException {
        try {
            String baseQuery = this.m_sqlManager.readQuery("C_READ_REWRITES");
            CmsPair<String, List<Object>> queryAndParams = this.prepareRewriteAliasConditions("rewriteAlias", filter);
            String condition = queryAndParams.getFirst();
            List<Object> params = queryAndParams.getSecond();
            String fullQuery = baseQuery + condition;
            Query q = this.m_sqlManager.createQueryWithParametersFromJPQL(dbc, fullQuery, params);
            ArrayList results = new ArrayList(q.getResultList());
            ArrayList<CmsRewriteAlias> convertedResults = new ArrayList<CmsRewriteAlias>();
            for (CmsDAORewriteAlias bean : results) {
                CmsRewriteAlias alias = new CmsRewriteAlias(new CmsUUID(bean.getId()), bean.getSiteRoot(), bean.getPattern(), bean.getReplacement(), CmsAliasMode.fromInt(bean.getMode()));
                convertedResults.add(alias);
            }
            return convertedResults;
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public List<CmsResource> readSiblings(CmsDbContext dbc, CmsUUID projectId, CmsResource resource, boolean includeDeleted) throws CmsDataAccessException {
        CmsFile currentResource = null;
        ArrayList<CmsResource> vfsLinks = new ArrayList<CmsResource>();
        try {
            Query q = includeDeleted ? this.m_sqlManager.createQuery(dbc, projectId, C_SELECT_VFS_SIBLINGS) : this.m_sqlManager.createQuery(dbc, projectId, C_SELECT_NONDELETED_VFS_SIBLINGS);
            q.setParameter(1, (Object)resource.getResourceId().toString());
            List res = q.getResultList();
            for (Object[] o : res) {
                currentResource = this.createFile(o, projectId, false);
                vfsLinks.add(currentResource);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return vfsLinks;
    }

    @Override
    public List<CmsUrlNameMappingEntry> readUrlNameMappingEntries(CmsDbContext dbc, boolean online, CmsUrlNameMappingFilter filter) throws CmsDataAccessException {
        ArrayList<CmsUrlNameMappingEntry> result = new ArrayList<CmsUrlNameMappingEntry>();
        try {
            String query = this.m_sqlManager.readQuery(C_READ_URLNAME_MAPPINGS);
            Query q = this.getQueryForFilter(dbc, query, filter, online);
            List res = q.getResultList();
            for (I_CmsDAOUrlNameMappings m : res) {
                CmsUrlNameMappingEntry entry = this.internalCreateUrlNameMappingEntry(m);
                result.add(entry);
            }
            return result;
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public Map<String, Integer> readVersions(CmsDbContext dbc, CmsUUID projectId, CmsUUID resourceId, CmsUUID structureId) throws CmsDataAccessException {
        int structureVersion = -1;
        int resourceVersion = -1;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_READ_VERSION_RES);
            q.setParameter(1, (Object)resourceId.toString());
            try {
                resourceVersion = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            }
            catch (NoResultException e) {
                // empty catch block
            }
            q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_READ_VERSION_STR);
            q.setParameter(1, (Object)structureId.toString());
            try {
                structureVersion = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("structure", new Integer(structureVersion));
        result.put("resource", new Integer(resourceVersion));
        return result;
    }

    @Override
    public void removeFile(CmsDbContext dbc, CmsUUID projectId, CmsResource resource) throws CmsDataAccessException {
        int siblingCount = 0;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_STRUCTURE_DELETE_BY_STRUCTUREID);
            q.setParameter(1, (Object)resource.getStructureId().toString());
            List res = q.getResultList();
            for (I_CmsDAOStructure ps : res) {
                this.m_sqlManager.remove(dbc, ps);
            }
            siblingCount = this.countSiblings(dbc, projectId, resource.getResourceId());
            if (siblingCount > 0) {
                q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_UPDATE_SIBLING_COUNT);
                q.setParameter(1, (Object)resource.getResourceId().toString());
                List ress = q.getResultList();
                for (I_CmsDAOResources r : ress) {
                    r.setSiblingCount(siblingCount);
                }
                q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_UPDATE_FLAGS);
                q.setParameter(1, (Object)resource.getResourceId().toString());
                List resf = q.getResultList();
                for (I_CmsDAOResources r : resf) {
                    r.setResourceFlags(resource.getFlags());
                }
            } else {
                boolean dbcHasProjectId;
                q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_DELETE_BY_RESOURCEID);
                q.setParameter(1, (Object)resource.getResourceId().toString());
                List res1 = q.getResultList();
                for (I_CmsDAOResources pr : res1) {
                    this.m_sqlManager.remove(dbc, pr);
                }
                boolean bl = dbcHasProjectId = dbc.getProjectId() != null && !dbc.getProjectId().isNullUUID();
                if (projectId.equals(CmsProject.ONLINE_PROJECT_ID)) {
                    q = this.m_sqlManager.createQuery(dbc, C_ONLINE_CONTENTS_HISTORY);
                    q.setParameter(1, (Object)resource.getResourceId().toString());
                    List res2 = q.getResultList();
                    for (CmsDAOContents c : res2) {
                        c.setOnlineFlag(0);
                    }
                } else if (dbcHasProjectId) {
                    q = this.m_sqlManager.createQuery(dbc, C_ONLINE_CONTENTS_DELETE);
                    q.setParameter(1, (Object)resource.getResourceId().toString());
                    q.executeUpdate();
                } else {
                    q = this.m_sqlManager.createQuery(dbc, C_OFFLINE_FILE_CONTENT_DELETE);
                    q.setParameter(1, (Object)resource.getResourceId().toString());
                    q.executeUpdate();
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void removeFolder(CmsDbContext dbc, CmsProject currentProject, CmsResource resource) throws CmsDataAccessException {
        if (dbc.getRequestContext() != null && dbc.getRequestContext().getAttribute("CHECK_PERMISSIONS") != null) {
            this.checkWritePermissionsInFolder(dbc, resource);
            return;
        }
        Iterator<CmsResource> childResources = this.readChildResources(dbc, currentProject, resource, true, true).iterator();
        CmsUUID projectId = CmsProject.ONLINE_PROJECT_ID;
        if (currentProject.isOnlineProject()) {
            projectId = CmsUUID.getOpenCmsUUID();
        }
        StringBuffer errorResNames = new StringBuffer(128);
        while (childResources.hasNext()) {
            boolean error;
            CmsResource errorRes = childResources.next();
            boolean bl = error = !currentProject.isOnlineProject();
            if (!error) {
                try {
                    String originalPath = this.m_driverManager.getVfsDriver().readResource(dbc, projectId, errorRes.getRootPath(), true).getRootPath();
                    error = originalPath.equals(errorRes.getRootPath()) || originalPath.startsWith(resource.getRootPath());
                }
                catch (CmsVfsResourceNotFoundException e) {
                    // empty catch block
                }
            }
            if (!error) continue;
            if (errorResNames.length() != 0) {
                errorResNames.append(", ");
            }
            errorResNames.append("[" + dbc.removeSiteRoot(errorRes.getRootPath()) + "]");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(errorResNames.toString())) {
            throw new CmsVfsException(Messages.get().container("ERR_DELETE_NONEMTY_FOLDER_2", dbc.removeSiteRoot(resource.getRootPath()), errorResNames.toString()));
        }
        this.internalRemoveFolder(dbc, currentProject, resource);
        String deletedResourceRootPath = resource.getRootPath();
        if (dbc.getRequestContext() != null) {
            dbc.getRequestContext().setAttribute("DBC_ATTR_READ_PROJECT_FOR_RESOURCE", Boolean.TRUE);
            I_CmsProjectDriver projectDriver = this.m_driverManager.getProjectDriver(dbc);
            for (CmsProject project : projectDriver.readProjects(dbc, deletedResourceRootPath)) {
                projectDriver.deleteProjectResource(dbc, project.getUuid(), deletedResourceRootPath);
            }
        }
    }

    @Override
    public void replaceResource(CmsDbContext dbc, CmsResource newResource, byte[] resContent, int newResourceType) throws CmsDataAccessException {
        if (resContent == null) {
            return;
        }
        try {
            this.writeContent(dbc, newResource.getResourceId(), resContent);
            Query q = this.m_sqlManager.createQuery(dbc, dbc.currentProject(), C_RESOURCE_REPLACE);
            q.setParameter(1, (Object)newResource.getResourceId().toString());
            List res = q.getResultList();
            for (I_CmsDAOResources r : res) {
                r.setResourceType(newResourceType);
                r.setResourceSize(resContent.length);
                r.setDateContent(System.currentTimeMillis());
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void setDriverManager(CmsDriverManager driverManager) {
        this.m_driverManager = driverManager;
    }

    @Override
    public void setSqlManager(org.opencms.db.CmsSqlManager sqlManager) {
        this.m_sqlManager = (CmsSqlManager)sqlManager;
    }

    @Override
    public void transferResource(CmsDbContext dbc, CmsProject project, CmsResource resource, CmsUUID createdUser, CmsUUID lastModifiedUser) throws CmsDataAccessException {
        if (createdUser == null) {
            createdUser = resource.getUserCreated();
        }
        if (lastModifiedUser == null) {
            lastModifiedUser = resource.getUserLastModified();
        }
        try {
            Query q = this.m_sqlManager.createQuery(dbc, project, C_RESOURCES_TRANSFER_RESOURCE);
            q.setParameter(1, (Object)resource.getResourceId().toString());
            List res = q.getResultList();
            for (I_CmsDAOResources r : res) {
                r.setUserCreated(createdUser.toString());
                r.setUserLastModified(lastModifiedUser.toString());
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void updateRelations(CmsDbContext dbc, CmsProject onlineProject, CmsResource offlineResource) throws CmsDataAccessException {
        I_CmsVfsDriver vfsDriver = this.m_driverManager.getVfsDriver(dbc);
        vfsDriver.deleteRelations(dbc, onlineProject.getUuid(), offlineResource, CmsRelationFilter.TARGETS);
        CmsUUID projectId = !dbc.getProjectId().isNullUUID() ? CmsProject.ONLINE_PROJECT_ID : dbc.currentProject().getUuid();
        CmsUUID dbcProjectId = dbc.getProjectId();
        dbc.setProjectId(CmsUUID.getNullUUID());
        Iterator<CmsRelation> itRelations = this.m_driverManager.getVfsDriver(dbc).readRelations(dbc, projectId, offlineResource, CmsRelationFilter.TARGETS).iterator();
        dbc.setProjectId(dbcProjectId);
        while (itRelations.hasNext()) {
            vfsDriver.createRelation(dbc, onlineProject.getUuid(), itRelations.next());
        }
    }

    @Override
    public boolean validateResourceIdExists(CmsDbContext dbc, CmsUUID projectId, CmsUUID resourceId) throws CmsDataAccessException {
        boolean exists = false;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_READ_RESOURCE_STATE);
            q.setParameter(1, (Object)resourceId.toString());
            try {
                int state = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
                exists = true;
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return exists;
    }

    @Override
    public boolean validateStructureIdExists(CmsDbContext dbc, CmsUUID projectId, CmsUUID structureId) throws CmsDataAccessException {
        boolean found = false;
        int count = 0;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_SELECT_STRUCTURE_ID);
            q.setParameter(1, (Object)structureId.toString());
            try {
                count = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
                found = count == 1;
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return found;
    }

    @Override
    public void writeContent(CmsDbContext dbc, CmsUUID resourceId, byte[] content) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, dbc.currentProject(), C_OFFLINE_CONTENTS_UPDATE);
            q.setParameter(1, (Object)resourceId.toString());
            List res = q.getResultList();
            for (CmsDAOOfflineContents oc : res) {
                oc.setFileContent(content);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writeLastModifiedProjectId(CmsDbContext dbc, CmsProject project, CmsUUID projectId, CmsResource resource) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, project, C_RESOURCES_UPDATE_PROJECT_LASTMODIFIED);
            q.setParameter(1, (Object)resource.getResourceId().toString());
            List res = q.getResultList();
            for (I_CmsDAOResources r : res) {
                r.setProjectLastModified(projectId.toString());
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writePropertyObject(CmsDbContext dbc, CmsProject project, CmsResource resource, CmsProperty property) throws CmsDataAccessException {
        CmsUUID projectId = dbc.getProjectId() == null || dbc.getProjectId().isNullUUID() ? project.getUuid() : dbc.getProjectId();
        CmsPropertyDefinition propertyDefinition = null;
        try {
            propertyDefinition = this.readPropertyDefinition(dbc, property.getName(), projectId);
        }
        catch (CmsDbEntryNotFoundException e) {
            if (property.autoCreatePropertyDefinition()) {
                propertyDefinition = this.createPropertyDefinition(dbc, projectId, property.getName(), CmsPropertyDefinition.TYPE_NORMAL);
                try {
                    this.readPropertyDefinition(dbc, property.getName(), CmsProject.ONLINE_PROJECT_ID);
                }
                catch (CmsDataAccessException e1) {
                    this.createPropertyDefinition(dbc, CmsProject.ONLINE_PROJECT_ID, property.getName(), CmsPropertyDefinition.TYPE_NORMAL);
                }
                try {
                    this.m_driverManager.getHistoryDriver(dbc).readPropertyDefinition(dbc, property.getName());
                }
                catch (CmsDataAccessException e1) {
                    this.m_driverManager.getHistoryDriver(dbc).createPropertyDefinition(dbc, property.getName(), CmsPropertyDefinition.TYPE_NORMAL);
                }
                OpenCms.fireCmsEvent(new CmsEvent(28, Collections.singletonMap("propertyDefinition", propertyDefinition)));
            }
            throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_PROPERTYDEF_WITH_NAME_1", property.getName()));
        }
        try {
            CmsProperty existingProperty = this.readPropertyObject(dbc, propertyDefinition.getName(), project, resource);
            if (existingProperty.isIdentical(property)) {
                return;
            }
            for (int i = 0; i < 2; ++i) {
                List res;
                Query q;
                int mappingType = -1;
                String value = null;
                CmsUUID id = null;
                boolean existsPropertyValue = false;
                boolean deletePropertyValue = false;
                if (i == 0) {
                    if (existingProperty.getStructureValue() != null && property.isDeleteStructureValue()) {
                        deletePropertyValue = true;
                    } else {
                        value = property.getStructureValue();
                        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) continue;
                    }
                    mappingType = 1;
                    id = resource.getStructureId();
                    existsPropertyValue = existingProperty.getStructureValue() != null;
                } else {
                    if (existingProperty.getResourceValue() != null && property.isDeleteResourceValue()) {
                        deletePropertyValue = true;
                    } else {
                        value = property.getResourceValue();
                        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) break;
                    }
                    mappingType = 2;
                    id = resource.getResourceId();
                    boolean bl = existsPropertyValue = existingProperty.getResourceValue() != null;
                }
                if (!deletePropertyValue) {
                    if (existsPropertyValue) {
                        q = this.m_sqlManager.createQuery(dbc, projectId, C_PROPERTIES_UPDATE);
                        q.setParameter(1, (Object)id.toString());
                        q.setParameter(2, (Object)mappingType);
                        q.setParameter(3, (Object)propertyDefinition.getId().toString());
                        res = q.getResultList();
                        for (I_CmsDAOProperties p : res) {
                            p.setPropertyValue(this.m_sqlManager.validateEmpty(value));
                        }
                        continue;
                    }
                    I_CmsDAOProperties p = CmsProject.isOnlineProject(project.getUuid()) ? new CmsDAOOnlineProperties() : new CmsDAOOfflineProperties();
                    p.setPropertyId(new CmsUUID().toString());
                    p.setPropertyDefId(propertyDefinition.getId().toString());
                    p.setPropertyMappingId(id.toString());
                    p.setPropertyMappingType(mappingType);
                    p.setPropertyValue(this.m_sqlManager.validateEmpty(value));
                    this.m_sqlManager.persist(dbc, p);
                    continue;
                }
                q = this.m_sqlManager.createQuery(dbc, projectId, C_PROPERTIES_DELETE);
                q.setParameter(1, (Object)propertyDefinition.getId().toString());
                q.setParameter(2, (Object)id.toString());
                q.setParameter(3, (Object)mappingType);
                res = q.getResultList();
                for (I_CmsDAOProperties pr : res) {
                    this.m_sqlManager.remove(dbc, pr);
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writePropertyObjects(CmsDbContext dbc, CmsProject project, CmsResource resource, List<CmsProperty> properties) throws CmsDataAccessException {
        for (CmsProperty property : properties) {
            this.writePropertyObject(dbc, project, resource, property);
        }
    }

    @Override
    public void writeResource(CmsDbContext dbc, CmsUUID projectId, CmsResource resource, int changed) throws CmsDataAccessException {
        this.internalValidateResourceLength(resource);
        String resourcePath = CmsFileUtil.removeTrailingSeparator(resource.getRootPath());
        long resourceDateModified = resource.isTouched() ? resource.getDateLastModified() : System.currentTimeMillis();
        CmsResourceState structureState = resource.getState();
        CmsResourceState resourceState = resource.getState();
        CmsResourceState structureStateOld = this.internalReadStructureState(dbc, projectId, resource);
        CmsResourceState resourceStateOld = this.internalReadResourceState(dbc, projectId, resource);
        CmsUUID projectLastModified = projectId;
        if (changed == 1) {
            resourceState = resourceStateOld;
            resourceState = resourceState.isNew() ? CmsResource.STATE_NEW : CmsResource.STATE_CHANGED;
            structureState = structureStateOld;
        } else if (changed == 2) {
            structureState = structureStateOld;
            structureState = structureState.isNew() ? CmsResource.STATE_NEW : CmsResource.STATE_CHANGED;
        } else if (changed == 0) {
            projectLastModified = resource.getProjectLastModified();
        } else {
            resourceState = resourceStateOld;
            resourceState = resourceState.isNew() ? CmsResource.STATE_NEW : CmsResource.STATE_CHANGED;
            structureState = structureStateOld;
            structureState = structureState.isNew() ? CmsResource.STATE_NEW : CmsResource.STATE_CHANGED;
        }
        try {
            List res;
            Query q;
            if (changed != 2) {
                q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_UPDATE_RESOURCES);
                q.setParameter(1, (Object)resource.getResourceId().toString());
                res = q.getResultList();
                for (I_CmsDAOResources r : res) {
                    r.setResourceType(resource.getTypeId());
                    r.setResourceFlags(resource.getFlags());
                    r.setDateLastModified(resourceDateModified);
                    r.setUserLastModified(resource.getUserLastModified().toString());
                    r.setResourceState(resourceState.getState());
                    r.setResourceSize(resource.getLength());
                    r.setDateContent(resource.getDateContent());
                    r.setProjectLastModified(projectLastModified.toString());
                    r.setSiblingCount(this.countSiblings(dbc, projectId, resource.getResourceId()));
                }
            } else {
                q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_UPDATE_RESOURCES_WITHOUT_STATE);
                q.setParameter(1, (Object)resource.getResourceId().toString());
                res = q.getResultList();
                for (I_CmsDAOResources r : res) {
                    r.setResourceType(resource.getTypeId());
                    r.setResourceFlags(resource.getFlags());
                    r.setDateLastModified(resourceDateModified);
                    r.setUserLastModified(resource.getUserLastModified().toString());
                    r.setResourceSize(resource.getLength());
                    r.setDateContent(resource.getDateContent());
                    r.setProjectLastModified(projectLastModified.toString());
                    r.setSiblingCount(this.countSiblings(dbc, projectId, resource.getResourceId()));
                }
            }
            String parentId = this.internalReadParentId(dbc, projectId, resourcePath);
            q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_UPDATE_STRUCTURE);
            q.setParameter(1, (Object)resource.getStructureId().toString());
            List res2 = q.getResultList();
            for (I_CmsDAOStructure s : res2) {
                s.setResourceId(resource.getResourceId().toString());
                s.setResourcePath(resourcePath);
                s.setStructureState(structureState.getState());
                s.setDateReleased(resource.getDateReleased());
                s.setDateExpired(resource.getDateExpired());
                s.setParentId(parentId);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writeResourceState(CmsDbContext dbc, CmsProject project, CmsResource resource, int changed, boolean isPublishing) throws CmsDataAccessException {
        if (project.getUuid().equals(CmsProject.ONLINE_PROJECT_ID)) {
            return;
        }
        try {
            List res;
            Query q;
            if (changed == 6) {
                q = this.m_sqlManager.createQuery(dbc, project, C_RESOURCES_UPDATE_RESOURCE_PROJECT);
                q.setParameter(1, (Object)resource.getResourceId().toString());
                List resr = q.getResultList();
                for (I_CmsDAOResources r : resr) {
                    r.setResourceFlags(resource.getFlags());
                    r.setProjectLastModified(project.getUuid().toString());
                }
            }
            if (changed == 4) {
                q = this.m_sqlManager.createQuery(dbc, project, C_RESOURCES_UPDATE_RESOURCE_STATELASTMODIFIED);
                q.setParameter(1, (Object)resource.getResourceId().toString());
                res = q.getResultList();
                for (I_CmsDAOResources r : res) {
                    r.setResourceState(resource.getState().getState());
                    r.setDateLastModified(resource.getDateLastModified());
                    r.setUserLastModified(resource.getUserLastModified().toString());
                    r.setProjectLastModified(project.getUuid().toString());
                }
            }
            if (changed == 1 || changed == 3) {
                q = this.m_sqlManager.createQuery(dbc, project, C_RESOURCES_UPDATE_RESOURCE_STATE);
                q.setParameter(1, (Object)resource.getResourceId().toString());
                res = q.getResultList();
                for (I_CmsDAOResources r : res) {
                    r.setResourceState(resource.getState().getState());
                    r.setProjectLastModified(project.getUuid().toString());
                }
            }
            if (changed == 5 || changed == 3 || changed == 2) {
                q = this.m_sqlManager.createQuery(dbc, project, C_RESOURCES_UPDATE_STRUCTURE_STATE);
                q.setParameter(1, (Object)resource.getStructureId().toString());
                res = q.getResultList();
                for (I_CmsDAOStructure s : res) {
                    s.setStructureState(resource.getState().getState());
                }
            }
            if (changed == 5 || changed == 3) {
                q = this.m_sqlManager.createQuery(dbc, project, C_RESOURCES_UPDATE_RELEASE_EXPIRED);
                q.setParameter(1, (Object)resource.getStructureId().toString());
                res = q.getResultList();
                for (I_CmsDAOStructure s : res) {
                    s.setDateReleased(resource.getDateReleased());
                    s.setDateExpired(resource.getDateExpired());
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        if (isPublishing) {
            this.internalUpdateVersions(dbc, resource);
        }
    }

    protected void checkWritePermissionsInFolder(CmsDbContext dbc, CmsResource folder) throws CmsDataAccessException {
        CmsUUID projectId = dbc.getRequestContext().getCurrentProject().getUuid();
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_READ_WITH_ACE_1);
            q.setParameter(1, (Object)CmsVfsDriver.escapeDbWildcard(folder.getRootPath() + "%"));
            List res = q.getResultList();
            for (Object[] o : res) {
                resources.add(this.createResource(o, projectId));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        for (CmsResource resource : resources) {
            try {
                this.m_driverManager.getSecurityManager().checkPermissions(dbc.getRequestContext(), resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
            }
            catch (CmsException e) {
                throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
            }
        }
        CmsResourceFilter filter = CmsResourceFilter.ALL;
        for (CmsResource resource : this.readTypesInResourceTree(dbc, projectId, folder.getRootPath(), CmsResourceTypeJsp.getJspResourceTypeIds(), filter.getState(), filter.getModifiedAfter(), filter.getModifiedBefore(), filter.getReleaseAfter(), filter.getReleaseBefore(), filter.getExpireAfter(), filter.getExpireBefore(), 0)) {
            try {
                this.m_driverManager.getSecurityManager().checkPermissions(dbc.getRequestContext(), resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
            }
            catch (CmsException e) {
                throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
            }
        }
    }

    protected int internalCountProperties(CmsDbContext dbc, CmsPropertyDefinition propertyDefinition, CmsUUID projectId) throws CmsDataAccessException {
        int count = 0;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_PROPERTIES_READALL_COUNT);
            q.setParameter(1, (Object)propertyDefinition.getId().toString());
            try {
                count = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            }
            catch (NoResultException e) {
                throw new CmsDbConsistencyException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", propertyDefinition.getName()));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return count;
    }

    protected CmsUrlNameMappingEntry internalCreateUrlNameMappingEntry(I_CmsDAOUrlNameMappings m) {
        String name = m.getName();
        CmsUUID structureId = new CmsUUID(m.getStructureId());
        int state = m.getState();
        long dateChanged = m.getDateChanged();
        String locale = m.getLocale();
        return new CmsUrlNameMappingEntry(name, structureId, state, dateChanged, locale);
    }

    protected String internalReadParentId(CmsDbContext dbc, CmsUUID projectId, String resourcename) throws CmsDataAccessException {
        if ("/".equalsIgnoreCase(resourcename)) {
            return CmsUUID.getNullUUID().toString();
        }
        String parent = CmsResource.getParentFolder(resourcename);
        parent = CmsFileUtil.removeTrailingSeparator(parent);
        String parentId = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RESOURCES_READ_PARENT_STRUCTURE_ID);
            q.setParameter(1, (Object)parent);
            try {
                parentId = (String)q.getSingleResult();
            }
            catch (NoResultException e) {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_PARENT_ID_1", dbc.removeSiteRoot(resourcename)));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return parentId;
    }

    protected CmsRelation internalReadRelation(I_CmsDAOResourceRelations rr) {
        CmsUUID sourceId = new CmsUUID(rr.getRelationSourceId());
        String sourcePath = rr.getRelationSourcePath();
        CmsUUID targetId = new CmsUUID(rr.getRelationTargetId());
        String targetPath = rr.getRelationTargetPath();
        int type = rr.getRelationType();
        return new CmsRelation(sourceId, sourcePath, targetId, targetPath, CmsRelationType.valueOf(type));
    }

    protected CmsResourceState internalReadResourceState(CmsDbContext dbc, CmsUUID projectId, CmsResource resource) throws CmsDataAccessException {
        CmsResourceState state = CmsResource.STATE_KEEP;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_READ_RESOURCE_STATE);
            q.setParameter(1, (Object)resource.getResourceId().toString());
            try {
                state = CmsResourceState.valueOf(CmsDataTypeUtil.numberToInt((Number)q.getSingleResult()));
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return state;
    }

    protected CmsResourceState internalReadStructureState(CmsDbContext dbc, CmsUUID projectId, CmsResource resource) throws CmsDataAccessException {
        CmsResourceState state = CmsResource.STATE_KEEP;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_READ_STRUCTURE_STATE);
            q.setParameter(1, (Object)resource.getStructureId().toString());
            try {
                state = CmsResourceState.valueOf(CmsDataTypeUtil.numberToInt((Number)q.getSingleResult()));
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
        return state;
    }

    protected void internalRemoveFolder(CmsDbContext dbc, CmsProject currentProject, CmsResource resource) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, currentProject, C_STRUCTURE_DELETE_BY_STRUCTUREID);
            q.setParameter(1, (Object)resource.getStructureId().toString());
            I_CmsDAOStructure s = (I_CmsDAOStructure)q.getSingleResult();
            this.m_sqlManager.remove(dbc, s);
            q = this.m_sqlManager.createQuery(dbc, currentProject, C_RESOURCES_DELETE_BY_RESOURCEID);
            q.setParameter(1, (Object)resource.getResourceId().toString());
            I_CmsDAOResources r = (I_CmsDAOResources)q.getSingleResult();
            this.m_sqlManager.remove(dbc, r);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    protected List<I_CmsDAOResourceRelations> internalResourceOus(List<I_CmsDAOResourceRelations> set, String resName) {
        ArrayList<I_CmsDAOResourceRelations> result = new ArrayList<I_CmsDAOResourceRelations>();
        if (resName == null) {
            return result;
        }
        for (I_CmsDAOResourceRelations rr : set) {
            if (rr.getRelationTargetPath() == null || resName.indexOf(rr.getRelationTargetPath()) == -1) continue;
            result.add(rr);
        }
        return result;
    }

    protected void internalUpdateVersions(CmsDbContext dbc, CmsResource resource) throws CmsDataAccessException {
        if (dbc.getRequestContext() == null) {
            return;
        }
        if (dbc.currentProject().isOnlineProject()) {
            return;
        }
        Map<String, Integer> onlineVersions = this.readVersions(dbc, CmsProject.ONLINE_PROJECT_ID, resource.getResourceId(), resource.getStructureId());
        int onlineStructureVersion = onlineVersions.get("structure");
        int onlineResourceVersion = onlineVersions.get("resource");
        try {
            Query q = this.m_sqlManager.createQuery(dbc, dbc.currentProject(), C_RESOURCES_UPDATE_RESOURCE_VERSION);
            q.setParameter(1, (Object)resource.getResourceId().toString());
            List res = q.getResultList();
            for (I_CmsDAOResources r : res) {
                r.setResourceVersion(onlineResourceVersion);
            }
            q = this.m_sqlManager.createQuery(dbc, dbc.currentProject(), C_RESOURCES_UPDATE_STRUCTURE_VERSION);
            q.setParameter(1, (Object)resource.getStructureId().toString());
            List ress = q.getResultList();
            for (I_CmsDAOStructure s : ress) {
                s.setStructureVersion(onlineStructureVersion);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    protected void internalValidateResourceLength(CmsResource resource) throws CmsDataAccessException {
        if (resource.isFolder() && resource.getLength() == -1) {
            return;
        }
        if (resource.isFile() && resource.getLength() >= 0) {
            return;
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_INVALID_RESOURCE_LENGTH_2", new Integer(resource.getLength()), resource.getRootPath()));
    }

    protected void moveRelations(CmsDbContext dbc, CmsUUID projectId, CmsUUID structureId, String rootPath) throws CmsDataAccessException {
        try {
            I_CmsDAOResourceRelations newR;
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_MOVE_RELATIONS_SOURCE);
            q.setParameter(1, (Object)structureId.toString());
            List res = q.getResultList();
            for (I_CmsDAOResourceRelations rr : res) {
                newR = CmsProject.isOnlineProject(projectId) ? new CmsDAOOnlineResourceRelations() : new CmsDAOOfflineResourceRelations();
                newR.setRelationSourceId(rr.getRelationSourceId());
                newR.setRelationSourcePath(rootPath);
                newR.setRelationTargetId(rr.getRelationTargetId());
                newR.setRelationTargetPath(rr.getRelationTargetPath());
                newR.setRelationType(rr.getRelationType());
                this.m_sqlManager.remove(dbc, rr);
                this.m_sqlManager.persist(dbc, newR);
            }
            q = this.m_sqlManager.createQuery(dbc, projectId, C_MOVE_RELATIONS_TARGET);
            q.setParameter(1, (Object)structureId.toString());
            List res1 = q.getResultList();
            for (I_CmsDAOResourceRelations rr : res1) {
                newR = CmsProject.isOnlineProject(projectId) ? new CmsDAOOnlineResourceRelations() : new CmsDAOOfflineResourceRelations();
                newR.setRelationSourceId(rr.getRelationSourceId());
                newR.setRelationSourcePath(rr.getRelationSourcePath());
                newR.setRelationTargetId(rr.getRelationTargetId());
                newR.setRelationTargetPath(rootPath);
                newR.setRelationType(rr.getRelationType());
                this.m_sqlManager.remove(dbc, rr);
                this.m_sqlManager.persist(dbc, newR);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    protected void prepareExpiredTimeRangeCondition(CmsUUID projectId, long startTime, long endTime, StringBuffer conditions, List<Object> params) {
        if (startTime > 0L) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, C_STRUCTURE_SELECT_BY_DATE_EXPIRED_AFTER));
            conditions.append(") ");
            params.add(startTime);
        }
        if (endTime > 0L) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, C_STRUCTURE_SELECT_BY_DATE_EXPIRED_BEFORE));
            conditions.append(") ");
            params.add(endTime);
        }
    }

    protected void preparePathCondition(CmsUUID projectId, String parent, int mode, StringBuffer conditions, List<Object> params) {
        if (parent == CmsDriverManager.READ_IGNORE_PARENT) {
            return;
        }
        if ((mode & 1) > 0) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_SELECT_BY_PARENT_UUID));
            conditions.append(") ");
            params.add(parent);
            return;
        }
        if ("/".equalsIgnoreCase(parent)) {
            return;
        }
        conditions.append(" AND (");
        conditions.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_SELECT_BY_PATH_PREFIX));
        conditions.append(") ");
        params.add(CmsFileUtil.addTrailingSeparator(CmsVfsDriver.escapeDbWildcard(parent)) + "%");
    }

    protected void prepareProjectCondition(CmsUUID projectId, int mode, StringBuffer conditions, List<Object> params) {
        if ((mode & 2) > 0) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_SELECT_BY_PROJECT_LASTMODIFIED));
            conditions.append(") ");
            params.add(String.valueOf(projectId));
        }
    }

    protected String prepareRelationConditions(CmsUUID projectId, CmsRelationFilter filter, CmsResource resource, List<Object> params, boolean checkSource) {
        Set<CmsRelationType> types;
        StringBuffer conditions = new StringBuffer(128);
        params.clear();
        if (filter.isSource() || filter.isTarget()) {
            if (resource != null) {
                conditions.append(" (");
                if (filter.isSource() && checkSource) {
                    if (!filter.isIncludeSubresources()) {
                        conditions.append(this.m_sqlManager.readQuery(projectId, C_RELATION_FILTER_TARGET_ID));
                        params.add(resource.getStructureId().toString());
                    } else {
                        conditions.append(this.m_sqlManager.readQuery(projectId, C_RELATION_FILTER_TARGET_PATH));
                        params.add(resource.getRootPath() + '%');
                    }
                } else if (filter.isTarget() && !checkSource) {
                    if (!filter.isIncludeSubresources()) {
                        conditions.append(this.m_sqlManager.readQuery(projectId, C_RELATION_FILTER_SOURCE_ID));
                        params.add(resource.getStructureId().toString());
                    } else {
                        conditions.append(this.m_sqlManager.readQuery(projectId, C_RELATION_FILTER_SOURCE_PATH));
                        params.add(resource.getRootPath() + '%');
                    }
                }
                conditions.append(") ");
            }
            if (filter.getStructureId() != null) {
                if (conditions.length() == 0) {
                    conditions.append(" (");
                } else {
                    conditions.append(" AND (");
                }
                if (filter.isSource() && checkSource) {
                    conditions.append(this.m_sqlManager.readQuery(projectId, C_RELATION_FILTER_SOURCE_ID));
                    params.add(filter.getStructureId().toString());
                } else if (filter.isTarget() && !checkSource) {
                    conditions.append(this.m_sqlManager.readQuery(projectId, C_RELATION_FILTER_TARGET_ID));
                    params.add(filter.getStructureId().toString());
                }
                conditions.append(") ");
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(filter.getPath())) {
                if (conditions.length() == 0) {
                    conditions.append(" (");
                } else {
                    conditions.append(" AND (");
                }
                String queryPath = filter.getPath();
                if (filter.isIncludeSubresources()) {
                    queryPath = queryPath + '%';
                }
                if (filter.isSource() && checkSource) {
                    conditions.append(this.m_sqlManager.readQuery(projectId, C_RELATION_FILTER_SOURCE_PATH));
                    params.add(queryPath);
                } else if (filter.isTarget() && !checkSource) {
                    conditions.append(this.m_sqlManager.readQuery(projectId, C_RELATION_FILTER_TARGET_PATH));
                    params.add(queryPath);
                }
                conditions.append(") ");
            }
        }
        if (!(types = filter.getTypes()).isEmpty()) {
            if (conditions.length() == 0) {
                conditions.append(" (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(projectId, C_RELATION_FILTER_TYPE));
            conditions.append(" (");
            Iterator<CmsRelationType> it = types.iterator();
            while (it.hasNext()) {
                CmsRelationType type = it.next();
                conditions.append("?");
                params.add(type.getId());
                if (!it.hasNext()) continue;
                conditions.append(", ");
            }
            conditions.append(") ");
            conditions.append(") ");
        }
        return conditions.toString();
    }

    protected void prepareReleasedTimeRangeCondition(CmsUUID projectId, long startTime, long endTime, StringBuffer conditions, List<Object> params) {
        if (startTime > 0L) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, C_STRUCTURE_SELECT_BY_DATE_RELEASED_AFTER));
            conditions.append(") ");
            params.add(startTime);
        }
        if (endTime > 0L) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, C_STRUCTURE_SELECT_BY_DATE_RELEASED_BEFORE));
            conditions.append(") ");
            params.add(endTime);
        }
    }

    protected void prepareResourceCondition(CmsUUID projectId, int mode, StringBuffer conditions) {
        if ((mode & 0x40) > 0) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_SELECT_ONLY_FOLDERS));
            conditions.append(") ");
        } else if ((mode & 0x80) > 0) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_SELECT_ONLY_FILES));
            conditions.append(") ");
        }
    }

    protected CmsPair<String, List<Object>> prepareRewriteAliasConditions(String name, CmsRewriteAliasFilter filter) {
        ArrayList<String> sqlConditions = new ArrayList<String>();
        ArrayList<String> parameters = new ArrayList<String>();
        sqlConditions.add(" 1 = 1 ");
        if (filter.getSiteRoot() != null) {
            sqlConditions.add(" " + name + ".m_siteRoot = ?");
            parameters.add(filter.getSiteRoot());
        }
        if (filter.getId() != null) {
            sqlConditions.add(" " + name + ".m_id = ?");
            parameters.add(filter.getId().toString());
        }
        String conditionString = CmsStringUtil.listAsString(sqlConditions, " AND ");
        return CmsPair.create(conditionString, parameters);
    }

    protected void prepareStateCondition(CmsUUID projectId, CmsResourceState state, int mode, StringBuffer conditions, List<Object> params) {
        if (state != null) {
            if ((mode & 8) > 0) {
                conditions.append(" AND NOT (");
            } else {
                conditions.append(" AND (");
            }
            conditions.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_SELECT_BY_RESOURCE_STATE));
            conditions.append(") ");
            params.add(state.getState());
            params.add(state.getState());
        }
    }

    protected void prepareTimeRangeCondition(CmsUUID projectId, long startTime, long endTime, StringBuffer conditions, List<Object> params) {
        if (startTime > 0L) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_SELECT_BY_DATE_LASTMODIFIED_AFTER));
            conditions.append(") ");
            params.add(startTime);
        }
        if (endTime > 0L) {
            conditions.append(" AND (");
            conditions.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_SELECT_BY_DATE_LASTMODIFIED_BEFORE));
            conditions.append(") ");
            params.add(endTime);
        }
    }

    protected void prepareTypeCondition(CmsUUID projectId, int type, int mode, StringBuffer conditions, List<Object> params) {
        if (type != -1) {
            if ((mode & 4) > 0) {
                conditions.append(" AND NOT (");
                conditions.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_SELECT_BY_RESOURCE_TYPE));
                conditions.append(") ");
                params.add(type);
            } else {
                conditions.append(" AND (");
                conditions.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_SELECT_BY_RESOURCE_TYPE));
                conditions.append(") ");
                params.add(type);
            }
        }
    }

    protected void prepareTypesCondition(CmsUUID projectId, List<Integer> types, int mode, StringBuffer conditions, List<Object> params) {
        if ((mode & 4) > 0) {
            conditions.append(" AND NOT (");
            conditions.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_SELECT_BY_RESOURCE_TYPE));
            conditions.append(") ");
            params.add(-1);
        } else if (types != null && !types.isEmpty()) {
            conditions.append(" AND (");
            Iterator<Integer> typeIt = types.iterator();
            while (typeIt.hasNext()) {
                conditions.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_SELECT_BY_RESOURCE_TYPE));
                params.add(typeIt.next());
                if (!typeIt.hasNext()) continue;
                conditions.append(" OR ");
            }
            conditions.append(") ");
        }
    }

    protected List<CmsResource> readTypesInResourceTree(CmsDbContext dbc, CmsUUID projectId, String parentPath, List<Integer> types, CmsResourceState state, long lastModifiedAfter, long lastModifiedBefore, long releasedAfter, long releasedBefore, long expiredAfter, long expiredBefore, int mode) throws CmsDataAccessException {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        StringBuffer conditions = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>(5);
        this.prepareProjectCondition(projectId, mode, conditions, params);
        this.prepareResourceCondition(projectId, mode, conditions);
        this.prepareTypesCondition(projectId, types, mode, conditions, params);
        this.prepareTimeRangeCondition(projectId, lastModifiedAfter, lastModifiedBefore, conditions, params);
        this.prepareReleasedTimeRangeCondition(projectId, releasedAfter, releasedBefore, conditions, params);
        this.prepareExpiredTimeRangeCondition(projectId, expiredAfter, expiredBefore, conditions, params);
        this.preparePathCondition(projectId, parentPath, mode, conditions, params);
        this.prepareStateCondition(projectId, state, mode, conditions, params);
        List res = null;
        try {
            StringBuffer queryBuf = new StringBuffer(256);
            queryBuf.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_READ_TREE));
            queryBuf.append(conditions);
            queryBuf.append(" ");
            queryBuf.append(this.m_sqlManager.readQuery(projectId, C_RESOURCES_ORDER_BY_PATH));
            Query q = this.m_sqlManager.createQueryFromJPQL(dbc, queryBuf.toString());
            for (int i = 0; i < params.size(); ++i) {
                q.setParameter(i + 1, params.get(i));
            }
            res = q.getResultList();
            for (Object[] obj : res) {
                CmsResource resource = this.createResource(obj, projectId);
                result.add(resource);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", C_RESOURCES_READ_TREE), (Throwable)e);
        }
        return result;
    }

    protected void repairBrokenRelations(CmsDbContext dbc, CmsUUID projectId, CmsUUID structureId, String rootPath) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RELATIONS_REPAIR_BROKEN);
            q.setParameter(1, (Object)rootPath);
            List res = q.getResultList();
            for (I_CmsDAOResourceRelations rr : res) {
                I_CmsDAOResourceRelations newR = CmsProject.isOnlineProject(projectId) ? new CmsDAOOnlineResourceRelations() : new CmsDAOOfflineResourceRelations();
                newR.setRelationSourceId(rr.getRelationSourceId());
                newR.setRelationSourcePath(rr.getRelationSourcePath());
                newR.setRelationTargetId(structureId.toString());
                newR.setRelationTargetPath(rr.getRelationTargetPath());
                newR.setRelationType(rr.getRelationType());
                this.m_sqlManager.remove(dbc, rr);
                this.m_sqlManager.persist(dbc, newR);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    protected void updateBrokenRelations(CmsDbContext dbc, CmsUUID projectId, String rootPath) throws CmsDataAccessException {
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_RELATIONS_UPDATE_BROKEN);
            q.setParameter(1, (Object)rootPath);
            List res = q.getResultList();
            for (I_CmsDAOResourceRelations rr : res) {
                I_CmsDAOResourceRelations newR = CmsProject.isOnlineProject(projectId) ? new CmsDAOOnlineResourceRelations() : new CmsDAOOfflineResourceRelations();
                newR.setRelationSourceId(rr.getRelationSourceId());
                newR.setRelationSourcePath(rr.getRelationSourcePath());
                newR.setRelationTargetId(CmsUUID.getNullUUID().toString());
                newR.setRelationTargetPath(rr.getRelationTargetPath());
                newR.setRelationType(rr.getRelationType());
                this.m_sqlManager.remove(dbc, rr);
                this.m_sqlManager.persist(dbc, newR);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_JPA_PERSITENCE_1", (Object)e), (Throwable)e);
        }
    }

    private CmsPair<String, List<String>> buildAliasConditions(CmsAliasFilter filter) {
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add("1 = 1");
        ArrayList<String> conditionParams = new ArrayList<String>();
        if (filter.getSiteRoot() != null) {
            conditions.add("alias.m_siteRoot = ?");
            conditionParams.add(filter.getSiteRoot());
        }
        if (filter.getStructureId() != null) {
            conditions.add("alias.m_structureId = ?");
            conditionParams.add(filter.getStructureId().toString());
        }
        if (filter.getPath() != null) {
            conditions.add("alias.m_aliasPath = ?");
            conditionParams.add(filter.getPath());
        }
        String conditionString = CmsStringUtil.listAsString(conditions, " AND ");
        return CmsPair.create(conditionString, conditionParams);
    }

    private Query getAliasQueryForFilter(CmsDbContext dbc, String baseQuery, CmsAliasFilter filter) {
        CmsPair<String, List<String>> conditionData = this.buildAliasConditions(filter);
        String query = baseQuery + " WHERE " + conditionData.getFirst();
        Query q = this.m_sqlManager.createQueryFromJPQL(dbc, query);
        List<String> conditionParams = conditionData.getSecond();
        for (int i = 0; i < conditionParams.size(); ++i) {
            q.setParameter(1 + i, (Object)conditionParams.get(i));
        }
        return q;
    }

    private Query getQueryForFilter(CmsDbContext dbc, String baseQuery, CmsUrlNameMappingFilter filter, boolean online) throws PersistenceException {
        CmsPair<String, List<I_CmsQueryParameter>> conditionData = CmsVfsDriver.prepareUrlNameMappingConditions(filter);
        String whereClause = "";
        if (!conditionData.getFirst().equals("")) {
            whereClause = " WHERE " + conditionData.getFirst();
        }
        String query = baseQuery + whereClause;
        query = this.replaceProject(query, online);
        Query q = this.m_sqlManager.createQueryFromJPQL(dbc, query);
        int counter = 1;
        for (I_CmsQueryParameter param : conditionData.getSecond()) {
            param.insertIntoQuery(q, counter);
            ++counter;
        }
        return q;
    }

    private String replaceProject(String query, boolean online) {
        return query.replace("%(PROJECT)", online ? "Online" : "Offline");
    }
}

