/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.opencms.db.CmsDbConsistencyException;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsVisitEntry;
import org.opencms.db.CmsVisitEntryFilter;
import org.opencms.db.generic.CmsSqlManager;
import org.opencms.db.generic.Messages;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.main.OpenCms;

public class CmsSubscriptionDriver
extends org.opencms.db.generic.CmsSubscriptionDriver {
    public CmsSqlManager initSqlManager(String classname) {
        return CmsSqlManager.getInstance(classname);
    }

    public void markResourceAsVisitedBy(CmsDbContext dbc, String poolName, CmsResource resource, CmsUser user) throws CmsDataAccessException {
        boolean entryExists = false;
        CmsVisitEntryFilter filter = CmsVisitEntryFilter.ALL.filterResource(resource.getStructureId()).filterUser(user.getId());
        if (this.readVisits(dbc, OpenCms.getSubscriptionManager().getPoolName(), filter).size() > 0) {
            entryExists = true;
            this.deleteVisits(dbc, OpenCms.getSubscriptionManager().getPoolName(), filter);
        }
        CmsVisitEntry entry = new CmsVisitEntry(user.getId(), System.currentTimeMillis(), resource.getStructureId());
        this.addVisit(dbc, poolName, entry);
        if (!entryExists) {
            PreparedStatement stmt = null;
            Connection conn = null;
            ResultSet res = null;
            int count = 0;
            try {
                conn = this.m_sqlManager.getConnection(poolName);
                stmt = this.m_sqlManager.getPreparedStatement(conn, dbc.currentProject(), "C_VISITED_USER_COUNT_1");
                stmt.setString(1, user.getId().toString());
                res = stmt.executeQuery();
                if (res.next()) {
                    count = res.getInt(1);
                    while (res.next()) {
                    }
                } else {
                    throw new CmsDbConsistencyException(Messages.get().container("ERR_COUNTING_VISITED_RESOURCES_1", user.getName()));
                }
                int maxCount = OpenCms.getSubscriptionManager().getMaxVisitedCount();
                if (count > maxCount) {
                    this.m_sqlManager.closeAll(dbc, null, stmt, res);
                    stmt = this.m_sqlManager.getPreparedStatement(conn, dbc.currentProject(), "C_MYSQL_VISITED_USER_DELETE_2");
                    stmt.setString(1, user.getId().toString());
                    stmt.setInt(2, count - maxCount);
                    stmt.executeUpdate();
                }
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
            }
            catch (SQLException e) {
                try {
                    throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                    throw throwable;
                }
            }
        }
    }
}

