/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsResource;
import org.opencms.util.CmsUUID;

public class CmsFile
extends CmsResource {
    private static final long serialVersionUID = -5201022482708455620L;
    private byte[] m_fileContent;

    public CmsFile(CmsResource resource) {
        this(resource.getStructureId(), resource.getResourceId(), resource.getRootPath(), resource.getTypeId(), resource.getFlags(), resource.getProjectLastModified(), resource.getState(), resource.getDateCreated(), resource.getUserCreated(), resource.getDateLastModified(), resource.getUserLastModified(), resource.getDateReleased(), resource.getDateExpired(), resource.getSiblingCount(), resource.getLength(), resource.getDateContent(), resource.getVersion(), resource instanceof CmsFile ? ((CmsFile)resource).getContents() : null);
    }

    public CmsFile(CmsUUID structureId, CmsUUID resourceId, String path, int type, int flags, CmsUUID projectId, CmsResourceState state, long dateCreated, CmsUUID userCreated, long dateLastModified, CmsUUID userLastModified, long dateReleased, long dateExpired, int linkCount, int length, long dateContent, int version, byte[] content) {
        super(structureId, resourceId, path, type, false, flags, projectId, state, dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, linkCount, length, dateContent, version);
        this.m_fileContent = content;
        if (this.m_fileContent == null) {
            this.m_fileContent = new byte[0];
        }
    }

    public Object clone() {
        byte[] newContent = new byte[this.getContents().length];
        System.arraycopy(this.getContents(), 0, newContent, 0, this.getContents().length);
        CmsFile clone = new CmsFile(this.getStructureId(), this.getResourceId(), this.getRootPath(), this.getTypeId(), this.getFlags(), this.getProjectLastModified(), this.getState(), this.getDateCreated(), this.getUserCreated(), this.getDateLastModified(), this.getUserLastModified(), this.getDateReleased(), this.getDateExpired(), this.getSiblingCount(), this.getLength(), this.getDateContent(), this.getVersion(), newContent);
        if (this.isTouched()) {
            clone.setDateLastModified(this.getDateLastModified());
        }
        return clone;
    }

    public byte[] getContents() {
        return this.m_fileContent;
    }

    public int getLength() {
        return this.m_length;
    }

    public boolean isFile() {
        return true;
    }

    public boolean isFolder() {
        return false;
    }

    public boolean isTemporaryFile() {
        return (this.getFlags() & 0x400) > 0 || CmsFile.isTemporaryFileName(this.getName());
    }

    public void setContents(byte[] value) {
        if (value == null) {
            value = new byte[]{};
        }
        long dateContent = System.currentTimeMillis();
        if (this.m_fileContent == null || this.m_fileContent.length == 0) {
            dateContent = this.m_dateContent;
        }
        this.m_fileContent = new byte[value.length];
        System.arraycopy(value, 0, this.m_fileContent, 0, value.length);
        this.m_length = this.m_fileContent.length > 0 ? this.m_fileContent.length : 0;
        this.m_dateContent = dateContent;
    }
}

