/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.CmsCollectorData;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.file.collectors.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class A_CmsResourceCollector
implements I_CmsResourceCollector {
    public static final String SEPARATOR_TEMPLATEFILE = "::";
    protected int m_order;
    private String m_defaultCollectorName;
    private String m_defaultCollectorParam;
    private int m_hashcode = this.getClass().getName().hashCode();

    public static String createResourceForCollector(CmsObject cms, String newLink, Locale locale, String referenceResource, String modelFile) throws CmsException {
        String templateFileName;
        String param;
        int pos = newLink.indexOf(124);
        String collectorName = newLink.substring(0, pos);
        String collectorParams = newLink.substring(pos + 1);
        if ((pos = collectorParams.indexOf(SEPARATOR_TEMPLATEFILE)) != -1) {
            param = collectorParams.substring(0, pos);
            templateFileName = collectorParams.substring(pos + SEPARATOR_TEMPLATEFILE.length());
        } else {
            param = collectorParams;
            templateFileName = referenceResource;
        }
        I_CmsResourceCollector collector = OpenCms.getResourceManager().getContentCollector(collectorName);
        String newFileName = "";
        CmsFile templateFile = cms.readFile(templateFileName, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsObject cloneCms = OpenCms.initCmsObject(cms);
        cloneCms.getRequestContext().setRequestTime(Long.MIN_VALUE);
        CmsXmlContent template = CmsXmlContentFactory.unmarshal(cloneCms, templateFile);
        CmsXmlContent newContent = CmsXmlContentFactory.createDocument(cms, locale, template.getEncoding(), template.getContentDefinition());
        newFileName = collector.getCreateLink(cms, collectorName, param);
        boolean useModelFile = false;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(modelFile)) {
            cms.getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_MODEL, modelFile);
            useModelFile = true;
        }
        cms.createResource(newFileName, templateFile.getTypeId());
        CmsFile newFile = cms.readFile(newFileName, CmsResourceFilter.ALL);
        if (!useModelFile) {
            newFile.setContents(newContent.marshal());
            cloneCms.writeFile(newFile);
        }
        return newFileName;
    }

    @Override
    public int compareTo(I_CmsResourceCollector obj) {
        if (obj == this) {
            return 0;
        }
        return this.getOrder() - obj.getOrder();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof I_CmsResourceCollector) {
            return this.getClass().getName().equals(obj.getClass().getName());
        }
        return false;
    }

    @Override
    public String getCreateLink(CmsObject cms) throws CmsException, CmsDataAccessException {
        this.checkParams();
        return this.getCreateLink(cms, this.getDefaultCollectorName(), this.getDefaultCollectorParam());
    }

    @Override
    public String getCreateParam(CmsObject cms) throws CmsDataAccessException {
        this.checkParams();
        return this.getCreateParam(cms, this.getDefaultCollectorName(), this.getDefaultCollectorParam());
    }

    @Override
    public String getDefaultCollectorName() {
        return this.m_defaultCollectorName;
    }

    @Override
    public String getDefaultCollectorParam() {
        return this.m_defaultCollectorParam;
    }

    @Override
    public int getOrder() {
        return this.m_order;
    }

    @Override
    public List<CmsResource> getResults(CmsObject cms) throws CmsDataAccessException, CmsException {
        this.checkParams();
        return this.getResults(cms, this.getDefaultCollectorName(), this.getDefaultCollectorParam());
    }

    public int hashCode() {
        return this.m_hashcode;
    }

    @Override
    public void setDefaultCollectorName(String collectorName) {
        this.m_defaultCollectorName = collectorName;
    }

    @Override
    public void setDefaultCollectorParam(String param) {
        this.m_defaultCollectorParam = param;
    }

    @Override
    public void setOrder(int order) {
        this.m_order = order;
    }

    protected void checkParams() {
        if (this.m_defaultCollectorName == null || this.m_defaultCollectorParam == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_DEFAULTS_INVALID_2", this.m_defaultCollectorName, this.m_defaultCollectorParam));
        }
    }

    protected String getCreateInFolder(CmsObject cms, CmsCollectorData data) throws CmsException {
        return OpenCms.getResourceManager().getNameGenerator().getNewFileName(cms, data.getFileName(), 4);
    }

    protected String getCreateInFolder(CmsObject cms, String param) throws CmsException {
        return this.getCreateInFolder(cms, new CmsCollectorData(param));
    }

    protected List<CmsResource> shrinkToFit(List<CmsResource> result, int maxSize) {
        if (maxSize > 0 && result.size() > maxSize) {
            result = result.subList(0, maxSize);
        }
        return result;
    }
}

