/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.types.A_CmsResourceTypeFolderBase;
import org.opencms.file.types.Messages;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsResourceTypeFolder
extends A_CmsResourceTypeFolderBase {
    public static final String CONFIGURATION_INDEX_PAGE_TYPE = "restypes.indexpage";
    public static final int RESOURCE_TYPE_ID = 0;
    public static final String RESOURCE_TYPE_NAME = "folder";
    private static boolean m_staticFrozen;
    private static int m_staticTypeId;
    private String m_indexPageTypes;

    public CmsResourceTypeFolder() {
        this.m_typeId = 0;
        this.m_typeName = RESOURCE_TYPE_NAME;
    }

    public static int getStaticTypeId() {
        return m_staticTypeId;
    }

    public static String getStaticTypeName() {
        return RESOURCE_TYPE_NAME;
    }

    public void addConfigurationParameter(String paramName, String paramValue) {
        super.addConfigurationParameter(paramName, paramValue);
        if (CmsStringUtil.isNotEmpty(paramName) && CmsStringUtil.isNotEmpty(paramValue) && CONFIGURATION_INDEX_PAGE_TYPE.equalsIgnoreCase(paramName)) {
            this.m_indexPageTypes = paramValue.trim();
        }
    }

    public CmsParameterConfiguration getConfiguration() {
        CmsParameterConfiguration result = new CmsParameterConfiguration();
        CmsParameterConfiguration additional = super.getConfiguration();
        if (additional != null && additional.size() > 0) {
            result.putAll(additional);
        }
        if (CmsStringUtil.isNotEmpty(this.getIndexPageTypes())) {
            result.put(CONFIGURATION_INDEX_PAGE_TYPE, this.getIndexPageTypes());
        }
        return result;
    }

    public String getIndexPageTypes() {
        return this.m_indexPageTypes;
    }

    public void initConfiguration(String name, String id, String className) throws CmsConfigurationException {
        if (OpenCms.getRunLevel() > 2 && m_staticFrozen) {
            throw new CmsConfigurationException(Messages.get().container("ERR_CONFIG_FROZEN_3", this.getClass().getName(), CmsResourceTypeFolder.getStaticTypeName(), new Integer(CmsResourceTypeFolder.getStaticTypeId())));
        }
        if (!RESOURCE_TYPE_NAME.equals(name)) {
            throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_RESTYPE_CONFIG_NAME_3", this.getClass().getName(), RESOURCE_TYPE_NAME, name));
        }
        m_staticFrozen = true;
        super.initConfiguration(RESOURCE_TYPE_NAME, id, className);
        m_staticTypeId = this.m_typeId;
    }
}

