/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsAlias;
import org.opencms.db.CmsAliasManager;
import org.opencms.db.CmsRewriteAlias;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.gwt.Messages;
import org.opencms.gwt.shared.alias.CmsAliasBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsAliasHelper {
    private static final Log LOG = CmsLog.getLog(CmsAliasHelper.class);
    private CmsObject m_cms;

    public String exportAliasesAsCsv(CmsObject cms) throws CmsException {
        String siteRoot = cms.getRequestContext().getSiteRoot();
        List<CmsAlias> aliases = OpenCms.getAliasManager().getAliasesForSite(cms, siteRoot);
        StringWriter writer = new StringWriter();
        CSVWriter csvWriter = new CSVWriter((Writer)writer);
        StringBuffer resultBuffer = writer.getBuffer();
        for (CmsAlias alias : aliases) {
            try {
                CmsResource resource = cms.readResource(alias.getStructureId());
                csvWriter.writeNext(new String[]{alias.getAliasPath(), cms.getSitePath(resource), alias.getMode().toString()});
            }
            catch (CmsException e) {
                LOG.warn((Object)"Could not read alias resource", (Throwable)e);
            }
        }
        List<CmsRewriteAlias> rewriteAliases = OpenCms.getAliasManager().getRewriteAliases(cms, siteRoot);
        for (CmsRewriteAlias rewrite : rewriteAliases) {
            csvWriter.writeNext(new String[]{rewrite.getPatternString(), rewrite.getReplacementString(), rewrite.getMode().toString(), "rewrite"});
        }
        try {
            csvWriter.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        return resultBuffer.toString();
    }

    public void saveAliases(CmsUUID structureId, List<CmsAliasBean> aliasBeans) throws CmsException {
        CmsAliasManager aliasManager = OpenCms.getAliasManager();
        CmsObject cms = this.m_cms;
        ArrayList<CmsAlias> aliases = new ArrayList<CmsAlias>();
        for (CmsAliasBean aliasBean : aliasBeans) {
            CmsAlias alias = new CmsAlias(structureId, cms.getRequestContext().getSiteRoot(), aliasBean.getSitePath(), aliasBean.getMode());
            aliases.add(alias);
        }
        aliasManager.saveAliases(cms, structureId, aliases);
    }

    public void setCms(CmsObject cms) {
        this.m_cms = cms;
    }

    protected String checkValidAliasPath(String path, Locale locale) {
        if (CmsAlias.ALIAS_PATTERN.matcher(path).matches()) {
            return null;
        }
        return Messages.get().getBundle(locale).key("ERR_ALIAS_INVALID_PATH_0");
    }

    protected CmsAliasBean convertAliasToBean(CmsAlias alias) {
        return new CmsAliasBean(alias.getAliasPath(), alias.getMode());
    }

    protected List<CmsAliasBean> getAliasesForPage(CmsUUID uuid) throws CmsException {
        CmsAliasManager aliasManager = OpenCms.getAliasManager();
        List<CmsAlias> aliases = aliasManager.getAliasesForStructureId(this.m_cms, uuid);
        ArrayList<CmsAliasBean> result = new ArrayList<CmsAliasBean>();
        for (CmsAlias alias : aliases) {
            CmsAliasBean bean = this.convertAliasToBean(alias);
            result.add(bean);
        }
        return result;
    }

    protected Map<String, String> validateAliases(CmsUUID uuid, Map<String, String> aliasPaths) throws CmsException {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
        HashSet<String> seenPaths = new HashSet<String>();
        HashSet<String> duplicatePaths = new HashSet<String>();
        for (String path : aliasPaths.values()) {
            if (seenPaths.contains(path)) {
                duplicatePaths.add(path);
            }
            seenPaths.add(path);
        }
        HashMap<String, String> errorMessagesByPath = new HashMap<String, String>();
        for (String path : duplicatePaths) {
            errorMessagesByPath.put(path, Messages.get().getBundle(locale).key("ERR_ALIAS_DUPLICATE_PATH_0"));
        }
        seenPaths.removeAll(duplicatePaths);
        block4: for (String path : seenPaths) {
            String pathError = this.checkValidAliasPath(path, locale);
            if (pathError != null) {
                errorMessagesByPath.put(path, pathError);
                continue;
            }
            errorMessagesByPath.put(path, null);
            if (this.m_cms.existsResource(path, CmsResourceFilter.ALL)) {
                errorMessagesByPath.put(path, Messages.get().getBundle(locale).key("ERR_ALIAS_IS_VFS_0"));
                continue;
            }
            List<CmsAlias> aliases = OpenCms.getAliasManager().getAliasesForPath(this.m_cms, this.m_cms.getRequestContext().getSiteRoot(), path);
            for (CmsAlias alias : aliases) {
                CmsUUID otherStructureId = alias.getStructureId();
                if (otherStructureId.equals(uuid)) continue;
                try {
                    CmsResource resource = this.m_cms.readResource(otherStructureId, CmsResourceFilter.ALL);
                    errorMessagesByPath.put(path, Messages.get().getBundle(locale).key("ERR_ALIAS_ALREADY_USED_1", resource.getRootPath()));
                }
                catch (CmsVfsResourceNotFoundException e) {
                    errorMessagesByPath.put(path, Messages.get().getBundle(locale).key("ERR_ALIAS_ALREADY_USED_UNKNOWN_0"));
                }
                continue block4;
            }
        }
        HashMap<String, String> errorMessagesById = new HashMap<String, String>();
        for (String key : aliasPaths.keySet()) {
            String path = aliasPaths.get(key);
            if (!errorMessagesByPath.containsKey(path)) continue;
            String errorMessage = (String)errorMessagesByPath.get(path);
            errorMessagesById.put(key, errorMessage);
        }
        return errorMessagesById;
    }
}

