/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsPreviewInfo
implements IsSerializable {
    private int m_height;
    private String m_locale;
    private LinkedHashMap<String, String> m_locales;
    private boolean m_newWindowRequired;
    private String m_previewContent;
    private String m_previewUrl;
    private String m_sitePath;
    private String m_title;
    private int m_width;

    public CmsPreviewInfo(String content, String url, boolean newWindowRequired, String title, String sitePath, String locale) {
        this.m_previewContent = content;
        this.m_previewUrl = url;
        this.m_newWindowRequired = newWindowRequired;
        this.m_title = title;
        this.m_sitePath = sitePath;
        this.m_locale = locale;
    }

    protected CmsPreviewInfo() {
    }

    public int getHeight() {
        return this.m_height;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public Map<String, String> getLocales() {
        return this.m_locales;
    }

    public String getPreviewContent() {
        return this.m_previewContent;
    }

    public String getPreviewUrl() {
        return this.m_previewUrl;
    }

    public String getSitePath() {
        return this.m_sitePath;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int getWidth() {
        return this.m_width;
    }

    public boolean hasAdditionalLocales() {
        return this.m_locales != null && this.m_locales.size() > 1;
    }

    public boolean hasDimensions() {
        return this.m_height > 0 && this.m_width > 0;
    }

    public boolean hasPreviewContent() {
        return CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_previewContent);
    }

    public boolean hasPreviewUrl() {
        return CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_previewUrl);
    }

    public boolean isNewWindowRequired() {
        return this.m_newWindowRequired;
    }

    public void setHeight(int height) {
        this.m_height = height;
    }

    public void setLocales(LinkedHashMap<String, String> locales) {
        this.m_locales = locales;
    }

    public void setWidth(int width) {
        this.m_width = width;
    }
}

