/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsADEManager;
import org.opencms.ade.containerpage.CmsContainerpageService;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReference;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReferenceParser;
import org.opencms.ade.containerpage.inherited.CmsInheritedContainerState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspTagInclude;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.containerpage.CmsADESessionCache;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.CmsXmlGroupContainerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsJspTagContainer
extends TagSupport {
    public static final String DEFAULT_MAX_ELEMENTS = "100";
    public static final String KEY_CONTAINER_DATA = "org_opencms_ade_containerpage_containers";
    private static final String CREATE_NO_TAG = "none";
    private static final String DEFAULT_TAG_NAME = "div";
    private static final Log LOG = CmsLog.getLog(CmsJspTagContainer.class);
    private static final long serialVersionUID = -1228397990961282556L;
    private boolean m_detailView;
    private String m_maxElements;
    private String m_name;
    private String m_tag;
    private String m_tagClass;
    private String m_type;
    private String m_width;

    protected static String getContainerDataTag(CmsContainerBean container, String widthStr, boolean isDetailView) throws JSONException {
        JSONObject jsonContainer = new JSONObject();
        jsonContainer.put("name", container.getName());
        jsonContainer.put("type", container.getType());
        jsonContainer.put("maxElem", container.getMaxElements());
        jsonContainer.put("isDetailView", isDetailView);
        int width = -1;
        try {
            if (widthStr != null) {
                width = Integer.parseInt(widthStr);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        jsonContainer.put("width", width);
        JSONArray jsonElements = new JSONArray();
        for (CmsContainerElementBean element : container.getElements()) {
            jsonElements.put(element.editorHash());
        }
        jsonContainer.put("elements", jsonElements);
        return new StringBuffer("<script type=\"text/javascript\">if (").append(KEY_CONTAINER_DATA).append("!=null) {").append(KEY_CONTAINER_DATA).append(".push(").append(jsonContainer.toString()).append("); } </script>").toString();
    }

    protected static String getTagClose(String tagName) {
        return "</" + tagName + ">";
    }

    protected static String getTagOpen(String tagName, String containerName, String tagClass) {
        String classAttr = CmsStringUtil.isEmptyOrWhitespaceOnly(tagClass) ? "" : "class=\"" + tagClass + "\" ";
        return "<" + tagName + " id=\"" + containerName + "\" " + classAttr + ">";
    }

    public int doStartTag() throws JspException {
        block28: {
            ServletRequest req = this.pageContext.getRequest();
            if (CmsFlexController.isCmsRequest(req)) {
                try {
                    String tagName;
                    CmsFlexController controller = CmsFlexController.getController(req);
                    CmsObject cms = controller.getCmsObject();
                    String requestUri = cms.getRequestContext().getUri();
                    Locale locale = cms.getRequestContext().getLocale();
                    CmsJspStandardContextBean standardContext = CmsJspStandardContextBean.getInstance(req);
                    CmsContainerPageBean containerPage = standardContext.getPage();
                    if (containerPage == null) {
                        CmsResource pageResource = (CmsResource)((Object)CmsHistoryResourceHandler.getHistoryResource(req));
                        if (pageResource == null) {
                            pageResource = cms.readResource(requestUri);
                        }
                        CmsXmlContainerPage xmlContainerPage = CmsXmlContainerPageFactory.unmarshal(cms, pageResource, req);
                        containerPage = xmlContainerPage.getContainerPage(cms, locale);
                        standardContext.setPage(containerPage);
                    }
                    boolean createTag = false;
                    String string = tagName = CmsStringUtil.isEmptyOrWhitespaceOnly(this.getTag()) ? DEFAULT_TAG_NAME : this.getTag();
                    if (!CREATE_NO_TAG.equals(this.getTag())) {
                        createTag = true;
                        this.pageContext.getOut().print(CmsJspTagContainer.getTagOpen(tagName, this.getName(), this.getTagClass()));
                    }
                    int maxElements = this.getMaxElements(requestUri);
                    CmsContainerBean container = null;
                    if (containerPage != null) {
                        container = containerPage.getContainers().get(this.getName());
                    }
                    boolean isOnline = cms.getRequestContext().getCurrentProject().isOnlineProject();
                    boolean isUsedAsDetailView = false;
                    CmsResource detailContent = standardContext.getDetailContent();
                    if (this.m_detailView && detailContent != null) {
                        isUsedAsDetailView = true;
                    }
                    if (container == null) {
                        if (!isUsedAsDetailView) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)Messages.get().getBundle().key("LOG_CONTAINER_NOT_FOUND_3", requestUri, locale, this.getName()));
                            }
                            if (!isOnline) {
                                try {
                                    this.pageContext.getOut().print(CmsJspTagContainer.getContainerDataTag(new CmsContainerBean(this.getName(), this.getType(), maxElements, null), this.getWidth(), isUsedAsDetailView));
                                }
                                catch (JSONException e) {
                                    throw new JspException((Throwable)e);
                                }
                            }
                            if (createTag) {
                                this.pageContext.getOut().print(CmsJspTagContainer.getTagClose(tagName));
                            }
                        } else {
                            container = new CmsContainerBean(this.getName(), this.getType(), maxElements, Collections.<CmsContainerElementBean>emptyList());
                        }
                    }
                    if (container == null) break block28;
                    standardContext.setContainer(container);
                    if (!this.getType().equals(container.getType())) {
                        throw new CmsIllegalStateException(Messages.get().container("LOG_WRONG_CONTAINER_TYPE_4", new Object[]{requestUri, locale, this.getName(), this.getType()}));
                    }
                    container.setMaxElements(maxElements);
                    container.setWidth(this.getWidth());
                    ArrayList<CmsContainerElementBean> allElements = new ArrayList<CmsContainerElementBean>();
                    CmsContainerElementBean detailElement = null;
                    if (isUsedAsDetailView) {
                        detailElement = this.generateDetailViewElement(cms, detailContent);
                    }
                    if (detailElement != null) {
                        allElements.add(detailElement);
                    } else {
                        allElements.addAll(container.getElements());
                    }
                    if (!isOnline) {
                        try {
                            CmsContainerBean cntBean = new CmsContainerBean(this.getName(), this.getType(), maxElements, allElements);
                            this.pageContext.getOut().print(CmsJspTagContainer.getContainerDataTag(cntBean, this.getWidth(), isUsedAsDetailView));
                        }
                        catch (JSONException e) {
                            throw new JspException((Throwable)e);
                        }
                    }
                    for (int i = 0; i < maxElements && i < allElements.size(); ++i) {
                        try {
                            this.renderContainerElement(cms, standardContext, (CmsContainerElementBean)allElements.get(i), locale);
                            continue;
                        }
                        catch (Exception e) {
                            if (!LOG.isErrorEnabled()) continue;
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    if (createTag) {
                        this.pageContext.getOut().print(CmsJspTagContainer.getTagClose(tagName));
                    }
                }
                catch (Exception ex) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "container"), (Throwable)ex);
                    }
                    throw new JspException((Throwable)ex);
                }
            }
        }
        return 0;
    }

    public String getDetailview() {
        return String.valueOf(this.m_detailView);
    }

    public String getMaxElements() {
        return CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_maxElements) ? DEFAULT_MAX_ELEMENTS : this.m_maxElements;
    }

    public String getName() {
        return this.m_name;
    }

    public String getTag() {
        return this.m_tag;
    }

    public String getTagClass() {
        return this.m_tagClass;
    }

    public String getType() {
        return CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_type) ? this.getName() : this.m_type;
    }

    public String getWidth() {
        return this.m_width;
    }

    public void release() {
        super.release();
        this.m_type = null;
        this.m_name = null;
        this.m_maxElements = null;
        this.m_tag = null;
        this.m_tagClass = null;
        this.m_detailView = false;
    }

    public void setDetailview(String detailView) {
        this.m_detailView = Boolean.parseBoolean(detailView);
    }

    public void setMaxElements(String maxElements) {
        this.m_maxElements = maxElements;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setTag(String tag) {
        this.m_tag = tag;
    }

    public void setTagClass(String tagClass) {
        this.m_tagClass = tagClass;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setWidth(String width) {
        this.m_width = width;
    }

    protected void printElementWrapperTagEnd(boolean isOnline, boolean isGroupcontainer) throws IOException {
        if (!isOnline) {
            String result = isGroupcontainer ? "</div>" : "<div class=\"cms_ade_element_end\" style=\"display:none\"></div>";
            this.pageContext.getOut().print(result);
        }
    }

    protected void printElementWrapperTagStart(boolean isOnline, CmsObject cms, CmsContainerElementBean elementBean, boolean isGroupContainer) throws Exception {
        if (!isOnline) {
            StringBuffer result = new StringBuffer("<div class='");
            if (isGroupContainer) {
                result.append("cms_ade_groupcontainer");
            } else {
                result.append("cms_ade_element_start");
            }
            String serializedElement = this.getElementInfo(cms, elementBean);
            result.append("'");
            String data = CmsEncoder.escapeXml(serializedElement);
            result.append(" rel='").append(data);
            if (isGroupContainer) {
                result.append("'>");
            } else {
                result.append("' style='display:none;'></div>");
            }
            this.pageContext.getOut().print((Object)result);
        }
    }

    private CmsContainerElementBean generateDetailViewElement(CmsObject cms, CmsResource detailContent) {
        CmsADEConfigData config;
        CmsFormatterConfiguration formatters;
        CmsFormatterBean formatter;
        CmsContainerElementBean element = null;
        if (detailContent != null && (formatter = (formatters = (config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri())).getFormatters(cms, detailContent)).getFormatter(this.getType(), this.getContainerWidth())) != null) {
            element = new CmsContainerElementBean(detailContent.getStructureId(), formatter.getJspStructureId(), null, false);
        }
        return element;
    }

    private int getContainerWidth() {
        int containerWidth = -1;
        try {
            containerWidth = Integer.parseInt(this.m_width);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return containerWidth;
    }

    private String getElementInfo(CmsObject cms, CmsContainerElementBean elementBean) throws Exception {
        CmsContainerpageService service = new CmsContainerpageService();
        service.setCms(cms);
        service.setRequest((HttpServletRequest)this.pageContext.getRequest());
        service.setResponse((HttpServletResponse)this.pageContext.getResponse());
        return service.getSerializedElementInfo(elementBean);
    }

    private List<CmsContainerElementBean> getGroupContainerElements(CmsObject cms, CmsContainerElementBean element, ServletRequest req, String containerType) throws CmsException {
        CmsXmlGroupContainer xmlGroupContainer = CmsXmlGroupContainerFactory.unmarshal(cms, element.getResource(), req);
        CmsGroupContainerBean groupContainer = xmlGroupContainer.getGroupContainer(cms, cms.getRequestContext().getLocale());
        if (!groupContainer.getTypes().contains(containerType)) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_XSD_NO_TEMPLATE_FORMATTER_3", element.getResource().getRootPath(), OpenCms.getResourceManager().getResourceType(element.getResource()).getTypeName(), containerType));
        }
        List<CmsContainerElementBean> subElements = groupContainer.getElements();
        return subElements;
    }

    private List<CmsContainerElementBean> getInheritedContainerElements(CmsObject cms, CmsContainerElementBean element) {
        CmsResource resource = element.getResource();
        CmsInheritanceReferenceParser parser = new CmsInheritanceReferenceParser(cms);
        try {
            parser.parse(resource);
            CmsInheritanceReference ref = parser.getReferences().get(cms.getRequestContext().getLocale());
            if (ref != null) {
                String name = ref.getName();
                CmsADEManager adeManager = OpenCms.getADEManager();
                CmsInheritedContainerState result = adeManager.getInheritedContainerState(cms, cms.getRequestContext().getRootUri(), name);
                return result.getElements(false);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private int getMaxElements(String requestUri) {
        String containerName = this.getName();
        String containerMaxElements = this.getMaxElements();
        int maxElements = -1;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(containerMaxElements)) {
            try {
                maxElements = Integer.parseInt(containerMaxElements);
            }
            catch (NumberFormatException e) {
                throw new CmsIllegalStateException(Messages.get().container("LOG_WRONG_CONTAINER_MAXELEMENTS_3", new Object[]{requestUri, containerName, containerMaxElements}), (Throwable)e);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_MAXELEMENTS_NOT_SET_2", new Object[]{containerName, requestUri}));
        }
        return maxElements;
    }

    private CmsADESessionCache getSessionCache(CmsObject cms) {
        CmsADESessionCache sessionCache = (CmsADESessionCache)((HttpServletRequest)this.pageContext.getRequest()).getSession().getAttribute("__OCMS_ADE_CACHE__");
        if (sessionCache == null) {
            sessionCache = new CmsADESessionCache(cms);
            ((HttpServletRequest)this.pageContext.getRequest()).getSession().setAttribute("__OCMS_ADE_CACHE__", (Object)sessionCache);
        }
        return sessionCache;
    }

    private void printElementErrorTag(boolean isOnline, String elementSitePath, String formatterSitePath, Exception exception) throws IOException {
        if (!isOnline) {
            String stacktrace = CmsException.getStackTraceAsString(exception);
            stacktrace = CmsStringUtil.isEmptyOrWhitespaceOnly(stacktrace) ? null : CmsEncoder.escapeXml(stacktrace);
            StringBuffer errorBox = new StringBuffer(256);
            errorBox.append("<div style=\"display:block; padding: 5px; border: red solid 2px; color: black; background: white;\" class=\"");
            errorBox.append("cms_ade_element_error");
            errorBox.append("\">");
            errorBox.append(Messages.get().getBundle().key("ERR_CONTAINER_PAGE_ELEMENT_RENDER_ERROR_2", elementSitePath, formatterSitePath));
            errorBox.append("<br />");
            errorBox.append(exception.getLocalizedMessage());
            if (stacktrace != null) {
                errorBox.append("<span onclick=\"__openStacktraceDialog(event);\" style=\"border: 1px solid black; cursor: pointer;\">");
                errorBox.append(Messages.get().getBundle().key("GUI_LABEL_STACKTRACE_0"));
                errorBox.append("<span title=\"");
                errorBox.append(Messages.get().getBundle().key("GUI_LABEL_STACKTRACE_0"));
                errorBox.append("\" class=\"hiddenStacktrace\" style=\"display:none;\"><pre><b>");
                errorBox.append(exception.getLocalizedMessage());
                errorBox.append("</b>\n\n");
                errorBox.append(stacktrace);
                errorBox.append("</pre></span></span>");
            }
            errorBox.append("</div>");
            this.pageContext.getOut().print(errorBox.toString());
        }
    }

    private void renderContainerElement(CmsObject cms, CmsJspStandardContextBean standardContext, CmsContainerElementBean element, Locale locale) throws Exception {
        ServletRequest req = this.pageContext.getRequest();
        ServletResponse res = this.pageContext.getResponse();
        String containerType = this.getType();
        int containerWidth = this.getContainerWidth();
        boolean isOnline = cms.getRequestContext().getCurrentProject().isOnlineProject();
        element.initResource(cms);
        if (!isOnline) {
            this.getSessionCache(cms).setCacheContainerElement(element.editorHash(), element);
        }
        CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri());
        boolean isGroupContainer = element.isGroupContainer(cms);
        boolean isInheritedContainer = element.isInheritedContainer(cms);
        if (isGroupContainer || isInheritedContainer) {
            List<CmsContainerElementBean> subElements = isGroupContainer ? this.getGroupContainerElements(cms, element, req, containerType) : this.getInheritedContainerElements(cms, element);
            this.printElementWrapperTagStart(isOnline, cms, element, true);
            for (CmsContainerElementBean subelement : subElements) {
                try {
                    CmsFormatterConfiguration subelementFormatters;
                    CmsFormatterBean subelementFormatter;
                    subelement.initResource(cms);
                    if (!isOnline) {
                        this.getSessionCache(cms).setCacheContainerElement(subelement.editorHash(), subelement);
                    }
                    if ((subelementFormatter = (subelementFormatters = adeConfig.getFormatters(cms, subelement.getResource())).getFormatter(containerType, containerWidth)) == null) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)new CmsIllegalStateException(Messages.get().container("ERR_XSD_NO_TEMPLATE_FORMATTER_3", subelement.getSitePath(), OpenCms.getResourceManager().getResourceType(subelement.getResource()).getTypeName(), containerType)));
                        continue;
                    }
                    this.printElementWrapperTagStart(isOnline, cms, subelement, false);
                    standardContext.setElement(subelement);
                    try {
                        CmsJspTagInclude.includeTagAction(this.pageContext, subelementFormatter.getJspRootPath(), null, locale, false, isOnline, null, CmsRequestUtil.getAtrributeMap(req), req, res);
                    }
                    catch (Exception e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)Messages.get().getBundle().key("ERR_CONTAINER_PAGE_ELEMENT_RENDER_ERROR_2", subelement.getSitePath(), subelementFormatter), (Throwable)e);
                        }
                        this.printElementErrorTag(isOnline, subelement.getSitePath(), subelementFormatter.getJspRootPath(), e);
                    }
                    this.printElementWrapperTagEnd(isOnline, false);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e);
                }
            }
            this.printElementWrapperTagEnd(isOnline, true);
        } else {
            String formatter = null;
            try {
                formatter = cms.getSitePath(cms.readResource(element.getFormatterId()));
            }
            catch (CmsException e) {
                CmsFormatterConfiguration elementFormatters = adeConfig.getFormatters(cms, element.getResource());
                CmsFormatterBean elementFormatterBean = elementFormatters.getFormatter(containerType, containerWidth);
                if (elementFormatterBean == null) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)new CmsIllegalStateException(Messages.get().container("ERR_XSD_NO_TEMPLATE_FORMATTER_3", element.getSitePath(), OpenCms.getResourceManager().getResourceType(element.getResource()).getTypeName(), containerType)));
                    }
                    return;
                }
                formatter = elementFormatterBean.getJspRootPath();
            }
            this.printElementWrapperTagStart(isOnline, cms, element, false);
            standardContext.setElement(element);
            try {
                CmsJspTagInclude.includeTagAction(this.pageContext, formatter, null, locale, false, isOnline, null, CmsRequestUtil.getAtrributeMap(req), req, res);
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_CONTAINER_PAGE_ELEMENT_RENDER_ERROR_2", element.getSitePath(), formatter), (Throwable)e);
                }
                this.printElementErrorTag(isOnline, element.getSitePath(), formatter, e);
            }
            this.printElementWrapperTagEnd(isOnline, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JsonContainer {
        elements,
        isDetailView,
        maxElem,
        name,
        type,
        width;

    }
}

