/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsContentInfoBean;
import org.opencms.jsp.CmsJspScopedVarBodyTagSuport;
import org.opencms.jsp.I_CmsResourceContainer;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspResourceLoadBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsJspTagResourceLoad
extends CmsJspScopedVarBodyTagSuport
implements I_CmsResourceContainer {
    private static final long serialVersionUID = -3753361821868919139L;
    protected transient CmsObject m_cms;
    protected String m_collector;
    protected String m_collectorName;
    protected String m_collectorParam;
    protected List<CmsResource> m_collectorResult;
    protected CmsContentInfoBean m_contentInfoBean;
    protected CmsFlexController m_controller;
    protected String m_pageIndex;
    protected String m_pageNavLength;
    protected String m_pageSize;
    protected String m_param;
    protected boolean m_preload;
    protected String m_property;
    protected transient CmsResource m_resource;
    protected String m_resourceName;

    public CmsJspTagResourceLoad() {
    }

    public CmsJspTagResourceLoad(I_CmsResourceContainer container, PageContext context, String collectorName, String collectorParam) throws JspException {
        this(container, context, collectorName, collectorParam, null, null);
    }

    public CmsJspTagResourceLoad(I_CmsResourceContainer container, PageContext context, String collectorName, String collectorParam, String pageIndex, String pageSize) throws JspException {
        this.setCollector(collectorName);
        this.setParam(collectorParam);
        this.setPageIndex(pageIndex);
        this.setPageSize(pageSize);
        this.m_preload = false;
        this.setPageContext(context);
        this.init(container);
    }

    protected static String getResourceName(CmsObject cms, I_CmsResourceContainer contentContainer) {
        if (contentContainer != null && contentContainer.getResourceName() != null) {
            return contentContainer.getResourceName();
        }
        if (cms != null) {
            return cms.getRequestContext().getUri();
        }
        return null;
    }

    protected static List<CmsResource> limitCollectorResult(CmsContentInfoBean contentInfoBean, List<CmsResource> collectorResult) {
        List<CmsResource> result = null;
        int pageCount = -1;
        if (contentInfoBean.getPageSize() > 0) {
            pageCount = collectorResult.size() / contentInfoBean.getPageSize();
            if (collectorResult.size() % contentInfoBean.getPageSize() != 0) {
                ++pageCount;
            }
            contentInfoBean.setPageCount(pageCount);
            int startIndex = (contentInfoBean.getPageIndex() - 1) * contentInfoBean.getPageSize();
            int endIndex = contentInfoBean.getPageIndex() * contentInfoBean.getPageSize();
            if (endIndex > collectorResult.size()) {
                endIndex = collectorResult.size();
            }
            result = collectorResult.subList(startIndex, endIndex);
        } else {
            result = collectorResult;
            if (collectorResult.size() > 0) {
                contentInfoBean.setPageCount(1);
            }
        }
        return result;
    }

    public int doAfterBody() throws JspException {
        if (this.hasMoreResources()) {
            return 2;
        }
        if (OpenCms.getSystemInfo().getServletContainerSettings().isReleaseTagsAfterEnd()) {
            this.release();
        }
        return 0;
    }

    public int doEndTag() {
        this.release();
        return 6;
    }

    public int doStartTag() throws JspException, CmsIllegalArgumentException {
        Tag ancestor = CmsJspTagResourceLoad.findAncestorWithClass((Tag)this, I_CmsResourceContainer.class);
        I_CmsResourceContainer container = null;
        if (ancestor != null && !(container = (I_CmsResourceContainer)ancestor).isPreloader()) {
            container = null;
        }
        this.init(container);
        this.hasMoreResources();
        return this.isScopeVarSet() ? 0 : 1;
    }

    public String getCollector() {
        return this.m_collector;
    }

    @Override
    public String getCollectorName() {
        return this.m_collectorName;
    }

    @Override
    public String getCollectorParam() {
        return this.m_collectorParam;
    }

    @Override
    public List<CmsResource> getCollectorResult() {
        return this.m_collectorResult;
    }

    public String getPageIndex() {
        return this.m_pageIndex;
    }

    public String getPageNavLength() {
        return this.m_pageNavLength;
    }

    public String getPageSize() {
        return this.m_pageSize;
    }

    public String getParam() {
        return this.m_param;
    }

    public String getPreload() {
        return String.valueOf(this.isPreloader());
    }

    public String getProperty() {
        return this.m_property;
    }

    @Override
    public CmsResource getResource() {
        return this.m_resource;
    }

    @Override
    public String getResourceName() {
        return this.m_resourceName;
    }

    @Override
    @Deprecated
    public boolean hasMoreContent() throws JspException {
        return this.hasMoreResources();
    }

    @Override
    public boolean hasMoreResources() throws JspException {
        boolean hasMoreResources;
        if (this.isPreloader()) {
            return false;
        }
        boolean bl = hasMoreResources = this.m_collectorResult.size() > 0;
        if (hasMoreResources) {
            this.doLoadNextResource();
        }
        return hasMoreResources;
    }

    @Override
    public boolean isPreloader() {
        return this.isScopeVarSet() ? true : this.m_preload;
    }

    @Override
    public void release() {
        this.m_cms = null;
        this.m_collector = null;
        this.m_collectorName = null;
        this.m_collectorParam = null;
        this.m_collectorResult = null;
        this.m_resource = null;
        this.m_contentInfoBean = null;
        this.m_controller = null;
        this.m_pageIndex = null;
        this.m_pageNavLength = null;
        this.m_pageSize = null;
        this.m_param = null;
        this.m_preload = false;
        this.m_property = null;
        this.m_resourceName = null;
        super.release();
    }

    public void setCollector(String collector) {
        this.m_collector = collector;
    }

    public void setPageIndex(String pageIndex) {
        this.m_pageIndex = pageIndex;
    }

    public void setPageNavLength(String pageNavLength) {
        this.m_pageNavLength = pageNavLength;
    }

    public void setPageSize(String pageSize) {
        this.m_pageSize = pageSize;
    }

    public void setParam(String param) {
        this.m_param = param;
    }

    public void setPreload(String preload) {
        this.m_preload = Boolean.valueOf(preload);
    }

    public void setProperty(String property) {
        this.m_property = property;
    }

    protected void doLoadNextResource() {
        CmsResource resource = this.getNextResource();
        if (resource == null) {
            this.m_resourceName = null;
            this.m_resource = null;
            return;
        }
        this.m_resourceName = this.m_cms.getSitePath(resource);
        this.m_resource = resource;
    }

    protected CmsContentInfoBean getContentInfoBean() {
        return this.m_contentInfoBean;
    }

    protected CmsResource getNextResource() {
        if (this.m_collectorResult != null && this.m_collectorResult.size() > 0) {
            this.m_contentInfoBean.incResultIndex();
            return this.m_collectorResult.remove(0);
        }
        return null;
    }

    protected void init(I_CmsResourceContainer container) throws JspException {
        I_CmsResourceContainer usedContainer;
        int pageAttribCount = 0;
        pageAttribCount += CmsStringUtil.isNotEmpty(this.m_pageSize) ? 1 : 0;
        if ((pageAttribCount += CmsStringUtil.isNotEmpty(this.m_pageIndex) ? 1 : 0) > 0 && pageAttribCount < 2) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_TAG_RESOURCELOAD_INDEX_SIZE_0"));
        }
        if (container == null) {
            usedContainer = this;
            if (CmsStringUtil.isEmpty(this.m_collector)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_TAG_RESOURCELOAD_MISSING_COLLECTOR_0"));
            }
            if (CmsStringUtil.isEmpty(this.m_param)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_TAG_RESOURCELOAD_MISSING_PARAM_0"));
            }
        } else {
            usedContainer = container;
        }
        this.m_controller = CmsFlexController.getController(this.pageContext.getRequest());
        this.m_cms = this.m_controller.getCmsObject();
        String resourcename = CmsJspTagResourceLoad.getResourceName(this.m_cms, usedContainer);
        CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(this.m_cms).setJspPageContext(this.pageContext).setResourceName(resourcename).setKeepEmptyMacros(true);
        if (container == null) {
            this.m_collectorName = resolver.resolveMacros(this.getCollector());
            this.m_collectorParam = resolver.resolveMacros(this.getParam());
            this.m_collectorResult = null;
        } else {
            this.m_collectorName = usedContainer.getCollectorName();
            this.m_collectorParam = usedContainer.getCollectorParam();
            this.m_collectorResult = usedContainer.getCollectorResult();
        }
        try {
            I_CmsResourceCollector collector = OpenCms.getResourceManager().getContentCollector(this.m_collectorName);
            if (collector == null) {
                throw new CmsException(Messages.get().container("ERR_COLLECTOR_NOT_FOUND_1", this.m_collectorName));
            }
            if (this.m_collectorResult == null) {
                this.m_collectorResult = collector.getResults(this.m_cms, this.m_collectorName, this.m_collectorParam);
            }
            this.m_contentInfoBean = new CmsContentInfoBean();
            this.m_contentInfoBean.setPageSizeAsString(resolver.resolveMacros(this.m_pageSize));
            this.m_contentInfoBean.setPageIndexAsString(resolver.resolveMacros(this.m_pageIndex));
            this.m_contentInfoBean.setPageNavLengthAsString(resolver.resolveMacros(this.m_pageNavLength));
            this.m_contentInfoBean.setResultSize(this.m_collectorResult.size());
            this.m_contentInfoBean.initResultIndex();
            if (!this.isPreloader()) {
                this.m_collectorResult = CmsJspTagResourceLoad.limitCollectorResult(this.m_contentInfoBean, this.m_collectorResult);
                this.m_contentInfoBean.initPageNavIndexes();
            } else if (this.isScopeVarSet()) {
                CmsJspResourceLoadBean bean = new CmsJspResourceLoadBean(this.m_cms, this.m_collectorResult);
                this.storeAttribute(bean);
            }
        }
        catch (CmsException e) {
            this.m_controller.setThrowable(e, this.m_cms.getRequestContext().getUri());
            throw new JspException((Throwable)e);
        }
    }
}

