/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.page.CmsXmlPageFactory;

public class CmsJspTagTemplate
extends BodyTagSupport {
    private static final long serialVersionUID = -3773247710025810438L;
    private static final Log LOG = CmsLog.getLog(CmsJspTagTemplate.class);
    private boolean m_checkall;
    private boolean m_checknone;
    private String m_element;
    private String m_elementlist;

    public static boolean templateTagAction(String element, String elementlist, boolean checkall, boolean checknone, ServletRequest req) {
        if (elementlist != null) {
            CmsFlexController controller = CmsFlexController.getController(req);
            String filename = controller.getCmsObject().getRequestContext().getUri();
            I_CmsXmlDocument content = null;
            try {
                content = CmsXmlPageFactory.unmarshal(controller.getCmsObject(), filename, req);
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_XML_DOCUMENT_UNMARSHAL_1", filename), (Throwable)e);
            }
            if (content != null) {
                String absolutePath = controller.getCmsObject().getSitePath(content.getFile());
                String[] elements = CmsStringUtil.splitAsArray(elementlist, ',');
                boolean found = false;
                for (int i = 0; i < elements.length; ++i) {
                    String el = elements[i].trim();
                    List<Locale> locales = content.getLocales(el);
                    Locale locale = null;
                    if (locales != null && locales.size() != 0) {
                        locale = OpenCms.getLocaleManager().getBestMatchingLocale(controller.getCmsObject().getRequestContext().getLocale(), OpenCms.getLocaleManager().getDefaultLocales(controller.getCmsObject(), absolutePath), locales);
                    }
                    if (locale != null && content.hasValue(el, locale) && content.isEnabled(el, locale)) {
                        found = true;
                        if (checkall) continue;
                        break;
                    }
                    if (!checkall) continue;
                    return false;
                }
                if (!found && !checknone) {
                    return false;
                }
                if (found && checknone) {
                    return false;
                }
            }
        }
        String param = req.getParameter("__element");
        return element == null || param == null || param.equals(element);
    }

    public int doStartTag() {
        if (CmsJspTagTemplate.templateTagAction(this.m_element, this.m_elementlist, this.m_checkall, this.m_checknone, this.pageContext.getRequest())) {
            return 1;
        }
        return 0;
    }

    public String getElement() {
        return this.m_element != null ? this.m_element : "";
    }

    public String getIfexists() {
        return this.m_elementlist != null ? this.m_elementlist : "";
    }

    public String getIfexistsall() {
        return this.m_elementlist != null ? this.m_elementlist : "";
    }

    public String getIfexistsnone() {
        return this.m_elementlist != null ? this.m_elementlist : "";
    }

    public String getIfexistsone() {
        return this.m_elementlist != null ? this.m_elementlist : "";
    }

    public void release() {
        super.release();
        this.m_element = null;
    }

    public void setElement(String element) {
        if (element != null) {
            this.m_element = element.toLowerCase();
        }
    }

    public void setIfexists(String elements) {
        if (elements != null) {
            this.m_elementlist = elements;
            this.m_checkall = false;
            this.m_checknone = false;
        }
    }

    public void setIfexistsall(String elements) {
        if (elements != null) {
            this.m_elementlist = elements;
            this.m_checkall = true;
            this.m_checknone = false;
        }
    }

    public void setIfexistsnone(String elements) {
        if (elements != null) {
            this.m_elementlist = elements;
            this.m_checkall = false;
            this.m_checknone = true;
        }
    }

    public void setIfexistsone(String elements) {
        if (elements != null) {
            this.m_elementlist = elements;
            this.m_checkall = false;
            this.m_checknone = false;
        }
    }
}

