/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.decorator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.jsp.decorator.CmsDecorationBundle;
import org.opencms.jsp.decorator.CmsDecorationMap;
import org.opencms.jsp.decorator.CmsDecoratorConfiguration;
import org.opencms.jsp.decorator.Messages;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsDecorationDefintion {
    private static final Log LOG = CmsLog.getLog(CmsDecorationDefintion.class);
    private String m_configurationFile;
    private boolean m_markFirst;
    private String m_name;
    private String m_postText;
    private String m_postTextFirst;
    private String m_preText;
    private String m_preTextFirst;

    public CmsDecorationDefintion() {
        this.m_configurationFile = null;
        this.m_markFirst = false;
        this.m_name = null;
        this.m_postText = null;
        this.m_postTextFirst = null;
        this.m_preText = null;
        this.m_preTextFirst = null;
    }

    public CmsDecorationDefintion(String name, String preText, String postText, String preTextFirst, String postTextFirst, boolean markFrist, String configurationFile) {
        this.m_configurationFile = configurationFile;
        this.m_markFirst = markFrist;
        this.m_name = name;
        this.m_postText = postText;
        this.m_postTextFirst = postTextFirst;
        this.m_preText = preText;
        this.m_preTextFirst = preTextFirst;
    }

    public static List<String> getDecorationDefinitionNames(CmsObject cms) throws CmsException {
        ArrayList<String> result = new ArrayList<String>();
        CmsModule module = OpenCms.getModuleManager().getModule("com.alkacon.opencms.extendeddecorator");
        String configFile = module.getParameter("configfile");
        if (CmsStringUtil.isEmpty(configFile)) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_CONFIG_MISSING_0"));
        } else {
            CmsDecoratorConfiguration config = new CmsDecoratorConfiguration(cms, configFile);
            List<CmsDecorationDefintion> decorationDefinitions = config.getDecorationDefinitions();
            for (CmsDecorationDefintion decDef : decorationDefinitions) {
                result.add(decDef.getName());
            }
        }
        return result;
    }

    public CmsDecorationBundle createDecorationBundle(CmsObject cms, Locale locale) throws CmsException {
        List<CmsResource> decorationMapFiles = this.getDecorationMapFiles(cms);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DECORATION_DEFINITION_MAP_FILES_2", decorationMapFiles, locale));
        }
        List<CmsDecorationMap> decorationMaps = this.getDecorationMaps(cms, decorationMapFiles);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DECORATION_DEFINITION_MAPS_2", decorationMaps, locale));
        }
        return this.createDecorationBundle(decorationMaps, locale);
    }

    public CmsDecorationBundle createDecorationBundle(List<CmsDecorationMap> decorationMaps, Locale locale) {
        CmsDecorationBundle decorationBundle = new CmsDecorationBundle(locale);
        Collections.sort(decorationMaps);
        for (CmsDecorationMap decMap : decorationMaps) {
            if (locale != null && decMap.getLocale() != null && !locale.getDisplayLanguage().equals(decMap.getLocale().getDisplayLanguage())) continue;
            decorationBundle.putAll(decMap.getDecorationMap());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DECORATION_DEFINITION_CREATE_BUNDLE_2", decMap.getName(), locale));
        }
        return decorationBundle;
    }

    public String getConfigurationFile() {
        return this.m_configurationFile;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPostText() {
        return this.m_postText;
    }

    public String getPostTextFirst() {
        return this.m_postTextFirst;
    }

    public String getPreText() {
        return this.m_preText;
    }

    public String getPreTextFirst() {
        return this.m_preTextFirst;
    }

    public boolean isMarkFirst() {
        return this.m_markFirst;
    }

    public void setConfigurationFile(String configurationFile) {
        this.m_configurationFile = configurationFile;
    }

    public void setMarkFirst(boolean markFirst) {
        this.m_markFirst = markFirst;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setPostText(String postText) {
        this.m_postText = postText;
    }

    public void setPostTextFirst(String postTextFirst) {
        this.m_postTextFirst = postTextFirst;
    }

    public void setPreText(String preText) {
        this.m_preText = preText;
    }

    public void setPreTextFirst(String preTextFirst) {
        this.m_preTextFirst = preTextFirst;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append(" [name = '");
        buf.append(this.m_name);
        buf.append("', markFirst = '");
        buf.append(this.m_markFirst);
        buf.append("', preText = '");
        buf.append(this.m_preText);
        buf.append("', postText = '");
        buf.append(this.m_postText);
        buf.append("', preTextFirst = '");
        buf.append(this.m_preTextFirst);
        buf.append("', postTextFirst = '");
        buf.append(this.m_postTextFirst);
        buf.append("', configFile = ");
        buf.append(this.m_configurationFile);
        buf.append("]");
        return buf.toString();
    }

    private List<CmsResource> getDecorationMapFiles(CmsObject cms) throws CmsException {
        int plainId;
        ArrayList<CmsResource> files = new ArrayList<CmsResource>();
        StringBuffer baseFilename = new StringBuffer();
        baseFilename.append(CmsResource.getParentFolder(this.m_configurationFile));
        String filename = cms.readResource(this.m_configurationFile).getName();
        if (filename.lastIndexOf(".") > -1) {
            filename = filename.substring(0, filename.lastIndexOf("."));
        }
        if (filename.lastIndexOf("_") > -1) {
            filename = filename.substring(0, filename.lastIndexOf("_"));
        }
        baseFilename.append(filename);
        String basename = baseFilename.toString();
        try {
            plainId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()).getTypeId();
        }
        catch (CmsLoaderException e) {
            plainId = CmsResourceTypePlain.getStaticTypeId();
        }
        List<CmsResource> resources = cms.readResources(CmsResource.getParentFolder(this.m_configurationFile), CmsResourceFilter.DEFAULT);
        for (CmsResource res : resources) {
            if (!cms.getSitePath(res).startsWith(basename) || res.getTypeId() != plainId) continue;
            files.add(res);
        }
        return files;
    }

    private List<CmsDecorationMap> getDecorationMaps(CmsObject cms, List<CmsResource> decorationListFiles) {
        ArrayList<CmsDecorationMap> decorationMaps = new ArrayList<CmsDecorationMap>();
        for (CmsResource res : decorationListFiles) {
            try {
                CmsDecorationMap decMap = (CmsDecorationMap)CmsVfsMemoryObjectCache.getVfsMemoryObjectCache().getCachedObject(cms, res.getRootPath());
                if (decMap == null) {
                    decMap = new CmsDecorationMap(cms, res, this);
                    CmsVfsMemoryObjectCache.getVfsMemoryObjectCache().putCachedObject(cms, res.getRootPath(), decMap);
                }
                decorationMaps.add(decMap);
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)Messages.get().getBundle().key("LOG_DECORATION_DEFINITION_CREATE_MAP_2", res.getName(), e));
            }
        }
        return decorationMaps;
    }
}

