/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.decorator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.decorator.CmsDecorationDefintion;
import org.opencms.jsp.decorator.CmsDecorationObject;
import org.opencms.jsp.decorator.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsDecorationMap
implements Comparable<CmsDecorationMap> {
    public static final String CSV_SEPERATOR = "|";
    private static final Log LOG = CmsLog.getLog(CmsDecorationMap.class);
    private Map<String, CmsDecorationObject> m_decorationMap;
    private CmsDecorationDefintion m_decoratorDefinition;
    private Locale m_locale;
    private String m_name;

    public CmsDecorationMap(CmsDecorationDefintion decDef, String name, Locale locale) {
        this.m_decoratorDefinition = decDef;
        this.m_name = name;
        this.m_locale = locale;
        this.m_decorationMap = new HashMap<String, CmsDecorationObject>();
    }

    public CmsDecorationMap(CmsObject cms, CmsResource res, CmsDecorationDefintion decDef) throws CmsException {
        this.m_decoratorDefinition = decDef;
        this.m_name = res.getName();
        this.m_locale = this.extractLocale();
        this.m_decorationMap = this.fillMap(cms, res);
    }

    @Override
    public int compareTo(CmsDecorationMap o) {
        return this.m_name.compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsDecorationMap) {
            return ((CmsDecorationMap)obj).m_name.equals(this.m_name);
        }
        return false;
    }

    public Map<String, CmsDecorationObject> getDecorationMap() {
        return this.m_decorationMap;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getName() {
        return this.m_name;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public void setDecorationMap(Map<String, CmsDecorationObject> decorationMap) {
        this.m_decorationMap = decorationMap;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append(" [name = '");
        buf.append(this.m_name);
        buf.append("' locale=");
        buf.append(this.m_locale);
        buf.append("' mapsize=");
        buf.append(this.m_decorationMap.size());
        buf.append("]");
        return buf.toString();
    }

    private Locale extractLocale() {
        Locale loc = null;
        int underscore = this.m_name.lastIndexOf("_");
        if (underscore > -1) {
            String localeName = this.m_name.substring(underscore + 1);
            if (localeName.lastIndexOf(".") > -1) {
                localeName = localeName.substring(0, localeName.lastIndexOf("."));
            }
            loc = CmsLocaleManager.getLocale(localeName);
        }
        return loc;
    }

    private Map<String, CmsDecorationObject> fillMap(CmsObject cms, CmsResource res) throws CmsException {
        String delimiter;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DECORATION_MAP_FILL_MAP_2", this.m_name, this.m_decoratorDefinition));
        }
        HashMap<String, CmsDecorationObject> decMap = new HashMap<String, CmsDecorationObject>();
        CmsFile file = cms.readFile(res);
        String unparsedContent = new String(file.getContents());
        if (unparsedContent.indexOf(delimiter = "\r\n") == -1 && unparsedContent.indexOf("\n") > -1) {
            delimiter = "\n";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DECORATION_MAP_FILL_MAP_DELIMITER_2", res.getName(), CmsStringUtil.escapeJavaScript(delimiter)));
        }
        List<String> entries = CmsStringUtil.splitAsList(unparsedContent, delimiter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DECORATION_MAP_FILL_MAP_SPLIT_LIST_2", res.getName(), entries));
        }
        Iterator<String> i = entries.iterator();
        while (i.hasNext()) {
            try {
                int speratator;
                String entry = i.next();
                if (!CmsStringUtil.isNotEmpty(entry) || (speratator = entry.indexOf(CSV_SEPERATOR)) <= -1) continue;
                String key = entry.substring(0, speratator).trim();
                String value = entry.substring(speratator + 1).trim();
                if (!CmsStringUtil.isNotEmpty(key) || !CmsStringUtil.isNotEmpty(value)) continue;
                CmsDecorationObject decObj = new CmsDecorationObject(key, value, this.m_decoratorDefinition, this.m_locale);
                decMap.put(key, decObj);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DECORATION_MAP_ADD_DECORATION_OBJECT_2", decObj, key));
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)Messages.get().getBundle().key("LOG_DECORATION_MAP_FILL_2", this.m_name, e));
            }
        }
        return decMap;
    }
}

