/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.util.CmsJspContentAccessValueWrapper;
import org.opencms.jsp.util.CmsJspElFunctions;
import org.opencms.jsp.util.CmsJspVfsAccessBean;
import org.opencms.jsp.util.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsConstantMap;
import org.opencms.util.CmsUUID;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.page.CmsXmlPageFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsJspContentAccessBean {
    protected static final Map<String, CmsJspContentAccessValueWrapper> CONSTANT_NULL_VALUE_WRAPPER_MAP = new CmsConstantMap<String, CmsJspContentAccessValueWrapper>(CmsJspContentAccessValueWrapper.NULL_VALUE_WRAPPER);
    private CmsObject m_cms;
    private I_CmsXmlDocument m_content;
    private Map<String, Boolean> m_hasLocale;
    private Map<String, Map<String, Boolean>> m_hasLocaleValue;
    private Locale m_locale;
    private Map<String, List<String>> m_localeNames;
    private Map<String, Map<String, String>> m_localeRdfa;
    private Map<String, Map<String, List<CmsJspContentAccessValueWrapper>>> m_localeSubValueList;
    private Map<String, Map<String, CmsJspContentAccessValueWrapper>> m_localeValue;
    private Map<String, Map<String, List<CmsJspContentAccessValueWrapper>>> m_localeValueList;
    private CmsResource m_resource;

    public CmsJspContentAccessBean() {
    }

    public CmsJspContentAccessBean(CmsObject cms, CmsResource resource) {
        this(cms, cms.getRequestContext().getLocale(), resource);
    }

    public CmsJspContentAccessBean(CmsObject cms, Locale locale, CmsResource resource) {
        this.init(cms, locale, null, resource);
    }

    public CmsJspContentAccessBean(CmsObject cms, Locale locale, I_CmsXmlDocument content) {
        this.init(cms, locale, content, content.getFile());
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public CmsFile getFile() {
        return this.getRawContent().getFile();
    }

    public String getFilename() {
        return this.m_cms.getSitePath(this.getRawContent().getFile());
    }

    public Map<String, Boolean> getHasLocale() {
        if (this.m_hasLocale == null) {
            this.m_hasLocale = CmsCollectionsGenericWrapper.createLazyMap(new CmsHasLocaleTransformer());
        }
        return this.m_hasLocale;
    }

    public Map<String, Map<String, Boolean>> getHasLocaleValue() {
        if (this.m_hasLocaleValue == null) {
            this.m_hasLocaleValue = CmsCollectionsGenericWrapper.createLazyMap(new CmsHasLocaleValueTransformer());
        }
        return this.m_hasLocaleValue;
    }

    public Map<String, Boolean> getHasValue() {
        return this.getHasLocaleValue().get(this.m_locale);
    }

    public CmsUUID getId() {
        return this.getRawContent().getFile().getStructureId();
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public Map<String, List<String>> getLocaleNames() {
        if (this.m_localeNames == null) {
            this.m_localeNames = CmsCollectionsGenericWrapper.createLazyMap(new CmsLocaleNamesTransformer());
        }
        return this.m_localeNames;
    }

    public Map<String, Map<String, String>> getLocaleRdfa() {
        if (this.m_localeRdfa == null) {
            this.m_localeRdfa = CmsCollectionsGenericWrapper.createLazyMap(new CmsLocaleRdfaTransformer());
        }
        return this.m_localeRdfa;
    }

    public Map<String, Map<String, List<CmsJspContentAccessValueWrapper>>> getLocaleSubValueList() {
        if (this.m_localeSubValueList == null) {
            this.m_localeSubValueList = CmsCollectionsGenericWrapper.createLazyMap(new CmsLocaleSubValueListTransformer());
        }
        return this.m_localeSubValueList;
    }

    public Map<String, Map<String, CmsJspContentAccessValueWrapper>> getLocaleValue() {
        if (this.m_localeValue == null) {
            this.m_localeValue = CmsCollectionsGenericWrapper.createLazyMap(new CmsLocaleValueTransformer());
        }
        return this.m_localeValue;
    }

    public Map<String, Map<String, List<CmsJspContentAccessValueWrapper>>> getLocaleValueList() {
        if (this.m_localeValueList == null) {
            this.m_localeValueList = CmsCollectionsGenericWrapper.createLazyMap(new CmsLocaleValueListTransformer());
        }
        return this.m_localeValueList;
    }

    public List<String> getNames() {
        return this.getLocaleNames().get(this.m_locale);
    }

    public I_CmsXmlDocument getRawContent() {
        if (this.m_content == null) {
            try {
                CmsFile file = this.m_cms.readFile(this.m_resource);
                this.m_content = CmsResourceTypeXmlPage.isXmlPage(file) ? CmsXmlPageFactory.unmarshal(this.m_cms, file) : CmsXmlContentFactory.unmarshal(this.m_cms, file);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_XML_CONTENT_UNMARSHAL_1", this.m_resource.getRootPath()), (Throwable)e);
            }
        }
        return this.m_content;
    }

    public Map<String, String> getRdfa() {
        return this.getLocaleRdfa().get(this.m_locale);
    }

    public Map<String, List<CmsJspContentAccessValueWrapper>> getSubValueList() {
        return this.getLocaleSubValueList().get(this.m_locale);
    }

    public Map<String, CmsJspContentAccessValueWrapper> getValue() {
        return this.getLocaleValue().get(this.m_locale);
    }

    public Map<String, List<CmsJspContentAccessValueWrapper>> getValueList() {
        return this.getLocaleValueList().get(this.m_locale);
    }

    public CmsJspVfsAccessBean getVfs() {
        return CmsJspVfsAccessBean.create(this.m_cms);
    }

    public void init(CmsObject cms, Locale locale, I_CmsXmlDocument content, CmsResource resource) {
        this.m_cms = cms;
        this.m_locale = locale;
        this.m_content = content;
        this.m_resource = resource;
    }

    public class CmsValueTransformer
    implements Transformer {
        private Locale m_selectedLocale;

        public CmsValueTransformer(Locale locale) {
            this.m_selectedLocale = locale;
        }

        public Object transform(Object input) {
            I_CmsXmlContentValue value = CmsJspContentAccessBean.this.getRawContent().getValue(String.valueOf(input), this.m_selectedLocale);
            return CmsJspContentAccessValueWrapper.createWrapper(CmsJspContentAccessBean.this.getCmsObject(), value);
        }
    }

    public class CmsValueListTransformer
    implements Transformer {
        private Locale m_selectedLocale;

        public CmsValueListTransformer(Locale locale) {
            this.m_selectedLocale = locale;
        }

        public Object transform(Object input) {
            List<I_CmsXmlContentValue> values = CmsJspContentAccessBean.this.getRawContent().getValues(String.valueOf(input), this.m_selectedLocale);
            ArrayList<CmsJspContentAccessValueWrapper> result = new ArrayList<CmsJspContentAccessValueWrapper>();
            for (I_CmsXmlContentValue value : values) {
                result.add(CmsJspContentAccessValueWrapper.createWrapper(CmsJspContentAccessBean.this.getCmsObject(), value));
            }
            return result;
        }
    }

    public class CmsSubValueListTransformer
    implements Transformer {
        private Locale m_selectedLocale;

        public CmsSubValueListTransformer(Locale locale) {
            this.m_selectedLocale = locale;
        }

        public Object transform(Object input) {
            List<I_CmsXmlContentValue> values = CmsJspContentAccessBean.this.getRawContent().getSubValues(String.valueOf(input), this.m_selectedLocale);
            ArrayList<CmsJspContentAccessValueWrapper> result = new ArrayList<CmsJspContentAccessValueWrapper>();
            for (I_CmsXmlContentValue value : values) {
                result.add(CmsJspContentAccessValueWrapper.createWrapper(CmsJspContentAccessBean.this.getCmsObject(), value));
            }
            return result;
        }
    }

    public class CmsRdfaTransformer
    implements Transformer {
        private Locale m_selectedLocale;

        public CmsRdfaTransformer(Locale locale) {
            this.m_selectedLocale = locale;
        }

        public Object transform(Object input) {
            CmsJspContentAccessValueWrapper wrapper = CmsJspContentAccessBean.this.getLocaleValue().get(this.m_selectedLocale).get(input);
            return wrapper.getRdfaAttr();
        }
    }

    public class CmsLocaleValueTransformer
    implements Transformer {
        public Object transform(Object input) {
            Locale locale = CmsLocaleManager.getLocale(String.valueOf(input));
            Map<String, CmsJspContentAccessValueWrapper> result = CmsJspContentAccessBean.this.getRawContent().hasLocale(locale) ? CmsCollectionsGenericWrapper.createLazyMap(new CmsValueTransformer(locale)) : CONSTANT_NULL_VALUE_WRAPPER_MAP;
            return result;
        }
    }

    public class CmsLocaleValueListTransformer
    implements Transformer {
        public Object transform(Object input) {
            Locale locale = CmsJspElFunctions.convertLocale(input);
            Map<String, List<CmsJspContentAccessValueWrapper>> result = CmsJspContentAccessBean.this.getRawContent().hasLocale(locale) ? CmsCollectionsGenericWrapper.createLazyMap(new CmsValueListTransformer(locale)) : CmsConstantMap.CONSTANT_EMPTY_LIST_MAP;
            return result;
        }
    }

    public class CmsLocaleSubValueListTransformer
    implements Transformer {
        public Object transform(Object input) {
            Locale locale = CmsJspElFunctions.convertLocale(input);
            Map<String, List<CmsJspContentAccessValueWrapper>> result = CmsJspContentAccessBean.this.getRawContent().hasLocale(locale) ? CmsCollectionsGenericWrapper.createLazyMap(new CmsSubValueListTransformer(locale)) : CmsConstantMap.CONSTANT_EMPTY_LIST_MAP;
            return result;
        }
    }

    public class CmsLocaleRdfaTransformer
    implements Transformer {
        public Object transform(Object input) {
            Locale locale = CmsLocaleManager.getLocale(String.valueOf(input));
            Map<String, String> result = CmsJspContentAccessBean.this.getRawContent().hasLocale(locale) ? CmsCollectionsGenericWrapper.createLazyMap(new CmsRdfaTransformer(locale)) : CmsConstantMap.CONSTANT_EMPTY_STRING_MAP;
            return result;
        }
    }

    public class CmsLocaleNamesTransformer
    implements Transformer {
        public Object transform(Object input) {
            Locale locale = CmsLocaleManager.getLocale(String.valueOf(input));
            return CmsJspContentAccessBean.this.getRawContent().getNames(locale);
        }
    }

    public class CmsHasValueTransformer
    implements Transformer {
        private Locale m_selectedLocale;

        public CmsHasValueTransformer(Locale locale) {
            this.m_selectedLocale = locale;
        }

        public Object transform(Object input) {
            return CmsJspContentAccessBean.this.getRawContent().hasValue(String.valueOf(input), this.m_selectedLocale);
        }
    }

    public class CmsHasLocaleValueTransformer
    implements Transformer {
        public Object transform(Object input) {
            Locale locale = CmsJspElFunctions.convertLocale(input);
            Map<String, Boolean> result = CmsJspContentAccessBean.this.getRawContent().hasLocale(locale) ? CmsCollectionsGenericWrapper.createLazyMap(new CmsHasValueTransformer(locale)) : CmsConstantMap.CONSTANT_BOOLEAN_FALSE_MAP;
            return result;
        }
    }

    public class CmsHasLocaleTransformer
    implements Transformer {
        public Object transform(Object input) {
            return CmsJspContentAccessBean.this.getRawContent().hasLocale(CmsJspElFunctions.convertLocale(input));
        }
    }
}

