/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.opencms.jsp.util.I_CmsJspDeviceSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsJspDeviceSelector
implements I_CmsJspDeviceSelector {
    public static final String C_CONSOLE = "console";
    public static final String C_DESKTOP = "desktop";
    public static final String C_MOBILE = "mobile";
    public static final String DEVICE_ANDROID = "android";
    public static final String DEVICE_ARCHOS = "archos";
    public static final String DEVICE_BB = "blackberry";
    public static final String DEVICE_BREW = "brew";
    public static final String DEVICE_DANGER = "danger";
    public static final String DEVICE_HIPTOP = "hiptop";
    public static final String DEVICE_IEMOBILE = "iemobile";
    public static final String DEVICE_IPHONE = "iphone";
    public static final String DEVICE_IPOD = "ipod";
    public static final String DEVICE_MIDP = "midp";
    public static final String DEVICE_NINTENDO = "nintendo";
    public static final String DEVICE_NINTENDO_DS = "nitro";
    public static final String DEVICE_PALM = "palm";
    public static final String DEVICE_PDA = "pda";
    public static final String DEVICE_PLAYSTATION = "playstation";
    public static final String DEVICE_S60 = "series60";
    public static final String DEVICE_S70 = "series70";
    public static final String DEVICE_S80 = "series80";
    public static final String DEVICE_S90 = "series90";
    public static final String DEVICE_SYMBIAN = "symbian";
    public static final String DEVICE_WII = "wii";
    public static final String DEVICE_WIN_MOBILE = "windows ce";
    public static final String DEVICE_WINDOWS = "windows";
    public static final String DEVICE_XBOX = "xbox";
    public static final String ENGINE_BLAZER = "blazer";
    public static final String ENGINE_NETFRONT = "netfront";
    public static final String ENGINE_OPEN_WEB = "openweb";
    public static final String ENGINE_OPERA = "opera";
    public static final String ENGINE_PIE = "wm5 pie";
    public static final String ENGINE_UP_BROWSER = "up.browser";
    public static final String ENGINE_WEBKIT = "webkit";
    public static final String ENGINE_XIINO = "xiino";
    public static final String LINUX = "linux";
    public static final String MAEMO = "maemo";
    public static final String MAEMO_TABLET = "tablet";
    public static final String MANU_ERICSSON = "ericsson";
    public static final String MANU_SAMSUNG1 = "sec-sgh";
    public static final String MANU_SONY = "sony";
    public static final String MANU_SONY_ERICSSON = "sonyericsson";
    public static final String MINI = "mini";
    public static final String MOBI = "mobi";
    public static final String MOBILE = "mobile";
    public static final String MYLO_COM2 = "com2";
    public static final String QT_EMBEDDED = "qt embedded";
    public static final String SVC_DOCOMO = "docomo";
    public static final String SVC_KDDI = "kddi";
    public static final String SVC_VODAFONE = "vodafone";
    public static final String UPLINK = "up.link";
    public static final String VND_RIM = "vnd.rim";
    public static final String VND_WAP = "vnd.wap";
    public static final String WML = "wml";
    protected String m_httpAccept = "";
    protected String m_userAgent = "";

    @Override
    public String getDeviceType(HttpServletRequest req) {
        this.init(req.getHeader("user-agent"), req.getHeader("Accept"));
        if (this.detectMobileQuick()) {
            return "mobile";
        }
        if (this.detectGameConsole()) {
            return C_CONSOLE;
        }
        return C_DESKTOP;
    }

    @Override
    public List<String> getDeviceTypes() {
        String[] devices = new String[]{"mobile", C_CONSOLE, C_DESKTOP};
        return Arrays.asList(devices);
    }

    public String getHttpAccept() {
        return this.m_httpAccept;
    }

    public String getUserAgent() {
        return this.m_userAgent;
    }

    public void init(String userAgent, String httpAccept) {
        if (userAgent != null) {
            this.m_userAgent = userAgent.toLowerCase();
        }
        if (httpAccept != null) {
            this.m_httpAccept = httpAccept.toLowerCase();
        }
    }

    protected boolean detectAndroid() {
        return this.m_userAgent.indexOf(DEVICE_ANDROID) != -1;
    }

    protected boolean detectAndroidWebKit() {
        return this.detectAndroid() && this.detectWebkit();
    }

    protected boolean detectArchos() {
        return this.m_userAgent.indexOf(DEVICE_ARCHOS) != -1;
    }

    protected boolean detectBlackBerry() {
        return this.m_userAgent.indexOf(DEVICE_BB) != -1 || this.m_httpAccept.indexOf(VND_RIM) != -1;
    }

    protected boolean detectBrewDevice() {
        return this.m_userAgent.indexOf(DEVICE_BREW) != -1;
    }

    protected boolean detectDangerHiptop() {
        return this.m_userAgent.indexOf(DEVICE_DANGER) != -1 || this.m_userAgent.indexOf(DEVICE_HIPTOP) != -1;
    }

    protected boolean detectGameConsole() {
        return this.detectSonyPlaystation() || this.detectNintendo() || this.detectXbox();
    }

    protected boolean detectIphone() {
        return this.m_userAgent.indexOf(DEVICE_IPHONE) != -1 && !this.detectIpod();
    }

    protected boolean detectIphoneOrIpod() {
        return this.m_userAgent.indexOf(DEVICE_IPHONE) != -1 || this.m_userAgent.indexOf(DEVICE_IPOD) != -1;
    }

    protected boolean detectIpod() {
        return this.m_userAgent.indexOf(DEVICE_IPOD) != -1;
    }

    protected boolean detectMaemoTablet() {
        return this.m_userAgent.indexOf(MAEMO) != -1;
    }

    protected boolean detectMidpCapable() {
        return this.m_userAgent.indexOf(DEVICE_MIDP) != -1 || this.m_httpAccept.indexOf(DEVICE_MIDP) != -1;
    }

    protected boolean detectMobileLong() {
        return this.detectMobileQuick() || this.detectMaemoTablet() || this.detectGameConsole();
    }

    protected boolean detectMobileQuick() {
        if (this.detectIphone()) {
            return true;
        }
        if (this.detectWapWml()) {
            return true;
        }
        if (this.detectOperaMobile()) {
            return true;
        }
        if (this.m_userAgent.indexOf(ENGINE_UP_BROWSER) != -1 && this.m_userAgent.indexOf(ENGINE_OPEN_WEB) != -1) {
            return true;
        }
        if (this.detectSmartphone()) {
            return true;
        }
        if (this.detectDangerHiptop() && this.detectMidpCapable()) {
            return true;
        }
        if (this.m_userAgent.indexOf(DEVICE_PDA) != -1 && this.m_userAgent.indexOf("mobile") != -1) {
            return true;
        }
        if (this.m_userAgent.indexOf(UPLINK) != -1 && this.m_userAgent.indexOf(MANU_SONY_ERICSSON) != -1) {
            return true;
        }
        if (this.m_userAgent.indexOf(MANU_ERICSSON) != -1 && this.m_userAgent.indexOf(MANU_SAMSUNG1) != -1) {
            return true;
        }
        if (this.m_userAgent.indexOf(SVC_DOCOMO) != -1 && this.m_userAgent.indexOf(SVC_KDDI) != -1) {
            return true;
        }
        if (this.m_userAgent.indexOf(SVC_VODAFONE) != -1) {
            return false;
        }
        return false;
    }

    protected boolean detectNintendo() {
        return this.m_userAgent.indexOf(DEVICE_NINTENDO) != -1 || this.m_userAgent.indexOf(DEVICE_WII) != -1 || this.m_userAgent.indexOf(DEVICE_NINTENDO_DS) != -1;
    }

    protected boolean detectOperaMobile() {
        return this.m_userAgent.indexOf(ENGINE_OPERA) != -1 && (this.m_userAgent.indexOf(MINI) != -1 || this.m_userAgent.indexOf(MOBI) != -1);
    }

    protected boolean detectPalmOS() {
        return this.m_userAgent.indexOf(DEVICE_PALM) != -1 || this.m_userAgent.indexOf(ENGINE_BLAZER) != -1 || this.m_userAgent.indexOf(ENGINE_XIINO) != -1;
    }

    protected boolean detectS60OssBrowser() {
        return this.detectWebkit() && (this.m_userAgent.indexOf(DEVICE_SYMBIAN) != -1 || this.m_userAgent.indexOf(DEVICE_S60) != -1);
    }

    protected boolean detectSmartphone() {
        return this.detectIphoneOrIpod() || this.detectS60OssBrowser() || this.detectSymbianOS() || this.detectWindowsMobile() || this.detectBlackBerry() || this.detectPalmOS() || this.detectAndroid();
    }

    protected boolean detectSonyMylo() {
        return this.m_userAgent.indexOf(MANU_SONY) != -1 && (this.m_userAgent.indexOf(QT_EMBEDDED) != -1 || this.m_userAgent.indexOf(MYLO_COM2) != -1);
    }

    protected boolean detectSonyPlaystation() {
        return this.m_userAgent.indexOf(DEVICE_PLAYSTATION) != -1;
    }

    protected boolean detectSymbianOS() {
        return this.m_userAgent.indexOf(DEVICE_SYMBIAN) != -1 || this.m_userAgent.indexOf(DEVICE_S60) != -1 || this.m_userAgent.indexOf(DEVICE_S70) != -1 || this.m_userAgent.indexOf(DEVICE_S80) != -1 || this.m_userAgent.indexOf(DEVICE_S90) != -1;
    }

    protected boolean detectTierIphone() {
        return this.detectIphoneOrIpod() || this.detectAndroid() || this.detectAndroidWebKit();
    }

    protected boolean detectTierOtherPhones() {
        return this.detectMobileQuick() && !this.detectTierIphone() && !this.detectTierSmartphones();
    }

    protected boolean detectTierSmartphones() {
        return this.detectSmartphone() && !this.detectTierIphone();
    }

    protected boolean detectWapWml() {
        return this.m_httpAccept.indexOf(VND_WAP) != -1 || this.m_httpAccept.indexOf(WML) != -1;
    }

    protected boolean detectWebkit() {
        return this.m_userAgent.indexOf(ENGINE_WEBKIT) != -1;
    }

    protected boolean detectWindowsMobile() {
        return this.m_userAgent.indexOf(DEVICE_WIN_MOBILE) != -1 || this.m_userAgent.indexOf(DEVICE_IEMOBILE) != -1 || this.m_userAgent.indexOf(ENGINE_PIE) != -1 || this.detectWapWml() && this.m_userAgent.indexOf(DEVICE_WINDOWS) != -1;
    }

    protected boolean detectXbox() {
        return this.m_userAgent.indexOf(DEVICE_XBOX) != -1;
    }
}

