/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.PropertyUtils;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.util.CmsJspContentAccessValueWrapper;
import org.opencms.jsp.util.CmsJspVfsAccessBean;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsHtml2TextConverter;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmsJspElFunctions {
    private CmsJspElFunctions() {
    }

    public static CmsObject convertCmsObject(Object input) {
        ServletRequest req;
        CmsObject result;
        if (input instanceof CmsObject) {
            result = (CmsObject)input;
        } else if (input instanceof ServletRequest) {
            result = CmsFlexController.getCmsObject((ServletRequest)input);
        } else if (input instanceof PageContext) {
            result = CmsFlexController.getCmsObject(((PageContext)input).getRequest());
        } else {
            try {
                result = OpenCms.initCmsObject(String.valueOf(input));
                req = CmsJspElFunctions.convertRequest(input);
                if (req instanceof HttpServletRequest) {
                    result.getRequestContext().setSiteRoot(OpenCms.getSiteManager().matchRequest((HttpServletRequest)req).getSiteRoot());
                }
            }
            catch (CmsException e) {
                result = null;
            }
        }
        if (result == null) {
            try {
                result = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
                req = CmsJspElFunctions.convertRequest(input);
                if (req instanceof HttpServletRequest) {
                    result.getRequestContext().setSiteRoot(OpenCms.getSiteManager().matchRequest((HttpServletRequest)req).getSiteRoot());
                }
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Date convertDate(Object input) {
        Date result;
        block8: {
            if (input instanceof Date) {
                result = (Date)input;
            } else if (input instanceof Long) {
                result = new Date((Long)input);
            } else {
                String str = String.valueOf(input);
                try {
                    long l = Long.parseLong(str);
                    result = new Date(l);
                }
                catch (NumberFormatException e) {
                    try {
                        result = DateFormat.getDateInstance().parse(str);
                    }
                    catch (ParseException e1) {
                        result = null;
                    }
                    if (result != null) break block8;
                    result = new Date(0L);
                }
            }
        }
        return result;
    }

    public static List<Object> convertList(List<Object> input, String attributeName) {
        ArrayList<Object> result = new ArrayList<Object>(input.size());
        for (Object item : input) {
            try {
                result.add(PropertyUtils.getProperty((Object)item, (String)attributeName));
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
        return result;
    }

    public static Locale convertLocale(Object input) {
        Locale locale = input instanceof Locale ? (Locale)input : CmsLocaleManager.getLocale(String.valueOf(input));
        return locale;
    }

    public static ServletRequest convertRequest(Object input) {
        ServletRequest req = null;
        if (input instanceof ServletRequest) {
            req = (ServletRequest)input;
        } else if (input instanceof PageContext) {
            req = ((PageContext)input).getRequest();
        }
        return req;
    }

    public static CmsResource convertResource(CmsObject cms, Object input) throws CmsException {
        CmsResource result = input instanceof String ? cms.readResource((String)input) : (input instanceof CmsResource ? (CmsResource)input : (input instanceof CmsUUID ? cms.readResource((CmsUUID)input) : cms.readResource(String.valueOf(input))));
        return result;
    }

    public static CmsUUID convertUUID(Object input) {
        CmsUUID uuid = input instanceof CmsUUID ? (CmsUUID)input : (input instanceof byte[] ? new CmsUUID((byte[])input) : new CmsUUID(String.valueOf(input)));
        return uuid;
    }

    public static String escape(String source, String encoding) {
        return CmsEncoder.escape(source, encoding);
    }

    public static CmsObject getCmsObject(Object input) {
        return CmsJspElFunctions.convertCmsObject(input);
    }

    public static Integer getListSize(List<Object> input) {
        if (input != null) {
            return input.size();
        }
        return 0;
    }

    public static String getNavigationUri(Object input) {
        ServletRequest req = CmsJspElFunctions.convertRequest(input);
        if (req == null) {
            return null;
        }
        return CmsJspElFunctions.getCmsObject(input).getRequestContext().getUri();
    }

    public static String getRequestLink(String url) {
        return CmsRequestUtil.getRequestLink(url);
    }

    public static String getRequestParam(String url, String paramName) {
        String[] result;
        int pos;
        Map<Object, Object> params = Collections.emptyMap();
        if (CmsStringUtil.isNotEmpty(url) && (pos = url.indexOf("?")) >= 0) {
            params = CmsRequestUtil.createParameterMap(url.substring(pos + 1));
        }
        if ((result = (String[])params.get(paramName)) != null) {
            return result[0];
        }
        return null;
    }

    public static CmsJspVfsAccessBean getVfsAccessBean(Object input) {
        return CmsJspVfsAccessBean.create(CmsJspElFunctions.convertCmsObject(input));
    }

    public static String stripHtml(Object input) {
        if (input instanceof CmsJspContentAccessValueWrapper) {
            CmsJspContentAccessValueWrapper wrapper = (CmsJspContentAccessValueWrapper)input;
            if (wrapper.getExists()) {
                return wrapper.obtainContentValue().getPlainText(wrapper.obtainCmsObject());
            }
            return "";
        }
        try {
            return CmsHtml2TextConverter.html2text(String.valueOf(input), OpenCms.getSystemInfo().getDefaultEncoding());
        }
        catch (Exception e) {
            return CmsMessages.formatUnknownKey(e.getMessage());
        }
    }

    public static String trimToSize(String input, int length) {
        return CmsStringUtil.trimToSize(input, length, " ...");
    }

    public static String unescape(String source, String encoding) {
        return CmsEncoder.unescape(source, encoding);
    }
}

