/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.loader.CmsTemplateLoaderFacade;
import org.opencms.loader.CmsXmlContentLoader;
import org.opencms.loader.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;

public class CmsXmlContainerPageLoader
extends CmsXmlContentLoader {
    public static final int CONTAINER_PAGE_RESOURCE_LOADER_ID = 11;

    public int getLoaderId() {
        return 11;
    }

    public String getResourceLoaderInfo() {
        return Messages.get().getBundle().key("GUI_LOADER_CONTAINERPAGE_DEFAULT_DESC_0");
    }

    public boolean isUsableForTemplates() {
        return true;
    }

    public void load(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, CmsException {
        CmsTemplateLoaderFacade loaderFacade = OpenCms.getResourceManager().getTemplateLoaderFacade(cms, resource, this.getTemplatePropertyDefinition());
        loaderFacade.getLoader().load(cms, loaderFacade.getLoaderStartResource(), req, res);
    }

    protected String getTemplatePropertyDefinition() {
        return "template";
    }

    protected CmsXmlContainerPage unmarshalXmlDocument(CmsObject cms, CmsResource resource, ServletRequest req) throws CmsException {
        return CmsXmlContainerPageFactory.unmarshal(cms, resource, req);
    }
}

