/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.Serializable;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.opencms.file.CmsRequestContext;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSessionInfo
implements Comparable<CmsSessionInfo>,
Serializable {
    public static final String ATTRIBUTE_SESSION_ID = "__org.opencms.main.CmsSessionInfo#m_sessionId";
    public static final int QUEUE_SIZE = 10;
    private static final long serialVersionUID = 927301527031117920L;
    private transient Buffer m_broadcastQueue;
    private int m_maxInactiveInterval;
    private String m_ouFqn;
    private CmsUUID m_projectId;
    private CmsUUID m_sessionId;
    private String m_siteRoot;
    private long m_timeCreated = System.currentTimeMillis();
    private long m_timeUpdated;
    private CmsUUID m_userId;

    public CmsSessionInfo(CmsRequestContext context, CmsUUID sessionId, int maxInactiveInterval) {
        this.m_sessionId = sessionId;
        this.m_maxInactiveInterval = maxInactiveInterval;
        this.m_userId = context.getCurrentUser().getId();
        this.update(context);
    }

    @Override
    public int compareTo(CmsSessionInfo obj) {
        if (obj == this) {
            return 0;
        }
        return this.m_userId.compareTo(obj.getUserId());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsSessionInfo) {
            return this.m_userId.equals(((CmsSessionInfo)obj).getUserId());
        }
        return false;
    }

    public Buffer getBroadcastQueue() {
        if (this.m_broadcastQueue == null) {
            this.m_broadcastQueue = BufferUtils.synchronizedBuffer((Buffer)new UnboundedFifoBuffer(10));
        }
        return this.m_broadcastQueue;
    }

    public int getMaxInactiveInterval() {
        return this.m_maxInactiveInterval;
    }

    public String getOrganizationalUnitFqn() {
        return this.m_ouFqn;
    }

    public CmsUUID getProject() {
        return this.m_projectId;
    }

    public CmsUUID getSessionId() {
        return this.m_sessionId;
    }

    public String getSiteRoot() {
        return this.m_siteRoot;
    }

    public long getTimeActive() {
        return this.m_timeUpdated - this.m_timeCreated;
    }

    public long getTimeCreated() {
        return this.m_timeCreated;
    }

    public long getTimeUpdated() {
        return this.m_timeUpdated;
    }

    public CmsUUID getUserId() {
        return this.m_userId;
    }

    public int hashCode() {
        return this.m_userId.hashCode();
    }

    public boolean isExpired() {
        return (System.currentTimeMillis() - this.m_timeUpdated) / 1000L > (long)this.m_maxInactiveInterval;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(64);
        str.append("[");
        str.append("sessionId: ").append(this.m_sessionId).append(", ");
        str.append("userId: ").append(this.m_userId).append(", ");
        str.append("projectId: ").append(this.m_projectId).append(", ");
        str.append("siteRoot: ").append(this.m_siteRoot).append(", ");
        str.append("timeCreated: ").append(this.m_timeCreated).append(", ");
        str.append("timeUpdated: ").append(this.m_timeUpdated).append(", ");
        str.append("maxInactiveInterval: ").append(this.m_maxInactiveInterval);
        str.append("ouFqn: ").append(this.m_ouFqn);
        str.append("]");
        return str.toString();
    }

    protected void setProject(CmsUUID projectId) {
        this.m_projectId = projectId;
    }

    protected void update(CmsRequestContext context) {
        this.m_timeUpdated = System.currentTimeMillis();
        this.m_siteRoot = context.getSiteRoot();
        this.setProject(context.getCurrentProject().getUuid());
        this.m_ouFqn = context.getOuFqn();
    }
}

