/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsServletContainerSettings;
import org.opencms.main.CmsShellCommands;
import org.opencms.main.I_CmsShellCommands;
import org.opencms.main.Messages;
import org.opencms.main.OpenCmsCore;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsShell {
    public static final String SHELL_PARAM_ADDITIONAL_COMMANDS = "-additional=";
    public static final String SHELL_PARAM_BASE = "-base=";
    public static final String SHELL_PARAM_DEFAULT_WEB_APP = "-defaultWebApp=";
    public static final String SHELL_PARAM_SCRIPT = "-script=";
    public static final String SHELL_PARAM_SERVLET_MAPPING = "-servletMapping=";
    protected CmsObject m_cms;
    private I_CmsShellCommands m_additionaShellCommands;
    private List<CmsCommandObject> m_commandObjects;
    private boolean m_echo;
    private boolean m_exitCalled;
    private CmsMessages m_messages;
    private OpenCmsCore m_opencms;
    private String m_prompt;
    private CmsUserSettings m_settings;
    private I_CmsShellCommands m_shellCommands;

    public CmsShell(String webInfPath, String servletMapping, String defaultWebAppName, String prompt, I_CmsShellCommands additionalShellCommands) {
        this.setPrompt(prompt);
        if (CmsStringUtil.isEmpty(servletMapping)) {
            servletMapping = "/opencms/*";
        }
        if (CmsStringUtil.isEmpty(defaultWebAppName)) {
            defaultWebAppName = "ROOT";
        }
        try {
            this.m_opencms = OpenCmsCore.getInstance();
            Locale locale = this.getLocale();
            this.m_messages = Messages.get().getBundle(locale);
            if (CmsStringUtil.isEmpty(webInfPath)) {
                System.out.println(this.m_messages.key("GUI_SHELL_NO_HOME_FOLDER_SPECIFIED_0"));
                System.out.println();
                webInfPath = CmsFileUtil.searchWebInfFolder(System.getProperty("user.dir"));
                if (CmsStringUtil.isEmpty(webInfPath)) {
                    System.err.println(this.m_messages.key("GUI_SHELL_HR_0"));
                    System.err.println(this.m_messages.key("GUI_SHELL_NO_HOME_FOLDER_FOUND_0"));
                    System.err.println();
                    System.err.println(this.m_messages.key("GUI_SHELL_START_DIR_LINE1_0"));
                    System.err.println(this.m_messages.key("GUI_SHELL_START_DIR_LINE2_0"));
                    System.err.println(this.m_messages.key("GUI_SHELL_HR_0"));
                    return;
                }
            }
            System.out.println(Messages.get().getBundle(locale).key("GUI_SHELL_WEB_INF_PATH_1", webInfPath));
            CmsServletContainerSettings settings = new CmsServletContainerSettings(webInfPath, "ROOT", servletMapping, null, null);
            this.m_opencms.getSystemInfo().init(settings);
            String propertyPath = this.m_opencms.getSystemInfo().getConfigurationFileRfsPath();
            System.out.println(this.m_messages.key("GUI_SHELL_CONFIG_FILE_1", propertyPath));
            System.out.println();
            CmsParameterConfiguration configuration = new CmsParameterConfiguration(propertyPath);
            this.m_opencms = this.m_opencms.upgradeRunlevel(configuration);
            this.m_cms = this.m_opencms.initCmsObject(this.m_opencms.getDefaultUsers().getUserGuest());
            this.m_settings = this.initSettings();
            this.m_shellCommands = new CmsShellCommands();
            this.m_shellCommands.initShellCmsObject(this.m_cms, this);
            if (additionalShellCommands != null) {
                this.m_additionaShellCommands = additionalShellCommands;
                this.m_additionaShellCommands.initShellCmsObject(this.m_cms, this);
                this.m_additionaShellCommands.shellStart();
            } else {
                this.m_shellCommands.shellStart();
            }
            this.m_commandObjects = new ArrayList<CmsCommandObject>();
            if (this.m_additionaShellCommands != null) {
                this.m_commandObjects.add(new CmsCommandObject(this.m_additionaShellCommands));
            }
            this.m_commandObjects.add(new CmsCommandObject(this.m_shellCommands));
            this.m_commandObjects.add(new CmsCommandObject(this.m_cms.getRequestContext()));
            this.m_commandObjects.add(new CmsCommandObject(this.m_cms));
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    public static void main(String[] args) {
        boolean wrongUsage = false;
        String webInfPath = null;
        String script = null;
        String servletMapping = null;
        String defaultWebApp = null;
        String additional = null;
        if (args.length > 4) {
            wrongUsage = true;
        } else {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith(SHELL_PARAM_BASE)) {
                    webInfPath = arg.substring(SHELL_PARAM_BASE.length());
                    continue;
                }
                if (arg.startsWith(SHELL_PARAM_SCRIPT)) {
                    script = arg.substring(SHELL_PARAM_SCRIPT.length());
                    continue;
                }
                if (arg.startsWith(SHELL_PARAM_SERVLET_MAPPING)) {
                    servletMapping = arg.substring(SHELL_PARAM_SERVLET_MAPPING.length());
                    continue;
                }
                if (arg.startsWith(SHELL_PARAM_DEFAULT_WEB_APP)) {
                    defaultWebApp = arg.substring(SHELL_PARAM_DEFAULT_WEB_APP.length());
                    continue;
                }
                if (arg.startsWith(SHELL_PARAM_ADDITIONAL_COMMANDS)) {
                    additional = arg.substring(SHELL_PARAM_ADDITIONAL_COMMANDS.length());
                    continue;
                }
                System.out.println(Messages.get().getBundle().key("GUI_SHELL_WRONG_USAGE_0"));
                wrongUsage = true;
            }
        }
        if (wrongUsage) {
            System.out.println(Messages.get().getBundle().key("GUI_SHELL_USAGE_1", CmsShell.class.getName()));
        } else {
            I_CmsShellCommands additionalCommands = null;
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(additional)) {
                try {
                    Class<?> commandClass = Class.forName(additional);
                    additionalCommands = (I_CmsShellCommands)commandClass.newInstance();
                }
                catch (Exception e) {
                    System.out.println(Messages.get().getBundle().key("GUI_SHELL_ERR_ADDITIONAL_COMMANDS_1", additional));
                    e.printStackTrace();
                    return;
                }
            }
            FileInputStream stream = null;
            if (script != null) {
                try {
                    stream = new FileInputStream(script);
                }
                catch (IOException exc) {
                    System.out.println(Messages.get().getBundle().key("GUI_SHELL_ERR_SCRIPTFILE_1", script));
                }
            }
            if (stream == null) {
                stream = new FileInputStream(FileDescriptor.in);
            }
            CmsShell shell = new CmsShell(webInfPath, servletMapping, defaultWebApp, "${user}@${project}:${siteroot}|${uri}>", additionalCommands);
            shell.start(stream);
        }
    }

    public void exit() {
        if (this.m_exitCalled) {
            return;
        }
        this.m_exitCalled = true;
        try {
            if (this.m_additionaShellCommands != null) {
                this.m_additionaShellCommands.shellExit();
            } else {
                this.m_shellCommands.shellExit();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.m_opencms.shutDown();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Locale getLocale() {
        if (this.getSettings() == null) {
            return CmsLocaleManager.getDefaultLocale();
        }
        return this.getSettings().getLocale();
    }

    public CmsMessages getMessages() {
        return this.m_messages;
    }

    public CmsUserSettings getSettings() {
        return this.m_settings;
    }

    public void printPrompt() {
        String prompt = this.m_prompt;
        try {
            prompt = CmsStringUtil.substitute(prompt, "${user}", this.m_cms.getRequestContext().getCurrentUser().getName());
            prompt = CmsStringUtil.substitute(prompt, "${siteroot}", this.m_cms.getRequestContext().getSiteRoot());
            prompt = CmsStringUtil.substitute(prompt, "${project}", this.m_cms.getRequestContext().getCurrentProject().getName());
            prompt = CmsStringUtil.substitute(prompt, "${uri}", this.m_cms.getRequestContext().getUri());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.out.print(prompt);
    }

    public void setLocale(Locale locale) throws CmsException {
        CmsUserSettings settings = this.getSettings();
        if (settings != null) {
            settings.setLocale(locale);
            settings.save(this.m_cms);
            this.m_messages = Messages.get().getBundle(locale);
        }
    }

    public void start(FileInputStream fileInputStream) {
        try {
            this.executeCommands(fileInputStream);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    protected void help(String searchString) {
        boolean foundSomething = false;
        System.out.println();
        for (CmsCommandObject cmdObj : this.m_commandObjects) {
            String commandList = cmdObj.getMethodHelp(searchString);
            if (CmsStringUtil.isEmpty(commandList)) continue;
            System.out.println(this.m_messages.key("GUI_SHELL_AVAILABLE_METHODS_1", cmdObj.getObject().getClass().getName()));
            System.out.println(commandList);
            foundSomething = true;
        }
        if (!foundSomething) {
            System.out.println(this.m_messages.key("GUI_SHELL_MATCH_SEARCHSTRING_1", searchString));
        }
    }

    protected CmsUserSettings initSettings() {
        this.m_settings = new CmsUserSettings(this.m_cms);
        return this.m_settings;
    }

    protected void setEcho(boolean echo) {
        this.m_echo = echo;
    }

    protected void setPrompt(String prompt) {
        this.m_prompt = prompt;
    }

    private void executeCommand(String command, List<String> parameters) {
        if (this.m_echo) {
            System.out.print(command);
            for (int i = 0; i < parameters.size(); ++i) {
                System.out.print(" " + parameters.get(i));
            }
            System.out.println();
        }
        boolean executed = false;
        Iterator<CmsCommandObject> i = this.m_commandObjects.iterator();
        while (!executed && i.hasNext()) {
            CmsCommandObject cmdObj = i.next();
            executed = cmdObj.executeMethod(command, parameters);
        }
        if (!executed) {
            System.out.println();
            StringBuffer commandMsg = new StringBuffer(command).append("(");
            for (int j = 0; j < parameters.size(); ++j) {
                commandMsg.append("value");
                if (j >= parameters.size() - 1) continue;
                commandMsg.append(", ");
            }
            commandMsg.append(")");
            System.out.println(this.m_messages.key("GUI_SHELL_METHOD_NOT_FOUND_1", commandMsg.toString()));
            System.out.println(this.m_messages.key("GUI_SHELL_HR_0"));
            ((CmsShellCommands)this.m_shellCommands).help();
        }
    }

    private void executeCommands(FileInputStream fileInputStream) {
        try {
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(fileInputStream));
            while (!this.m_exitCalled) {
                this.printPrompt();
                String line = lnr.readLine();
                if (line == null) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Throwable t) {}
                    break;
                }
                if (line.trim().startsWith("#")) {
                    System.out.println(line);
                    continue;
                }
                StringReader reader = new StringReader(line);
                StreamTokenizer st = new StreamTokenizer(reader);
                st.eolIsSignificant(true);
                st.wordChars(42, 42);
                ArrayList<String> parameters = new ArrayList<String>();
                while (st.nextToken() != -1) {
                    if (st.ttype == -2) {
                        parameters.add(Integer.toString(new Double(st.nval).intValue()));
                        continue;
                    }
                    parameters.add(st.sval);
                }
                reader.close();
                if (parameters.size() == 0) {
                    if (!this.m_echo) continue;
                    System.out.println();
                    continue;
                }
                String command = (String)parameters.get(0);
                parameters = parameters.subList(1, parameters.size());
                this.executeCommand(command, parameters);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CmsCommandObject {
        private Map<String, List<Method>> m_methods;
        private Object m_object;

        protected CmsCommandObject(Object object) {
            this.m_object = object;
            this.initShellMethods();
        }

        protected boolean executeMethod(String command, List<String> parameters) {
            Class<?>[] clazz;
            String lookup = this.buildMethodLookup(command, parameters.size());
            List<Method> possibleMethods = this.m_methods.get(lookup);
            if (possibleMethods == null) {
                return false;
            }
            Method onlyStringMethod = null;
            Method foundMethod = null;
            Object[] params = null;
            for (Method method : possibleMethods) {
                clazz = method.getParameterTypes();
                boolean onlyString = true;
                for (int j = 0; j < clazz.length; ++j) {
                    if (clazz[j].equals(String.class)) continue;
                    onlyString = false;
                    break;
                }
                if (!onlyString) continue;
                onlyStringMethod = method;
                break;
            }
            for (Method method : possibleMethods) {
                if (method == onlyStringMethod) continue;
                clazz = method.getParameterTypes();
                Object[] converted = new Object[clazz.length];
                boolean match = true;
                for (int j = 0; j < clazz.length; ++j) {
                    String value = parameters.get(j);
                    try {
                        converted[j] = CmsDataTypeUtil.parse(value, clazz[j]);
                        continue;
                    }
                    catch (Throwable t) {
                        match = false;
                        break;
                    }
                }
                if (!match) continue;
                params = converted;
                foundMethod = method;
                break;
            }
            if (foundMethod == null && onlyStringMethod != null) {
                params = parameters.toArray();
                foundMethod = onlyStringMethod;
            }
            if (params == null || foundMethod == null) {
                return false;
            }
            try {
                Object result = foundMethod.invoke(this.m_object, params);
                if (result != null) {
                    if (result instanceof Collection) {
                        Collection c = (Collection)result;
                        System.out.println(c.getClass().getName() + " (size: " + c.size() + ")");
                        int count = 0;
                        if (result instanceof Map) {
                            Map m = (Map)result;
                            for (Map.Entry entry : m.entrySet()) {
                                System.out.println(count++ + ": " + entry.getKey() + "= " + entry.getValue());
                            }
                        } else {
                            Iterator j = c.iterator();
                            while (j.hasNext()) {
                                System.out.println(count++ + ": " + j.next());
                            }
                        }
                    } else {
                        System.out.println(result.toString());
                    }
                }
            }
            catch (InvocationTargetException ite) {
                System.out.println(Messages.get().getBundle(CmsShell.this.getLocale()).key("GUI_SHELL_EXEC_METHOD_1", new Object[]{foundMethod.getName()}));
                ite.getTargetException().printStackTrace(System.out);
            }
            catch (Throwable t) {
                System.out.println(Messages.get().getBundle(CmsShell.this.getLocale()).key("GUI_SHELL_EXEC_METHOD_1", new Object[]{foundMethod.getName()}));
                t.printStackTrace(System.out);
            }
            return true;
        }

        protected String getMethodHelp(String searchString) {
            StringBuffer buf = new StringBuffer(512);
            Iterator<String> i = this.m_methods.keySet().iterator();
            while (i.hasNext()) {
                List<Method> l = this.m_methods.get(i.next());
                for (Method method : l) {
                    if (searchString != null && method.getName().toLowerCase().indexOf(searchString.toLowerCase()) <= -1) continue;
                    buf.append("* ");
                    buf.append(method.getName());
                    buf.append("(");
                    Class<?>[] params = method.getParameterTypes();
                    for (int k = 0; k < params.length; ++k) {
                        String par = params[k].getName();
                        par = par.substring(par.lastIndexOf(46) + 1);
                        if (k != 0) {
                            buf.append(", ");
                        }
                        buf.append(par);
                    }
                    buf.append(")\n");
                }
            }
            return buf.toString();
        }

        protected Object getObject() {
            return this.m_object;
        }

        private String buildMethodLookup(String methodName, int paramCount) {
            StringBuffer buf = new StringBuffer(32);
            buf.append(methodName.toLowerCase());
            buf.append(" [");
            buf.append(paramCount);
            buf.append("]");
            return buf.toString();
        }

        private void initShellMethods() {
            TreeMap<String, List<Method>> result = new TreeMap<String, List<Method>>();
            Method[] methods = this.m_object.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].getDeclaringClass() != this.m_object.getClass() || methods[i].getModifiers() != 1) continue;
                boolean onlyPrimitive = true;
                Class<?>[] clazz = methods[i].getParameterTypes();
                for (int j = 0; j < clazz.length; ++j) {
                    if (CmsDataTypeUtil.isParseable(clazz[j])) continue;
                    onlyPrimitive = false;
                    break;
                }
                if (!onlyPrimitive) continue;
                String lookup = this.buildMethodLookup(methods[i].getName(), methods[i].getParameterTypes().length);
                ArrayList<Method> l = result.containsKey(lookup) ? (ArrayList<Method>)result.get(lookup) : new ArrayList<Method>(1);
                l.add(methods[i]);
                result.put(lookup, l);
            }
            this.m_methods = result;
        }
    }
}

