/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.I_CmsRequestHandler;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsCore;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

public class OpenCmsSolrHandler
implements I_CmsRequestHandler {
    public static final String PARAM_BASE_URI = "baseUri";
    public static final String PARAM_CORE = "core";
    public static final String PARAM_INDEX = "index";
    protected static final String HEADER_REFERER_KEY = "referer";
    private static String[] HANDLER_NAMES = new String[]{"SolrSelect"};

    private static String getRequestUri(HttpServletRequest req, CmsObject cms) {
        String baseUri = req.getParameter(PARAM_BASE_URI);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(baseUri)) {
            String referer = req.getHeader(HEADER_REFERER_KEY);
            CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(cms.getRequestContext().getSiteRoot());
            if (site != null) {
                String prefix = site.getServerPrefix(cms, "/") + OpenCms.getSystemInfo().getOpenCmsContext();
                if (referer != null && referer.startsWith(prefix)) {
                    baseUri = referer.substring(prefix.length());
                }
            }
        }
        return baseUri;
    }

    public String[] getHandlerNames() {
        return HANDLER_NAMES;
    }

    public void handle(HttpServletRequest req, HttpServletResponse res, String name) throws IOException {
        try {
            Map<String, String[]> params;
            String baseUri;
            CmsObject cms = OpenCmsCore.getInstance().initCmsObjectFromSession(req);
            if (cms == null) {
                cms = OpenCmsCore.getInstance().initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
                String siteRoot = OpenCmsCore.getInstance().getSiteManager().matchRequest(req).getSiteRoot();
                cms.getRequestContext().setSiteRoot(siteRoot);
            }
            if ((baseUri = OpenCmsSolrHandler.getRequestUri(req, cms)) != null) {
                cms.getRequestContext().setUri(baseUri);
            }
            String indexName = (params = CmsRequestUtil.createParameterMap(req.getParameterMap())).get(PARAM_CORE) != null ? params.get(PARAM_CORE)[0] : (params.get(PARAM_INDEX) != null ? params.get(PARAM_INDEX)[0] : null);
            OpenCms.getSearchManager();
            CmsSolrIndex index = CmsSearchManager.getIndexSolr(cms, params);
            if (index != null) {
                CmsSolrQuery query = new CmsSolrQuery(cms, CmsRequestUtil.createParameterMap(req.getParameterMap()));
                index.writeResponse((ServletResponse)res, index.search(cms, query));
            } else {
                res.setStatus(417);
                String message = Messages.get().getBundle().key("GUI_SOLR_INDEX_NOT_FOUND_1", indexName);
                res.getWriter().println(Messages.get().getBundle().key("GUI_SOLR_ERROR_HTML_1", message));
            }
        }
        catch (Exception e) {
            res.setStatus(417);
            String message = Messages.get().getBundle().key("GUI_SOLR_UNEXPECTED_ERROR_0");
            String formattedException = CmsException.getStackTraceAsString(e).replace("\n", "<br/>");
            res.getWriter().println(Messages.get().getBundle().key("GUI_SOLR_ERROR_HTML_1", message + formattedException));
        }
    }
}

