/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsModuleConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.CmsExport;
import org.opencms.importexport.CmsExportParameters;
import org.opencms.importexport.CmsImport;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportHelper;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.I_CmsImportExportHandler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.module.CmsModuleXmlHandler;
import org.opencms.module.Messages;
import org.opencms.report.CmsHtmlReport;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.CmsSecurityException;
import org.opencms.xml.CmsXmlErrorHandler;
import org.opencms.xml.CmsXmlException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsModuleImportExportHandler
implements I_CmsImportExportHandler {
    private static final Log LOG = CmsLog.getLog(CmsModuleImportExportHandler.class);
    private List<String> m_additionalResources;
    private String m_description = org.opencms.importexport.Messages.get().getBundle().key("GUI_CMSIMPORTHANDLER_DEFAULT_DESC_0");
    private String m_fileName;
    private CmsModule m_importedModule;
    private CmsImportParameters m_importParams;
    private String m_moduleName;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CmsModule readModuleFromImport(String importResource) throws CmsConfigurationException {
        CmsModule importedModule;
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.setValidating(false);
        digester.setRuleNamespaceURI(null);
        digester.setErrorHandler((ErrorHandler)new CmsXmlErrorHandler(importResource));
        CmsModuleImportExportHandler handler = new CmsModuleImportExportHandler();
        digester.push((Object)handler);
        CmsModuleXmlHandler.addXmlDigesterRules(digester);
        InputStream stream = null;
        ZipFile importZip = null;
        try {
            try {
                File file = new File(importResource);
                if (file.isFile()) {
                    importZip = new ZipFile(importResource);
                    ZipEntry entry = importZip.getEntry("manifest.xml");
                    if (entry == null) {
                        CmsMessageContainer message = Messages.get().container("ERR_NO_MANIFEST_MODULE_IMPORT_1", importResource);
                        LOG.error((Object)message.key());
                        throw new CmsConfigurationException(message);
                    }
                    stream = importZip.getInputStream(entry);
                } else if (file.isDirectory()) {
                    file = new File(file, "manifest.xml");
                    stream = new FileInputStream(file);
                }
                digester.parse(stream);
            }
            catch (IOException e) {
                CmsMessageContainer message = Messages.get().container("ERR_IO_MODULE_IMPORT_1", importResource);
                LOG.error((Object)message.key(), (Throwable)e);
                throw new CmsConfigurationException(message, (Throwable)e);
            }
            catch (SAXException e) {
                CmsMessageContainer message = Messages.get().container("ERR_SAX_MODULE_IMPORT_1", importResource);
                LOG.error((Object)message.key(), (Throwable)e);
                throw new CmsConfigurationException(message, (Throwable)e);
            }
            Object var9_12 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            try {
                if (importZip != null) {
                    importZip.close();
                }
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (importZip != null) {
            importZip.close();
        }
        if (stream != null) {
            stream.close();
        }
        if ((importedModule = handler.getModule()) != null) return importedModule;
        throw new CmsConfigurationException(Messages.get().container("ERR_IMPORT_MOD_ALREADY_INSTALLED_1", importResource));
    }

    @Override
    public void exportData(CmsObject cms, I_CmsReport report) throws CmsConfigurationException, CmsImportExportException, CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        report.print(Messages.get().container("RPT_EXPORT_MODULE_BEGIN_0"), 2);
        if (report instanceof CmsHtmlReport) {
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", "<i>" + this.getModuleName() + "</i>"));
        } else {
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", this.getModuleName()));
        }
        report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
        if (!OpenCms.getModuleManager().hasModule(this.getModuleName())) {
            throw new CmsConfigurationException(Messages.get().container("ERR_NO_MOD_FOR_EXPORT_1", this.getModuleName()));
        }
        CmsModule module = OpenCms.getModuleManager().getModule(this.getModuleName());
        if (!module.getVersion().isUpdated()) {
            module.getVersion().increment();
            OpenCms.writeConfiguration(CmsModuleConfiguration.class);
        }
        module.getVersion().setUpdated(false);
        Element moduleElement = CmsModuleXmlHandler.generateXml(module);
        CmsExportParameters params = new CmsExportParameters(this.getFileName(), moduleElement, true, false, false, this.getAdditionalResources(), true, true, 0L, true, false);
        new CmsExport(cms, report).exportData(params);
        report.println(Messages.get().container("RPT_EXPORT_MODULE_END_0"), 2);
    }

    public List<String> getAdditionalResources() {
        return this.m_additionalResources;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    @Override
    public CmsImportParameters getImportParameters() {
        return this.m_importParams;
    }

    public String getModuleName() {
        return this.m_moduleName;
    }

    public List<String> getResourcesAsList() {
        return this.m_additionalResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void importData(CmsObject cms, I_CmsReport report) throws CmsXmlException, CmsImportExportException, CmsRoleViolationException, CmsException {
        CmsImportParameters parameters = this.getImportParameters();
        CmsProject previousProject = cms.getRequestContext().getCurrentProject();
        try {
            CmsProject importProject = null;
            String modulePackageName = null;
            String storedSiteRoot = cms.getRequestContext().getSiteRoot();
            CmsImportHelper helper = new CmsImportHelper(parameters);
            try {
                try {
                    cms.getRequestContext().setSiteRoot("/");
                    helper.openFile();
                    modulePackageName = helper.getFileName();
                    try {
                        importProject = cms.readProject(Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_IMPORT_MODULE_PROJECT_NAME_1", new Object[]{modulePackageName}));
                    }
                    catch (CmsException e) {
                        importProject = cms.createProject(Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_IMPORT_MODULE_PROJECT_NAME_1", new Object[]{modulePackageName}), Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_IMPORT_MODULE_PROJECT_DESC_1", new Object[]{modulePackageName}), OpenCms.getDefaultUsers().getGroupAdministrators(), OpenCms.getDefaultUsers().getGroupAdministrators(), CmsProject.PROJECT_TYPE_TEMPORARY);
                    }
                    cms.getRequestContext().setCurrentProject(importProject);
                    cms.copyResourceToProject("/");
                }
                catch (Exception e) {
                    throw new CmsImportExportException(Messages.get().container("ERR_IO_MODULE_IMPORT_1", parameters.getPath()), (Throwable)e);
                }
                Object var11_11 = null;
                helper.closeFile();
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                helper.closeFile();
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
                throw throwable;
            }
            report.print(Messages.get().container("RPT_IMPORT_MODULE_BEGIN_0"), 2);
            if (report instanceof CmsHtmlReport) {
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", "<i>" + modulePackageName + "</i>"));
            } else {
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", modulePackageName));
            }
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            this.importModule(cms, report, parameters);
            report.println(Messages.get().container("RPT_PUBLISH_PROJECT_BEGIN_0"), 2);
            cms.unlockProject(importProject.getUuid());
            OpenCms.getPublishManager().publishProject(cms, report);
            OpenCms.getPublishManager().waitWhileRunning();
            report.println(Messages.get().container("RPT_PUBLISH_PROJECT_END_0"), 2);
            report.println(Messages.get().container("RPT_IMPORT_MODULE_END_0"), 2);
            Object var13_14 = null;
            cms.getRequestContext().setCurrentProject(previousProject);
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            cms.getRequestContext().setCurrentProject(previousProject);
            throw throwable;
        }
    }

    @Override
    @Deprecated
    public void importData(CmsObject cms, String importFile, String importPath, I_CmsReport report) throws CmsXmlException, CmsImportExportException, CmsRoleViolationException, CmsException {
        CmsImportParameters parameters = new CmsImportParameters(importFile, importPath, true);
        this.setImportParameters(parameters);
        this.importData(cms, report);
    }

    @Override
    public boolean matches(Document manifest) {
        Element rootElement = manifest.getRootElement();
        return rootElement.selectNodes("./module/name").size() > 0;
    }

    public void setAdditionalResources(String[] resources) {
        this.m_additionalResources = Arrays.asList(resources);
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    @Override
    public void setImportParameters(CmsImportParameters importParams) {
        this.m_importParams = importParams;
    }

    public void setModule(CmsModuleXmlHandler moduleHandler) {
        this.m_importedModule = moduleHandler.getModule();
    }

    public void setModuleName(String moduleName) {
        this.m_moduleName = moduleName;
    }

    private CmsModule getModule() {
        return this.m_importedModule;
    }

    private synchronized void importModule(CmsObject cms, I_CmsReport report, CmsImportParameters parameters) throws CmsSecurityException, CmsConfigurationException, CmsException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        CmsModule importedModule = CmsModuleImportExportHandler.readModuleFromImport(parameters.getPath());
        if (OpenCms.getModuleManager().hasModule(importedModule.getName())) {
            throw new CmsConfigurationException(Messages.get().container("ERR_MOD_ALREADY_INSTALLED_1", importedModule.getName()));
        }
        List<CmsModuleDependency> dependencies = OpenCms.getModuleManager().checkDependencies(importedModule, 1);
        if (dependencies.size() > 0) {
            StringBuffer missingModules = new StringBuffer();
            for (CmsModuleDependency dependency : dependencies) {
                missingModules.append("  ").append(dependency.getName()).append(", Version ").append(dependency.getVersion()).append("\r\n");
            }
            throw new CmsConfigurationException(Messages.get().container("ERR_MOD_DEPENDENCY_INFO_2", importedModule.getName() + ", Version " + importedModule.getVersion(), missingModules));
        }
        ArrayList<I_CmsResourceType> checkedTypes = new ArrayList<I_CmsResourceType>();
        for (I_CmsResourceType type : importedModule.getResourceTypes()) {
            I_CmsResourceType conflictingType;
            int externalConflictIndex = OpenCms.getResourceManager().getResourceTypes().indexOf(type);
            if (externalConflictIndex >= 0 && !type.isIdentical(conflictingType = OpenCms.getResourceManager().getResourceTypes().get(externalConflictIndex))) {
                throw new CmsConfigurationException(org.opencms.loader.Messages.get().container("ERR_CONFLICTING_MODULE_RESOURCE_TYPES_5", new Object[]{type.getTypeName(), new Integer(type.getTypeId()), importedModule.getName(), conflictingType.getTypeName(), new Integer(conflictingType.getTypeId())}));
            }
            int internalConflictIndex = checkedTypes.indexOf(type);
            if (internalConflictIndex >= 0) {
                I_CmsResourceType conflictingType2 = (I_CmsResourceType)checkedTypes.get(internalConflictIndex);
                throw new CmsConfigurationException(org.opencms.loader.Messages.get().container("ERR_CONFLICTING_RESTYPES_IN_MODULE_5", new Object[]{importedModule.getName(), type.getTypeName(), new Integer(type.getTypeId()), conflictingType2.getTypeName(), new Integer(conflictingType2.getTypeId())}));
            }
            checkedTypes.add(type);
        }
        OpenCms.getModuleManager().addModule(cms, importedModule);
        if (importedModule.getResourceTypes() != Collections.EMPTY_LIST) {
            OpenCms.getResourceManager().initialize(cms);
        }
        if (importedModule.getExplorerTypes() != Collections.EMPTY_LIST) {
            OpenCms.getWorkplaceManager().addExplorerTypeSettings(importedModule);
        }
        CmsImport cmsImport = new CmsImport(cms, report);
        cmsImport.importData(parameters);
    }
}

