/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.notification;

import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.notification.A_CmsNotification;
import org.opencms.notification.Messages;
import org.opencms.report.I_CmsReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsPublishNotification
extends A_CmsNotification {
    public static final String NOTIFICATION_CONTENT = "/system/workplace/admin/notification/publish-notification";
    private I_CmsReport m_report;

    public CmsPublishNotification(CmsObject cms, CmsUser receiver, I_CmsReport report) {
        super(cms, receiver);
        this.m_report = report;
    }

    @Override
    protected String generateHtmlMsg() {
        StringBuffer buffer = new StringBuffer();
        if (this.m_report.hasWarning()) {
            buffer.append("<b>");
            buffer.append(Messages.get().getBundle().key("GUI_PUBLISH_WARNING_HEADER_0"));
            buffer.append("</b><br/>\n");
            this.appendList(buffer, this.m_report.getWarnings());
            buffer.append("<br/>\n");
        }
        if (this.m_report.hasError()) {
            buffer.append("<b>");
            buffer.append(Messages.get().getBundle().key("GUI_PUBLISH_ERROR_HEADER_0"));
            buffer.append("</b><br/>\n");
            this.appendList(buffer, this.m_report.getErrors());
            buffer.append("<br/>\n");
        }
        return buffer.toString();
    }

    @Override
    protected String getNotificationContent() {
        return NOTIFICATION_CONTENT;
    }

    private void appendList(StringBuffer buffer, List<Object> list) {
        for (Object entry : list) {
            buffer.append(entry).append("<br/>\n");
        }
    }
}

