/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import org.opencms.file.CmsObject;
import org.opencms.mail.CmsSimpleMail;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.relations.Messages;
import org.opencms.report.CmsStringBufferReport;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsInternalRelationsValidationJob
implements I_CmsScheduledJob {
    public static final String PARAM_EMAIL = "email";
    public static final String PARAM_SUBJECT = "subject";
    public static final String PARAM_FROM = "from";

    @Override
    public String launch(CmsObject cms, Map<String, String> parameters) throws Exception {
        CmsStringBufferReport report = null;
        String msg = null;
        try {
            report = new CmsStringBufferReport(cms.getRequestContext().getLocale());
            report.println(Messages.get().container("GUI_RELATIONS_VALIDATION_PROJECT_1", cms.getRequestContext().getCurrentProject().getName()), 2);
            OpenCms.getPublishManager().validateRelations(cms, null, report);
        }
        catch (Exception e) {
            if (report != null) {
                report.println(e);
            }
            msg = CmsException.getStackTraceAsString(e);
        }
        String from = parameters.get(PARAM_FROM);
        String addresses = parameters.get(PARAM_EMAIL);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(addresses)) {
            addresses = cms.getRequestContext().getCurrentUser().getEmail();
        }
        ArrayList<InternetAddress> to = new ArrayList<InternetAddress>();
        Iterator<String> it = CmsStringUtil.splitAsList(addresses, ',').iterator();
        while (it.hasNext()) {
            to.add(new InternetAddress(it.next()));
        }
        String subject = parameters.get(PARAM_SUBJECT);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(subject)) {
            subject = Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_RELATIONS_VALIDATION_DEFAULT_SUBJECT_0");
        }
        if (report != null) {
            msg = ((Object)report).toString();
        }
        CmsSimpleMail mail = new CmsSimpleMail();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(from)) {
            mail.setFrom(from);
        }
        mail.setTo(to);
        mail.setSubject(subject);
        mail.setMsg(msg);
        mail.send();
        return null;
    }
}

