/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.I_CmsConfigurationParameterHandler;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.CmsSearchResultList;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.Messages;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.fields.I_CmsSearchFieldConfiguration;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class A_CmsSearchIndex
implements I_CmsConfigurationParameterHandler {
    public static final String A_LEGACY_PARAM_PREFIX = "org.opencms.search.CmsSearchIndex";
    public static final String BACKUP_REINDEXING = "org.opencms.search.CmsSearchIndex.useBackupReindexing";
    public static final String EXCERPT = "org.opencms.search.CmsSearchIndex.createExcerpt";
    public static final String EXTRACT_CONTENT = "org.opencms.search.CmsSearchIndex.extractContent";
    public static final String MAX_HITS = "org.opencms.search.CmsSearchIndex.maxHits";
    public static final int MAX_HITS_DEFAULT = 5000;
    public static final String PERMISSIONS = "org.opencms.search.CmsSearchIndex.checkPermissions";
    public static final String PRIORITY = "org.opencms.search.CmsSearchIndex.priority";
    public static final String PROPERTY_SEARCH_EXCLUDE_VALUE_ALL = "all";
    public static final String REBUILD_MODE_AUTO = "auto";
    public static final String REBUILD_MODE_MANUAL = "manual";
    public static final String REBUILD_MODE_OFFLINE = "offline";
    public static final String TIME_RANGE = "search.checkTimeRange";
    public static final String USE_ALL_LOCALE = "all";
    private static final Log LOG = CmsLog.getLog(A_CmsSearchIndex.class);
    private boolean m_backupReindexing;
    private boolean m_checkPermissions = true;
    private Map<String, List<String>> m_documenttypes;
    private boolean m_enabled = true;
    private boolean m_extractContent = true;
    private I_CmsSearchFieldConfiguration m_fieldConfiguration;
    private String m_fieldConfigurationName;
    private I_CmsIndexWriter m_indexWriter;
    private Locale m_locale;
    private String m_name;
    private String m_path;
    private int m_priority = -1;
    private String m_project;
    private String m_rebuild;
    private boolean m_requireViewPermission;
    private List<String> m_sourceNames = new ArrayList<String>();
    private List<CmsSearchIndexSource> m_sources;

    public A_CmsSearchIndex() {
        this.m_documenttypes = new HashMap<String, List<String>>();
    }

    public A_CmsSearchIndex(String name) throws CmsIllegalArgumentException {
        this();
        this.setName(name);
    }

    @Override
    public void addConfigurationParameter(String key, String value) {
        if (PERMISSIONS.equals(key)) {
            this.m_checkPermissions = Boolean.valueOf(value);
        } else if (EXTRACT_CONTENT.equals(key)) {
            this.m_extractContent = Boolean.valueOf(value);
        } else if (BACKUP_REINDEXING.equals(key)) {
            this.m_backupReindexing = Boolean.valueOf(value);
        } else if (PRIORITY.equals(key)) {
            this.m_priority = Integer.parseInt(value);
            if (this.m_priority < 1) {
                this.m_priority = 1;
                LOG.error((Object)Messages.get().getBundle().key("LOG_SEARCH_PRIORITY_TOO_LOW_2", value, new Integer(1)));
            } else if (this.m_priority > 10) {
                this.m_priority = 10;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SEARCH_PRIORITY_TOO_HIGH_2", value, new Integer(10)));
            }
        }
    }

    public void addSourceName(String sourceName) {
        this.m_sourceNames.add(sourceName);
    }

    public boolean checkConfiguration(CmsObject cms) {
        if (this.isEnabled()) {
            try {
                cms.readProject(this.getProject());
                this.setEnabled(true);
            }
            catch (CmsException e) {
                this.setEnabled(false);
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_SEARCHINDEX_CREATE_BAD_PROJECT_2", this.getProject(), this.getName()));
                }
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_SEARCHINDEX_DISABLED_1", this.getName()));
        }
        return this.isEnabled();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof A_CmsSearchIndex) {
            return ((A_CmsSearchIndex)obj).getName().equals(this.m_name);
        }
        return false;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        CmsParameterConfiguration result = new CmsParameterConfiguration();
        if (this.getPriority() > 0) {
            result.put(PRIORITY, String.valueOf(this.m_priority));
        }
        if (!this.isExtractingContent()) {
            result.put(EXTRACT_CONTENT, String.valueOf(this.m_extractContent));
        }
        if (!this.isCheckingPermissions()) {
            result.put(PERMISSIONS, String.valueOf(this.m_checkPermissions));
        }
        if (this.isBackupReindexing()) {
            result.put(BACKUP_REINDEXING, String.valueOf(this.m_backupReindexing));
        }
        return result;
    }

    public abstract I_CmsSearchDocument getDocument(String var1, String var2);

    public I_CmsDocumentFactory getDocumentFactory(CmsResource res) {
        I_CmsDocumentFactory result;
        if (res != null && this.getSources() != null && (result = OpenCms.getSearchManager().getDocumentFactory(res)) != null) {
            for (CmsSearchIndexSource source : this.getSources()) {
                if (!source.isIndexing(res.getRootPath(), result.getName())) continue;
                return result;
            }
        }
        return null;
    }

    public I_CmsSearchFieldConfiguration getFieldConfiguration() {
        return this.m_fieldConfiguration;
    }

    public String getFieldConfigurationName() {
        return this.m_fieldConfigurationName;
    }

    public I_CmsIndexWriter getIndexWriter(I_CmsReport report, boolean create) throws CmsIndexException {
        if (this.m_indexWriter != null) {
            if (!create) {
                return this.m_indexWriter;
            }
            try {
                this.m_indexWriter.close();
                this.m_indexWriter = null;
            }
            catch (IOException e) {
                throw new CmsIndexException(Messages.get().container("LOG_IO_INDEX_WRITER_CLOSE_2", this.getPath(), this.getName()), (Throwable)e);
            }
        }
        I_CmsIndexWriter indexWriter = this.createIndexWriter(create, report);
        if (!create) {
            this.m_indexWriter = indexWriter;
        }
        return indexWriter;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public Locale getLocaleForResource(CmsObject cms, CmsResource resource, List<Locale> availableLocales) {
        List<Locale> defaultLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
        List<Locale> locales = availableLocales;
        if (locales == null || locales.size() == 0) {
            locales = defaultLocales;
        }
        Locale result = OpenCms.getLocaleManager().getBestMatchingLocale(this.getLocale(), defaultLocales, locales);
        return result;
    }

    public String getLocaleString() {
        return this.getLocale().toString();
    }

    public String getName() {
        return this.m_name;
    }

    public String getPath() {
        if (this.m_path == null) {
            this.m_path = this.generateIndexDirectory();
        }
        return this.m_path;
    }

    public int getPriority() {
        return this.m_priority;
    }

    public String getProject() {
        return this.m_project;
    }

    public String getRebuildMode() {
        return this.m_rebuild;
    }

    public List<String> getSourceNames() {
        return this.m_sourceNames;
    }

    public List<CmsSearchIndexSource> getSources() {
        return this.m_sources;
    }

    public int hashCode() {
        return this.m_name != null ? this.m_name.hashCode() : 0;
    }

    @Override
    public void initConfiguration() {
    }

    public void initialize() throws CmsSearchException {
        if (!this.isEnabled()) {
            return;
        }
        String sourceName = null;
        CmsSearchIndexSource indexSource = null;
        List<String> searchIndexSourceDocumentTypes = null;
        List<String> resourceNames = null;
        String resourceName = null;
        this.m_sources = new ArrayList<CmsSearchIndexSource>();
        this.m_path = this.getPath();
        int n = this.m_sourceNames.size();
        for (int i = 0; i < n; ++i) {
            try {
                sourceName = this.m_sourceNames.get(i);
                indexSource = OpenCms.getSearchManager().getIndexSource(sourceName);
                this.m_sources.add(indexSource);
                resourceNames = indexSource.getResourcesNames();
                searchIndexSourceDocumentTypes = indexSource.getDocumentTypes();
                int m = resourceNames.size();
                for (int j = 0; j < m; ++j) {
                    resourceName = resourceNames.get(j);
                    this.m_documenttypes.put(resourceName, searchIndexSourceDocumentTypes);
                }
                continue;
            }
            catch (Exception e) {
                this.setEnabled(false);
                throw new CmsSearchException(Messages.get().container("ERR_INDEX_SOURCE_ASSOCIATION_1", sourceName), (Throwable)e);
            }
        }
        if (this.m_fieldConfigurationName == null) {
            this.m_fieldConfigurationName = "standard";
        }
        this.m_fieldConfiguration = OpenCms.getSearchManager().getFieldConfiguration(this.m_fieldConfigurationName);
        if (this.m_fieldConfiguration == null) {
            throw new CmsSearchException(Messages.get().container("ERR_FIELD_CONFIGURATION_UNKNOWN_2", this.m_name, this.m_fieldConfigurationName));
        }
    }

    public boolean isBackupReindexing() {
        return this.m_backupReindexing;
    }

    public boolean isCheckingPermissions() {
        return this.m_checkPermissions;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public boolean isExtractingContent() {
        return this.m_extractContent;
    }

    public boolean isRequireViewPermission() {
        return this.m_requireViewPermission;
    }

    public boolean isUpdatedIncremental() {
        return this.m_indexWriter != null;
    }

    public void removeSourceName(String sourceName) {
        this.m_sources.remove(sourceName);
        this.m_sourceNames.remove(sourceName);
    }

    public abstract CmsSearchResultList search(CmsObject var1, CmsSearchParameters var2) throws CmsSearchException;

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public void setFieldConfiguration(I_CmsSearchFieldConfiguration fieldConfiguration) {
        this.m_fieldConfiguration = fieldConfiguration;
    }

    public void setFieldConfigurationName(String fieldConfigurationName) {
        this.m_fieldConfigurationName = fieldConfigurationName;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setLocaleString(String locale) {
        this.setLocale(CmsLocaleManager.getLocale(locale));
    }

    public void setName(String name) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_MISSING_NAME_0"));
        }
        if (!name.equals(this.m_name) && OpenCms.getRunLevel() > 2) {
            Iterator<String> itIdxNames = OpenCms.getSearchManager().getIndexNames().iterator();
            while (itIdxNames.hasNext()) {
                if (!itIdxNames.next().equals(name)) continue;
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_INVALID_NAME_1", name));
            }
        }
        this.m_name = name;
    }

    public void setProject(String project) {
        this.m_project = project;
    }

    public void setRebuildMode(String rebuildMode) {
        this.m_rebuild = rebuildMode;
    }

    public void setRequireViewPermission(boolean requireViewPermission) {
        this.m_requireViewPermission = requireViewPermission;
    }

    public void shutDown() {
        if (this.m_indexWriter != null) {
            try {
                this.m_indexWriter.commit();
                this.m_indexWriter.close();
            }
            catch (IOException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_CLOSE_2", this.getPath(), this.getName()), (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    protected String createIndexBackup() {
        if (!this.isBackupReindexing()) {
            return null;
        }
        File file = new File(this.getPath());
        if (!file.exists()) {
            return null;
        }
        String backupPath = this.getPath() + "_backup";
        try {
            FSDirectory oldDir = FSDirectory.open((File)file);
            FSDirectory newDir = FSDirectory.open((File)new File(backupPath));
            for (String fileName : oldDir.listAll()) {
                oldDir.copy((Directory)newDir, fileName, fileName);
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_BACKUP_CREATE_3", this.getName(), this.getPath(), backupPath), (Throwable)e);
            backupPath = null;
        }
        return backupPath;
    }

    protected abstract I_CmsIndexWriter createIndexWriter(boolean var1, I_CmsReport var2) throws CmsIndexException;

    protected boolean excludeFromIndex(CmsObject cms, CmsResource resource) {
        boolean excludeFromIndex;
        block5: {
            excludeFromIndex = false;
            if (resource.isInternal() || resource.isFolder() || resource.isTemporaryFile() || resource.getDateExpired() <= System.currentTimeMillis()) {
                return true;
            }
            try {
                String propValue = cms.readPropertyObject(resource, "search.exclude", true).getValue();
                excludeFromIndex = Boolean.valueOf(propValue);
                if (!excludeFromIndex && propValue != null) {
                    excludeFromIndex = "all".equalsIgnoreCase(propValue.trim());
                }
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_PROPERTY_1", resource.getRootPath()));
            }
        }
        if (!excludeFromIndex && !"all".equalsIgnoreCase(this.getLocale().getLanguage())) {
            List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
            Locale match = OpenCms.getLocaleManager().getFirstMatchingLocale(Collections.singletonList(this.getLocale()), locales);
            excludeFromIndex = match == null;
        }
        return excludeFromIndex;
    }

    protected String generateIndexDirectory() {
        return OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(OpenCms.getSearchManager().getDirectory() + "/" + this.getName());
    }

    protected CmsResource getResource(CmsObject cms, I_CmsSearchDocument doc) {
        String contextPath = cms.getRequestContext().removeSiteRoot(doc.getPath());
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT;
        if (this.isRequireViewPermission()) {
            filter = CmsResourceFilter.DEFAULT_ONLY_VISIBLE;
        }
        try {
            return cms.readResource(contextPath, filter);
        }
        catch (CmsException e) {
            return null;
        }
    }

    protected boolean hasReadPermission(CmsObject cms, I_CmsSearchDocument doc) {
        return !this.needsPermissionCheck(doc) ? true : null != this.getResource(cms, doc);
    }

    protected abstract void indexSearcherClose();

    protected abstract void indexSearcherOpen(String var1);

    protected abstract void indexSearcherUpdate();

    protected boolean needsPermissionCheck(I_CmsSearchDocument doc) {
        if (!this.isCheckingPermissions()) {
            return false;
        }
        if (doc.getType() == null || doc.getPath() == null) {
            return false;
        }
        return "VFS".equals(doc.getType()) || OpenCms.getResourceManager().hasResourceType(doc.getType());
    }

    protected void removeIndexBackup(String path) {
        if (!this.isBackupReindexing()) {
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        try {
            FSDirectory dir = FSDirectory.open((File)file);
            dir.close();
            CmsFileUtil.purgeDirectory(file);
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_BACKUP_REMOVE_2", this.getName(), path), (Throwable)e);
        }
    }

    protected void setIndexWriter(I_CmsIndexWriter writer) {
        this.m_indexWriter = writer;
    }
}

