/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.opencms.main.CmsLog;
import org.opencms.search.CmsLuceneIndex;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.Messages;

public class CmsLuceneIndexWriter
implements I_CmsIndexWriter {
    protected static final Log LOG = CmsLog.getLog(CmsLuceneIndexWriter.class);
    private CmsLuceneIndex m_index;
    private final IndexWriter m_indexWriter;

    public CmsLuceneIndexWriter(IndexWriter indexWriter) {
        this(indexWriter, null);
    }

    public CmsLuceneIndexWriter(IndexWriter indexWriter, CmsLuceneIndex index) {
        this.m_indexWriter = indexWriter;
        this.m_index = index;
        if (this.m_index != null && LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_INDEX_WRITER_MSG_CREATE_2", this.m_index.getName(), this.m_index.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Directory dir = this.m_indexWriter.getDirectory();
        try {
            if (this.m_index != null && LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_INDEX_WRITER_MSG_CLOSE_2", this.m_index.getName(), this.m_index.getPath()));
            }
            this.m_indexWriter.close();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (dir != null && IndexWriter.isLocked((Directory)dir)) {
                IndexWriter.unlock((Directory)dir);
            }
            throw throwable;
        }
        if (dir != null && IndexWriter.isLocked((Directory)dir)) {
            IndexWriter.unlock((Directory)dir);
        }
    }

    public void commit() throws IOException {
        if (this.m_index != null && LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_INDEX_WRITER_MSG_COMMIT_2", this.m_index.getName(), this.m_index.getPath()));
        }
        this.m_indexWriter.commit();
    }

    public void deleteDocuments(String rootPath) throws IOException {
        Term term = new Term("path", rootPath);
        if (this.m_index != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_INDEX_WRITER_MSG_DOC_DELETE_3", rootPath, this.m_index.getName(), this.m_index.getPath()));
        }
        this.m_indexWriter.deleteDocuments(term);
    }

    public void optimize() throws IOException {
        if (this.m_index != null && LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_INDEX_WRITER_MSG_OPTIMIZE_2", this.m_index.getName(), this.m_index.getPath()));
        }
        int oldPriority = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(2);
        this.m_indexWriter.forceMerge(5);
        Thread.currentThread().setPriority(oldPriority);
    }

    public void updateDocument(String rootPath, I_CmsSearchDocument document) throws IOException {
        Term pathTerm = new Term("path", rootPath);
        if (this.m_index != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_INDEX_WRITER_MSG_DOC_UPDATE_3", rootPath, this.m_index.getName(), this.m_index.getPath()));
        }
        this.m_indexWriter.updateDocument(pathTerm, (Document)document.getDocument());
    }
}

