/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.documents;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmsDocumentDependency {
    public static final Pattern DOC_PATTERN_LOCALE = Pattern.compile("(.*)_([a-z]{2}(?:_[A-Z]{2})?)($|[$|\\.|_])");
    public static final Pattern DOC_PATTERN_NUMBER = Pattern.compile("(.*)_(\\d+)(\\.[^\\.^\\n]*)?$");
    private static final String ATTR_DOC_DEPENDENCY = "CmsDocumentDependency.";
    private static final String JSON_ATTACHMENTS = "attachments";
    private static final String JSON_DATE_CREATED = "dateCreated";
    private static final String JSON_DATE_MODIFIED = "dateModified";
    private static final String JSON_LANGUAGES = "languages";
    private static final String JSON_MAIN = "main";
    private static final String JSON_PATH = "path";
    private static final String JSON_TITLE = "title";
    private static final String JSON_UUID = "uuid";
    private static final Log LOG = CmsLog.getLog(CmsDocumentDependency.class);
    private Integer m_attachmentNumber;
    private List<CmsDocumentDependency> m_attachments = new ArrayList<CmsDocumentDependency>();
    private List<CmsDocumentDependency> m_dependencies = new ArrayList<CmsDocumentDependency>();
    private String m_documentName;
    private String m_documentSuffix;
    private Locale m_locale;
    private CmsDocumentDependency m_mainDocument;
    private CmsPublishedResource m_resource;
    private DependencyType m_type;
    private List<CmsDocumentDependency> m_variants = new ArrayList<CmsDocumentDependency>();

    private CmsDocumentDependency(CmsPublishedResource res) {
        this(res, res.getRootPath());
    }

    private CmsDocumentDependency(CmsPublishedResource resource, String rootPath) {
        this.m_resource = resource;
        String docName = CmsResource.getName(this.m_resource.getRootPath());
        Matcher matcher = DOC_PATTERN_NUMBER.matcher(docName);
        if (matcher.find()) {
            docName = matcher.group(1);
            Integer partNumber = new Integer(Integer.parseInt(matcher.group(2)));
            this.setAttachmentNumber(partNumber);
        }
        Locale locale = null;
        matcher = DOC_PATTERN_LOCALE.matcher(docName);
        if (matcher.find()) {
            docName = matcher.group(1);
            String suffix = matcher.group(2);
            String langString = suffix.substring(0, 2);
            Locale locale2 = locale = suffix.length() == 5 ? new Locale(langString, suffix.substring(3, 5)) : new Locale(langString);
        }
        if (locale == null || !OpenCms.getLocaleManager().getDefaultLocales().contains(locale)) {
            locale = CmsLocaleManager.getDefaultLocale();
        }
        this.setLocale(locale);
        int index = this.getResource().getRootPath().lastIndexOf(46);
        if (index != -1) {
            this.setDocumentSuffix(this.getResource().getRootPath().substring(index));
        }
        this.setDocumentName(CmsResource.getFolderPath(this.m_resource.getRootPath()) + docName);
    }

    private CmsDocumentDependency(CmsResource res) {
        this(new CmsPublishedResource(res, -1, CmsResourceState.STATE_CHANGED));
    }

    public static Locale getLocale(String rootPath) {
        return new CmsDocumentDependency(null, rootPath).getLocale();
    }

    public static CmsDocumentDependency load(CmsObject cms, CmsPublishedResource pubRes) {
        CmsDocumentDependency result = CmsDocumentDependency.readFromContext(cms, pubRes.getRootPath());
        if (result == null) {
            result = new CmsDocumentDependency(pubRes);
            result.readDependencies(cms);
        }
        return result;
    }

    public static CmsDocumentDependency load(CmsObject cms, CmsResource res) {
        CmsDocumentDependency result = CmsDocumentDependency.readFromContext(cms, res.getRootPath());
        if (result == null) {
            result = new CmsDocumentDependency(res);
            result.readDependencies(cms);
        }
        return result;
    }

    public static CmsDocumentDependency load(CmsObject cms, CmsResource res, List<CmsResource> resources) {
        CmsDocumentDependency result = CmsDocumentDependency.readFromContext(cms, res.getRootPath());
        if (result == null) {
            result = new CmsDocumentDependency(res);
            result.readDependencies(cms, resources);
        }
        return result;
    }

    protected static CmsDocumentDependency loadForTest(String rootPath) {
        return new CmsDocumentDependency(null, rootPath);
    }

    protected static void removeFromContext(CmsObject cms, CmsPublishedResource pubRes) {
        cms.getRequestContext().removeAttribute(CmsDocumentDependency.getAttributeKey(pubRes.getRootPath()));
    }

    private static String getAttributeKey(String rootPath) {
        return ATTR_DOC_DEPENDENCY + rootPath;
    }

    private static CmsDocumentDependency readFromContext(CmsObject cms, String rootPath) {
        return (CmsDocumentDependency)cms.getRequestContext().getAttribute(CmsDocumentDependency.getAttributeKey(rootPath));
    }

    public void addAttachment(CmsDocumentDependency dep) {
        boolean exist = false;
        for (CmsDocumentDependency att : this.m_attachments) {
            if (att.getAttachmentNumber() != dep.getAttachmentNumber()) continue;
            if (this.m_locale.equals(dep.getLocale())) {
                for (CmsDocumentDependency langAtt : att.getVariants()) {
                    dep.addVariant(langAtt);
                }
                dep.addVariant(att);
                this.m_attachments.remove(att);
                break;
            }
            exist = true;
            att.addVariant(dep);
            break;
        }
        if (!exist) {
            dep.setType(DependencyType.attachment);
            this.m_attachments.add(dep);
        } else {
            dep.setType(DependencyType.variant);
        }
        this.addDependency(dep);
    }

    public void addDependency(CmsDocumentDependency dep) {
        this.m_dependencies.add(dep);
    }

    public void addVariant(CmsDocumentDependency dep) {
        for (CmsDocumentDependency lang : this.m_variants) {
            if (!lang.getLocale().equals(dep.getLocale())) continue;
            return;
        }
        dep.setType(DependencyType.variant);
        this.m_variants.add(dep);
        this.addDependency(dep);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsDocumentDependency) {
            CmsDocumentDependency other = (CmsDocumentDependency)obj;
            return this.m_resource.getRootPath().equals(other.getResource().getRootPath()) && this.m_locale.equals(other.m_locale);
        }
        return false;
    }

    public int getAttachmentNumber() {
        if (this.m_attachmentNumber != null) {
            return this.m_attachmentNumber;
        }
        return 0;
    }

    public List<CmsDocumentDependency> getAttachments() {
        return this.m_attachments;
    }

    public List<CmsDocumentDependency> getDependencies() {
        return this.m_dependencies;
    }

    public String getDocumentName() {
        return this.m_documentName;
    }

    public String getDocumentSuffix() {
        return this.m_documentSuffix;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public CmsDocumentDependency getMainDocument() {
        return this.m_mainDocument;
    }

    public CmsPublishedResource getResource() {
        return this.m_resource;
    }

    public DependencyType getType() {
        return this.m_type;
    }

    public List<CmsDocumentDependency> getVariants() {
        return this.m_variants;
    }

    public int hashCode() {
        return this.getResource().hashCode();
    }

    public boolean isAttachment() {
        return this.m_attachmentNumber != null;
    }

    public void readDependencies(CmsObject cms) {
        try {
            List<CmsResource> folderContent = cms.getResourcesInFolder(CmsResource.getParentFolder(cms.getRequestContext().removeSiteRoot(this.getResource().getRootPath())), CmsResourceFilter.DEFAULT);
            this.readDependencies(cms, folderContent);
        }
        catch (CmsException e) {
            LOG.warn((Object)("Unable to read dependencies for " + this.getResource().getRootPath()), (Throwable)e);
        }
    }

    public void readDependencies(CmsObject cms, List<CmsResource> folderContent) {
        HashMap<Integer, CmsDocumentDependency> attachments = new HashMap<Integer, CmsDocumentDependency>();
        if (this.isAttachment()) {
            attachments.put(new Integer(this.getAttachmentNumber()), this);
        }
        for (CmsResource r : folderContent) {
            if (!r.isFile() || this.getResource().getRootPath().equals(r.getRootPath())) continue;
            CmsPublishedResource pubRes = new CmsPublishedResource(r, this.getResource().getPublishTag(), CmsResourceState.STATE_CHANGED);
            CmsDocumentDependency dep = new CmsDocumentDependency(pubRes);
            if (!this.getDocumentName().equals(dep.getDocumentName())) continue;
            if (this.isAttachment()) {
                if (dep.isAttachment()) {
                    if (this.getAttachmentNumber() == dep.getAttachmentNumber()) {
                        this.addVariant(dep);
                        continue;
                    }
                    Integer attNum = new Integer(dep.getAttachmentNumber());
                    CmsDocumentDependency att = (CmsDocumentDependency)attachments.get(attNum);
                    if (att != null) {
                        att.addVariant(dep);
                        continue;
                    }
                    attachments.put(attNum, dep);
                    continue;
                }
                this.setMainDocument(dep);
                continue;
            }
            if (dep.isAttachment()) {
                this.addAttachment(dep);
                continue;
            }
            if (!CmsStringUtil.isEqual(this.getDocumentSuffix(), dep.getDocumentSuffix())) continue;
            this.addVariant(dep);
        }
        if (this.m_mainDocument != null) {
            for (CmsDocumentDependency att : attachments.values()) {
                this.m_mainDocument.addAttachment(att);
            }
            this.addDependency(this.m_mainDocument);
        }
    }

    public void setAttachmentNumber(Integer attachmentNumber) {
        this.m_attachmentNumber = attachmentNumber;
    }

    public void setDocumentName(String documentName) {
        this.m_documentName = documentName;
    }

    public void setDocumentSuffix(String documentSuffix) {
        this.m_documentSuffix = documentSuffix;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setMainDocument(CmsDocumentDependency mainDocument) {
        mainDocument.setType(DependencyType.document);
        if (this.m_mainDocument == null) {
            this.m_mainDocument = mainDocument;
        } else if (mainDocument.getLocale().equals(this.getLocale())) {
            mainDocument.addVariant(this.m_mainDocument);
            this.m_mainDocument = mainDocument;
        } else {
            List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales();
            int pos1 = locales.indexOf(this.m_mainDocument.getLocale());
            if (pos1 > 0) {
                int pos2 = locales.indexOf(mainDocument.getLocale());
                if (pos2 < pos1) {
                    mainDocument.addVariant(this.m_mainDocument);
                    this.m_mainDocument = mainDocument;
                }
            } else {
                this.m_mainDocument.addVariant(mainDocument);
            }
        }
    }

    public void setType(DependencyType type) {
        this.m_type = type;
    }

    public void storeInContext(CmsObject cms) {
        cms.getRequestContext().setAttribute(CmsDocumentDependency.getAttributeKey(this.getResource().getRootPath()), this);
    }

    public String toDependencyString(CmsObject cms) {
        JSONObject jsonDoc = this.toJSON(cms, true);
        try {
            CmsDocumentDependency main;
            if (!this.isAttachment() && this.m_attachments != null) {
                JSONArray jsonAttachments = new JSONArray();
                for (CmsDocumentDependency att : this.m_attachments) {
                    JSONObject jsonAttachment = att.toJSON(cms, true);
                    jsonAttachments.put(jsonAttachment);
                }
                jsonDoc.put(JSON_ATTACHMENTS, jsonAttachments);
            } else if (this.isAttachment() && (main = this.getMainDocument()) != null) {
                JSONObject jsonMain = main.toJSON(cms, true);
                List<CmsDocumentDependency> attachments = main.getAttachments();
                if (attachments != null) {
                    JSONArray jsonAttachments = new JSONArray();
                    for (CmsDocumentDependency att : attachments) {
                        JSONObject jsonAttachment = att.toJSON(cms, true);
                        jsonAttachments.put(jsonAttachment);
                    }
                    jsonMain.put(JSON_ATTACHMENTS, jsonAttachments);
                }
                jsonDoc.put(JSON_MAIN, jsonMain);
            }
            return jsonDoc.toString();
        }
        catch (JSONException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public JSONObject toJSON(CmsObject cms, boolean includeLang) {
        try {
            List<CmsDocumentDependency> langs;
            JSONObject jsonAttachment = new JSONObject();
            jsonAttachment.put(JSON_UUID, this.getResource().getStructureId());
            jsonAttachment.put(JSON_PATH, this.getResource().getRootPath());
            CmsResource res = cms.readResource(this.getResource().getRootPath(), CmsResourceFilter.IGNORE_EXPIRATION);
            Map<String, String> props = CmsProperty.toMap(cms.readPropertyObjects(res, false));
            jsonAttachment.put(JSON_TITLE, props.get("Title"));
            jsonAttachment.put(JSON_DATE_CREATED, res.getDateCreated());
            jsonAttachment.put(JSON_DATE_MODIFIED, res.getDateLastModified());
            if (includeLang && (langs = this.getVariants()) != null) {
                JSONArray jsonLanguages = new JSONArray();
                for (CmsDocumentDependency lang : langs) {
                    JSONObject jsonLanguage = lang.toJSON(cms, false);
                    jsonLanguages.put(jsonLanguage);
                }
                jsonAttachment.put(JSON_LANGUAGES, jsonLanguages);
            }
            return jsonAttachment;
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            return null;
        }
    }

    public String toString() {
        return this.m_resource.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DependencyType {
        attachment,
        document,
        variant;

    }
}

