/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.extractors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.I_CmsSearchField;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsExtractionResult
implements I_CmsExtractionResult,
Serializable {
    private static final long serialVersionUID = 1465447302192195154L;
    private Map<String, String> m_contentItems;
    private Set<I_CmsSearchField> m_mappingFields = new HashSet<I_CmsSearchField>();
    private byte[] m_serializedVersion;

    public CmsExtractionResult(String content) {
        this(content, null);
        this.m_contentItems.put("__raw", content);
    }

    public CmsExtractionResult(String content, Map<String, String> contentItems) {
        this.m_contentItems = contentItems != null ? contentItems : new HashMap<String, String>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(content)) {
            this.m_contentItems.put("__content", content);
        }
    }

    public CmsExtractionResult(String content, Map<String, String> contentItems, Set<I_CmsSearchField> mappingFields) {
        this(content, contentItems);
        this.m_mappingFields = mappingFields != null ? mappingFields : new HashSet<I_CmsSearchField>();
    }

    public static final CmsExtractionResult fromBytes(byte[] bytes) {
        Object obj = null;
        if (bytes != null) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                ObjectInputStream oin = new ObjectInputStream(in);
                obj = oin.readObject();
                oin.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (obj instanceof CmsExtractionResult) {
                CmsExtractionResult result = (CmsExtractionResult)obj;
                result.m_serializedVersion = bytes;
                return result;
            }
        }
        return null;
    }

    @Override
    public byte[] getBytes() {
        if (this.m_serializedVersion != null) {
            return this.m_serializedVersion;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(512);
            ObjectOutputStream oout = new ObjectOutputStream(out);
            oout.writeObject(this);
            oout.close();
            this.m_serializedVersion = out.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_serializedVersion;
    }

    @Override
    public String getContent() {
        return this.m_contentItems.get("__content");
    }

    @Override
    public Map<String, String> getContentItems() {
        return this.m_contentItems;
    }

    @Override
    public Set<I_CmsSearchField> getMappingFields() {
        return this.m_mappingFields;
    }

    @Override
    public void release() {
        if (!this.m_contentItems.isEmpty()) {
            this.m_contentItems.clear();
        }
        this.m_contentItems = null;
        this.m_serializedVersion = null;
    }

    @Override
    public void addMappingField(I_CmsSearchField field) {
        this.m_mappingFields.add(field);
    }
}

