/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.util.ArrayList;
import java.util.List;
import org.opencms.search.fields.I_CmsSearchField;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class A_CmsSearchField
implements I_CmsSearchField {
    private static final long serialVersionUID = 3185631015824549119L;
    private float m_boost = 1.0f;
    private String m_defaultValue;
    private List<I_CmsSearchFieldMapping> m_mappings = new ArrayList<I_CmsSearchFieldMapping>();
    private String m_name;

    public A_CmsSearchField() {
    }

    public A_CmsSearchField(String name, String defaultValue, float boost) {
        this();
        this.m_name = name;
        this.m_boost = boost;
        this.m_defaultValue = defaultValue;
    }

    @Override
    public void addMapping(I_CmsSearchFieldMapping mapping) {
        this.m_mappings.add(mapping);
    }

    public boolean equals(Object obj) {
        if (obj instanceof A_CmsSearchField) {
            return CmsStringUtil.isEqual(this.m_name, ((A_CmsSearchField)obj).getName());
        }
        return false;
    }

    @Override
    public float getBoost() {
        return this.m_boost;
    }

    @Override
    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    @Override
    public List<I_CmsSearchFieldMapping> getMappings() {
        return this.m_mappings;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public int hashCode() {
        return this.m_name == null ? 41 : this.m_name.hashCode();
    }

    @Override
    public void setBoost(float boost) {
        if (boost < 0.0f) {
            boost = 0.0f;
        }
        this.m_boost = boost;
    }

    @Override
    public void setBoost(String boost) {
        try {
            this.setBoost(Float.valueOf(boost).floatValue());
        }
        catch (NumberFormatException e) {
            this.setBoost(1.0f);
        }
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.m_defaultValue = CmsStringUtil.isNotEmptyOrWhitespaceOnly(defaultValue) ? defaultValue.trim() : null;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    public String toString() {
        return this.getName();
    }
}

