/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategoryService;
import org.opencms.search.A_CmsSearchIndex;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.I_CmsSearchField;
import org.opencms.search.fields.I_CmsSearchFieldConfiguration;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class A_CmsSearchFieldConfiguration
implements I_CmsSearchFieldConfiguration {
    public static final String STR_STANDARD = "standard";
    private String m_description;
    private Map<String, I_CmsSearchField> m_fieldLookup;
    private List<String> m_fieldNames;
    private List<I_CmsSearchField> m_fields = new ArrayList<I_CmsSearchField>();
    private A_CmsSearchIndex m_index;
    private String m_name;

    public static final String getLocaleExtendedName(String lookup, Locale locale) {
        if (locale == null) {
            return lookup;
        }
        return A_CmsSearchFieldConfiguration.getLocaleExtendedName(lookup, locale.toString());
    }

    public static final String getLocaleExtendedName(String lookup, String locale) {
        StringBuffer result = new StringBuffer(32);
        result.append(lookup);
        result.append('_');
        result.append(locale);
        return result.toString();
    }

    public static String getParentFolderTokens(String rootPath) {
        if (CmsStringUtil.isEmpty(rootPath)) {
            return "/";
        }
        StringBuffer result = new StringBuffer(128);
        String folderName = CmsResource.getFolderPath(rootPath);
        for (int i = 0; i < folderName.length(); ++i) {
            char c = folderName.charAt(i);
            if (c != '/') continue;
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(folderName.substring(0, i + 1));
        }
        return result.toString();
    }

    @Override
    public void addField(I_CmsSearchField field) {
        if (field != null) {
            this.m_fields.add(field);
        }
    }

    public void addFields(Collection<I_CmsSearchField> fields) {
        for (I_CmsSearchField field : fields) {
            if (this.getFieldNames().contains(field.getName())) continue;
            this.addField(field);
        }
    }

    @Override
    public int compareTo(I_CmsSearchFieldConfiguration obj) {
        return this.m_name.compareTo(obj.getName());
    }

    @Override
    public I_CmsSearchDocument createDocument(CmsObject cms, CmsResource resource, A_CmsSearchIndex index, I_CmsExtractionResult extraction) throws CmsException {
        this.m_index = index;
        I_CmsSearchDocument document = this.createEmptyDocument(resource);
        List<CmsProperty> propertiesSearched = cms.readPropertyObjects(resource, true);
        List<CmsProperty> properties = cms.readPropertyObjects(resource, false);
        document = this.appendContentBlob(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendPath(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendType(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendDates(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendLocales(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendProperties(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendCategories(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendFieldMappings(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.setBoost(document, cms, resource, extraction, properties, propertiesSearched);
        return document;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof A_CmsSearchFieldConfiguration) {
            return ((A_CmsSearchFieldConfiguration)obj).getName().equals(this.m_name);
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public I_CmsSearchField getField(String name) {
        if (this.m_fieldLookup == null) {
            this.m_fieldLookup = new HashMap<String, I_CmsSearchField>();
            for (I_CmsSearchField field : this.m_fields) {
                this.m_fieldLookup.put(field.getName(), field);
            }
        }
        return this.m_fieldLookup.get(name);
    }

    @Override
    public List<String> getFieldNames() {
        if (this.m_fieldNames == null) {
            this.m_fieldNames = new ArrayList<String>();
            for (I_CmsSearchField field : this.m_fields) {
                this.m_fieldNames.add(field.getName());
            }
        }
        return new ArrayList<String>(this.m_fieldNames);
    }

    @Override
    public List<I_CmsSearchField> getFields() {
        return this.m_fields;
    }

    public A_CmsSearchIndex getIndex() {
        return this.m_index;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setIndex(A_CmsSearchIndex index) {
        this.m_index = index;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    protected I_CmsSearchDocument appendCategories(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) throws CmsException {
        CmsCategoryService categoryService = CmsCategoryService.getInstance();
        document.addCategoryField(categoryService.readResourceCategories(cms, resource));
        return document;
    }

    protected I_CmsSearchDocument appendContentBlob(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        byte[] data;
        if (extractionResult != null && (data = extractionResult.getBytes()) != null) {
            document.addContentField(data);
        }
        return document;
    }

    protected I_CmsSearchDocument appendDates(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        document.addDateField("created", resource.getDateCreated(), true);
        document.addDateField("lastmodified", resource.getDateLastModified(), true);
        document.addDateField("contentdate", resource.getDateContent(), false);
        return document;
    }

    protected I_CmsSearchDocument appendFieldMapping(I_CmsSearchDocument document, I_CmsSearchField field, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        StringBuffer text = new StringBuffer();
        for (I_CmsSearchFieldMapping mapping : field.getMappings()) {
            String mapResult = mapping.getStringValue(cms, resource, extractionResult, properties, propertiesSearched);
            if (mapResult == null) continue;
            if (text.length() > 0) {
                text.append('\n');
            }
            text.append(mapResult);
        }
        if (text.length() > 0) {
            document.addSearchField(field, text.toString());
        }
        return document;
    }

    protected I_CmsSearchDocument appendFieldMappings(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        for (I_CmsSearchField field : this.getFields()) {
            document = this.appendFieldMapping(document, field, cms, resource, extractionResult, properties, propertiesSearched);
        }
        return document;
    }

    protected I_CmsSearchDocument appendLocales(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        return document;
    }

    protected I_CmsSearchDocument appendPath(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        document.addPathField(resource.getRootPath());
        document.addRootPathField(resource.getRootPath());
        return document;
    }

    protected I_CmsSearchDocument appendProperties(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        return document;
    }

    protected I_CmsSearchDocument appendType(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) throws CmsLoaderException {
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
        String typeName = "VFS";
        if (type != null) {
            typeName = type.getTypeName();
        }
        document.addTypeField(typeName);
        String resName = CmsResource.getName(resource.getRootPath());
        int index = resName.lastIndexOf(46);
        if (index != -1) {
            document.addSuffixField(resName.substring(index));
        }
        return document;
    }

    protected I_CmsSearchDocument setBoost(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        float boost = 1.0f;
        String value = CmsProperty.get("search.priority", propertiesSearched).getValue();
        if (value != null) {
            if ((value = value.trim().toLowerCase()).equals("max")) {
                boost = 2.0f;
            } else if (value.equals("high")) {
                boost = 1.5f;
            } else if (value.equals("low")) {
                boost = 0.5f;
            }
        }
        if (boost != 1.0f) {
            document.setBoost(boost);
        }
        return document;
    }
}

