/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.fields.A_CmsSearchField;
import org.opencms.util.CmsStringUtil;

public class CmsSearchField
extends A_CmsSearchField {
    public static final String IGNORE_DISPLAY_NAME = "-";
    public static final String STR_COMPRESS = "compress";
    public static final String STR_NO = "no";
    public static final String STR_TOKENIZED = "tokenized";
    public static final String STR_UN_TOKENIZED = "untokenized";
    public static final String STR_YES = "yes";
    private static final long serialVersionUID = -4946013624087640706L;
    private Analyzer m_analyzer;
    private float m_boost;
    private boolean m_compressed;
    private boolean m_displayed;
    private String m_displayName;
    private String m_displayNameForConfiguration;
    private boolean m_excerpt;
    private boolean m_indexed;
    private boolean m_stored;
    private boolean m_tokenized;
    private String m_type;

    public CmsSearchField() {
    }

    public CmsSearchField(String name, String displayName, boolean isStored, boolean isIndexed) {
        this(name, displayName, isStored, isIndexed, isIndexed, false, 1.0f, null);
    }

    public CmsSearchField(String name, String displayName, boolean isStored, boolean isCompressed, boolean isIndexed, boolean isTokenized, boolean isInExcerpt, Analyzer analyzer, float boost, String defaultValue) {
        super(name, defaultValue, boost);
        this.setDisplayName(displayName);
        this.setStored(isStored);
        this.setCompressed(isCompressed);
        this.setIndexed(isIndexed);
        this.setTokenized(isTokenized);
        this.setInExcerpt(isInExcerpt);
        this.setAnalyzer(analyzer);
    }

    public CmsSearchField(String name, String displayName, boolean isStored, boolean isIndexed, boolean isTokenized, boolean isInExcerpt, float boost, String defaultValue) {
        this(name, displayName, isStored, false, isIndexed, isTokenized, isInExcerpt, null, boost, defaultValue);
    }

    public Field createField(String content) {
        return this.createField(this.getName(), content);
    }

    public Field createField(String name, String content) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(content)) {
            content = this.getDefaultValue();
        }
        if (content != null) {
            Field.Index index = Field.Index.NO;
            if (this.isIndexed()) {
                index = this.isTokenizedAndIndexed() ? Field.Index.ANALYZED : Field.Index.NOT_ANALYZED;
            }
            Field.Store store = Field.Store.NO;
            if (this.isStored() || this.isCompressed()) {
                store = Field.Store.YES;
            }
            Field result = new Field(name, content, store, index);
            if (this.getBoost() != 1.0f) {
                result.setBoost(this.getBoost());
            }
            return result;
        }
        return null;
    }

    public Analyzer getAnalyzer() {
        return this.m_analyzer;
    }

    public String getBoostDisplay() {
        if (this.m_boost == 1.0f) {
            return null;
        }
        return String.valueOf(this.m_boost);
    }

    public String getDisplayName() {
        if (!this.isDisplayed()) {
            return IGNORE_DISPLAY_NAME;
        }
        if (this.m_displayName == null) {
            return this.getName();
        }
        return this.m_displayName;
    }

    public String getDisplayNameForConfiguration() {
        return this.m_displayNameForConfiguration;
    }

    public String getIndexed() {
        if (this.isTokenizedAndIndexed()) {
            return String.valueOf(this.isTokenizedAndIndexed());
        }
        if (this.isIndexed()) {
            return STR_UN_TOKENIZED;
        }
        return String.valueOf(this.isIndexed());
    }

    public Locale getLocale() {
        return null;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean isCompressed() {
        return this.m_compressed;
    }

    public boolean isDisplayed() {
        return this.m_displayed;
    }

    public boolean isIndexed() {
        return this.m_indexed;
    }

    public boolean isInExcerpt() {
        return this.m_excerpt;
    }

    public boolean isInExcerptAndStored() {
        return this.m_excerpt && this.m_stored;
    }

    public boolean isStored() {
        return this.m_stored;
    }

    public boolean isTokenized() {
        return this.m_tokenized;
    }

    public boolean isTokenizedAndIndexed() {
        return this.m_tokenized && this.m_indexed;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.m_analyzer = analyzer;
    }

    public void setAnalyzer(String analyzerName) throws Exception {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(analyzerName)) {
            this.setAnalyzer(CmsSearchManager.getAnalyzer(analyzerName));
        }
    }

    public void setBoostDisplay(String boost) {
        this.setBoost(boost);
    }

    public void setCompressed(boolean compressed) {
        this.m_compressed = compressed;
        if (compressed) {
            this.setStored(true);
        }
    }

    public void setDisplayed(boolean displayed) {
        this.m_displayed = displayed;
    }

    public void setDisplayName(String displayName) {
        if (CmsStringUtil.isEmpty(displayName) || IGNORE_DISPLAY_NAME.equals(displayName)) {
            this.m_displayName = null;
            this.setDisplayed(false);
        } else {
            this.m_displayName = displayName;
            this.m_displayNameForConfiguration = displayName;
            this.setDisplayed(true);
        }
    }

    public void setDisplayNameForConfiguration(String displayNameForConfiguration) {
        this.m_displayNameForConfiguration = displayNameForConfiguration;
        this.setDisplayName(displayNameForConfiguration);
    }

    public void setIndexed(boolean indexed) {
        this.m_indexed = indexed;
    }

    public void setIndexed(String indexed) {
        boolean isIndexed = false;
        boolean isTokenized = false;
        if (indexed != null) {
            if (STR_TOKENIZED.equals(indexed = indexed.trim().toLowerCase())) {
                isIndexed = true;
                isTokenized = true;
            } else if (STR_UN_TOKENIZED.equals(indexed)) {
                isIndexed = true;
            } else if (!STR_NO.equals(indexed)) {
                isTokenized = isIndexed = Boolean.valueOf(indexed).booleanValue();
            }
        }
        this.setIndexed(isIndexed);
        this.setTokenized(isTokenized);
    }

    public void setInExcerpt(boolean excerpt) {
        this.m_excerpt = excerpt;
    }

    public void setInExcerpt(String excerpt) {
        this.setInExcerpt(Boolean.valueOf(String.valueOf(excerpt)));
    }

    public void setStored(boolean stored) {
        this.m_stored = stored;
    }

    public void setStored(String stored) {
        boolean isStored = false;
        boolean isCompressed = false;
        if (stored != null) {
            if (STR_COMPRESS.equals(stored = stored.trim().toLowerCase())) {
                isCompressed = true;
                isStored = true;
            } else {
                isStored = STR_YES.equals(stored) ? true : Boolean.valueOf(stored);
            }
        }
        this.setStored(isStored);
        this.setCompressed(isCompressed);
    }

    public void setTokenized(boolean tokenized) {
        this.m_tokenized = tokenized;
    }

    public void setType(String type) {
        this.m_type = type;
    }
}

