/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.opencms.file.CmsResource;
import org.opencms.search.CmsLuceneDocument;
import org.opencms.search.CmsLuceneIndex;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.fields.A_CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.fields.CmsSearchFieldMappingType;
import org.opencms.search.fields.I_CmsSearchField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSearchFieldConfiguration
extends A_CmsSearchFieldConfiguration {
    public static final CmsSearchFieldConfiguration DEFAULT_STANDARD = CmsSearchFieldConfiguration.createStandardConfiguration();
    public static final String STR_STANDARD_DESCRIPTION = "The standard OpenCms search index field configuration.";
    private List<String> m_excerptFieldNames;

    private static CmsSearchFieldConfiguration createStandardConfiguration() {
        CmsSearchFieldConfiguration result = new CmsSearchFieldConfiguration();
        result.setName("standard");
        result.setDescription(STR_STANDARD_DESCRIPTION);
        CmsSearchField field = new CmsSearchField("content", "%(key.field.content)", true, true, true, true, true, null, 1.0f, null);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.CONTENT, null));
        result.addField(field);
        field = new CmsSearchField("title-key", "-", true, true, false, false, 0.0f, null);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Title"));
        result.addField(field);
        field = new CmsSearchField("title", "%(key.field.title)", false, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Title"));
        result.addField(field);
        field = new CmsSearchField("keywords", "%(key.field.keywords)", true, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Keywords"));
        result.addField(field);
        field = new CmsSearchField("description", "%(key.field.description)", true, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Description"));
        result.addField(field);
        field = new CmsSearchField("meta", "%(key.field.meta)", false, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Title"));
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Keywords"));
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Description"));
        result.addField(field);
        return result;
    }

    @Override
    public I_CmsSearchDocument createEmptyDocument(CmsResource res) {
        return new CmsLuceneDocument(new Document());
    }

    public Analyzer getAnalyzer(Analyzer analyzer) {
        WhitespaceAnalyzer ws = new WhitespaceAnalyzer(CmsLuceneIndex.LUCENE_VERSION);
        HashMap<String, Object> analyzers = new HashMap<String, Object>();
        analyzers.put("parent-folders", ws);
        analyzers.put("category", ws);
        analyzers.put("lastmodified_lookup", ws);
        analyzers.put("created_lookup", ws);
        for (CmsSearchField field : this.getLuceneFields()) {
            Analyzer fieldAnalyzer = field.getAnalyzer();
            if (fieldAnalyzer == null) continue;
            analyzers.put(field.getName(), fieldAnalyzer);
        }
        return new PerFieldAnalyzerWrapper(analyzer, analyzers);
    }

    public List<String> getExcerptFieldNames() {
        if (this.m_excerptFieldNames == null) {
            this.m_excerptFieldNames = new ArrayList<String>();
            for (CmsSearchField cmsSearchField : this.getFields()) {
                if (!cmsSearchField.isInExcerptAndStored()) continue;
                this.m_excerptFieldNames.add(cmsSearchField.getName());
            }
        }
        return new ArrayList<String>(this.m_excerptFieldNames);
    }

    public List<CmsSearchField> getLuceneFields() {
        ArrayList<CmsSearchField> result = new ArrayList<CmsSearchField>();
        for (I_CmsSearchField field : this.getFields()) {
            if (!(field instanceof CmsSearchField)) continue;
            result.add((CmsSearchField)field);
        }
        return result;
    }
}

