/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.search.A_CmsSearchIndex;
import org.opencms.search.CmsIndexException;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.CmsDocumentXmlContent;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.A_CmsSearchFieldConfiguration;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsGalleryDocumentXmlContent
extends CmsDocumentXmlContent {
    private static final Log LOG = CmsLog.getLog(CmsDocumentXmlContent.class);

    public CmsGalleryDocumentXmlContent(String name) {
        super(name);
    }

    public I_CmsSearchDocument createDocument(CmsObject cms, CmsResource resource, A_CmsSearchIndex index) throws CmsException {
        I_CmsExtractionResult content = null;
        try {
            content = this.extractContent(cms, resource, index);
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
        return index.getFieldConfiguration().createDocument(cms, resource, index, content);
    }

    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, A_CmsSearchIndex index) throws CmsException {
        this.logContentExtraction(resource, index);
        try {
            CmsFile file = this.readFile(cms, resource);
            CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, file);
            HashMap<String, String> items = new HashMap<String, String>();
            StringBuffer locales = new StringBuffer();
            for (Locale locale : xmlContent.getLocales()) {
                locales.append(locale.toString());
                locales.append(' ');
                StringBuffer content = new StringBuffer();
                for (String xpath : xmlContent.getNames(locale)) {
                    List<String> mappings;
                    String extracted;
                    I_CmsXmlContentValue value = xmlContent.getValue(xpath, locale);
                    if (value.getContentDefinition().getContentHandler().isSearchable(value) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted = value.getPlainText(cms))) {
                        content.append(extracted);
                        content.append('\n');
                    }
                    if ((mappings = xmlContent.getHandler().getMappings(value.getPath())) == null || mappings.size() <= 0) continue;
                    for (String mapping : mappings) {
                        String extracted2;
                        String propertyName;
                        if (!mapping.startsWith("property:") || !"Title".equals(propertyName = mapping.substring(mapping.lastIndexOf(58) + 1)) && !"Description".equals(propertyName) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted2 = value.getPlainText(cms))) continue;
                        String fieldName = null;
                        fieldName = "Title".equals(propertyName) ? "title" : "description";
                        items.put(A_CmsSearchFieldConfiguration.getLocaleExtendedName(fieldName, locale), extracted2);
                    }
                }
                if (content.length() > 0) {
                    items.put(A_CmsSearchFieldConfiguration.getLocaleExtendedName("content", locale), content.toString());
                }
                items.put("res_locales", locales.toString());
            }
            return new CmsExtractionResult(null, items);
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
    }

    public boolean isLocaleDependend() {
        return false;
    }
}

